/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-environment.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-environment
 * @title: IAnjutaEnvironment
 * @short_description: Implemented by plugins doing cross compilation
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-environment.h
 * 
 */

#include "ianjuta-environment.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_environment_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-environment-quark");
	}
	
	return quark;
}

/**
* ianjuta_environment_get_real_directory:
* @obj: Self
* @dir: A directory path in the environment
* @err: Error propagation and reporting.
*
* Convert a directory in the environment to a directory outside.
* It is useful when the environment use chroot. Take care that
* the input directory string is freed using g_free but and you need to
* free the output string when not needed.
*
* Returns: The directory path outside the environment
*/
gchar*
ianjuta_environment_get_real_directory (IAnjutaEnvironment *obj, gchar *dir, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ENVIRONMENT(obj), NULL);
	return IANJUTA_ENVIRONMENT_GET_IFACE (obj)->get_real_directory (obj, dir, err);
}

/* Default implementation */
static gchar*
ianjuta_environment_get_real_directory_default (IAnjutaEnvironment *obj, gchar *dir, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_environment_override:
* @obj: Self
* @dirp: a pointer on the working directory
* @argvp: a pointer on a NULL terminated string array
*     containing the command name in argv[0] and all
*    its argument
* @envp: a pointer on a NULL terminated string array
*    containing all additional environment variable
*    used by the command
* @err: Error propagation and reporting.
*
* Override a command to work in another build environment
*
* Returns: FALSE if there is an error.
*/
gboolean
ianjuta_environment_override (IAnjutaEnvironment *obj, gchar **dirp,   gchar ***argvp,   gchar ***envp, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ENVIRONMENT(obj), FALSE);
	return IANJUTA_ENVIRONMENT_GET_IFACE (obj)->override (obj, dirp, argvp, envp, err);
}

/* Default implementation */
static gboolean
ianjuta_environment_override_default (IAnjutaEnvironment *obj, gchar **dirp,   gchar ***argvp,   gchar ***envp, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_environment_base_init (IAnjutaEnvironmentIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_real_directory = ianjuta_environment_get_real_directory_default;
	klass->override = ianjuta_environment_override_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_environment_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEnvironmentIface),
			(GBaseInitFunc) ianjuta_environment_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEnvironment", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_environment_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_ENVIRONMENT_CONFIG, "IANJUTA_ENVIRONMENT_CONFIG", "config" }, 
		{ IANJUTA_ENVIRONMENT_OTHER_ERROR, "IANJUTA_ENVIRONMENT_OTHER_ERROR", "other-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaEnvironmentError", values);
	}

	return type;
}
