/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_SYMBOL_H_
#define _IANJUTA_SYMBOL_H_

#include <glib-object.h>
#include <gdk/gdkpixbuf.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_SYMBOL (ianjuta_symbol_get_type ())
#define IANJUTA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_SYMBOL, IAnjutaSymbol))
#define IANJUTA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_SYMBOL))
#define IANJUTA_SYMBOL_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_SYMBOL, IAnjutaSymbolIface))

#define IANJUTA_TYPE_SYMBOL_FIELD (ianjuta_symbol_field_get_type())
#define IANJUTA_TYPE_SYMBOL_TYPE (ianjuta_symbol_type_get_type())

typedef enum {
	IANJUTA_SYMBOL_FIELD_NONE = 0,
	IANJUTA_SYMBOL_FIELD_NAME = 1,
	IANJUTA_SYMBOL_FIELD_TYPE = 2,
	IANJUTA_SYMBOL_FIELD_FILE = 4,
	IANJUTA_SYMBOL_FIELD_LINE = 8,
	IANJUTA_SYMBOL_FIELD_POSITION = 16,
	IANJUTA_SYMBOL_FIELD_SCOPE = 32,
	IANJUTA_SYMBOL_FIELD_INHERITANCE = 64,
	IANJUTA_SYMBOL_FIELD_ARGUMENTS = 128,
	IANJUTA_SYMBOL_FIELD_LOCAL = 256,
	IANJUTA_SYMBOL_FIELD_TIME = 512,
	IANJUTA_SYMBOL_FIELD_VARTYPE = 1024,
	IANJUTA_SYMBOL_FIELD_ACCESS = 2048,
	IANJUTA_SYMBOL_FIELD_IMPLEMENTATION = 4096,
	IANJUTA_SYMBOL_FIELD_LANGUAGE = 8192,
	IANJUTA_SYMBOL_FIELD_INACTIVE = 16384,
	IANJUTA_SYMBOL_FIELD_POINTER = 32768,
	IANJUTA_SYMBOL_FIELD_MAX = 65535
} IAnjutaSymbolField;

typedef enum {
	IANJUTA_SYMBOL_TYPE_UNDEF = 0,
	IANJUTA_SYMBOL_TYPE_CLASS = 1,
	IANJUTA_SYMBOL_TYPE_ENUM = 2,
	IANJUTA_SYMBOL_TYPE_ENUMERATOR = 4,
	IANJUTA_SYMBOL_TYPE_FIELD = 8,
	IANJUTA_SYMBOL_TYPE_FUNCTION = 16,
	IANJUTA_SYMBOL_TYPE_INTERFACE = 32,
	IANJUTA_SYMBOL_TYPE_MEMBER = 64,
	IANJUTA_SYMBOL_TYPE_METHOD = 128,
	IANJUTA_SYMBOL_TYPE_NAMESPACE = 256,
	IANJUTA_SYMBOL_TYPE_PACKAGE = 512,
	IANJUTA_SYMBOL_TYPE_PROTOTYPE = 1024,
	IANJUTA_SYMBOL_TYPE_STRUCT = 2048,
	IANJUTA_SYMBOL_TYPE_TYPEDEF = 4096,
	IANJUTA_SYMBOL_TYPE_UNION = 8192,
	IANJUTA_SYMBOL_TYPE_VARIABLE = 16384,
	IANJUTA_SYMBOL_TYPE_EXTERNVAR = 32768,
	IANJUTA_SYMBOL_TYPE_MACRO = 65536,
	IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG = 131072,
	IANJUTA_SYMBOL_TYPE_FILE = 262144,
	IANJUTA_SYMBOL_TYPE_OTHER = 524288,
	IANJUTA_SYMBOL_TYPE_MAX = 1048575
} IAnjutaSymbolType;

#define IANJUTA_SYMBOL_ERROR ianjuta_symbol_error_quark()

typedef struct _IAnjutaSymbol IAnjutaSymbol;
typedef struct _IAnjutaSymbolIface IAnjutaSymbolIface;

struct _IAnjutaSymbolIface {
	GTypeInterface g_iface;
	

	const gchar * (*access) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*args) (IAnjutaSymbol *obj, GError **err);
	const GdkPixbuf * (*icon) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*impl) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*inheritance) (IAnjutaSymbol *obj, GError **err);
	gboolean (*is_local) (IAnjutaSymbol *obj, GError **err);
	gulong (*line) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*name) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*scope) (IAnjutaSymbol *obj, GError **err);
	IAnjutaSymbolType (*type) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*type_name) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*type_str) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*uri) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*var_type) (IAnjutaSymbol *obj, GError **err);

};
GType ianjuta_symbol_field_get_type (void);
GType ianjuta_symbol_type_get_type (void);

GQuark ianjuta_symbol_error_quark     (void);
GType  ianjuta_symbol_get_type        (void);

const gchar * ianjuta_symbol_access (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_args (IAnjutaSymbol *obj, GError **err);

const GdkPixbuf * ianjuta_symbol_icon (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_impl (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_inheritance (IAnjutaSymbol *obj, GError **err);

gboolean ianjuta_symbol_is_local (IAnjutaSymbol *obj, GError **err);

gulong ianjuta_symbol_line (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_name (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_scope (IAnjutaSymbol *obj, GError **err);

IAnjutaSymbolType ianjuta_symbol_type (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_type_name (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_type_str (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_uri (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_var_type (IAnjutaSymbol *obj, GError **err);


G_END_DECLS

#endif
