/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-breakpoint-debugger.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-breakpoint-debugger
 * @title: IAnjutaBreakpointDebugger
 * @short_description: Breakpoint Debugger interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-breakpoint-debugger.h
 * 
 */

#include "ianjuta-breakpoint-debugger.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_breakpoint_debugger_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-breakpoint-debugger-quark");
	}
	
	return quark;
}

/**
* ianjuta_breakpoint_debugger_clear_breakpoint:
* @obj: Self
* @id: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_clear_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->clear_breakpoint (obj, id, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_clear_breakpoint_default (IAnjutaBreakpointDebugger *obj, guint id,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_condition_breakpoint:
* @obj: Self
* @id: fixme
* @condition: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_condition_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,   const gchar* condition,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->condition_breakpoint (obj, id, condition, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_condition_breakpoint_default (IAnjutaBreakpointDebugger *obj, guint id,   const gchar* condition,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_enable_breakpoint:
* @obj: Self
* @id: fixme
* @enable: fixme
* @callback: fixme
* @user_data: fixme	
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_enable_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,   gboolean enable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->enable_breakpoint (obj, id, enable, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_enable_breakpoint_default (IAnjutaBreakpointDebugger *obj, guint id,   gboolean enable,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_ignore_breakpoint:
* @obj: Self
* @id: fixme
* @ignore: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_ignore_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,   guint ignore,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->ignore_breakpoint (obj, id, ignore, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_ignore_breakpoint_default (IAnjutaBreakpointDebugger *obj, guint id,   guint ignore,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_set_breakpoint_at_address:
* @obj: Self
* @address: fixme
* @callback: fixme
* @user_date: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_address (IAnjutaBreakpointDebugger *obj, guint address,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->set_breakpoint_at_address (obj, address, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_address_default (IAnjutaBreakpointDebugger *obj, guint address,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_set_breakpoint_at_function:
* @obj: Self
* @file: fixme
* @function: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_function (IAnjutaBreakpointDebugger *obj, const gchar* file,   const gchar* function,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->set_breakpoint_at_function (obj, file, function, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_function_default (IAnjutaBreakpointDebugger *obj, const gchar* file,   const gchar* function,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_breakpoint_debugger_set_breakpoint_at_line:
* @obj: Self
* @file: fixme
* @line: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_line (IAnjutaBreakpointDebugger *obj, const gchar* file,   guint line,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BREAKPOINT_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE (obj)->set_breakpoint_at_line (obj, file, line, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_breakpoint_debugger_set_breakpoint_at_line_default (IAnjutaBreakpointDebugger *obj, const gchar* file,   guint line,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_breakpoint_debugger_base_init (IAnjutaBreakpointDebuggerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->clear_breakpoint = ianjuta_breakpoint_debugger_clear_breakpoint_default;
	klass->condition_breakpoint = ianjuta_breakpoint_debugger_condition_breakpoint_default;
	klass->enable_breakpoint = ianjuta_breakpoint_debugger_enable_breakpoint_default;
	klass->ignore_breakpoint = ianjuta_breakpoint_debugger_ignore_breakpoint_default;
	klass->set_breakpoint_at_address = ianjuta_breakpoint_debugger_set_breakpoint_at_address_default;
	klass->set_breakpoint_at_function = ianjuta_breakpoint_debugger_set_breakpoint_at_function_default;
	klass->set_breakpoint_at_line = ianjuta_breakpoint_debugger_set_breakpoint_at_line_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_breakpoint_debugger_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaBreakpointDebuggerIface),
			(GBaseInitFunc) ianjuta_breakpoint_debugger_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaBreakpointDebugger", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
