/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-file.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_file_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-file-quark");
	}
	
	return quark;
}

/**
 * ianjuta_file_get_uri:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Returns the URI that was opened with ianjuta_file_open().
 *
 * Return value: The last URI opened.
 */
gchar*
ianjuta_file_get_uri (IAnjutaFile *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_FILE(obj), NULL);
	return IANJUTA_FILE_GET_IFACE (obj)->get_uri (obj, err);
}

/**
 * ianjuta_file_open:
 * @obj: Self
 * @uri: URI to open.
 * @err: Error propagation and reporting
 *
 * The implementor opens the given URI.
 */
void
ianjuta_file_open (IAnjutaFile *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_FILE_GET_IFACE (obj)->open (obj, uri, err);
}

static void
ianjuta_file_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_file_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaFileIface),
			ianjuta_file_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaFile", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
