/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __bookmarks_bonoboui_tb_h
#define __bookmarks_bonoboui_tb_h

#include <glib.h>
#include <glib-object.h>
#include <bonobo/bonobo-ui-component.h>
#include "bookmarks.h"
#include "bookmarks-util.h"
#include "bookmarks-location-source.h"

/* object forward declarations */

typedef struct _GbBonoboUIToolbar GbBonoboUIToolbar;
typedef struct _GbBonoboUIToolbarClass GbBonoboUIToolbarClass;
typedef struct _GbBonoboUIToolbarPrivate GbBonoboUIToolbarPrivate;

/**
 * GbBonoboUIToolbar object
 */

#define GB_TYPE_BONOBO_UI_TOOLBAR	(gb_bonobo_ui_toolbar_get_type())
#define GB_BONOBO_UI_TOOLBAR(object)	(G_TYPE_CHECK_INSTANCE_CAST((object), GB_TYPE_BONOBO_UI_TOOLBAR,\
					 GbBonoboUIToolbar))
#define GB_BONOBO_UI_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), GB_TYPE_BONOBO_UI_TOOLBAR,\
					   GbBonoboUIToolbarClass))
#define GB_IS_BONOBO_UI_TOOLBAR(object)	(G_TYPE_CHECK_INSTANCE_TYPE((object), GB_TYPE_BONOBO_UI_TOOLBAR))
#define GB_IS_BONOBO_UI_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GB_TYPE_BONOBO_UI_TOOLBAR))
#define GB_BONOBO_UI_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), GB_TYPE_BONOBO_UI_TOOLBAR,\
					     GbBonoboUIToolbarClass))

struct _GbBonoboUIToolbarClass
{
	GObjectClass parent_class;

	/* signals */
	GbBookmarkActivatedCallback gb_bonobo_ui_toolbar_bookmark_activated;

};

/* Remember: fields are public read-only */
struct _GbBonoboUIToolbar
{
	GObject parent_object;
	
	GbBonoboUIToolbarPrivate *priv;
};

GType			gb_bonobo_ui_toolbar_get_type	(void);
GbBonoboUIToolbar *	gb_bonobo_ui_toolbar_new	(GbBookmarkSet *set, BonoboUIComponent *uic);
void			gb_bonobo_ui_toolbar_set_visible (GbBonoboUIToolbar *buit, gboolean visible);
void			gb_bonobo_ui_toolbar_set_location_source (GbBonoboUIToolbar *buim,
								  GbLocationSource *src);

#endif
