// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_FILE_H
#define _GIOMM_FILE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/error.h>
#include <glibmm/interface.h>
#include <giomm/asyncresult.h>
#include <giomm/fileattributeinfolist.h>
#include <giomm/fileenumerator.h>
#include <giomm/fileinfo.h>
#include <giomm/fileinputstream.h>
#include <giomm/filemonitor.h>
#include <giomm/fileoutputstream.h>
#include <giomm/mountoperation.h>
//#include <giomm/volume.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GFileIface GFileIface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GFile GFile;
typedef struct _GFileClass GFileClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class File_Class; } // namespace Gio
namespace Gio
{

class Volume;

/** @addtogroup giommEnums Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum FileQueryInfoFlags
{
  FILE_QUERY_INFO_NONE
};


/**
 * @ingroup giommEnums
 */
enum FileCreateFlags
{
  FILE_CREATE_NONE
};


/**
 * @ingroup giommEnums
 */
enum FileCopyFlags
{
  FILE_COPY_NONE
};


/**
 * @ingroup giommEnums
 */
enum FileMonitorFlags
{
  FILE_MONITOR_NONE
};


/**
 * @ingroup giommEnums
 */
enum MountUnmountFlags
{
  MOUNT_UNMOUNT_NONE
};


/** File and directory handling.
 * Gio::File is a high level abstraction for manipulating files on a virtual file system. Gio::Files are lightweight, immutable objects that do no 
 * I/O upon creation. It is necessary to understand that a Gio::File object does not represent a file, merely a handle to a file. All file I/O is 
 * implemented as streaming operations (see Gio::InputStream and Gio::OutputStream).
 *
 * A GioFile can be constructed from a path, URI, or a command line argument.
 *
 * You can move through the filesystem with Gio::File handles with get_parent() to get a handle to the parent directory, 
 * get_child() to get a handle to a child within a directory, and resolve_relative_path() to resolve a relative path between two Gio::Files.
 *
 * Many Gio::File operations have both synchronous and asynchronous versions to suit your application. Asynchronous versions of synchronous 
 * functions simply have _async() appended to their function names. The asynchronous I/O functions call a SlotAsyncReady callback slot which is 
 * then used to finalize the operation, producing a AsyncResult which is then passed to the function's matching _finish() operation.
 *
 * Some Gio::File operations do not have synchronous analogs, as they may take a very long time to finish, and blocking may leave an application 
 * unusable. Notable cases include: mount_mountable() to mount a mountable file, unmount_mountable() to unmount a mountable file, 
 * and eject_mountable() to eject a mountable file.
 * 
 * One notable feature of Gio::Files are entity tags, or "etags" for short. Entity tags are somewhat like a more abstract version of the 
 * traditional mtime, and can be used to quickly determine if the file has been modified from the version on the file system. 
 * See the HTTP 1.1 specification for HTTP Etag headers, which are a very similar concept.
 *
 * @newin2p16
 */ 

class File : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef File CppObjectType;
  typedef File_Class CppClassType;
  typedef GFile BaseObjectType;
  typedef GFileIface BaseClassType;

private:
  friend class File_Class;
  static CppClassType file_class_;

  // noncopyable
  File(const File&);
  File& operator=(const File&);

protected:
  File(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit File(GFile* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~File();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GFile*       gobj()       { return reinterpret_cast<GFile*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GFile* gobj() const { return reinterpret_cast<GFile*>(gobject_); }

private:


public:
  
  
  // Although this is an interface, it is possible to create objects using
  // its static create* members. In the implementation, these would lead
  // to functions of the default GVfs implementation, which, in case of
  // this class' create methods, would rely on concrete GFile implementations
  // such as GLocalFile and GDummyFile.

  /** Constructs a File for a given path.
   * This operation never fails, but the returned object might not support any I/O operation if path is malformed.
   *
   * @param path A string containing a relative or absolute path.
   * @result A new instantiation of an appropriate Gio::File class.
   */
  static Glib::RefPtr<File> create_for_path(const std::string& path);

  /** Constructs a File for a given URI.
   * This operation never fails, but the returned object might not support any I/O operation if path is malformed.
   *
   * @param uri A string containing a URI.
   * @result A new instantiation of an appropriate Gio::File class.
   */
  static Glib::RefPtr<File> create_for_uri(const std::string& uri);

  /** Constructs a File for a given argument from the command line. 
   * The value of @a arg can be either a URI, an absolute path or a relative path resolved relative to the current working directory. 
   * This operation never fails, but the returned object might not support any I/O operation if arg points to a malformed path.
   *
   * @param arg A string containing a relative or absolute path.
   * @result A new instantiation of an appropriate Gio::File class.
   */
  static Glib::RefPtr<File> create_for_commandline_arg(const std::string& arg);

  // parse_name is a UTF8-guaranteed "nice" string that can both
  // be resolved to a GFile (via create_for_parse_name) and put in
  // e.g. a GtkEntry. In practice, it is either a UTF8-only absolute
  // filename (if it starts with a /), or an IRI (i.e. a URI that allows
  // UTF8-encoded unicode chars instead of escaping them).
  static Glib::RefPtr<File> create_for_parse_name(const Glib::ustring& parse_name);

  
  /** Duplicates a G::File handle. This operation does not duplicate 
   * the actual file or directory represented by the G::File; see 
   * g_file_copy() if attempting to copy a file. 
   * 
   * This call does no blocking i/o.
   * @return G::File that is a duplicate of the given G::File.
   */
  Glib::RefPtr<File> dup() const;

  // The method intended to be used for making hash tables
  // (g_hash_table_new in C).
  
  /** Creates a hash value for a G::File.
   * 
   * This call does no blocking i/o.
   * @param file #gconstpointer to a G::File.
   * @return 0 if @a file  is not a valid G::File, otherwise an 
   * integer that can be used as hash value for the G::File. 
   * This function is intended for easily hashing a G::File to 
   * add to a G::HashTable or similar data structure.
   */
  guint hash() const;

  //Not that the implementation of equal() is already virtual via equal_vfunc().
  
  /** Checks equality of two given G::File&lt;!-- --&gt;s
   * 
   * This call does no blocking i/o.
   * @param file2 The second G::File.
   * @return <tt>true</tt> if @a file1  and @a file2  are equal.
   * <tt>false</tt> if either is not a G::File.
   */
  bool equal(const Glib::RefPtr<File>& other) const;

  
  /** Gets the basename (the last component of the path) for a given G::File.
   * 
   * If called for the toplevel of a system (such as the filesystem root
   * or a uri like sftp://host/ it will return a single directory separator
   * (and on Windows, possibly a drive letter).
   * 
   * This call does no blocking i/o.
   * @return String containing the G::File's base name, or <tt>0</tt> 
   * if given G::File is invalid. The returned string should be 
   * freed with Glib::free() when no longer needed.
   */
  std::string get_basename() const;
  
  /** Gets the local pathname for G::File, if one exists. 
   * 
   * This call does no blocking i/o.
   * @return String containing the G::File's path, or <tt>0</tt> if 
   * no such path exists. The returned string should be 
   * freed with Glib::free() when no longer needed.
   */
  std::string get_path() const;
  
  /** Gets the URI for the @a file .
   * 
   * This call does no blocking i/o.
   * @return A string containing the G::File's URI.
   * The returned string should be freed with Glib::free() when no longer needed.
   */
  std::string get_uri() const;
  
  /** Gets the parse name of the @a file .
   * A parse name is a UTF-8 string that describes the
   * file such that one can get the G::File back using
   * g_file_parse_name().
   * 
   * This is generally used to show the G::File as a nice
   * string in a user interface, like in a location entry.
   * 
   * For local files with names that can safely be converted
   * to UTF8 the pathname is used, otherwise the IRI is used
   * (a form of URI that allows UTF8 characters unescaped).
   * 
   * This call does no blocking i/o.
   * @return A string containing the G::File's parse name. The returned 
   * string should be freed with Glib::free() when no longer needed.
   */
  Glib::ustring get_parse_name() const;

  //Note that these return a reference (usually new instances, 
  //so we don't need to use refreturn.

  //TODO: Do we need const and unconst versions of these get_*() methods,
  //or do we consider that the returned File cannot be used to change "this".
  //murrayc.
  
  /** Gets the parent directory for the @a file . 
   * If the @a file  represents the root directory of the 
   * file system, then <tt>0</tt> will be returned.
   * 
   * This call does no blocking i/o.
   * @return A G::File structure to the parent of the given
   * G::File or <tt>0</tt> if there is no parent.
   */
  Glib::RefPtr<File> get_parent() const;

  
  /** Gets a specific child of @a file  with name equal to @a name .
   * 
   * Note that the file with that specific name might not exist, but
   * you can still have a G::File that points to it. You can use this
   * for instance to create that file.
   * 
   * This call does no blocking i/o.
   * @param name String containing the child's name.
   * @return A G::File to a child specified by @a name .
   */
  Glib::RefPtr<File> get_child(const std::string& name) const;

  
  /** Gets the child of @a file  for a given @a display_name  (i.e.\ a UTF8
   * version of the name). If this function fails, it returns <tt>0</tt> and @a error  will be 
   * set. This is very useful when constructing a GFile for a new file
   * and the user entered the filename in the user interface, for instance
   * when you select a directory and type a filename in the file selector.
   * 
   * This call does no blocking i/o.
   * @param display_name String to a possible child.
   * @param error G::Error.
   * @return A G::File to the specified child, or 
   * <tt>0</tt> if the display name couldn't be converted.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<File> get_child_for_display_name(const std::string& display_name) const;
#else
  Glib::RefPtr<File> get_child_for_display_name(const std::string& display_name, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Checks whether @a parent  (recursively) contains the specified @a descendent .
   * 
   * This call does no blocking i/o.
   * @param descendant Input G::File.
   * @return <tt>true</tt> if the @a descendent 's parent, grandparent, etc is @a parent . <tt>false</tt> otherwise.
   */
  bool contains_file(const Glib::RefPtr<File>& descendant) const;
  
  /** Gets the path for @a descendant  relative to @a parent . 
   * 
   * This call does no blocking i/o.
   * @param descendant Input G::File.
   * @return String with the relative path from @a descendant  
   * to @a parent , or <tt>0</tt> if @a descendant  is not a descendant of @a parent . The returned string should be freed with 
   * Glib::free() when no longer needed.
   */
  std::string get_relative_path(const Glib::RefPtr<File>& descendant) const;
  
  /** Resolves a relative path for @a file  to an absolute path.
   * 
   * This call does no blocking i/o.
   * @param relative_path A given relative path string.
   * @return G::File to the resolved path. <tt>0</tt> if @a relative_path  
   * is <tt>0</tt> or if @a file  is invalid.
   */
  Glib::RefPtr<File> resolve_relative_path(const std::string& relative_path) const;
  
  /** Checks to see if a file is native to the platform.
   * 
   * A native file s one expressed in the platform-native filename format,
   * e.g. "C:\Windows" or "/usr/bin/". This does not mean the file is local,
   * as it might be on a locally mounted remote filesystem.
   * 
   * On some systems non-native files may be availible using
   * the native filesystem via a userspace filesystem (FUSE), in
   * these cases this call will return <tt>false</tt>, but g_file_get_path()
   * will still return a native path.
   * 
   * This call does no blocking i/o.
   * @return <tt>true</tt> if file is native.
   */
  bool is_native() const;
  
  /** Checks to see if a G::File has a given URI scheme.
   * 
   * This call does no blocking i/o.
   * @param uri_scheme A string containing a URI scheme.
   * @return <tt>true</tt> if G::File's backend supports the
   * given URI scheme, <tt>false</tt> if URI scheme is <tt>0</tt>,
   * not supported, or G::File is invalid.
   */
  bool has_uri_scheme(const std::string& uri_scheme) const;

  
  /** Gets the URI scheme for a G::File.
   * RFC 3986 decodes the scheme as:
   * 
   * URI = scheme ":" hier-part [ "?" query ] [ "#" fragment ] 
   * 
   * Common schemes include "file", "http", "ftp", etc. 
   * 
   * This call does no blocking i/o.
   * @return A string containing the URI scheme for the given 
   * G::File. The returned string should be freed with Glib::free() 
   * when no longer needed.
   */
  std::string get_uri_scheme() const;

  //TODO: We don't have both const and unconst versions because a FileInputStream can't really change the File.
  
  /** Opens a file for reading. The result is a G::FileInputStream that
   * can be used to read the contents of the file.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned. 
   * 
   * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
   * If the file is a directory, the G_IO_ERROR_IS_DIRECTORY error will be returned.
   * Other errors are possible too, and depend on what kind of filesystem the file is on.
   * @param cancellable A G::Cancellable.
   * @param error A G::Error, or <tt>0</tt>.
   * @return G::FileInputStream or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInputStream> read(const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileInputStream> read(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Opens a file for reading. The result is a FileInputStream that
   * can be used to read the contents of the file.
   * 
   * If the file does not exist, the IO_ERROR_NOT_FOUND error will be returned.
   * If the file is a directory, theIO_ERROR_IS_DIRECTORY error will be returned.
   * Other errors are possible too, and depend on what kind of filesystem the file is on.
   * @return FileInputStream or an empty RefPtr on error.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInputStream> read();
  #else
  Glib::RefPtr<FileInputStream> read(std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Asynchronously opens the file for reading.
   * For more details, see read() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call read_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param io_priority The I/O priority of the request.
   */
  void read_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously opens the file for reading.
   * For more details, see read() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call read_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param io_priority The I/O priority of the request.
   */
  void read_async(const SlotAsyncReady& slot, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an asynchronous file read operation started with 
   * g_file_read_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileInputStream or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInputStream> read_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileInputStream> read_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Gets an output stream for appending data to the file. If
   * the file doesn't already exist it is created.
   * 
   * By default files created are generally readable by everyone,
   * but if you pass G::FILE_CREATE_PRIVATE in @a flags  the file
   * will be made readable only to the current user, to the level that
   * is supported on the target filesystem.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned. 
   * 
   * Some filesystems don't allow all filenames, and may
   * return an G_IO_ERROR_INVALID_FILENAME error.
   * If the file is a directory the G_IO_ERROR_IS_DIRECTORY error will be
   * returned. Other errors are possible too, and depend on what kind of
   * filesystem the file is on.
   * @param flags A set of G::FileCreateFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileOutputStream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> append_to(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileOutputStream> append_to(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //We renamed this to create_file from (g_file_create()), to avoid confusion with static create() methods, 
  //but I would still like to choose a different word, but can't think of a good one. murrayc.
  
  /** Creates a new file and returns an output stream for writing to it.
   * The file must not already exists.
   * 
   * By default files created are generally readable by everyone,
   * but if you pass G::FILE_CREATE_PRIVATE in @a flags  the file
   * will be made readable only to the current user, to the level that
   * is supported on the target filesystem.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned. 
   * 
   * If a file with this name already exists the G_IO_ERROR_EXISTS error
   * will be returned. If the file is a directory the G_IO_ERROR_IS_DIRECTORY
   * error will be returned.
   * Some filesystems don't allow all filenames, and may
   * return an G_IO_ERROR_INVALID_FILENAME error, and if the name
   * is to long G_IO_ERROR_FILENAME_TOO_LONG will be returned.
   * Other errors are possible too, and depend on what kind of
   * filesystem the file is on.
   * @param flags A set of G::FileCreateFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileOutputStream for the newly created file, or 
   * <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> create_file(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileOutputStream> create_file(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: Rephrase this documentation in terms of _throwing_ exceptions instead of returning errors. And what exception is thrown?

  /** Returns an output stream for overwriting the file, possibly creating a backup copy of the file first.
   * This will try to replace the file in the safest way possible so that any errors during the writing will 
   * not affect an already existing copy of the file. For instance, for local files it may write to a 
   * temporary file and then atomically rename over the destination when the stream is closed.
   *
   * By default files created are generally readable by everyone, but if you pass FILE_CREATE_PRIVATE in 
   * @a flags the file will be made readable only to the current user, to the level that is supported on the 
   * target filesystem.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. 
   * If the operation was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * If you pass in an etag value, then this value is compared to the current entity tag of the file, 
   * and if they differ an IO_ERROR_WRONG_ETAG error is returned. This generally means that the file has 
   * been changed since you last read it. You can get the new etag from FileOutputStream::get_etag() 
   * after you've finished writing and closed the FileOutputStream. When you load a new file you can 
   * use FileInputStream::query_info() to get the etag of the file.
   *
   * If @a make_backup is true, this function will attempt to make a backup of the current file before 
   * overwriting it. If this fails a IO_ERROR_CANT_CREATE_BACKUP error will be returned. If you want to replace 
   * anyway, try again with @a make_backup set to false.
   *
   * If the file is a directory the IO_ERROR_IS_DIRECTORY error will be returned, and if the file is some 
   * other form of non-regular file then a IO_ERROR_NOT_REGULAR_FILE error will be returned. Some file 
   * systems don't allow all file names, and may return an IO_ERROR_INVALID_FILENAME error, and if the 
   * name is to long IO_ERROR_FILENAME_TOO_LONG will be returned. Other errors are possible too, and 
   * depend on what kind of filesystem the file is on.
   * 
   * @param etag An optional entity tag for the current Glib::File.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @return A FileOutputStream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> replace(const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag = std::string(), bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  Glib::RefPtr<FileOutputStream> replace(const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Returns an output stream for overwriting the file, possibly creating a backup copy of the file first.
   * This will try to replace the file in the safest way possible so that any errors during the writing will 
   * not affect an already existing copy of the file. For instance, for local files it may write to a 
   * temporary file and then atomically rename over the destination when the stream is closed.
   *
   * By default files created are generally readable by everyone, but if you pass FILE_CREATE_PRIVATE in 
   * @a flags the file will be made readable only to the current user, to the level that is supported on the 
   * target filesystem.
   *
   * If you pass in an etag value, then this value is compared to the current entity tag of the file, 
   * and if they differ an IO_ERROR_WRONG_ETAG error is returned. This generally means that the file has 
   * been changed since you last read it. You can get the new etag from FileOutputStream::get_etag() 
   * after you've finished writing and closed the FileOutputStream. When you load a new file you can 
   * use FileInputStream::query_info() to get the etag of the file.
   *
   * If @a make_backup is true, this function will attempt to make a backup of the current file before 
   * overwriting it. If this fails a IO_ERROR_CANT_CREATE_BACKUP error will be returned. If you want to replace 
   * anyway, try again with @a make_backup set to false.
   *
   * If the file is a directory the IO_ERROR_IS_DIRECTORY error will be returned, and if the file is some 
   * other form of non-regular file then a IO_ERROR_NOT_REGULAR_FILE error will be returned. Some file 
   * systems don't allow all file names, and may return an IO_ERROR_INVALID_FILENAME error, and if the 
   * name is to long IO_ERROR_FILENAME_TOO_LONG will be returned. Other errors are possible too, and 
   * depend on what kind of filesystem the file is on.
   * 
   * @param etag An optional entity tag for the current Glib::File.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @return A FileOutputStream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> replace(const std::string& etag = std::string(), bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  Glib::RefPtr<FileOutputStream> replace(const std::string& etag, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Asynchronously opens the file for appending.
   * For more details, see append_to() which is the synchronous version of this call.
   * 
   * When the operation is finished, @a slot will be called. You can then call append_to_finish() to get the result of the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param flags a set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   */
  void append_to_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously opens the file for appending.
   * For more details, see append_to() which is the synchronous version of this call.
   * 
   * When the operation is finished, @a slot will be called. You can then call append_to_finish() to get the result of the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param flags a set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   */
  void append_to_async(const SlotAsyncReady& slot, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an asynchronous file append operation started with 
   * g_file_append_to_async().
   * @param res G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A valid G::FileOutputStream or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> append_to_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileOutputStream> append_to_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //We renamed this to create_file_async from (g_file_create_async()), to avoid confusion with static create() methods, 
  //but I would still like to choose a different word, but can't think of a good one. murrayc. See also create_file().

  /** Asynchronously creates a new file and returns an output stream for writing to it. The file must not already exist.
   * For more details, see create() which is the synchronous version of this call.
   *
   * When the operation is finished, @a slot will be called. You can then call create_file_finish() to get the result of the operation.
   * 
   * @param flags a set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void create_file_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously creates a new file and returns an output stream for writing to it. The file must not already exist.
   * For more details, see create() which is the synchronous version of this call.
   *
   * When the operation is finished, @a slot will be called. You can then call create_file_finish() to get the result of the operation.
   * 
   * @param flags a set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void create_file_async(const SlotAsyncReady& slot, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an asynchronous file create operation started with 
   * g_file_create_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileOutputStream or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> create_file_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileOutputStream> create_file_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Asyncronously overwrites the file, replacing the contents, possibly creating a backup copy of the file first.
   * For more details, see replace() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call replace_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param etag An entity tag for the current Gio::File.
   * @param make_backup true if a backup of the existing file should be made.
   * @param flags A set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   */
  void replace_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag = std::string(), bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);

  /** Asyncronously overwrites the file, replacing the contents, possibly creating a backup copy of the file first.
   * For more details, see replace() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call replace_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param etag An entity tag for the current Gio::File.
   * @param make_backup true if a backup of the existing file should be made.
   * @param flags A set of FileCreateFlags.
   * @param io_priority The I/O priority of the request.
   */
  void replace_async(const SlotAsyncReady& slot, const std::string& etag = std::string(), bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an asynchronous file replace operation started with 
   * g_file_replace_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileOutputStream, or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileOutputStream> replace_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileOutputStream> replace_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the requested information about the file. The result
   * is a FileInfo object that contains key-value attributes (such as the  type or size
   * of the file).
   *
   * The @a attribute value is a string that specifies the file attributes that
   * should be gathered. It is not an error if it's not possible to read a particular
   * requested attribute from a file - it just won't be set. @a attribute should
   * be a comma-separated list of attribute or attribute wildcards. The wildcard "*"
   * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
   * namespace. An example attribute query be "standard::*,owner::user".
   * The standard attributes are available as defines, like #G_FILE_ATTRIBUTE_STANDARD_NAME.
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
   *
   * For symlinks, normally the information about the target of the
   * symlink is returned, rather than information about the symlink itself.
   * However if you pass FILE_QUERY_INFO_NOFOLLOW_SYMLINKS in @a flags the
   * information about the symlink itself will be returned. Also, for symlinks
   * that point to non-existing files the information about the symlink itself
   * will be returned.
   *
   * If the file does not exist, the IO_ERROR_NOT_FOUND error will be returned.
   * Other errors are possible too, and depend on what kind of filesystem the file is on.
   *
   * @param cancellable A Cancellable object.
   * @param attributes: An attribute query string.
   * @param flags: A set of FileQueryInfoFlags.
   * @result a FileInfo for the file, or an empty RefPtr on error.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_info(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE) const;
  #else
  Glib::RefPtr<FileInfo> query_info(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes, FileQueryInfoFlags flags, std::auto_ptr<Glib::Error>& error) const;
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Gets the requested information about the file. The result
   * is a FileInfo object that contains key-value attributes (such as the  type or size
   * of the file).
   *
   * The @a attribute value is a string that specifies the file attributes that
   * should be gathered. It is not an error if it's not possible to read a particular
   * requested attribute from a file - it just won't be set. @a attribute should
   * be a comma-separated list of attribute or attribute wildcards. The wildcard "*"
   * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
   * namespace. An example attribute query be "standard::*,owner::user".
   * The standard attributes are available as defines, like #G_FILE_ATTRIBUTE_STANDARD_NAME.
   *
   * For symlinks, normally the information about the target of the
   * symlink is returned, rather than information about the symlink itself.
   * However if you pass FILE_QUERY_INFO_NOFOLLOW_SYMLINKS in @a flags the
   * information about the symlink itself will be returned. Also, for symlinks
   * that point to non-existing files the information about the symlink itself
   * will be returned.
   *
   * If the file does not exist, the IO_ERROR_NOT_FOUND error will be returned.
   * Other errors are possible too, and depend on what kind of filesystem the file is on.
   *
   * @param attributes: An attribute query string.
   * @param flags: A set of FileQueryInfoFlags.
   * @result a FileInfo for the file, or an empty RefPtr on error.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_info(const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE) const;
  #else
  Glib::RefPtr<FileInfo> query_info(const std::string& attributes, FileQueryInfoFlags flags, std::auto_ptr<Glib::Error>& error) const;
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
  bool query_exists(const Glib::RefPtr<Cancellable>& cancellable) const;


  /** Utility function to check if a particular file exists. This is
   * implemented using query_info() and as such does blocking I/O.
   *
   * Note that in many cases it is racy to first check for file existance
   * and then execute something based on the outcome of that, because the
   * file might have been created or removed inbetween the operations. The
   * general approach to handling that is to not check, but just do the
   * operation and handle the errors as they come.
   *
   * As an example of race-free checking, take the case of reading a file, and
   * if it doesn't exist, creating it. There are two racy versions: read it, and
   * on error create it; and: check if it exists, if not create it. These
   * can both result in two processes creating the file (with perhaps a partially
   * written file as the result). The correct approach is to always try to create
   * the file with g_file_create() which will either atomically create the file
   * or fail with an IO_ERROR_EXISTS error.
   *
   * However, in many cases an existance check is useful in a user
   * interface, for instance to make a menu item sensitive/insensitive, so that
   * you don't have to fool users that something is possible and then just show
   * and error dialog. If you do this, you should make sure to also handle the
   * errors that can happen due to races when you execute the operation.
   * 
   * @result true if the file exists (and can be detected without error), false otherwise (or if cancelled).
   */
  bool query_exists() const;


  /** Asynchronously gets the requested information about specified file. The result is a FileInfo object that contains key-value attributes (such as type or size for the file).
   *
   * For more details, see query_info() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call query_info_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   */
  void query_info_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT) const;

  /** Asynchronously gets the requested information about specified file. The result is a FileInfo object that contains key-value attributes (such as type or size for the file).
   *
   * For more details, see query_info() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call query_info_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   */
  void query_info_async(const SlotAsyncReady& slot, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT) const;
  

  /** Finishes an asynchronous file info query. 
   * See g_file_query_info_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error.
   * @return G::FileInfo for given @a file  or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_info_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileInfo> query_info_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Similar to g_file_query_info(), but obtains information
   * about the filesystem the file is on, rather than the file itself.
   * For instance the amount of space availible and the type of
   * the filesystem.
   * 
   * The @a attribute  value is a string that specifies the file attributes that
   * should be gathered. It is not an error if its not possible to read a particular
   * requested attribute from a file, it just won't be set. @a attribute  should
   * be a comma-separated list of attribute or attribute wildcards. The wildcard "*"
   * means all attributes, and a wildcard like "fs:*" means all attributes in the fs
   * namespace. The standard namespace for filesystem attributes is "fs".
   * Common attributes of interest are FILE_ATTRIBUTE_FILESYSTEM_SIZE
   * (the total size of the filesystem in bytes), FILE_ATTRIBUTE_FILESYSTEM_FREE (number of
   * bytes availible), and FILE_ATTRIBUTE_FILESYSTEM_TYPE (type of the filesystem).
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
   * 
   * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
   * Other errors are possible too, and depend on what kind of filesystem the file is on.
   * @param cancellable A Cancellable object.
   * @param attributes An attribute query string.
   * @return A FileInfo or an empty RefPtr if there was an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_filesystem_info(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes = "*");
#else
  Glib::RefPtr<FileInfo> query_filesystem_info(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Gets the requested information about the files in a directory. The result
   * is a FileEnumerator object that will give out FileInfo objects for
   * all the files in the directory.
   * 
   * The @a attribute  value is a string that specifies the file attributes that
   * should be gathered. It is not an error if its not possible to read a particular
   * requested attribute from a file, it just won't be set. @a attribute  should
   * be a comma-separated list of attribute or attribute wildcards. The wildcard "*"
   * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
   * namespace. An example attribute query be "standard::*,owner::user".
   * The standard attributes are availible as defines, like FILE_ATTRIBUTE_STANDARD_NAME.
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
   * 
   * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
   * If the file is not a directory, the G_FILE_ERROR_NOTDIR error will be returned.
   * Other errors are possible too.
   *
   * @param cancellable A Cancellable object.
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @return A FileEnumerator if successful, <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileEnumerator> enumerate_children(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE);
#else
  Glib::RefPtr<FileEnumerator> enumerate_children(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes, FileQueryInfoFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Gets the requested information about the files in a directory. The result
   * is a FileEnumerator object that will give out FileInfo objects for
   * all the files in the directory.
   * 
   * The @a attribute  value is a string that specifies the file attributes that
   * should be gathered. It is not an error if its not possible to read a particular
   * requested attribute from a file, it just won't be set. @a attribute  should
   * be a comma-separated list of attribute or attribute wildcards. The wildcard "*"
   * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
   * namespace. An example attribute query be "standard::*,owner::user".
   * The standard attributes are availible as defines, like FILE_ATTRIBUTE_STANDARD_NAME.
   * 
   * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
   * If the file is not a directory, the G_FILE_ERROR_NOTDIR error will be returned.
   * Other errors are possible too.
   *
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @return A FileEnumerator if successful, <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileEnumerator> enumerate_children(const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE);
#else
  Glib::RefPtr<FileEnumerator> enumerate_children(const std::string& attributes, FileQueryInfoFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Asynchronously gets the requested information about the files in a directory. The result is a GFileEnumerator object that will give out GFileInfo objects for all the files in the directory.
   *
   * For more details, see enumerate_children() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call enumerate_children_finish() to get the result of the operation.
   *
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void enumerate_children_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously gets the requested information about the files in a directory. The result is a GFileEnumerator object that will give out GFileInfo objects for all the files in the directory.
   *
   * For more details, see enumerate_children() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call enumerate_children_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param attributes An attribute query string.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   */
  void enumerate_children_async(const SlotAsyncReady& slot, const std::string& attributes = "*", FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes an async enumerate children operation.
   * See g_file_enumerate_children_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error.
   * @return A G::FileEnumerator or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileEnumerator> enumerate_children_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileEnumerator> enumerate_children_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Renames @a file  to the specified display name.
   * 
   * The display name is converted from UTF8 to the correct encoding for the target
   * filesystem if possible and the @a file  is renamed to this.
   * 
   * If you want to implement a rename operation in the user interface the edit name
   * (G::FILE_ATTRIBUTE_STANDARD_EDIT_NAME) should be used as the initial value in the rename
   * widget, and then the result after editing should be passed to g_file_set_display_name().
   * 
   * On success the resulting converted filename is returned.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param display_name A string.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::File specifying what @a file  was renamed to, or <tt>0</tt> if there was an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<File> set_display_name(const Glib::ustring& display_name, const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<File> set_display_name(const Glib::ustring& display_name, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Renames the file to the specified display name.
   * 
   * The display name is converted from UTF8 to the correct encoding for the target
   * filesystem if possible and the file is renamed to this.
   * 
   * If you want to implement a rename operation in the user interface the edit name
   * (G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME) should be used as the initial value in the rename
   * widget, and then the result after editing should be passed to set_display_name().
   * 
   * On success the resulting converted filename is returned.
   * 
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * @param display_name A string.
   * @return A Glib::File specifying what the file was renamed to, or an empty RefPtr if there was an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<File> set_display_name(const Glib::ustring& display_name);
#else
  Glib::RefPtr<File> set_display_name(const Glib::ustring& display_name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Asynchronously sets the display name for a given Gio::File. For the synchronous version of this function, see set_display_name().
   * When the operation is finished, @a slot will be called. You can then call set_display_name_finish() to get the result of the operation.
   *
   * @param display_name A string.
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param io_priority The I/O priority of the request.
   */
  void set_display_name_async(const Glib::ustring& display_name, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously sets the display name for a given Gio::File. For the synchronous version of this function, see set_display_name().
   * When the operation is finished, @a slot will be called. You can then call set_display_name_finish() to get the result of the operation.
   *
   * @param display_name A string.
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param io_priority The I/O priority of the request.
   */
  void set_display_name_async(const Glib::ustring& display_name, const SlotAsyncReady& slot, int io_priority = G_PRIORITY_DEFAULT);
  

  /** Finishes setting a display name started with 
   * g_file_set_display_name_async().
   * @param res A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::File or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<File> set_display_name_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<File> set_display_name_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: remember to add the docs manually, as we name the method differently.
   
  /** Deletes a file.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the file was deleted. <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool remove(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sends @a file  to the "Trashcan", if possible. This is similar to
   * deleting it, but the user can recover it before emptying the trashcan.
   * Not all filesystems support trashing, so this call can return the
   * G::IO_ERROR_NOT_SUPPORTED error.
   * 
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> on successful trash, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool trash(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool trash(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** A signal handler would be, for instance:
   * void on_file_progress(goffset current_num_bytes, goffset total_num_bytes);
   */
  typedef sigc::slot<void, goffset, goffset> SlotFileProgress;

  //TODO: Rephrase this in terms of exceptions rather than errors. And what exceptions are thrown?
  /** Copies the file source to the location specified by destination. Can not handle recursive copies of directories.
   * If the flag FILE_COPY_OVERWRITE is specified an already existing destination file is overwritten.
   * If the flag FILE_COPY_NOFOLLOW_SYMLINKS is specified then symlinks will be copied as symlinks, otherwise the target of the source symlink will be copied.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * The operation can be monitored via the @a slot callback.
   *
   * If the source file does not exist then the IO_ERROR_NOT_FOUND error is returned, independent on the status of the destination.
   *
   * If FILE_COPY_OVERWRITE is not specified and the target exists, then the error IO_ERROR_EXISTS is returned.
   *
   * If trying to overwrite a file over a directory the IO_ERROR_IS_DIRECTORY error is returned. 
   * If trying to overwrite a directory with a directory the IO_ERROR_WOULD_MERGE error is returned.
   *
   * If the source is a directory and the target does not exist, or FILE_COPY_OVERWRITE is specified and the target is a file, 
   * then the IO_ERROR_WOULD_RECURSE error is returned.
   *
   * If you are interested in copying the Gio::File object itself (not the on-disk file), see File::dup().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags = FILE_COPY_NONE, std::auto_ptr<Glib::Error>& error);
#endif

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags, std::auto_ptr<Glib::Error>& error);
#endif

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool copy(const Glib::RefPtr<File>& destination, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool copy(const Glib::RefPtr<File>& destination, FileCopyFlags flags, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED
  

  //TODO: Rephrase this in terms of exceptions rather than errors. And what exceptions are thrown?
  /** Tries to move the file or directory source to the location specified by destination. If native move operations are supported then this is 
   * used, otherwise a copy and delete fallback is used. The native implementation may support moving directories (for instance on moves inside 
   * the same filesystem), but the fallback code does not.
   *
   * If the flag FILE_COPY_OVERWRITE is specified an already existing destination file is overwritten.
   * 
   * If the flag FILE_COPY_NOFOLLOW_SYMLINKS is specified then symlinks will be copied as symlinks, otherwise the target of the source symlink will be copied.
   * 
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * The operation can be monitored via the @a slot callback.
   * If the source file does not exist then the IO_ERROR_NOT_FOUND error is returned, independent on the status of the destination.
   * 
   * If G_FILE_COPY_OVERWRITE is not specified and the target exists, then the error G_IO_ERROR_EXISTS is returned.
   * 
   * If trying to overwrite a file over a directory the IO_ERROR_IS_DIRECTORY error is returned. 
   * If trying to overwrite a directory with a directory the IO_ERROR_WOULD_MERGE error is returned.
   * 
   * If the source is a directory and the target does not exist, or FILE_COPY_OVERWRITE is specified and the target is a file, then the IO_ERROR_WOULD_RECURSE error may be returned (if the native move operation isn't available).
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags = FILE_COPY_NONE, std::auto_ptr<Glib::Error>& error);
#endif

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags, std::auto_ptr<Glib::Error>& error);
#endif

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool move(const Glib::RefPtr<File>& destination, FileCopyFlags flags = FILE_COPY_NONE);
#else
  bool move(const Glib::RefPtr<File>& destination, FileCopyFlags flags, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED
  

  /** Creates a directory.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> on successful creation, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool make_directory(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool make_directory(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Creates a symbolic link.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param symlink_value A string with the value of the new symlink.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error.
   * @return <tt>true</tt> on the creation of a new symlink, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool make_symbolic_link(const std::string& symlink_value, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool make_symbolic_link(const std::string& symlink_value, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Obtain the list of settable attributes for the file.
   * 
   * Returns: a G::FileAttributeInfoList describing the settable attributes.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileAttributeInfoList describing the settable attributes.
   * When you are done with it, release it with g_file_attribute_info_list_unref().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileAttributeInfoList> query_settable_attributes(const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileAttributeInfoList> query_settable_attributes(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Obtain the list of attribute namespaces where new attributes 
   * can be created by a user. An example of this is extended
   * attributes (in the "xattr" namespace).
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::FileAttributeInfoList describing the writable namespaces.
   * When you are done with it, release it with g_file_attribute_info_list_unref().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileAttributeInfoList> query_writable_namespaces(const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileAttributeInfoList> query_writable_namespaces(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Tries to set all attributes in the G::FileInfo on the target values, 
   * not stopping on the first error.
   * 
   * If there is any error during this operation then @a error  will be set to
   * the first error. Error on particular fields are flagged by setting 
   * the "status" field in the attribute value to 
   * G::FILE_ATTRIBUTE_STATUS_ERROR_SETTING, which means you can also detect
   * further errors.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param info A G::FileInfo.
   * @param flags G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if there was any error, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attributes_from_info(const Glib::RefPtr<FileInfo>& info, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attributes_from_info(const Glib::RefPtr<FileInfo>& info, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Asynchronously sets the attributes of file with info.
   *
   * For more details, see set_attributes_from_info() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call set_attributes_finish() to get the result of the operation.
   *
   * @param info A FileInfo.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void set_attributes_async(const Glib::RefPtr<FileInfo>& info, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT);

  /** Asynchronously sets the attributes of file with info.
   *
   * For more details, see set_attributes_from_info() which is the synchronous version of this call.
   * When the operation is finished, @a slot will be called. You can then call set_attributes_finish() to get the result of the operation.
   *
   * @param info A FileInfo.
   * @param flags A set of FileQueryInfoFlags.
   * @param io_priority The I/O priority of the request.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void set_attributes_async(const Glib::RefPtr<FileInfo>& info, const SlotAsyncReady& slot, FileQueryInfoFlags flags = FILE_QUERY_INFO_NONE, int io_priority = G_PRIORITY_DEFAULT);
  
   // takes GFileInfo**

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attributes_finish(const Glib::RefPtr<AsyncResult>& result, const Glib::RefPtr<FileInfo>& info);
#else
  bool set_attributes_finish(const Glib::RefPtr<AsyncResult>& result, const Glib::RefPtr<FileInfo>& info, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_STRING to @a value . 
   * If @a attribute  is of a different type, this operation will fail.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A string containing the attribute's value.
   * @param flags G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_BYTE_STRING to @a value . 
   * If @a attribute  is of a different type, this operation will fail, 
   * returning <tt>false</tt>. 
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A string containing the attribute's new value.
   * @param flags A G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set to @a value  
   * in the @a file , <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_UINT32 to @a value . 
   * If @a attribute  is of a different type, this operation will fail.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A #guint32 containing the attribute's new value.
   * @param flags A G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set to @a value  
   * in the @a file , <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_INT32 to @a value . 
   * If @a attribute  is of a different type, this operation will fail.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A #gint32 containing the attribute's new value.
   * @param flags A G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set to @a value  
   * in the @a file , <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_UINT64 to @a value . 
   * If @a attribute  is of a different type, this operation will fail.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A #guint64 containing the attribute's new value.
   * @param flags A G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set to @a value  
   * in the @a file , <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets @a attribute  of type G::FILE_ATTRIBUTE_TYPE_INT64 to @a value . 
   * If @a attribute  is of a different type, this operation will fail.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param attribute A string containing the attribute's name.
   * @param value A #guint64 containing the attribute's new value.
   * @param flags A G::FileQueryInfoFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a attribute  was successfully set, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Mounts a file of type FILE_TYPE_MOUNTABLE. Using @a mount_operation, you can request callbacks when, for instance, 
   * passwords are needed during authentication.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error 
   * IO_ERROR_CANCELLED will be returned.
   *
   * When the operation is finished, @a slot will be called. You can then call mount_mountable_finish() to get the result of the operation.
   *
   * @param flags Flags affecting the operation.
   * @param mount_operation A MountOperation.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  /** Mounts a file of type FILE_TYPE_MOUNTABLE. Using @a mount_operation, you can request callbacks when, for instance, 
   * passwords are needed during authentication.
   *
   * When the operation is finished, @a slot will be called. You can then call mount_mountable_finish() to get the result of the operation.
   *
   * @param flags Flags affecting the operation.
   * @param mount_operation A MountOperation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot);

  /** Mounts a file of type FILE_TYPE_MOUNTABLE without user interaction.
   *
   * When the operation is finished, @a slot will be called. You can then call mount_mountable_finish() to get the result of the operation.
   *
   * @param flags Flags affecting the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void mount_mountable(const SlotAsyncReady& slot);
  

  /** Finishes a mount operation. See g_file_mount_mountable() for details.
   * 
   * Finish an asynchronous mount operation that was started 
   * with g_file_mount_mountable().
   * @param result A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return A G::File or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<File> mount_mountable_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<File> mount_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Unmounts a file of type FILE_TYPE_MOUNTABLE.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error 
   * IO_ERROR_CANCELLED will be returned.
   *
   * When the operation is finished, @a slot will be called. You can then call unmount_mountable_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param flags Flags affecting the operation.
   */
  void unmount_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Unmounts a file of type FILE_TYPE_MOUNTABLE.
   *
   * When the operation is finished, @a slot will be called. You can then call unmount_mountable_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param flags Flags affecting the operation.
   */
  void unmount_mountable(const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Unmounts a file of type FILE_TYPE_MOUNTABLE.
   *
   * @param flags Flags affecting the operation.
   */
  void unmount_mountable(MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  

  /** Finishes an unmount operation, see g_file_unmount_mountable() for details.
   * 
   * Finish an asynchronous unmount operation that was started 
   * with g_file_unmount_mountable().
   * @param result A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the operation finished successfully. <tt>false</tt>
   * otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool unmount_mountable_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool unmount_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Starts an asynchronous eject on a mountable.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error 
   * IO_ERROR_CANCELLED will be returned.
   *
   * When the operation is finished, @a slot will be called. You can then call eject_mountable_finish() to get the result of the operation.
   *
   * @param flags Flags affecting the operation.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void eject_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Starts an asynchronous eject on a mountable.
   *
   * When the operation is finished, @a slot will be called. You can then call eject_mountable_finish() to get the result of the operation.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param flags Flags affecting the operation.
   */
  void eject_mountable(const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Starts an asynchronous eject on a mountable.
   *
   * @param flags Flags affecting the operation.
   */
  void eject_mountable(MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  

  /** Finishes an asynchronous eject operation started by 
   * g_file_eject_mountable().
   * @param result A G::AsyncResult.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a file  was ejected successfully. <tt>false</tt> 
   * otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool eject_mountable_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool eject_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Obtains a directory monitor for the given file.
   * This may fail if directory monitoring is not supported.
   * 
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * @param cancellable A Cancellable object.
   * @param flags A set of FileMonitorFlags.
   * @return A FileMonitor for the file , 
   * or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileMonitor> monitor_directory(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags = FILE_MONITOR_NONE);
#else
  Glib::RefPtr<FileMonitor> monitor_directory(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Obtains a directory monitor for the given file.
   * This may fail if directory monitoring is not supported.
   * 
   * @param flags A set of FileMonitorFlags.
   * @return A FileMonitor for the file , 
   * or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileMonitor> monitor_directory(FileMonitorFlags flags = FILE_MONITOR_NONE);
#else
  Glib::RefPtr<FileMonitor> monitor_directory(FileMonitorFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Obtains a file monitor for the given file. If no file notification
   * mechanism exists, then regular polling of the file is used.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param flags A set of G::FileMonitorFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @return A G::FileMonitor for the given @a file .
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileMonitor> monitor_file(FileMonitorFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileMonitor> monitor_file(FileMonitorFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Obtains a file monitor for the given file. If no file notification
   * mechanism exists, then regular polling of the file is used.
   * 
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * @param flags A set of FileMonitorFlags.
   * @param A Cancellable object.
   * @return A FileMonitor for the file.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileMonitor> monitor_file(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags = FILE_MONITOR_NONE);
#else
  Glib::RefPtr<FileMonitor> monitor_file(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Obtains a file monitor for the given file. If no file notification
   * mechanism exists, then regular polling of the file is used.
   * 
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * @param flags A set of FileMonitorFlags.
   * @param A Cancellable object.
   * @return A FileMonitor for the file.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileMonitor> monitor_file(FileMonitorFlags flags = FILE_MONITOR_NONE);
#else
  Glib::RefPtr<FileMonitor> monitor_file(FileMonitorFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: Documentation.
  //TODO: atm I don't understand what's etag_out:
  // "a pointer to the current entity tag for the document" - sounds like it
  // should be kept as char**
  
  /** Loads the content of the file into memory, returning the size of
   * the data. The data is always zero terminated, but this is not
   * included in the resultant @a length .
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param contents A location to place the contents of the file.
   * @param length A location to place the length of the contents of the file.
   * @param etag_out A location to place the current entity tag for the file.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the @a file 's contents were successfully loaded.
   * <tt>false</tt> if there were errors..
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_contents(const Glib::RefPtr<Cancellable>& cancellable, char** contents, gsize& length, char** etag_out);
#else
  bool load_contents(const Glib::RefPtr<Cancellable>& cancellable, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Starts an asynchronous load of the file's contents.
   * For more details, see load_contents() which is the synchronous version of this call.
   *
   * When the load operation has completed, the @a slot will be called. To finish the operation, 
   * call load_contents_finish() with the AsyncResult provided to the @a slot.
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. 
   * If the operation was cancelled, the error IO_ERROR_CANCELLED will be returned.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object.
   */
  void load_contents_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  /** Starts an asynchronous load of the file's contents.
   * For more details, see load_contents() which is the synchronous version of this call.
   *
   * When the load operation has completed, the @a slot will be called. To finish the operation, 
   * call load_contents_finish() with the AsyncResult provided to the @a slot.
   *
   * @param slot A callback slot which will be called when the request is satisfied.
   */
  void load_contents_async(const SlotAsyncReady& slot);
  

  /** Finishes an asynchronous load of the @a file 's contents. 
   * The contents are placed in @a contents , and @a length  is set to the 
   * size of the @a contents  string. If @a etag_out  is present, it will be 
   * set to the new entity tag for the @a file .
   * @param res A G::AsyncResult.
   * @param contents A location to place the contents of the file.
   * @param length A location to place the length of the contents of the file.
   * @param etag_out A location to place the current entity tag for the file.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the load was successful. If <tt>false</tt> and @a error  is 
   * present, it will be set appropriately.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out);
#else
  bool load_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** A signal handler would be, for instance:
   * bool on_read_more(const char* file_contents, goffset file_size);
   */
  typedef sigc::slot<bool, const char*, goffset> SlotReadMore;

  //Note that slot_read_more can be NULL but that would not be a useful method overload, because the documentation says that it would 
  //then be equivalent to load_contents_async.

  /** Reads the partial contents of a file.
   * The @a slot_read_more callback slot should be used to stop reading from the file when appropriate. This operation can be finished by load_partial_contents_finish().
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error 
   * IO_ERROR_CANCELLED will be returned.
   *
   * When the operation is finished, @a slot will be called. You can then call load_partial_contents_finish() to get the result of the operation.
   *
   * @param slot_read_more A callback to receive partial data and to specify whether further data should be read.
   * @param slot_async_ready A callback slot which will be called when the request is satisfied.
   * @param cancellable A Cancellable object which can be used to cancel the operation.
   */
  void load_partial_contents_async(const SlotReadMore& slot_read_more, const SlotAsyncReady& slot_async_ready, const Glib::RefPtr<Cancellable>& cancellable);

  /** Reads the partial contents of a file.
   * The @a slot_read_more callback slot should be used to stop reading from the file when appropriate. This operation can be finished by load_partial_contents_finish().
   *
   * The operation can be cancelled by triggering the cancellable object from another thread. If the operation was cancelled, the error 
   * IO_ERROR_CANCELLED will be returned.
   *
   * When the operation is finished, @a slot will be called. You can then call load_partial_contents_finish() to get the result of the operation.
   *
   * @param slot_read_more A callback to receive partial data and to specify whether further data should be read.
   * @param slot_async_ready A callback slot which will be called when the request is satisfied.
   */
  void load_partial_contents_async(const SlotReadMore& slot_read_more, const SlotAsyncReady& slot_async_ready);
  

  //TODO: atm I don't understand what's etag_out:
  // "a pointer to the current entity tag for the document" - sounds like it
  // should be kept as char**
  
  /** Finishes an asynchronous partial load operation that was started
   * with g_file_load_partial_contents_async().
   * @param res A G::AsyncResult.
   * @param contents A location to place the contents of the file.
   * @param length A location to place the length of the contents of the file.
   * @param etag_out A location to place the current entity tag for the file.
   * @param error A G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if the load was successful. If <tt>false</tt> and @a error  is 
   * present, it will be set appropriately.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_partial_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out);
#else
  bool load_partial_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Replaces the contents of @a file with @a contents of @a length bytes.
   *  
   * If @a etag is specified (not <tt>0</tt>) any existing file must have that etag, or
   * the error IO_ERROR_WRONG_ETAG will be returned.
   * 
   * If @a make_backup is <tt>true</tt>, this function will attempt to make a backup of the file.
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
   * 
   * The returned @a new_etag  can be used to verify that the file hasn't changed the
   * next time it is saved over.
   * @param contents A string containing the new contents for the file.
   * @param length The length of @a contents in bytes.
   * @param etag The old entity tag 
   * for the document.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @param new_etag A location to a new entity tag
   * for the document.
   * @param cancellable A Cancellable object.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents(const char* contents, gsize length, const std::string& etag, std::string& new_etag, const Glib::RefPtr<Cancellable>& cancellable, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  void replace_contents(const char* contents, gsize length, const std::string& etag, std::string& new_etag, const Glib::RefPtr<Cancellable>& cancellable, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Replaces the contents of @a file with @a contents of @a length bytes.
   *  
   * If @a etag is specified (not <tt>0</tt>) any existing file must have that etag, or
   * the error IO_ERROR_WRONG_ETAG will be returned.
   * 
   * If @a make_backup is <tt>true</tt>, this function will attempt to make a backup of @a file.
   * 
   * The returned @a new_etag  can be used to verify that the file hasn't changed the
   * next time it is saved over.
   * @param contents A string containing the new contents for the file.
   * @param length The length of @a contents in bytes.
   * @param etag The old entity tag 
   * for the document.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @param new_etag A location to a new entity tag
   * for the document.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents(const char* contents, gsize length, const std::string& etag, std::string& new_etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  void replace_contents(const char* contents, gsize length, const std::string& etag, std::string& new_etag, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Replaces the contents of @a file with @a contents.
   *  
   * If @a etag is specified (not <tt>0</tt>) any existing file must have that etag, or
   * the error IO_ERROR_WRONG_ETAG will be returned.
   * 
   * If @a make_backup is <tt>true</tt>, this function will attempt to make a backup of the file.
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
   * 
   * The returned @a new_etag  can be used to verify that the file hasn't changed the
   * next time it is saved over.
   * @param contents A string containing the new contents for the file.
   * @param etag The old entity tag 
   * for the document.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @param new_etag A location to a new entity tag
   * for the document.
   * @param cancellable A Cancellable object.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag, const Glib::RefPtr<Cancellable>& cancellable, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  void replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag, const Glib::RefPtr<Cancellable>& cancellable, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Replaces the contents of @a file with @a contents.
   *  
   * If @a etag is specified (not <tt>0</tt>) any existing file must have that etag, or
   * the error IO_ERROR_WRONG_ETAG will be returned.
   * 
   * If @a make_backup is <tt>true</tt>, this function will attempt to make a backup of @a file.
   * 
   * The returned @a new_etag  can be used to verify that the file hasn't changed the
   * next time it is saved over.
   * @param contents A string containing the new contents for the file.
   * @param etag The old entity tag 
   * for the document.
   * @param make_backup <tt>true</tt> if a backup should be created.
   * @param flags A set of FileCreateFlags.
   * @param new_etag A location to a new entity tag
   * for the document.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);
#else
  void replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag, bool make_backup, FileCreateFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  //TODO: Documentation


 /** Starts an asynchronous replacement of the file with the given 
  * @contents of @length bytes. @etag will replace the document's 
  * current entity tag.
  * 
  * When this operation has completed, @a slot will be called 
  * and the operation can be finalized with replace_contents_finish().
  * 
  * The operation can be cancelled by
  * triggering the cancellable object from another thread. If the operation
  * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
  * 
  * If @a make_backup is true, this function will attempt to 
  * make a backup of the file.
  *
  * @param slot: A callback to call when the request is satisfied.
  * @param cancellable A Cancellable object.
  * @param contents String of contents to replace the file with.
  * @param length The length of @a contents in bytes.
  * @param etag a new entity tag for the file.
  * @param make_backup true if a backup should be created.
  * @param flags A set of FileCreateFlags.
  */
  void replace_contents_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, const char* contents, gsize length, const std::string& etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);

 /** Starts an asynchronous replacement of the file with the given 
  * @contents of @length bytes. @etag will replace the document's 
  * current entity tag.
  * 
  * When this operation has completed, @a slot will be called 
  * and the operation can be finalized with replace_contents_finish().
  * 
  * If @a make_backup is true, this function will attempt to 
  * make a backup of the file.
  *
  * @param slot: A callback to call when the request is satisfied.
  * @param contents String of contents to replace the file with.
  * @param length The length of @a contents in bytes.
  * @param etag a new entity tag for the file.
  * @param make_backup true if a backup should be created.
  * @param flags A set of FileCreateFlags.
  */
  void replace_contents_async(const SlotAsyncReady& slot, const char* contents, gsize length, const std::string& etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);

 /** Starts an asynchronous replacement of the file with the given 
  * @contents of @length bytes. @etag will replace the document's 
  * current entity tag.
  * 
  * When this operation has completed, @a slot will be called 
  * and the operation can be finalized with replace_contents_finish().
  * 
  * The operation can be cancelled by
  * triggering the cancellable object from another thread. If the operation
  * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
  * 
  * If @a make_backup is true, this function will attempt to 
  * make a backup of the file.
  *
  * @param slot: A callback to call when the request is satisfied.
  * @param cancellable A Cancellable object.
  * @param contents String of contents to replace the file with.
  * @param etag a new entity tag for the file.
  * @param make_backup true if a backup should be created.
  * @param flags A set of FileCreateFlags.
  */
  void replace_contents_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, const std::string& contents, const std::string& etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);

 /** Starts an asynchronous replacement of the file with the given 
  * @a contents. @a etag will replace the document's 
  * current entity tag.
  * 
  * When this operation has completed, @a slot will be called 
  * and the operation can be finalized with replace_contents_finish().
  * 
  * The operation can be cancelled by
  * triggering the cancellable object from another thread. If the operation
  * was cancelled, the error IO_ERROR_CANCELLED will be returned. 
  * 
  * If @a make_backup is true, this function will attempt to 
  * make a backup of the file.
  *
  * @param slot: A callback to call when the request is satisfied.
  * @param contents String of contents to replace the file with.
  * @param etag a new entity tag for the file.
  * @param make_backup true if a backup should be created.
  * @param flags A set of FileCreateFlags.
  */
  void replace_contents_async(const SlotAsyncReady& slot, const std::string& contents, const std::string& etag, bool make_backup = false, FileCreateFlags flags = FILE_CREATE_NONE);

  
  /** Finishes an asynchronous replace of the given @a file . See
   * replace_contents_async(). Sets @a new_etag to the new entity 
   * tag for the document.
   * @param result A AsyncResult.
   * @param new_etag A location of a new entity tag 
   * for the document.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, std::string& etag);
#else
  void replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, std::string& etag, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** Finishes an asynchronous replace of the given @a file . See
   * replace_contents_async(). Sets @a new_etag to the new entity 
   * tag for the document.
   * @param result A AsyncResult.
   * for the document.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void replace_contents_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  void replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  // *** vfuncs ***

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<File> dup_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual guint hash_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  //TODO: equal() vfunc

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual std::string get_basename_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual std::string get_path_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual std::string get_uri_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual std::string get_parse_name_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


  //TODO: Careful of refcounting: _WRAP_VFUNC(Glib::RefPtr<File> get_parent() const, "get_parent")

  // TODO: GFileIface does not define get_child(). Perhaps it's not intentional.
  //  _WRAP_VFUNC(Glib::RefPtr<File> get_child(const std::string& name) const, "get_child")

  // TODO: howto wrap a vfunc that takes a GError**
//   _WRAP_VFUNC(Glib::RefPtr<File> get_child_for_display_name(const std::string& display_name) const,
//               "get_child_for_display_name",
//               errthrow)

 
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool contains_file_vfunc(const Glib::RefPtr<File>& descendant) const;
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual std::string get_relative_path_vfunc(const Glib::RefPtr<File>& descendant) const;
#endif //GLIBMM_VFUNCS_ENABLED


  //TODO: Careful of refcounting:   _WRAP_VFUNC(Glib::RefPtr<File> resolve_relative_path(const std::string& relative_path) const, "resolve_relative_path")

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool is_native_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool has_uri_scheme_vfunc(const std::string& uri_scheme) const;
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::File
   */
  Glib::RefPtr<Gio::File> wrap(GFile* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_FILE_H */

