/* test-chess-game.c generated by valac 0.11.6, the Vala compiler
 * generated from test-chess-game.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH
} ChessRule;

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer gl_chess_parent_class = NULL;
static gint gl_chess_test_count;
static gint gl_chess_test_count = 0;
static gint gl_chess_failure_count;
static gint gl_chess_failure_count = 0;

gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
gchar* chess_state_get_fen (ChessState* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static void gl_chess_test_bad_move (const gchar* fen, const gchar* move);
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);


static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule) {
	ChessState* _tmp0_ = NULL;
	ChessState* state;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ChessRule move_rule = 0;
	ChessRule _tmp12_;
	ChessResult _tmp13_;
	ChessResult move_result;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (fen != NULL);
	g_return_if_fail (move != NULL);
	g_return_if_fail (result_fen != NULL);
	_tmp0_ = chess_state_new (fen);
	state = _tmp0_;
	gl_chess_test_count++;
	_tmp1_ = chess_state_move (state, move, TRUE);
	if (!_tmp1_) {
		fprintf (stderr, "%d. FAIL %s + %s is a valid move\n", gl_chess_test_count, fen, move);
		gl_chess_failure_count++;
		_chess_state_unref0 (state);
		return;
	}
	_tmp2_ = chess_state_get_fen (state);
	_tmp3_ = _tmp2_;
	if ((_tmp4_ = g_strcmp0 (_tmp3_, result_fen) != 0, _g_free0 (_tmp3_), _tmp4_)) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = chess_state_get_fen (state);
		_tmp6_ = _tmp5_;
		fprintf (stderr, "%d. FAIL %s + %s has state %s not %s\n", gl_chess_test_count, fen, move, _tmp6_, result_fen);
		_g_free0 (_tmp6_);
		gl_chess_failure_count++;
		_chess_state_unref0 (state);
		return;
	}
	_tmp7_ = chess_move_get_san (state->last_move);
	_tmp8_ = _tmp7_;
	if ((_tmp9_ = g_strcmp0 (_tmp8_, move) != 0, _g_free0 (_tmp8_), _tmp9_)) {
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = chess_move_get_san (state->last_move);
		_tmp11_ = _tmp10_;
		fprintf (stderr, "%d. FAIL %s + %s has SAN move %s\n", gl_chess_test_count, fen, move, _tmp11_);
		_g_free0 (_tmp11_);
		gl_chess_failure_count++;
		_chess_state_unref0 (state);
		return;
	}
	_tmp13_ = chess_state_get_result (state, &_tmp12_);
	move_rule = _tmp12_;
	move_result = _tmp13_;
	if (move_result != _result_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = move_rule != rule;
	}
	if (_tmp14_) {
		fprintf (stderr, "%d. FAIL %s + %s has result %d not %d\n", gl_chess_test_count, fen, move, (gint) move_result, (gint) _result_);
		gl_chess_failure_count++;
		_chess_state_unref0 (state);
		return;
	}
	fprintf (stderr, "%d. PASS %s + %s is valid\n", gl_chess_test_count, fen, move);
	_chess_state_unref0 (state);
}


static void gl_chess_test_bad_move (const gchar* fen, const gchar* move) {
	ChessState* _tmp0_ = NULL;
	ChessState* state;
	gboolean _tmp1_;
	g_return_if_fail (fen != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = chess_state_new (fen);
	state = _tmp0_;
	gl_chess_test_count++;
	_tmp1_ = chess_state_move (state, move, FALSE);
	if (_tmp1_) {
		fprintf (stderr, "%d. FAIL %s + %s is valid\n", gl_chess_test_count, fen, move);
		gl_chess_failure_count++;
		_chess_state_unref0 (state);
		return;
	}
	fprintf (stderr, "%d. PASS %s + %s is invalid\n", gl_chess_test_count, fen, move);
	_chess_state_unref0 (state);
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a3", "8/8/8/8/8/P7/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a4", "8/8/8/8/P7/8/8/8 b - a3 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_bad_move ("8/8/8/8/8/P7/8/8 w - - 0 1", "a2a5");
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a8=Q", "Q7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("8/8/8/pP6/8/8/8/8 w - a6 0 1", "bxa6", "8/8/P7/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_bad_move ("8/8/8/pP6/8/8/8/8 w - - 0 1", "b5a6");
	gl_chess_test_good_move ("8/8/8/8/8/8/8/4K2R w K - 0 1", "O-O", "8/8/8/8/8/8/8/5RK1 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("8/8/8/8/8/8/8/R3K3 w Q - 0 1", "O-O-O", "8/8/8/8/8/8/8/2KR4 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K2R w - - 0 1", "O-O");
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K3 w K - 0 1", "O-O");
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
	gl_chess_test_bad_move ("5r2/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/4R3/4K3 w - - 0 1", "e2f2");
	gl_chess_test_good_move ("k7/8/8/8/8/8/8/1R6 w - - 0 1", "Ra1+", "k7/8/8/8/8/8/8/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("k7/8/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1#", "k7/8/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_WHITE_WON, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("k7/7r/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1+", "k7/7r/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE);
	gl_chess_test_good_move ("k7/8/7R/8/8/8/8/1R6 w - - 0 1", "Rh7", "k7/7R/8/8/8/8/8/1R6 b - - 1 1", CHESS_RESULT_DRAW, CHESS_RULE_STALEMATE);
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/8 w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL);
	fprintf (stdout, "%d/%d tests successful\n", gl_chess_test_count - gl_chess_failure_count, gl_chess_test_count);
	result = gl_chess_failure_count;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gl_chess_main (argv, argc);
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
	self = (GlChess*) g_type_create_instance (object_type);
	return self;
}


GlChess* gl_chess_new (void) {
	return gl_chess_construct (TYPE_GL_CHESS);
}


static void value_gl_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gl_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gl_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GlChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gl_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gl_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gl_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gl_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
	gl_chess_parent_class = g_type_class_peek_parent (klass);
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
}


static void gl_chess_instance_init (GlChess * self) {
	self->ref_count = 1;
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
	self = GL_CHESS (obj);
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GL_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



