/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.DecompressionCoordinator;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.scopes.ScopedCacheBuilderFactory;

public class DefaultDecompressionCoordinator
implements DecompressionCoordinator {
    private static final String EXPANSION_CACHE_KEY = "expanded";
    private static final String EXPANSION_CACHE_NAME = "Compressed Files Expansion Cache";
    private final PersistentCache cache;
    private final ProducerGuard<File> guard = ProducerGuard.adaptive();

    public DefaultDecompressionCoordinator(ScopedCacheBuilderFactory cacheBuilderFactory) {
        this.cache = cacheBuilderFactory.createCacheBuilder(EXPANSION_CACHE_KEY).withDisplayName(EXPANSION_CACHE_NAME).withInitialLockMode(FileLockManager.LockMode.OnDemand).open();
    }

    @VisibleForTesting
    public DefaultDecompressionCoordinator(PersistentCache cache) {
        this.cache = cache;
    }

    @Override
    public void exclusiveAccessTo(File expandedDir, Runnable action) {
        this.cache.withFileLock(() -> this.guard.guardByKey(expandedDir, () -> {
            action.run();
            return null;
        }));
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

