//////////////////////////////////////////////////////////////////////
// XLogical - A puzzle game
//
// Copyright (C) 2000 Neil Brown, Tom Warkentin
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// or at the website: http://www.gnu.org
//
////////////////////////////////////////////////////////////////////////



#ifndef EXCEPTION_H
#define EXCEPTION_H

// Language Includes
#include <string>

using namespace std;

#define CatchEx(aEx)		catch( CXLException aEx )
#define ThrowEx(aError)		throw CXLException(aError,__FILE__,__LINE__)

class CXLException
{
public:
	CXLException(
		const string &aError,
		const string &aFile,
		const unsigned long aLine );
	virtual ~CXLException( void );

	// 'get' functions
	const string &		Error( void );
	const string &		File( void );
	const unsigned long	Line( void );

	// 'set' functions
	void SetError( const string &aError );
	void SetFile( const string &aFile );
	void SetLine( const unsigned long aLine );

	// friends
	friend ostream &
	operator << ( ostream &os, CXLException &e );

protected:
private:
	CXLException( void );

	string			fError;
	string			fFile;
	unsigned long	fLine;
};

#endif
// $Id: exception.h,v 1.6 2003-03-11 08:31:43 tom Exp $
//
// $Log: exception.h,v $
// Revision 1.6  2003-03-11 08:31:43  tom
// fixed g++ 3.2.3 compilation errors
//
// Revision 1.5  2001/02/17 07:18:21  tom
// got xlogical working in windows finally - with the following limitations:
// - music is broken (disabled in this checkin)
// - no user specified mod directories for in game music
// - high scores will be saved as user "nobody"
//
// Revision 1.4  2001/02/16 20:59:52  tom
// did some WIN32 porting work on the code... just a few more files to go.
//
// Revision 1.3  2001/01/20 17:32:26  brown
// Working toward Windows integration
//
// Revision 1.2  2000/10/06 19:29:04  brown
// Added autoconf stuff
// Added GPL header to files
// Added WON scroller
// Added GPL to about screen
//
// Revision 1.1.1.1  2000/09/28 02:17:52  tom
// imported sources
//
// Revision 1.3  1999/12/25 08:18:33  tom
// Added "Id" and "Log" CVS keywords to source code.
//
