/* $Id$ */
/* File: defines.h */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 *
 * Edit: Added arbitrary screen sizes; for now just implemented up to 44 map
 *       lines aka 46 main window lines. (v4.4.9.1.0.2) - C. Blue
 */



/* MAJOR/MINOR/PATCH version should be 0-15. BUILD == 1 means 'test build' */
#define VERSION_MAJOR		4
#define VERSION_MINOR		9
#define VERSION_PATCH		2
#define VERSION_EXTRA		0
#define VERSION_BRANCH		0
#define VERSION_BUILD		0

/* MAJOR/MINOR/PATCH version that counts as 'latest' (should be 0-15).
   If a player is online with a version > this && <= current version (VERSION_)
   it will be assumed that he's using a 'test client' and be marked in @ list
   with a 'T' marker which is visible only to admins.*/
#define VERSION_MAJOR_LATEST	4
#define VERSION_MINOR_LATEST	9
#define VERSION_PATCH_LATEST	2
#define VERSION_EXTRA_LATEST	0
#define VERSION_BRANCH_LATEST	0
#define VERSION_BUILD_LATEST	0

/* maximum MAJOR/MINOR/PATCH version that counts as 'outdated' (should be 0-15). */
#define VERSION_MAJOR_OUTDATED	4
#define VERSION_MINOR_OUTDATED	9
#define VERSION_PATCH_OUTDATED	1
#define VERSION_EXTRA_OUTDATED	0
#define VERSION_BRANCH_OUTDATED	0
#define VERSION_BUILD_OUTDATED	2 /* should always be 1 to invalidate previous 'test' versions */

/* Server release version tag (such as "a", "b" etc), or empty if none:
   Minimum client version tag required to "play 100%". */
#define SERVER_VERSION_TAG	""

/* Client-side only: Client release version tag, or empty if none
   (such as "a", "b" etc) used in window title and file dumps */
#ifdef CLIENT_SIDE
 #define CLIENT_TAG		""
 #ifndef TEST_CLIENT
  #define CLIENT_VERSION_TAG	CLIENT_TAG
 #else
  #define CLIENT_VERSION_TAG	CLIENT_TAG"-Test"
 #endif
#endif

/* Minimum client version required to be allowed to log in */
#define MIN_VERSION_MAJOR	4
#define MIN_VERSION_MINOR	4
#define MIN_VERSION_PATCH	1
#define MIN_VERSION_EXTRA	0

/* Maximum client version allowed to log in */
#define MAX_VERSION_MAJOR	5
#define MAX_VERSION_MINOR	15
#define MAX_VERSION_PATCH	15
#define MAX_VERSION_EXTRA	INT_MAX


/* For savefile purpose only */
#define SF_VERSION_MAJOR	4
#define SF_VERSION_MINOR	9
#define SF_VERSION_PATCH	15
#define SF_VERSION_EXTRA	0 /* <- not used in version checks! */

/* For quests savefile purpose only */
#define QUEST_SF_VERSION_MAJOR	1
#define QUEST_SF_VERSION_MINOR	0
#define QUEST_SF_VERSION_PATCH	1
#define QUEST_SF_VERSION_EXTRA	0


/* version_os constants, set by gcc flags - C. Blue */
#define OS_UNKNOWN	0
#define OS_WIN32	1
#define OS_GCU		2
#define OS_X11		3
#define OS_GCU_X11	4
#define OS_OSX		5

/* Set new VERSION_OS (after 4.4.8.1.0.0) for client - C. Blue */
#ifdef CLIENT_SIDE
 #ifdef WIN32
  #define VERSION_OS		OS_WIN32
 #elif defined(OSX)
  #define VERSION_OS		OS_OSX
 #elif defined(USE_X11) && defined(USE_GCU)
  #define VERSION_OS		OS_GCU_X11
 #elif defined(USE_GCU)
  #define VERSION_OS		OS_GCU
 #elif defined(USE_X11)
  #define VERSION_OS		OS_X11
 #else
  #define VERSION_OS		OS_UNKNOWN
 #endif
#endif



/*
 * Base version strings of TomeNET (see version_build)
 */
#define TOMENET_VERSION_SHORT		"TomeNET"

/*
 * This value is a single 16-bit number holding the version info
 */

#define MY_VERSION (VERSION_MAJOR << 12 | VERSION_MINOR << 8 | VERSION_PATCH \
	<< 4 | VERSION_EXTRA)



/* Main server flags */
#define SFLG0_NORMAL		0x00000000U
#define SFLG0_RPG		0x00000001U
#define SFLG0_FUN		0x00000002U
#define SFLG0_PARTY		0x00000004U
#define SFLG0_ARCADE		0x00000008U
#define SFLG0_TEST		0x00000010U
#define SFLG0_RPG_ADMIN		0x00000020U
#define SFLG0_DED_IDDC		0x00000040U
#define SFLG0_DED_PVP		0x00000080U
#define SFLG0_NO_PK		0x00000100U
#define SFLG0_PVP_MAIA		0x00000200U	/* Maiar in PvP-mode start at level 20 or above and hence need to set their trait in the client already */

/* Feature flags */
#define SFLG1_NORMAL		0x00000000U
#define SFLG1_PARTY		0x00000001U
#define SFLG1_BIG_MAP		0x00000002U
#define SFLG1_NEW_SHIELDS_NO_AC	0x00000004U
#define SFLG1_LIMIT_SPELLS	0x00000008U
#define SFLG1_WEAPONS_NO_AC	0x00000010U


/* Determine fundamental server type (Normal, RPG, Arcade, Fun flagged). */
#include "defines-local.h"

/* Add feature enabling/disabling definitions - C. Blue */
#include "defines-features.h"

/* Add colour schemes - C. Blue */
#include "colours.h"


/* Characters disallowed in save files */
#define SF_BAD_CHARS ":!?\\/()\"@. _"

/* Maximum number of different characters one player account may hold - C. Blue */
#define MAX_CHARS_PER_ACCOUNT	12
#define MAX_DED_IDDC_CHARS	2	/* additional iddc-only characters (needs ALLOW_DED_IDDC_MODE) */
#define MAX_DED_PVP_CHARS	1	/* additional pvp-only characters (needs ALLOW_DED_PVP_MODE) */

#define C_ATTRIBUTES	6	/* Number of base stats: str, int, wis, con, dex, chr */

/* What kind of character creation method does the server use? - C. Blue
   currently (since 4.2.0):     0 = traditional random rolling (1 try)
                                1 = player can set his stats manually */
/* I'm using 0x02 for sending the server version - mikaelh */
#define CHAR_CREATION_FLAGS	1


/*
 * Define the maximum number of characters to use in many things
 */
#define MAX_CHARS		80	/* typically 1 line */
#define MAX_CHARS_WIDE		(MAX_CHARS * 2)	/* typically a line with possibly colour codes */

/* max length + 1 of item names including inscription */
#define ONAME_LEN		160
/* max item inscription length + 1 */
#define INSCR_LEN		80
/* Reserve space for already existing inscription + 4 powins-marker bytes (2 at start, 2 at end: "@^" or "@&)
   and 2x the legal inscription length, in case we're not called to actually inscribe an item but just to return a full list of spells in a book. */
#define POW_INSCR_LEN		(INSCR_LEN * 3 + 4)

/* max length + 1 of monster names (with pronominum etc) */
#define MNAME_LEN		80

/* max length of party/guild names + 1 */
#define NAME_LEN		20
/* max length of login info + 1 */
#define CNAME_LEN		16
#define ACCNAME_LEN		16
#define PASSWORD_LEN		16
#define PASSWORD_MIN_LEN	6
/* Note: These two are [20], but in fact user_name(), real_name, getlocalhostname() all cap at 16 - TODO maybe: fix */
#define REALNAME_LEN		20 /* realname is replaced by "PLAYER" anyway */
#define HOSTNAME_LEN		20

/* Minimum length of account and character names */
#define ACC_CHAR_MIN_LEN	2

/* Lengths + 1 of fields used in tomenet.acc file (account name, normalised account name and password) */
#define ACCFILE_NAME_LEN	30
#define ACCFILE_PASSWD_LEN	20

/*
 * Maximum message length
 */
#define MSG_LEN 256

/*
 * Define the maximum size of temporary file-name length.
 */
#define MAX_TMP_PATH_LEN	256

/*
 * The maximum number of player ID's / accounts
 */
#define MAX_ID 65536
#define MAX_ACCOUNTS	8192

/* For storing event rewards for to-be-created characters of an account */
#define MAX_CONTENDER_BUFFERS 128
#define MAX_ACHIEVEMENT_BUFFERS 128

/* For temporarily reserving character names for an account */
#define MAX_RESERVED_NAMES 128


/*
 * This is very important...
 *
 * This is the number of "frames" to produce per second.  It determines
 * the speed of the game.
 */
/*#define FPS 60 */
#define FPS (cfg.fps)


/* Characters and accounts do never expire? (Enable this in your LAN for example) */
//#define PLAYERS_NEVER_EXPIRE

/* Number of days after which an account without any characters on it will expire. */
#ifdef RPG_SERVER
 #define ACCOUNT_EXPIRY_DAYS 185
#else
 #define ACCOUNT_EXPIRY_DAYS 64
#endif

/* Number of days after which an unused character will expire. */
#define CHARACTER_EXPIRY_DAYS 367


/*
 * The types of communication that we send to the metaserver
 */
#define META_START	0x01
#define META_DIE	0x02
#define META_UPDATE	0x04


#ifdef CLIENT_SIDE
 /* Client-side: Maximum amount of terminal windows the client may have. */
 #define ANGBAND_TERM_MAX 10	/* POSIX X11 version */
 #define MAX_TERM_DATA 10	/* Win version */
 #define MAX_TERM_DATA_GCU 4	/* POSIX GCU version */

 #define NR_OPTIONS_SHOWN	11 /* # of possible sub-window types, see window_flag_desc[]) */
#endif


/* Traditional hard-coded number of grids used to display the dungeon,
   had to be multiples of 11 and 33 respectively.
   Only kept now for setting default values - C. Blue */
#define SCREEN_HGT		22
#define SCREEN_WID		66

/* New for BIG_MAP feature: Minimum and maximum screen size - C. Blue */
#define MIN_SCREEN_WID		SCREEN_WID
#define MIN_SCREEN_HGT		SCREEN_HGT
#ifndef ARCADE_SERVER
 #define MAX_SCREEN_WID		SCREEN_WID
#else
 //#define MAX_SCREEN_WID		(SCREEN_WID * 3)	/* For experimental screen-size code testing in the future */
 #define MAX_SCREEN_WID		SCREEN_WID
#endif
#define MAX_SCREEN_HGT		(SCREEN_HGT * 2)

/* (BIG_MAP) Padding of on-screen map, because of chat line, status bars, etc */
#define SCREEN_PAD_LEFT		13
#define SCREEN_PAD_RIGHT	1
#define SCREEN_PAD_TOP		1
#define SCREEN_PAD_BOTTOM	1
#define SCREEN_PAD_X		(SCREEN_PAD_LEFT + SCREEN_PAD_RIGHT)
#define SCREEN_PAD_Y		(SCREEN_PAD_TOP + SCREEN_PAD_BOTTOM)

/* (BIG_MAP) Maximum possible main window size */
#define MAX_WINDOW_WID	(MAX_SCREEN_WID + SCREEN_PAD_LEFT + SCREEN_PAD_RIGHT)
#define MAX_WINDOW_HGT	(MAX_SCREEN_HGT + SCREEN_PAD_TOP + SCREEN_PAD_BOTTOM)

#ifdef CLIENT_SIDE
 /* For resizing the main window while client runs */
 #define CL_WINDOW_WID	(screen_wid + SCREEN_PAD_LEFT + SCREEN_PAD_RIGHT)
 #define CL_WINDOW_HGT	(screen_hgt + SCREEN_PAD_TOP + SCREEN_PAD_BOTTOM)
#else
 /* For handling client functions depending on BIG_MAP */
 #define CL_WINDOW_WID	(Players[Ind]->screen_wid + SCREEN_PAD_LEFT + SCREEN_PAD_RIGHT)
 #define CL_WINDOW_HGT	(Players[Ind]->screen_hgt + SCREEN_PAD_TOP + SCREEN_PAD_BOTTOM)
#endif

/*
 * Maximum dungeon height in grids, must be a multiple of SCREEN_HGT,
 * probably hard-coded to SCREEN_HGT * 3.
 */
#define MAX_HGT		66

/*
 * Maximum dungeon width in grids, must be a multiple of SCREEN_WID,
 * probably hard-coded to SCREEN_WID * 3.
 */
#define MAX_WID		198

/* Used only in object3.c / trap effects (ToME) */
#if ((MAX_HGT / SCREEN_HGT) < (MAX_WID / SCREEN_WID))
 #define RATIO (MAX_WID / SCREEN_WID)
#else
 #define RATIO (MAX_HGT / SCREEN_HGT)
#endif

/* for consistent setting of max_panel_rows/cols: */
#ifndef BIG_MAP /* old -> rounding issues */
 #define MAX_PANEL_ROWS_L	(((l_ptr->hgt + p_ptr->screen_hgt / 2) / p_ptr->screen_hgt) * 2 - 2)
 #define MAX_PANEL_COLS_L	(((l_ptr->wid + p_ptr->screen_wid / 2) / p_ptr->screen_wid) * 2 - 2)
 #define MAX_PANEL_ROWS		((MAX_HGT / p_ptr->screen_hgt) * 2 - 2)
 #define MAX_PANEL_COLS		((MAX_WID / p_ptr->screen_wid) * 2 - 2)

 /* stuff that depends on normal-sized panels, for various effects such as magic mapping */
 #define MAX_TRADPANEL_ROWS_L	MAX_PANEL_ROWS_L
 #define MAX_TRADPANEL_COLS_L	MAX_PANEL_COLS_L
 #define MAX_TRADPANEL_ROWS	MAX_PANEL_ROWS
 #define MAX_TRADPANEL_COLS	MAX_PANEL_COLS

 #define TRADPANEL_ROW_MIN	(p_ptr->panel_row_min)
 #define TRADPANEL_ROW_MAX	(p_ptr->panel_row_max)
 #define TRADPANEL_COL_MIN	(p_ptr->panel_col_min)
 #define TRADPANEL_COL_MAX	(p_ptr->panel_col_max)
#else /* allow larger main screen than 80x24 - C. Blue */
 #define MAX_PANEL_ROWS_L	((int)((l_ptr->hgt + p_ptr->screen_hgt / 2 - 1) / (p_ptr->screen_hgt / 2)) - 2)
 #define MAX_PANEL_COLS_L	((int)((l_ptr->wid + p_ptr->screen_wid / 2 - 1) / (p_ptr->screen_wid / 2)) - 2)
 #define MAX_PANEL_ROWS		((int)((MAX_HGT + p_ptr->screen_hgt / 2 - 1) / (p_ptr->screen_hgt / 2)) - 2)
 #define MAX_PANEL_COLS		((int)((MAX_WID + p_ptr->screen_wid / 2 - 1) / (p_ptr->screen_wid / 2)) - 2)

 /* 'traditional' panel variables used for various effects such as magic mapping (working on 66x22) */
 #define MAX_TRADPANEL_ROWS_L	(((l_ptr->hgt + SCREEN_HGT / 2) / SCREEN_HGT) * 2 - 2)
 #define MAX_TRADPANEL_COLS_L	(((l_ptr->wid + SCREEN_WID / 2) / SCREEN_WID) * 2 - 2)
 #define MAX_TRADPANEL_ROWS	((MAX_HGT / SCREEN_HGT) * 2 - 2)
 #define MAX_TRADPANEL_COLS	((MAX_WID / SCREEN_WID) * 2 - 2)

 #if 1
  /* use traditional panel sizes and map around the one we'd be within (better) */
  #define TRADPANEL_ROW_MIN	(p_ptr->tradpanel_row_min)
  #define TRADPANEL_ROW_MAX	(p_ptr->tradpanel_row_max)
  #define TRADPANEL_COL_MIN	(p_ptr->tradpanel_col_min)
  #define TRADPANEL_COL_MAX	(p_ptr->tradpanel_col_max)
 #else /* centers magic mapping on current huge panel (quick and easy) */
  /* this causes a problem when player is close to an edge of a level! */
  #define TRADPANEL_ROW_MIN	(p_ptr->panel_row_min + p_ptr->screen_hgt / 2 - SCREEN_HGT / 2)
  #define TRADPANEL_ROW_MAX	(p_ptr->panel_row_max - p_ptr->screen_hgt / 2 + SCREEN_HGT / 2)
  #define TRADPANEL_COL_MIN	(p_ptr->panel_col_min + p_ptr->screen_wid / 2 - SCREEN_WID / 2)
  #define TRADPANEL_COL_MAX	(p_ptr->panel_col_max - p_ptr->screen_wid / 2 + SCREEN_WID / 2)
 #endif
#endif

#ifdef CLIENT_SIDE
 /* For client-side BIG_MAP handling */
 #define HGT_PLUS	(screen_hgt - SCREEN_HGT)
 #define WID_PLUS	(screen_wid - SCREEN_WID)
#else
 /* For handling client functions depending on BIG_MAP */
 #define HGT_PLUS	(Players[Ind]->screen_hgt - SCREEN_HGT)
 #define WID_PLUS	(Players[Ind]->screen_wid - SCREEN_WID)
#endif


/* 'uniques_killed': Declare it as char array instead of pointer that requires memory allocation? */
#define UNIQUES_KILLED_ARRAY


/*
 * Hack -- This is used to make sure that every player that has a structure
 * dedicated to them is actually connected
 */
#define NOT_CONNECTED	(-1)


/*
 * Maximum number of players playing at once.
 *
 * This limit has never been stretched, and it would be interesting to see
 * what happens when 100 or so players play at once.
 */
#define MAX_PLAYERS	1000

#ifdef PLAYER_STORES
/* How many of them can at once visit different player stores? */
 #define MAX_VISITED_PLAYER_STORES	(MAX_PLAYERS / 20)
#endif

/*
 * Maximum number of player "race" types (see "table.c", etc)
 */
#ifdef ENABLE_MAIA
 #ifdef ENABLE_KOBOLD
  #define MAX_RACE	18
 #else
  #define MAX_RACE	17
 #endif
#else
 #ifdef ENABLE_KOBOLD
  #define MAX_RACE	17
 #else
  #define MAX_RACE	16
 #endif
#endif


/* Amount of RF4_TRAPS casts after which disarming those traps will no longer yield XP (continously dropping) */
#define MAX_CLONE_TRAPPING 5


/*
 * Maximum number of player "class" types (see "table.c", etc)
 */
#ifdef ENABLE_DEATHKNIGHT
 #ifdef ENABLE_HELLKNIGHT
  #ifdef ENABLE_CPRIEST
   #define MAX_CLASS	16
  #else
   #define MAX_CLASS	15
  #endif
 #else
  #define MAX_CLASS	14
 #endif
#else
 #define MAX_CLASS	13
#endif

/*
 * Maximum number of character traits. Originally added for Draconians - C. Blue
 */
#define MAX_TRAIT	32	/* 0 = N/A; 13 dragon flavours; 2 Maiar flavours; ... */

/*
 * Maximum NPC robots to allow.
 */
#define MAX_NPCS	16	/* Allow more perhaps, or make it expandable... */

/*
 * Maximum number of parties to allow.  If, while trying to create a new
 * party, you get a "No empty party slot" or somesuch message, increase
 * this number.  However, you should NEVER decrease this number after a
 * server has been run, or all sorts of bad things could happen.
 */
#define MAX_PARTIES	1024
#define MAX_GUILDS	512

/* Price to create a guild */
#define GUILD_PRICE	2000000

/*
 * Maximum number of houses available.
 */
#define MAX_HOUSES		65536	/* temp value... */
#define HOUSE_KEY		0
#define HOUSE_PASS		1

#define FILL_BUILD		0
#define FILL_CLEAR		1
#define FILL_MAKEHOUSE		2
#define FILL_PLAYER		3
#define FILL_OBJECT		4
#define FILL_GUILD		5
#ifdef HOUSE_PAINTING
 #define FILL_UNPAINT		6
#endif
#define FILL_GUILD_SUS		7	/* for leaderless guild handling: no item/gold pickup possible */
#define FILL_GUILD_SUS_UNDO	8
#define FILL_SFX_KNOCK		9

/*
 * Number of entries in the player name hash table.
 * This must be a power of 2!
 */
#define NUM_HASH_ENTRIES	256


/*
 * Maximum array bounds for template based arrays
 */
/*
 * TODO: make them redefinable w/o client update
 */

#define MAX_F_IDX	256	/* Max size for "f_info[]" */
#define MAX_K_IDX	1280	/* Max size for "k_info[]" */
#define MAX_A_IDX	512	/* Max size for "a_info[]" */
#define MAX_E_IDX	384	/* Max size for "e_info[]" */
#define MAX_R_IDX	1280	/* Max size for "r_info[]" */
#define MAX_V_IDX 	256	/* Max size for "v_info[]" */
#define MAX_RE_IDX	128	/* Max size for "re_info[]" */
#define MAX_T_IDX	256	/* Max size for "t_info[]" */
#define MAX_OW_IDX	128	/* Max size for "ow_info[]" */
#define MAX_ST_IDX	128	/* Max size for "st_info[]" */
#define MAX_BA_IDX	128	/* Max size for "ba_info[]" */
#define MAX_D_IDX	64	/* Max size for "d_info[]" */
#define MAX_Q_IDX	100	/* Max size for "q_info[]" */

/* for compatibility with 4.5.8.1- clients: */
#define MAX_F_IDX_COMPAT	256
#define MAX_K_IDX_COMPAT	1024
#define MAX_A_IDX_COMPAT	512
#define MAX_E_IDX_COMPAT	256
#define MAX_R_IDX_COMPAT	1152
#define MAX_V_IDX_COMPAT 	256
#define MAX_RE_IDX_COMPAT	128
#define MAX_T_IDX_COMPAT	256
#define MAX_OW_IDX_COMPAT	96
#define MAX_ST_IDX_COMPAT	96
#define MAX_BA_IDX_COMPAT	96
#define MAX_D_IDX_COMPAT	64
#define MAX_Q_IDX_COMPAT	100

/* Max ego base type restrictions */
#define MAX_EGO_BASETYPES	10


#ifdef CLIENT_SIDE
 /* Client-side unique list */
 #define MAX_UNIQUES		300

 //defines.h: (for client-side, from angband)
 /* Given an array, determine how many elements are in it: */
 //note: appearently doesnt work for the main purpose ie sound_modules -_- -C. Blue
 #define N_ELEMENTS(a) (sizeof(a) / sizeof((a)[0]))

 /* Client-side auto inscriptions - doubled to 200 after introduction of auto-pickup/destroy in 4.7.4;
    increased to 500 on player request, whatever. */
 #define MAX_AUTO_INSCRIPTIONS	500

 #define AUTOINS_MATCH_LEN	55
 #define AUTOINS_TAG_LEN	19

 #define MAX_PLAYERS_LISTED	100

 #define PRF_BODY_SEPARATOR	'^'

  /* For ALLOW_NAVI_KEYS_IN_PROMPT */
  #define NAVI_KEY_UP		-127
  #define NAVI_KEY_DOWN		-126
  #define NAVI_KEY_LEFT		-125
  #define NAVI_KEY_RIGHT	-124
  #define NAVI_KEY_PAGEUP	-123
  #define NAVI_KEY_PAGEDOWN	-122
  #define NAVI_KEY_POS1		-121
  #define NAVI_KEY_END		-120
  #define NAVI_KEY_DEL		-119	/* Windows only, not available on POSIX (there DEL is same as BACKSPACE) */
#endif


/*
 * Maximum array bounds for entity list arrays
 */
/*
 * 32768 is way too large; 4096 monsters/objs are enough to weigh
 * your latest comp down(even w/o AI code)!
 */
#define MAX_O_IDX	65535	/* Max size for "o_list[]" */
#define MAX_M_IDX 	32768	/* Max size for "m_list[]" */


/* Maximum number of extermination orders for 'xorder' type (OLD, unused) */
#define MAX_XO_IDX		4
/* Maximum number of extermination orders for 'xorder_type' type (NEW, used instead) */
#define MAX_XORDERS		20
/* Duration until extermination order expires */
#define MAX_XORDER_TURNS	(DAY * 2)

/* Maximum number of concurrent quests (quest_info type) */
#define MAX_CONCURRENT_QUESTS 5
#define LOCAL_QUEST (MAX_CONCURRENT_QUESTS) /* hack: reserve a special slot index for a 'local' type quest */
#define MAX_PQUESTS (MAX_CONCURRENT_QUESTS + 1) /* maximum number of quests a player can have: concurrently running quests plus the special 'local' quest */
/* highlight quest keywords enclosed in [[..]] brackets in this colour */
#if 0
 #define QUEST_KEYWORD_HIGHLIGHT	'y'
#else
 #define QUEST_KEYWORD_HIGHLIGHT	'o'
#endif

/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES	100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_WILD_X	64
#define MAX_WILD_Y	64
#define MAX_WILD	(MAX_WILD_X*MAX_WILD_Y)
#define MAX_WILD_8	((MAX_WILD_X*MAX_WILD_Y)/8)
#define MAX_DEPTH_OBJ	128 /* must be <= 128 */
#define MAX_DEPTH	255 /* should be <= 255? (Valinor at 200 is deepest level) */

/* Amount of towns */
#define TOWNS		6

/* The 'generally acknowledged' max radius for a town's housing zone.
   This is not so much used to create wilderness than to check stuff - don't touch! */
#define MAX_TOWNAREA	3

/* How many mushroom fields on the global world surface map will we index for Farmer Maggot spawning?
   At 64x64 = 4096 worldmap sectors, the value should be able to index all generated mushroom 'gardens'. */
#define MAX_MUSHROOM_FIELDS	1024

/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 5, and even if the "lite"
 * was rectangular, we would never require more than 128 entries in the array.
 */
#define LITE_MAX 529 /* 529 = ((10+1 safety) radius + 1 centre) 128 */
#define LITE_CAP 10 /* just a limiter */

/* Maximum number of notes that the server will store */
#define MAX_NOTES 200
//#define MAX_PARTYNOTES 30
#define MAX_PARTYNOTES MAX_PARTIES
//#define MAX_GUILDNOTES 10
#define MAX_GUILDNOTES MAX_GUILDS
#define MAX_ADMINNOTES 20
/* Max # of notes a player may have pending at a time [6] */
#define MAX_NOTES_PLAYER 6

/* Number of text lines for the in-game BBS */
#define BBS_LINES 15

/* Max amount of swear words */
#define MAX_SWEAR 100

/* Max amount of legal words that override swear words */
#define MAX_NONSWEAR 200

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 1536


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 512 macros are used
 */
#define MACRO_MAX	512

/*
 * OPTION: Maximum number of "quarks" (see "io.c")
 * Default: assume at most 512 different inscriptions are used
 * Hm, 8k worked well for the past 10 years :) but now not anymore..
 * 2019-04-14: 16k is not enough either anymore :D extending to 32k.
 *  Possibly the last increase happened before the world reshaping,
 *  which added many more houses for item storage.
 */
#define QUARK_MAX	32768

/*
 * OPTION: Maximum number of messages to remember (see "io.c")
 * Default: assume maximal memorization of 2048 total messages
 * Doubled to 4096 - mikaelh // Doubled again to 8k - C. Blue
 */
#define MESSAGE_MAX	8192

/*
 * OPTION: Maximum space for the message text buffer (see "io.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 * Doubled to 65536 - mikaelh // Quadrupled again to 256k - C.Blue
 */
#define MESSAGE_BUF	262143


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR	255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT	32767

/*
 * Maximum path length
 */
#define MAX_PATH_LENGTH	128


/* The four seasons - C. Blue */
#define SEASON_SPRING 0
#define SEASON_SUMMER 1
#define SEASON_AUTUMN 2
#define SEASON_WINTER 3

/* Jail - crime sentences */
#define JAIL_MURDER 100
#define JAIL_MURDER_KPK 500
#define JAIL_STEALING 500
#define JAIL_SWEARING 20
#define JAIL_SPAM 30
#define JAIL_OLD_CRIMES 0
#define JAIL_VISIT 10


/* ---------------------------------------------------------------- (Rather fundamental 'features')  ---------------------------------------------------------------- */

/* --- Player settings --- */

/* Define this to make 'exp ratio' determine exp-gain instead of exp-to-adv:
   (has no effect if KINGCAP_EXP is defined) */
#define ALT_EXPRATIO

/* for PvP mode: */
#define MIN_PVP_LEVEL	20
#define MID_PVP_LEVEL	25
#define MAX_PVP_LEVEL	30


/* For flash player 2 option, cfg.fps/n, for short range teleport [8] */
#define FLASH_SELF_DIVS 8
/* For flash player option, cfg.fps/n, for teleport [4] */
#define FLASH_SELF_DIV 4
/* For flash player option, cfg.fps/n, for floor change [3] */
#define FLASH_SELF_DIV2 3

/* Time to be idle for auto-afk to kick in, in seconds [60] */
#define AUTO_AFK_TIMER 60

/* Time to be idle and starving for auto-kick to kick in, in seconds [30] */
#define STARVE_KICK_TIMER 30

/* Maximum armour class value that yields in a reduction of damage.
   Note: The chance to get hit still goes down further above this value.
   Also search code for CAP_ITEM_BONI to find +hit/+dam/+ac cappings. */
#ifdef ENABLE_NEW_MELEE
 #if 0
  #define AC_CAP	250
  #define AC_CAP_DIV	350
 #else
  #ifndef TO_AC_CAP_30
   #define AC_CAP	200
   #define AC_CAP_DIV	300
  #else
    /* for now the same - could reduce cap to 175 or even 150 */
   #define AC_CAP	200
   #define AC_CAP_DIV	300
  #endif
 #endif
#else
 #define AC_CAP		150
 #define AC_CAP_DIV	250
#endif

/* Percentage reduction of anti-magic field effects on party members [75] or [100].
   Notes: 75% is reasonable; however, for Nether Realm paries you might want 100% for QoL. */
#define AM_PARTY_REDUCTION	100

/* Limit value for Anti-magic fields (AM cap)
   Should range from 75..80%, maybe make skill & DS percentage
   multiply instead of sum up. - C. Blue */
#define ANTIMAGIC_CAP		75

/* Cap for AM field radius. 9 is implied by skill+darksword,
   if monster form AM is added it could stack up to 12 though,
   which seems out of line --
    an unbeliever (warrior) should not be surpassed and 12 seems too much. */
#define ANTIMAGIC_DIS_CAP	9

/* Limit effectiveness of interception/martial arts [50..80] */
#define INTERCEPT_CAP		70

/* If both interception and antimagic field suppress the same casting attempt of the same monster,
   reduce the combined chance somewhat: from 92% (1 in 12) to 83% (1 in 6) to stay sane. */
#define COMBO_AM_IC_CAP		83

/* upper limit of dodging chance. [80] */
#define DODGE_CAP		80

/* Maximum level difference for party members,
   and (+1 tolerance here) for supporting fellow players (depending on HENC_STRICTNESS) */
#define MAX_PARTY_LEVEL_DIFF 7

/* Maximum level difference for winner-party members,
   and (+1 tolerance here) for supporting fellow players (depending on HENC_STRICTNESS) */
#define MAX_KING_PARTY_LEVEL_DIFF 11

/* Party level diff cancellation threshold. Just comment out (ie don't define it) to disable.
   For super high level winner characters: Minimum level at and above which there is no more limit to level difference of party members. [80]
   So as soon as all characters are of this level, they share exp even if they exceed MAX_KING_PARTY_LEVEL_DIFF. */
#define KING_PARTY_FREE_THRESHOLD 80


/* --- Monster settings --- */

#ifdef MONSTER_ASTAR
 /* max size of open/closed pathfinding table in an A* instance.
    4000: Can track reasonably over a complete big level with non-trivial layout.
          This is enough to cover a big 'maze' layout almost completely, except when
          hidint in the very, diagonally opposite, corners. Maybe add another 500..?
    2000: Can track reasonably over a complete big level of the usual, normal layout
          w/ rooms and hallways. However, practically no monsters have this AAF.
    1000: Can track ok over 3 sectors of usual layout. [RECOMMENDED]
     500: Can track ok over 2 sectors of usual layout.
     300: Can track ok within a distance of 1 sector.
     100: Can find lesser, local shortcuts. */
 #define ASTAR_MAX_NODES	1000
 /* how many spawned monsters can use A* at once (Sauron + 9 Nazgul = 10? Adunaphel has PASS_WALL though.) */
 #define ASTAR_MAX_INSTANCES	10
 /* Heuristics function: Guesstimate distance from an inbetween grid sx,sy to our destination grid dx,dy */
 #define ASTAR_HEURISTICS(sx,sy,dx,dy)	(ABS((sx) - (dx)) > ABS((sy) - (dy)) ? ABS((sx) - (dx)) : ABS((sy) - (dy)))
 /* Distribute calculations onto multiple server frames?
    Assumption: Monster doesn't really move INSANELY fast: Divide cfg.fps by how often it can move at most per second.
                Test results for ASTAR_MAX_NODES 1000 and monster vision 200:
                 3 is not enough for a +20 monster at very shallow dungeon depths.
                 4 is fine even for +40 there, if it's not a huge maze.
                 5 works even in a maze.
                Suggested default: 5 times.
    Note that it's still really bad at huge maze levels. */
 #define ASTAR_DISTRIBUTE	(ASTAR_MAX_NODES / (cfg.fps / 5))
#endif

/* for MONSTER_FLOW_BY_SOUND */
/* Range limit? */
#define MONSTER_FLOW_BY_SOUND_DEPTH	64
/* Time limit? */
#define MONSTER_FLOW_BY_SOUND_TIME	50

/* for MONSTER_FLOW_BY_SMELL */
/* Range limit? */
#define MONSTER_FLOW_BY_SMELL_DEPTH	200
/* Time limit? */
#define MONSTER_FLOW_BY_SMELL_TIME	50
/* Scent radius surrounding a player. Note: not implemented yet, but it doesn't bring additional cost, so adding it. - C. Blue */
#define MONSTER_FLOW_BY_SMELL_RADIUS	2

/* for MONSTER_FLOW_BY_ESP */
/* Total flow depth? Might be superfluous, just flood whole level, and let sound/smell take care of the rest.. - C. Blue */
#define MONSTER_FLOW_DEPTH		32

/* Sort the monster list by level before displaying it? */
#define MONS_PRE_SORT

#if 0 //unused
/* maximum respawn time for uniques.... from japanese patch */
 #define COME_BACK_TIME_MAX 600
#endif

/* Approximate cap of a monster's average raw melee damage output per turn
   (before AC of the target is even incorporated)	[700] */
#define AVG_MELEE_CAP		700
/* Non-magical ranged monsters' damage cap */
#define RANGED_CAP		500	/* UNUSED currently */
/* Generic magical damage cap (BEFORE susceptibilities, for those it may still be doubled) */
#define MAGICAL_CAP		1600

/* Disallow monsters summoning onto themselves when out of MAX_RANGE but having LoS?
   This is only really important for Nether Realm (maybe somewhat for Cloud Planes). */
#define NO_SELF_SUMMON

/* Levels that Morgoth spawns on will not allow *destruction* nor any use of
   genocide spells. This can also prevent too trivial loot retrieval in
   case of unexpected deathhh - C. Blue */
#define MORGOTH_DANGEROUS_LEVEL

/* If Morgoth is generated within a vault at the time the
   dungeon level is generated, set it to NO_TELE.
   (overridden by MORGOTH_NO_TELE_VAULTS, see below) - C. Blue */
//#define MORGOTH_NO_TELE_VAULT

/* If Morgoth is generated on a dungeon level at the time the
   dungeon level is generated, set all vaults on it to NO_TELE.
   Also prevent Morgoth from spawning 'live' (meaning later on,
   after the level had already been generated) which would
   undermine the NO_TELE vault concept (or require more code :) - C. Blue */
#define MORGOTH_NO_TELE_VAULTS

/* All player deaths that occur on a level Morgoth is currently on
   are no-ghost deaths, resulting in total termination of the character!
   This was added after some complaints arrived that the atmosphere was taken out of
   the game by mostly everlasting players who made killing him kind of a routine. - C. Blue */
#define MORGOTH_GHOST_DEATH_LEVEL

/* Both of the above lead to preventing live spawns of Morgoth, other than during
   generation of the dungeon level. (for technical reasons) */
#ifdef MORGOTH_NO_TELE_VAULTS
 #define MORGOTH_NO_LIVE_SPAWN
#endif
#ifdef MORGOTH_GHOST_DEATH_LEVEL
 #define MORGOTH_NO_LIVE_SPAWN
#endif

/* Make Sauron more dangerous for AM or Intercepters,
   by giving him AI_ANNOY vs melee targets. */
#define SAURON_ANTI_MELEE

/* Make Sauron more dangerous for Glyphers
   by giving him faster cast rate while blocked by glyphs. */
#define SAURON_ANTI_GLYPH

/* Set Sauron's boost factor (1/n chance to cast spells) [67,75] */
#define SAURON_SPELL_BOOST	67

/* Replace strict no_hp_regen/no_mp_regen that just exits the regen-functions by a regen&drain-workaround? */
#define NO_REGEN_ALT


/* ----------------------------------------------- (Rather specific 'features', could go to defines-features.h instead)  ----------------------------------------------- */

/* Give all characters a basic interception chance depending on level
   and to compensate reduce the additional bonus from the skill somewhat.
   Also this makes Interception skill actually scale properly for low skill levels vs
   high monster levels instead of the investment being completely effectless (!). */
#define GENERIC_INTERCEPTION

/* Startup equipment treatment: [3]
   0 = like any item
   1 = level 0 (unusable by others), can be sold by anyone, not throwable/droppable till charlevel cfg.newbies_cannot_drop
   2 = level 0 (unusable by others), can be sold by yourself only, dropped items (with special exceptions) turn {+,0} before charlevel cfg.newbies_cannot_drop
   3 = level 0 (unusable by others), can't be sold at all, dropped items (with special exceptions) turn {+,0} before charlevel cfg.newbies_cannot_drop
   Note: 2 and 3 imply that all level 0 items in the game can only be sold by their owners.
         All settings now also 'OR' MODE_STARTER_ITEM to indicate starter items.
         MODE_STARTER_ITEM sets object_value_real()/object_value() to zero and prevents loss of this item on death. Actually gets cleared on randart creation :D.
   Special exceptions that don't get 0'ed: Game pieces, keys, special objects, chests. */
#define STARTEQ_TREATMENT 3

/* Do artifacts time out after a while to prevent hoarding?
   (Fluent artifact reset system vs static reset schedules) - C. Blue */
#define FLUENT_ARTIFACT_RESETS
/* Warn a player if an artifact is about to timeout [4 hours] */
#define FLUENT_ARTIFACT_WARNING (60 * 4)
/* Default time in weeks until a true artifact times out.
   Gets doubled for winner-arts and doubled on rpg-server (cumulative). */
#define FLUENT_ARTIFACT_WEEKS 5

#ifdef FLUENT_ARTIFACT_RESETS
 /* The One Ring/Bladeturner don't get their timeout duration halved when their wearer wins */
 #define L100_ARTS_LAST
 /* Does the shop value of a trueart decline continuously while its timeout progresses? */
 #define TRUE_ART_VALUE_DECLINE
#endif

/* Sort the artifact list by tval/sval before displaying it? */
#define ARTS_PRE_SORT

/* Can staticed levels no longer get their static-timeout 'reset' by someone
   logging on on them and leaving again? */
#define NO_STATIC_TIMER_RESET
/* Allow exception for someone dying there when it's already stale, if his
   level is at least 1/4 of the depth and >= cfg.newbies_cannot_drop? */
#define STATIC_TIMER_RESETS_ON_DEATH
/* Sauron's floor in Mt Doom has a shorter static timer */
#define SAURON_FLOOR_FAST_UNSTAT

/* Turn currently invalid items into seals? Otherwise they are simply deleted. */
#define SEAL_INVALID_OBJECTS

/* Pre-set owner for DROP_CHOSEN items, so you can't cheeze them to someone else
   by ground-IDing them, then have someone else to pick them up! (especially for Nazgul rings) */
#define PRE_OWN_DROP_CHOSEN

/* Base level for speed rings of bpval >= 0 that gets added to their bpval. [31..35]
   At 35 this results in level 50 for +15 speed rings, so that should be max. */
#define SPEED_RING_BASE_LEVEL	35

/* Does drinking from fountains bear the possibility of conjuring a guardian monster? */
#define FOUNTAIN_GUARDS		10	/* chance of appearing */

/* Keys are safe from monsters? (taking/killing/stealing) */
//#define MON_IGNORE_KEYS

/* only imprison within town area? Otherwise it can be exploited for world travel. */
#define JAIL_TOWN_AREA
/* does the Jailer remove WoR scrolls and discharge WoR rods? */
//#define JAILER_KILLS_WOR

/* Monster interception ("interference") will not cancel FTK (fire-till-kill)?
   -- TODO: implement for spells/runecraft/mimicpowers (those have 0 interference chance atm though so it doesn't matter) */
#define INTERFERE_KEEPS_FTK
/* Performing certain actions - using consumables, activating magic devices that don't require a direction -
  will not break FTK. This is useful to zap a rod of healing or speed in between without losing the target.
  (So far the only item type where this was possible were potions.) */
#define CONTINUE_FTK

/* Total size of internal IDDC depth table */
#define IDDC_HIGHSCORE_SIZE 50
/* The first n entries that are actually displayed */
#define IDDC_HIGHSCORE_DISPLAYED 10
/* A character who makes it through IDDC is always placed 1st? */
#define IDDC_THROUGH_IS_FIRST
/* A character of same account and class will replace a worse entry of himself on the score board, or get discarded */
#define IDDC_RESTRICT_ACC_CLASS

/* EXPERIMENTAL:
  Allow incompatible char modes (everlasting vs non-everlasting) to interact
   (form party, trade items) while inside the Ironman Deep Dive Challenge? */
#define IRONDEEPDIVE_ALLOW_INCOMPAT

#ifdef DM_MODULES
 #define MODULE_ALLOW_INCOMPAT // See also ALLOW_NR_CROSS_PARTIES - Kurzel
#endif

/* Real Iron: Un-cheeze IDDC, also indirectly removing shop-scumming craziness from infinite money supplies:
   - Allow forming a party _outside_ of the IDDC but within the IDDC sector.
   - Cannot re-party inside the IDDC.
   - Can only trade with party members.
   Note: These rules are applied to 'Iron Team' type parties in IDDC too. */
//#define IDDC_IRON_COOP /* TODO: verify that ALL party members are actually outside, not just adder and addee! */
/* Make 'Iron Team' the only possible party mode in IDDC.
   Note: IRON_IRON_TEAM or IDDC_IRON_COOP should be enabled for this, to enforce the trading rules too. */
//#define IDDC_IRON_TEAM_ONLY

/* Specialty: Apply the trading rules that are used for IDDC_IRON_COOP to the 'Iron Team'
   party type (anywhere, outside of the IDDC too) same as parties within IDDC:
   - Can only trade with party members.
   (This modifier works completely independant from whether IDDC_IRON_COOP is enabled or not.) */
#define IRON_IRON_TEAM

/* Alternative IDDC anti-cheeze if IDDC_IRON_COOP is too harsh:
   Allow any form of partying, but
   - don't allow trading items that were found before an involved party member had joined the party
   - don't allow trading gold or items bought from shops. */
#define IDDC_RESTRICTED_TRADING
/* Addition for IDDC_RESTRICTED_TRADING:
   Only allow partying when already inside the IDDC, by erasing any party membership on entering it,
   except for the party owner.
   Further, you cannot add someone who already has another character in that party,
   and you can only add someone who is on the same floor or deeper as the deepest party member.
   Last but not least, items cannot be traded on stale floors (could exploit via logging+farming the same floor over and over with new chars)! */
#define IDDC_RESTRICTED_PARTYING

/* Special anti-cheeze hack: Disallow carrying items from town to IDDC and
   giving them to another character inside IDDC, for the first n floors. */
#ifndef IDDC_IRON_COOP
 #define IDDC_NO_TRADE_CHEEZE 5
#endif

/* Do not allow an iron team owner to add any further players as soon as he hits level 9.
   This allows for creating a sort of 'no-trading-allowed' character,
   if he's the only member of his iron team, starting at level 9, guaranteedly.
   NOTE: Alternatively the PA_IRONTEAM_CLOSED flag can simply be used. */
//#define IRON_TEAM_LEVEL9

/* Give a crazy form learning boost inside Ironman Deep Dive Challenge? [9] */
#define IDDC_MIMICRY_BOOST 9

/* Make true artifacts pass their rarity roll more easily in IDDC? */
#define IDDC_EASY_TRUE_ARTIFACTS

/* Faster pseudo-id and more id / *id* scroll drops in IDDC? */
#define IDDC_ID_BOOST

/* Show character icon with coloured '@' or 'b' in top score table
   of the Ironman Deep Dive Challenge? */
#define IDDC_HISCORE_SHOWS_ICON

/* IDDC special buff: Regain a random drained attribute on levelup. */
#define IDDC_LEVELUP_RESTORES_STAT

/* IDDC-only characters: Alternatively allow entering the Halls of Mandos! */
#define DED_IDDC_MANDOS


/* Maximum amount of gold that can be farmed from townies before you get 1 XP
   from it. This is an anti-cheeze for Highlander Tournament and Ironman Deep
   Dive Challenge. (-1 = no limit) [300] */
#define EVENT_TOWNIE_GOLD_LIMIT 300

/* New, added for the implementation of FINAL_GUARDIAN (finally) - C. Blue
   Does the player have to actually explore a dungeon to get his recall depth set for it?
   (If not then he can just get his recall depth from another dungeon and use it here.)
   NOTE: Make sure 0,0 holds no 'normal' dungeon (only special-sector highlander etc). */
#define SEPARATE_RECALL_DEPTHS

/* Dungeons have minimum player level requirements to enter? */
//#define OBEY_DUNGEON_LEVEL_REQUIREMENTS

/* When one player discovers a dungeon, its location will automatically be
   visible to everyone in the mathom house?
   At the same time this will prevent players from discovering dungeons just by visiting
   the according world map sector - they will additionally have to SEE the staircase once!
   This can sometimes make discovering newly added dungeons much harder. */
#define GLOBAL_DUNGEON_KNOWLEDGE

/* Disallow instant resurrection in the Nether Realm */
#define INSTANT_RES_EXCEPTION

/* Auto-retaliation: */
/* No class restriction; limit to non-escape mechanisms. */
#define AUTO_RET_NEW
/* Enable use of /autoret or /ar command to specify auto-retaliation.
   This is especially to enable mimics to use their powers in auto-retaliation,
   if this option is enabled, they will be unable to use @OM inscription for that instead. */
#define AUTO_RET_CMD

/* Does a projection 'explode' ON a wall grid it hits, or BEFORE the wall grid?
   Exploding before it means that players standing in walls will only take 50%
   damage from it, while exploding on the wall grid means normal 100% damage.
   Should be on when PY_PROJ_WALL is on. */
#define PROJ_ON_WALL

/* Allow players to target monsters in walls, for fairness (monsters can usually
   target players in walls just fine). Should be on when PROJ_ON_WALL is on and
   must be on if PROJ_MON_ON_WALL is on. */
#define PY_PROJ_WALL

/* Allow monsters on wall grids which are _target_ (aka the epicenter x,y grid)
   of a projection to get hit by it. Otherwise, monsters on wall grids are always
   protected from balls/breaths by default. Must be on if PY_PROJ_WALL is on. */
#define PROJ_MON_ON_WALL

/* Allow players to fire ammo at monsters standing on walls.
   Also used for throwing. */
#define PY_FIRE_ON_WALL

/* Allow monsters to cast bolt spells at players standing on a wall/mountain/tree grid?
   Note: Shooting arrows/bolts/shots/missiles is casting bolt spells too. */
#define MON_BOLT_ON_WALL

/* Don't cause potion_smash_effect()s from terrain damage */
#define NO_TERRAIN_POTION_EXPLOSION

/* Reduce the effect of aggravating equipment on the player
   and especially fellow players? - C. Blue */
#define REDUCED_AGGRAVATION

/* How do polymorph rings work? - C. Blue    [1]
   0 = wear ring to keep the form, ring has timeout until it desintegrates
   1 = ring gets destroyed on activation and effect is timed */
#define POLY_RING_METHOD 1

/* Divide stack size of ethereal ammunition by this to make it rarer */
#define ETHEREAL_AMMO_REDUCTION 2

/* Various melee/ranged combat settings for cmd1.c and cmd2.c mostly */

#define MAX_VAMPIRIC_DRAIN 50   /* was 25 - note: this counts per turn, not per blow */
#define WEAPON_VAMPIRIC_CHANCE 100
#define NON_WEAPON_VAMPIRIC_CHANCE 50 /* was 67 - chance to drain if VAMPIRIC is given be a non-weapon item */

#define MAX_VAMPIRIC_DRAIN_RANGED 10    /* was 25 - note: this counts per shot, not per turn */
#define WEAPON_VAMPIRIC_CHANCE_RANGED 50
#define NON_WEAPON_VAMPIRIC_CHANCE_RANGED 33 /* chance to drain if VAMPIRIC is given be a non-weapon/non-ammo item */

/* Reduce damage in PvP by this factor */
#define PVP_MELEE_DAM_REDUCTION 3
/* Reduce damage in PvP by this factor */
#define PVP_SHOOT_DAM_REDUCTION 5 /* [3] */
/* Reduce damage in PvP by this factor */
#define PVP_THROW_DAM_REDUCTION 3
/* divide magical damage by this in PvP */
#define PVP_SPELL_DAM_REDUCTION 5
/* divide aura damage by this in PvP */
#define PVP_AURA_DAM_REDUCTION 3

/* Adam's experimental spell damage reduction for PvP (disables PVP_SPELL_DAM_REDUCTION if enabled) */
//#define EXPERIMENTAL_PVP_SPELL_DAM

/* Increase mana-regeneration rate in PvP? */
#define PVP_MANA_REGEN_BOOST 3

/* Reduce AC used for testing the hit chance in PvP?
   Intended to counter heavy royal armour, which would otherwise be near impossible to beat. */
#define PVP_AC_REDUCTION

/* Does backstabbing bypass damage reduction from AC? (somewhat experimental, needs play-testing) */
#define PVP_BACKSTAB_PIERCES

/* Reduction of vampirism in PvP (melee and ranged) */
//unused atm #define PVP_VAMPIRISM_REDUCTION 3

/* Should other hostile players in line of sight cause a player to abort running?
   PvP mode chars cannot run with this on, which might be bad if a ranged char has
   phase door on auto-retaliation, while the other char is melee. Disabling it for now. */
//#define HOSTILITY_ABORTS_RUNNING

/* Number of turns you cannot use /pvp to exit the pvp arena, recall, or teleport, after
   getting hit or after entering the pvp arena. - C. Blue */
#define PVP_COOLDOWN_TELEPORT 30

/* Not allowed to steal while in town? */
#define TOWN_NO_STEALING

/* Not allowed to steal on protected floor grids (Inns)? */
#define PROTECTED_NO_STEALING

/* Combine 'Money Belt' and 'Device of Theft Prevention' aka Backpack Safety Lock in one item? */
#define TOOL_NOTHEFT_COMBO
/* Tool's chance to prevent theft */
#define TOOL_SAFETY_CHANCE 85

/*
 * Allow wraith-formed player to pass through permawalls on the surface.
 */
/*
 * TODO: wraithes should only pass townwalls of her/his own house
 */
#define WRAITH_THROUGH_TOWNWALL

/* when do rogues learn cloaking mode? */
#define LEARN_CLOAKING_LEVEL 15

/* Should a mind-link also display shops and shop actions to the secondary player? */
//#define MINDLINK_STORE

/* Percentage as chp multiplier for turning chars into numbers.
   100 would be most accurate, but we ever since used 95 instead to sort of pre-warn the player a bit ^^ */
#define TURN_CHAR_INTO_NUMBER_MULT 95
/* At which % should a char turn into a number? (10 = always, -1 = never) default: [6] */
#define TURN_CHAR_INTO_NUMBER 7
/* Experimental (2022, Dec): When disruption shield is on, [alternatingly] show HP instead if
   HP ratio becomes worse than MP ratio? To warn the player ie if he's cut/poisoned/diseased. - C. Blue */
#define TURN_CHAR_INTO_NUMBER_NEWMETHOD

/* Martyrdom doesn't allow to restore mana? (deprecated, we use half damage
   output for GF_DISP_xxx damage types instead of this penalty) */
//#define MARTYR_NO_MANA
/* Martyrdom reduces damage output of all GF_DISP_xxx to anti-cheeze pit sweeping? */
#define MARTYR_CUT_DISP

/* A random, rarely visited dungeon has a (slim) chance for firework drops */
#define FIREWORK_DUNGEON
/* Different colours of fireworks */
#define FIREWORK_COLOURS 7

#ifdef HOUSE_PAINTING
 /* Don't display house paint of mode-wise unusable player stores? */
 #define HOUSE_PAINTING_HIDE_BAD_MODE
 /* Don't display house paint of stores that contain more unsellable items than sellable ones? */
 //TODO:implement fully
 //#define HOUSE_PAINTING_HIDE_UNSELLABLE
 /* Don't display house paint of 'museum' like player stores, where most sellable items are priced > 50x value? Added new '@S-' for this! */
 //TODO:implement fully
 //#define HOUSE_PAINTING_HIDE_MUSEUM
#endif

/* Different items stacking may at most pile up to this many items (0 = no limit) */
//#define MAX_ITEMS_STACKING		10

/* Bad hack: Witan boots retain -STEALTH as artifacts.. ew */
#define ART_WITAN_STEALTH

/* Allow fallen winners to wear/wield WINNERS_ONLY items? */
#define FALLEN_WINNERSONLY

/* Force certain items to drop from certain monsters, to fit their lore? - C. Blue
   Eg swords from swordmasters, blunt weapons from priests.
   Note: We ignore books/crystals at this time, also distinguishing between those would use too many flags.
   0: off, 1: way 1 (soft), 2: way 2 (hard) -- utilizes RESF_COND... flags. [2] */
#define FORCED_DROPS 2
/* Artificial generation chance when we try hard to generate a fitting item (overrides normal item probabilities): (1 in n) [50] */
#define FORCE_DROPS_PROBABLE 50

/* minimum time required to stay on current floor in order to get an extra feeling on next floor */
#define TURNS_FOR_EXTRA_FEELING		(cfg.fps * 120)

/* Enable strict probability-travel prevention by NO_MAGIC floor flag, even in up/down direction? */
//#define NOMAGIC_INHIBITS_LEVEL_PROBTRAVEL

/* Prevent probtravelling players ruining experience on floors of other players:
   Skip a floor if it already has players on it who are all not in your party. */
#define PROBTRAVEL_AVOIDS_OTHERS

#define CONDENSED_HP_MP		/* reduce HP and SP to 1 line each, instead of 1 line for max and 1 line for cur values? */

/* Chance for a door that is bashed open to break. */
#define DOOR_BASH_BREAKAGE	80

/* Create backup when erasing a player whose level is >= this. [40] because that's minimum kinging level. */
#define SAFETY_BACKUP_PLAYER 35

/* For Halloween event: Floor and player level range allowed for spawn/interaction with Pumpkin */
#ifndef RPG_SERVER
 #define HALLOWEEN_MAX_PLEV 30
 #define HALLOWEEN_MAX_DLEV 35
 #define HALLOWEEN_DLEV_TOUGHEST 25
 #define HALLOWEEN_DLEV_TOUGHER 17
 #define HALLOWEEN_DLEV_TOUGH 9
 #define HALLOWEEN_IDDC_DLEV 10
#else
 #define HALLOWEEN_MAX_PLEV 35
 #define HALLOWEEN_MAX_DLEV 40
 #define HALLOWEEN_DLEV_TOUGHEST 30
 #define HALLOWEEN_DLEV_TOUGHER 22
 #define HALLOWEEN_DLEV_TOUGH 14
 #define HALLOWEEN_IDDC_DLEV 10
#endif

/* Power inscriptions aren't "hard-coded" but can change when an item is curse-flipped? */
#define POWINS_DYNAMIC
/* Handle marker hiding on client side? Drawback: Requires new client version. Advantage: It's cleaner. Pft. */
//#define POWINS_DYNAMIC_CLIENTSIDE


/* ----------------------------------------------------------------------- (End of 'features')  ----------------------------------------------------------------------- */


/* SLAY and KILL (ie *SLAY*) multiplier */
#if 0 /* from old times when 2-handed weapons had very low dice */
 #define FACTOR_MULT 1	/* multiplier for actual FACTOR_ values, for finer resolution */
 #define FACTOR_HURT 2	/* slay animal/evil */
 #define FACTOR_SLAY 3
 #define FACTOR_KILL 5
 #define FACTOR_BRAND_RES 2
 #define FACTOR_BRAND 3
 #define FACTOR_BRAND_SUSC 6
#else /* adjusted for modern weapon dice to prevent insane output */
 #define FACTOR_MULT		10	/* multiplier for actual FACTOR_ values, for finer resolution */
 #define FACTOR_HURT		15	/* slay animal/evil */
 #define FACTOR_SLAY		20
 #define FACTOR_KILL		30
 #define FACTOR_BRAND_RES	15
 #define FACTOR_BRAND		20
 #define FACTOR_BRAND_STRONG	30	/* added for Hellfire vs <Good && Resist> */
 #define FACTOR_BRAND_SUSC	40
#endif
/* Apply flat brand/slay +todam bonus too (for low-dice weapons)? - C. Blue */
#define FLAT_MIN_BONUS		1	/* added for Hellfire vs <Good && Immune> */
#define FLAT_HALF_BONUS		2	/* added for Hellfire vs <Good && Resist> */
#define FLAT_HURT_BONUS		3
#define FLAT_BRAND_BONUS	4	/* same for susceptible monsters, none for resisting monsters */
#define FLAT_SLAY_BONUS		4
#define FLAT_KILL_BONUS		5


/*
 * Party commands
 */
#define PARTY_CREATE		1
#define PARTY_ADD		2
#define PARTY_DELETE		3
#define PARTY_REMOVE_ME		4
#define PARTY_HOSTILE		5
#define PARTY_PEACE		6
#define PARTY_CREATE_IRONTEAM	7
#define PARTY_CLOSE		8

/*
 * Party modes
 */
#define PA_NORMAL		0x0
#define PA_IRONTEAM		0x1
#define PA_IRONTEAM_CLOSED	0x2	/* Could replace IRON_TEAM_LEVEL9: Allow owner to manually close the party to newcomers. */

/*
 * Guild commands
 */
#define GUILD_CREATE	1
#define GUILD_ADD	2
#define GUILD_DELETE	3
#define GUILD_REMOVE_ME	4

/*
 * Dungeon master commands
 */
#define	MASTER_NULL	0
#define	MASTER_LEVEL	1
#define MASTER_BUILD	2
#define	MASTER_SUMMON	3
#define MASTER_GENERATE	4
#define MASTER_PLAYER	5
#define	MASTER_SCRIPTL	6
#define	MASTER_SCRIPTB	7
#define	MASTER_SCRIPTE	8
#define	MASTER_SCRIPTS	9
//#define	MASTER_SUMMON_SPEFIC	0	?
//#define	MASTER_SUMMON_
#define	MASTER_SCRIPTB_W	'w'
#define	MASTER_SCRIPTB_A	'a'


/* Dungeon indices (d_ptr->type) hardcoded from d_info.txt file: */
#define DI_MT_DOOM		5
#define DI_NETHER_REALM		6
#define DI_SUBMERGED_RUINS	7
#define DI_HALLS_OF_MANDOS	8
#define DI_PATHS_DEAD		16
#define DI_THE_ORC_CAVE		19
#define DI_SMALL_WATER_CAVE	24
#define DI_SANDWORM_LAIR	27
#define DI_DEATH_FATE		28
#define DI_HELCARAXE		29
#define DI_VALINOR		31
#define DI_CLOUD_PLANES		32

/* Monster indices (r_idx) hardcoded from r_info.txt file.
   (Note -- the following code parts still use hard-coded numbers:
   taunt_monsters(), calc_body_bonus(), fountain_guard(), and mimic form handling:
   (mimic_shaman_E, mimic_druid, mimic_vampire, check_experience(), do_cmd_check_extra_info()).) */
#define RI_FARMER_MAGGOT	8
#define RI_LEPER		13
#define RI_NOVICE_MAGE		46
#define RI_SMEAGOL		63	/* DROP_CHOSEN */
#define RI_NOVICE_MAGE_F	93
#define RI_ROBIN_HOOD		138	/* DROP_CHOSEN */
#define RI_NURGLING		139
#define RI_BLUE_HORROR		189
#define RI_PINK_HORROR		242	/* DROP_CHOSEN */
#define RI_SOFTWARE_BUG		246
#define RI_UFTHAK		260
#define RI_BEARER_NURGLE	268
#define RI_DOOR_MIMIC		311
#define RI_VAMPIRIC_MIST	365
#define RI_VAMPIRE_BAT		391
#define RI_BEAST_NURGLE		422
#define RI_HALF_TROLL		491	/* TROLL_REGENERATION */
#define RI_BLOODLETTER		523
#define RI_RAALS_TOME		557	/* DROP_CHOSEN */
#define RI_EOL			660	/* DROP_CHOSEN */
#define RI_WARRIOR_DAWN		693
#define RI_STORMBRINGER		698	/* DROP_CHOSEN */
#define RI_SANTA1		733	/* terror santa from hell */
#define RI_GUO			736
#define RI_ARTSI		770	/* DROP_CHOSEN */
#define RI_SARUMAN		771	/* DROP_CHOSEN */
#define RI_VLAD_DRACULA		780	/* DROP_CHOSEN */
#define RI_MARDRA		791	/* DROP_CHOSEN */
#ifdef ENABLE_OHERETICISM
 #define RI_BLOODTHIRSTER	758
#endif
#define RI_UNMAKER		815	/* prevent live spawn */
#define RI_DOL_GULDUR		819	/* 'easy' version of sauron */
#define RI_MEPHISTOPHELES	831	/* DROP_CHOSEN */
#define RI_OREMORJ		843	/* note: jokeangband */
#define RI_GOTHMOG		856	/* DROP_CHOSEN */
#define RI_SAURON		860
#define RI_MORGOTH		862
#define RI_RNG			869

/* The Nazgul */
#define RI_UVATHA		946
#define RI_ADUNAPHEL		947
#define RI_AKHORAHIL		948
#define RI_REN			949
#define RI_JI			950
#define RI_DWAR			951
#define RI_HOARMUTH		952
#define RI_KHAMUL		953
#define RI_WITCHKING		954

#define RI_GORLIM		961	/* DROP_CHOSEN */
#define RI_TIK_SRVZLLAT		1032
#define RI_KRONOS		1037	/* DROP_CHOSEN */
#define RI_LIVING_LIGHTNING	1147
#define RI_HELLRAISER		1067
#define RI_NETHER_GUARD		1068
#define RI_DOR			1085
#define RI_PUMPKIN		1088	/* new: max hp version is now _the_ (only) Pumpkin form - its HP get downscaled live on spawn according to floor level. */
#define RI_ZU_AON		1097
#define RI_OROME		1098
#define RI_BRIGHTLANCE		1100
#define RI_TARGET_DUMMY1	1101	/* normal version */
#define RI_SANTA2		1102	/* normal version */
#define RI_CANDLEBEARER		1104	/* ENABLE_MAIA */
#define RI_DARKLING		1105	/* ENABLE_MAIA */
#define RI_BAD_LUCK_BAT		1114
#define RI_TARGET_DUMMY2	1126	/* snow-covered version */
#define RI_PANDA		1135
#define RI_ROBIN		1142
#define RI_TARGET_DUMMYA1	1144	/* normal armoured version */
#define RI_TARGET_DUMMYA2	1145	/* snow-covered armoured version */
#define RI_BAHAMUT		1146
#define RI_BLUE			1152
#define RI_MIRROR		1153
#define RI_HORNED_REAPER_GE	1154	/* low-power Horned Reaper for 'Dungeon Keeper' event */
#define RI_BLOB_SHRIEK		1162

#define RI_ARCADE_START		1115	/* first arcade-specific monster; TODO: add ARCADE flag instead */
#define RI_ARCADE_END		1124	/* last arcade-specific monster; TODO: add ARCADE flag instead */


/* Monster ego power indices from re_info.txt */
#define RE_NONE			0
#define RE_DRUNK		15
#define RE_MASTER_THIEF		33	/* CHAR_CLEAR+ATTR_CLEAR */
#define RE_SHADOWED		45	/* CHAR_CLEAR+ATTR_CLEAR */
#define RE_RUNEMASTER		62


/* Use normal monster abilities instead of truly mirrored abilities?
   (This is basically a placeholder until a true mirror image is eventually implemented..) */
#define SIMPLE_RI_MIRROR

/* Use player's max_plv instead of max_lev as level? */
//#define RI_MIRROR_MAXPLV

/* Only learn spells if the player actually carries them too?
   Otherwise the pure school knowledge of the player is sufficient for the mirror to know all fitting spells!
   This can make things easier by diluting spells, but also much harder for key spells such as healing. */
#define SIMPLE_RI_MIRROR_CHECKFORSPELLS

/* 'Cast' all resistance-giving spells preemptively ie gain all available resistances from spells right at
   the beginning of the fight? If not, we will acquire the missing ones as soon as the player casts them, instead. */
#define RI_MIRROR_PREEMPT_RES

/* Reduced % of damage taken by the mirror */
#define MIRROR_REDUCE_DAM_TAKEN_MELEE 20
#define MIRROR_REDUCE_DAM_TAKEN_THROW 20
#define MIRROR_REDUCE_DAM_TAKEN_RANGED 20
#define MIRROR_REDUCE_DAM_TAKEN_SPELL 20
#define MIRROR_REDUCE_DAM_TAKEN_AURA 20
#define MIRROR_REDUCE_DAM_TAKEN_RUNECRAFT 12	/* experimental, needs more testing */

/* Reduced % of damage dealt by the mirror */
#define MIRROR_REDUCE_DAM_DEALT_MELEE 20
#define MIRROR_REDUCE_DAM_DEALT_SPELL 20
#define MIRROR_REDUCE_DAM_DEALT_AURA 20


/* Summoning/spawning override flags for checks in monster placement routines */
#define SO_NONE			0x0000	/* apply all checks (default) */
#define SO_ALL			0xFFFF	/* ignore ALL checks (admin summmoning) */

#define SO_PROTECTED		0x0001	/* ignore PROTECTED grids (Inn) */
#define SO_HOUSE		0x0002	/* ignore CAVE_ICKY grids on surface around towns (houses) */
#define SO_FORCE_DEPTH		0x0004	/* ignore FORCE_DEPTH check (monlev vs dunlev) */
#define SO_GRID_EMPTY		0x0008	/* ignore check for 'empty' or 'mountain' (if monster can pass mountains) grid */

#define SO_GRID_TERRAIN		0x0010	/* ignore check for terrain the monster can pass. NOTE: currently these two SO_GRID_.. are checked inconsistently -> fix! */
#define SO_GRID_GLYPH		0x0020	/* ignore check for glyphed grid */
#define SO_TT_RPG		0x0040	/* RPG server rules: Don't spawn any monsters in training tower */
#define SO_EVENTS		0x0080	/* ignore check preventing disturbing live spawns during events. Note: wild_add_monster() has own check. */

#define SO_PRE_STAIRS		0x0100	/* ignore safety check preventing monster packs occupying staircase grids, pushing off the player when he enters the level */
#define SO_BOSS_LEVELS		0x0200	/* ignore checks which manage special levels (containing bosses) */
#define SO_BOSS_MONSTERS	0x0400	/* ignore checks which restrict boss/special/unique monster appearances (nether realm monsters too) */
#define SO_SURFACE		0x0800	/* ignore checks which restrict certain monster spawns on the world surface (breeders, uniques) */

#define SO_IDDC			0x1000	/* legalize uncheezable summoning in ironman deep dive challenge. Note: clone/clone_summoning imply this flag! */
#define SO_PLAYER_SUMMON	0x2000	/* player deliberately summoned -> do not reduce monster starting energy helpfully */


/*
 * Methods of leaving a level
 */
#define LEVEL_UP		0
#define LEVEL_DOWN		1
#define LEVEL_RAND		2
#define LEVEL_GHOST		3
#define	LEVEL_OUTSIDE		4
#define LEVEL_OUTSIDE_RAND	5
#define LEVEL_HOUSE		6
#define LEVEL_RECALL_UP		7
#define LEVEL_RECALL_DOWN	8
#define LEVEL_PROB_TRAVEL	9
#define LEVEL_TO_TEMPLE		10
#define LEVEL_OUTSIDE_CENTER	11


/*
 * Pkill flags
 */
#define PK_RULES_TRAD		0
#define PK_RULES_DECLARE	1
#define PK_RULES_NEVER		2

#define PKILL_SET		1	/* On/off */
/* KURZEL_PK -- We now just use a single (PK) flag (above) now. */
#define PKILL_KILLABLE		2	/* Can be killed */
#define PKILL_KILLER		4	/* Can kill */


/* Misc */
#define BUMP_OPEN_DOOR		0x01
#define BUMP_OPEN_HOUSE		0x02
#define BUMP_OPEN_TRAP		0x04


/*
 * The types of special file perusal.
 */
#define SPECIAL_FILE_NONE		0
#define SPECIAL_FILE_UNIQUE		1
#define SPECIAL_FILE_ARTIFACT		2
#define SPECIAL_FILE_PLAYER		3
#define SPECIAL_FILE_OTHER		4	/* actually, this can handle everything */
#define SPECIAL_FILE_SCORES		5
#define SPECIAL_FILE_HELP		6
#define SPECIAL_FILE_PLAYER_EQUIP	7
#define SPECIAL_FILE_LOG		8
#define SPECIAL_FILE_DEATHS		9
#define SPECIAL_FILE_SERVER_SETTING	10
#define SPECIAL_FILE_MONSTER		11
#define SPECIAL_FILE_OBJECT		12
#define SPECIAL_FILE_HOUSE		13
#define SPECIAL_FILE_TRAP		14
#define SPECIAL_FILE_RECALL		15
#define SPECIAL_FILE_MOTD2		16
#define SPECIAL_FILE_EXTRAINFO		17	/* Same as /ex command, just as a file to browse -- not implemented */


/*
 * The commands that can be given to the new console
 */
#define CONSOLE_STATUS			10
#define CONSOLE_PLAYER_INFO		11
#define CONSOLE_ARTIFACT_LIST		12
#define CONSOLE_UNIQUE_LIST		13
#define CONSOLE_CHANGE_ARTIFACT		14
#define CONSOLE_CHANGE_UNIQUE		15
#define CONSOLE_SHUTDOWN		16
#define CONSOLE_MESSAGE			17
#define CONSOLE_KICK_PLAYER		18
#define CONSOLE_RELOAD_SERVER_PREFERENCES	19

/*
 * The replies that the new console can send
 */
#define CONSOLE_DENIED		100

/*
 * Store constants
 */
/* Total number of base stores (see "store.c", etc). Note: MAX_ST_IDX is total # of stores. */
#define MAX_BASE_STORES		10		/* default stores that appear in every town */
/* Total number of owners per store (see "store.c", etc) */
#define MAX_STORE_OWNERS	6	/* Max size for st_ptr->owners[] */
#define MAX_STORE_ACTIONS	9	/* Max # of different store actions from ba_info.txt/bldg.c */

#define STORE_INVEN_MAX		120		/* Max number of discrete objs in inven [48] */
#define STORE_CHOICES		64		/* Number of items to choose stock from (defined in st_info.txt) */
#define STORE_OBJ_LEVEL		5		/* Magic Level for normal stores */
#define STORE_TURNOVER_DIV	3		/* Normal shop turnover, per day (stock_size / this = randint(amount of items to turnover)) */
#define STORE_SHUFFLE		20		/* 1/Chance (per day) of an owner changing */
#define STORE_TURNOUT		60		/* Max turns a player may stay in a store if crowded */

#define STORE_PURSE_BOOST	10	/* Multiplier for max_cost (15) */

/* Stores/buildings defines */
#define STORE_HATED		0
#define STORE_LIKED		1
#define STORE_NORMAL		2

/* Store flags */
#define SF1_DEPEND_LEVEL	0x00000001U	/* Item kind levels depend on dungeon level */
#define SF1_SHALLOW_LEVEL	0x00000002U	/* Add a little to minimum item level */
#define SF1_MEDIUM_LEVEL	0x00000004U	/* Add to minimum item level */
#define SF1_DEEP_LEVEL		0x00000008U	/* Add much to minimum item level */
#define SF1_RARE		0x00000010U	/* k-chance must be >= 3 */
#define SF1_VERY_RARE		0x00000020U	/* k-chance must be >= 8 */
#define SF1_FLAT_BASE		0x00000040U	/* a) prevent rare base item types, b) give all base item types same probability */
#define SF1_ALL_ITEM		0x00000080U	/* Works as the BM */
#define SF1_RANDOM		0x00000100U	/* Sets level to 0 for apply_magic() if it isn't increased by ..._LEVEL store flags anyway. */
#define SF1_FORCE_LEVEL		0x00000200U	/* Prevent items of much lower kind level than store level. Applies to T-256 wildcard only. */
#define SF1_BUY50		0x00000400U	/* Shop buys for 50% of value (can be combined with BUY66, for 1/3 sell value) */
#define SF1_NO_DISCOUNT		0x00000800U	/* no discount at all */
#define SF1_NO_DISCOUNT2	0x00001000U	/* no 50%/75%/90% off */
#define SF1_EGO			0x00002000U	/* often has ego items (should go with SF1_GOOD and SF1_GREAT) */
#define SF1_RARE_EGO		0x00004000U	/* reroll on simple ego items (value<9000 or rarest rarity<7) at 75% probability */
#define SF1_PRICE1		0x00008000U	/* prices * 1.5 */
#define SF1_PRICE2		0x00010000U	/* double prices */
#define SF1_PRICE4		0x00020000U	/* prices * 4 */
#define SF1_PRICE16		0x00040000U	/* prices * 16 */
#define SF1_GOOD		0x00080000U	/* apply_magic good */
#define SF1_GREAT		0x00100000U	/* apply_magic great */
#define SF1_PRICY_ITEMS1	0x00200000U	/* items are worth 3000+ */
#define SF1_PRICY_ITEMS2	0x00400000U	/* items are worth 8000+ */
#define SF1_PRICY_ITEMS3	0x00800000U	/* items are worth 15000+ */
#define SF1_PRICY_ITEMS4	0x01000000U	/* items are worth 25000+ (except runes) */
#define SF1_HARD_STEAL		0x02000000U	/* hard to steal from this shop */
#define SF1_VHARD_STEAL		0x04000000U	/* very hard to steal from this shop */
#define SF1_SPECIAL		0x08000000U	/* Store doesn't have an inventory but prints arbitrary text to screen instead */
#define SF1_BUY67		0x10000000U	/* Shop buys for 67% of value */
#define SF1_NO_DISCOUNT1	0x20000000U	/* no 20+% discounts even */
#define SF1_SELL67		0x40000000U	/* Store sells for 67% of value (can be combined with BUY50, for 1/3 sell value) */
#define SF1_ZEROLEVEL		0x80000000U	/* all items are level 0 and can't be traded */

#define SF1_NO_DISCOUNT3	(SF1_NO_DISCOUNT1 | SF1_NO_DISCOUNT2)	/* Hack: Reduce discounts somewhat */

#define SF2_MUSEUM		0x00000001U
#define SF2_KEEP_QUART		0x00000002U	/* On store inventory turnover, keep at most 1/4 of the stock, resulting in somewhat more new items (for book stores mostly) */
#define SF2_KEEP_HALF		0x00000004U	/* On store inventory turnover, keep at most half the stock, resulting in more new items (for book stores mostly) */
#define SF2_KEEP_TQUART		0x00000008U	/* On store inventory turnover, keep at most 3/4 of the stock, resulting in somewhat more new items (for book stores mostly) */
#define SF2_FILL_WELL		0x00000010U	/* Fill up store inventory on turnover, so only few slots remain empty (potentially for buying items from the player). For book stores mostly. */


/* This seems to be bad, but backported once anyway;
 * consider removing them later */
#define STORE_GENERAL	0
#define STORE_ARMOURY	1
#define STORE_WEAPON	2
#define STORE_TEMPLE	3
#define STORE_ALCHEMIST	4
#define STORE_MAGIC	5
#define STORE_BLACK	6
#define STORE_HOME	7	/* player's house, NOT the inn (which is STORE_INN) */
#define STORE_BOOK	8
//#define STORE_PET	9
#define STORE_RUNE	9
#define STORE_MAYOR	10
#define STORE_INN	11
#define STORE_CASTLE	14
#define STORE_CASINO	15
#define STORE_SEATRULING	24
#define STORE_KINGTOWER	27
#define STORE_SEADOME	35
#define STORE_JEWELX	42
#define STORE_SHOESX	45
#define STORE_LIBRARY	46		/* unused */
#define STORE_FORBIDDENLIBRARY	47	/* unused */
#define STORE_BLACKX	48
#define STORE_MINING	59
#define STORE_BLACKS	60
#define STORE_BTSUPPLY	61
#define STORE_HERBALIST	62
#define STORE_STRADER	63	/* for ironman dungeons / RPG_SERVER settings */

#define STORE_PLAYER	66	/* Player store template */

/* The specialist shops - the_sandman */
#define STORE_SPEC_AXE		38
#define STORE_SPEC_BLUNT	39
#define STORE_SPEC_POLE		40
#define STORE_SPEC_SWORD	41
#define STORE_RARE_JEWELRY	42
#define STORE_DEEPSUPPLY	51
#define STORE_SPEC_SCROLL	52
#define STORE_SPEC_POTION	53
#define STORE_SPEC_ARCHER	55
#define STORE_MERCHANTS_GUILD	56
#define STORE_MATHOM_HOUSE	57
#define STORE_SPEC_CLOSECOMBAT	64
#define STORE_HIDDENLIBRARY	65
#define STORE_POTION_IDDC	67
#define STORE_DUNGEON_INN	68

/* Dungeon store clones of the normal town stores */
#define STORE_GENERAL_DUN	70
#define STORE_ARMOURY_DUN	71
#define STORE_WEAPON_DUN	72
#define STORE_TEMPLE_DUN	73
#define STORE_ALCHEMIST_DUN	74
#define STORE_MAGIC_DUN		75
#define STORE_BLACK_DUN		76
#define STORE_HOME_DUN		77	/* player's house, but inside a dungeon (NOT the inn, which is STORE_DUNGEON_INN) -- currently this doesn't exist */
#define STORE_BOOK_DUN		78
//#define STORE_PET_DUN		79
#define STORE_RUNE_DUN		79

/* special 'stores' (hacks for build_store()) */
#define STORE_FEAT_MORE	100	/* staircase down */
#define STORE_FEAT_LESS	101	/* staircase up */
#define STORE_HOUSE	102	/* trad/list/appartment */
#define STORE_DOORWAY	103	/* 'destroyed house' */
#define STORE_FOREST	104
#define STORE_POND	105
#define STORE_AUCTION	106	/* deprecated (not 'new' code, would need re-integration first) */
#define STORE_NINE	107	/* unknown, but supposed to have been a '9' and much bigger */

#define is_bookstore(st_idx) \
	(st_idx == STORE_BOOK || st_idx == STORE_BOOK_DUN || st_idx == STORE_LIBRARY || st_idx == STORE_HIDDENLIBRARY || st_idx == STORE_FORBIDDENLIBRARY ? TRUE : FALSE)


/*
 * Misc constants
 */
#define SERVER_SAVE	500		/* How often to save the server state (100) */
#if 0
 #define TOWN_DAWN	10000		/* Number of turns from dawn to dawn XXX */
 #define TOWN_DAWN	(DAY / 2)	/* Number of turns from dawn to dawn XXX */
#endif /* 0 */
#define GROW_TREE	5000		/* How often to grow a new tree in town */
#define BREAK_GLYPH	350		/* Rune of protection resistance */
#define BTH_PLUS_ADJ	3		/* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ	8		/* High value slows multiplication */
#define MON_SUMMON_ADJ	2		/* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE	2		/* Percent of player exp drained per hit */
#define USE_DEVICE	3		/* Value for calculating magic device activation chances, also modifier for EASY_USE and easier use of devices in general. */
/* Enable to prevent cursed diggers/tools to be created. - C. Blue
   Note: For tools that do not have (+hit) or (+dam) values, this might
   slightly increase amount of tools generated in stores since they will
   be generated fine even if they'd otherwise have come out as 'cursed'. */
//#define PREVENT_CURSED_TOOLS
/* If enabled, ATTR_BNW is calculated 'manually' on server-side same as
   breath-based flickering. This makes the BNW flickering much slower, which
   might or might not look better than the client-side fast flickering of
   dungeon wizards. Added ATTR_BNW and all this for silyl Panda Bear. - C. Blue
   NOTE: ATTR_BNW Stacks with ATTR_BASE. If SLOW_ATTR_BNW is NOT defined, then
   ATTR_BNW even cannot be used without ATTR_BASE if client is <= v447, because
   sole ATTR_BNW will also return TERM_DARK otherwise, which looks pretty bad. */
#define SLOW_ATTR_BNW


/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ	20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON	50		/* 1/chance of inflated monster level */



/*
 * Refueling constants
 */
#define FUEL_TORCH	5000	/* Maximum amount of fuel in a torch */
#define FUEL_LAMP	15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT	20	/* Maximum view distance */
#define MAX_RANGE	18	/* Maximum range (spells, etc) */

/* max range of arrows in do_cmd_fire.
 * the aim is to prevent 'out-of-range attack' abuse.
 * [MAX_RANGE] */
/* commented out due to monster AI improvements.
 * activate it if STUPID_MONSTER_SPELLS is defined!
 * --actually this should always be enabled and set to MAX_RANGE, that limit is also used for spellcasting.
 */
#define ARROW_DIST_LIMIT MAX_RANGE



/*
 * There is a 1/160 chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE	160

/*
 * Normal levels get at least 14 monsters
 */
#define MIN_M_ALLOC_LEVEL	14

/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD		4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN		8


/*
 * Misc constants ( see bst(), do_cmd_time() )
 */
#define DAY			(10 * 384 * cfg.fps)	/* Number of turns per day (10 * 384) times cfg.fps */
#define HOUR			(DAY / 24)		/* Number of turns per hour */
#define MINUTE			(HOUR / 60)		/* Number of turns per minute */
#define YEAR			(DAY * 365)		/* Number of turns per year */

#define SUNRISE			5			/* Sunrise */
#define NIGHTFALL		21			/* Nightfall */

/* Macros for determing if it is night or day */

#if 0
 #define	IS_DAY	 ((turn % (10L * TOWN_DAWN)) <= (10L * TOWN_DAWN / 2))
 #define	IS_NIGHT ((turn % (10L * TOWN_DAWN)) > (10L * TOWN_DAWN / 2))
#else	/* 0 */
 #define	IS_NIGHT_RAW	((bst(HOUR, turn) < SUNRISE) || (bst(HOUR, turn) >= NIGHTFALL))
 /* Certain events keep the world dark - Halloween and fireworks during season_new_years_eve: */
 #define	IS_NIGHT	(IS_NIGHT_RAW || season_halloween || fireworks)
 #define	IS_DAY		(!IS_NIGHT)
#endif	/* 0 */
/* For new quests */
 #define	IS_MORNING	((bst(HOUR, turn) >= SUNRISE) && (bst(HOUR, turn) <= 9))
 #define	IS_FORENOON	((bst(HOUR, turn) >= 10) && (bst(HOUR, turn) <= 11))
 #define	IS_NOON		((bst(HOUR, turn) >= 12) && (bst(HOUR, turn) <= 13))
 #define	IS_AFTERNOON	((bst(HOUR, turn) >= 14) && (bst(HOUR, turn) <= 17))
 #define	IS_EVENING	((bst(HOUR, turn) >= 18) && (bst(HOUR, turn) <= 21))
 //#define	IS_NIGHT	((bst(HOUR, turn) >= 22) && (bst(HOUR, turn) <= 23)) -- already defined as opposite of day (+events)
 #define	IS_MIDNIGHT	(bst(HOUR, turn) == 0)
 #define	IS_DEEPNIGHT	((bst(HOUR, turn) >= 1) && (bst(HOUR, turn) < SUNRISE))


/* More time macros */

#define START_YEAR		2890			/* Bilbo birthday year */
#define START_DAY		265			/* Bilbo birthday (22. Sept.) */


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO	100


/*
 * Player constants
 */
#define PY_MAX_EXP	999999999L	/* Maximum exp -- same as the final entry of player_exp() in tables.c */
#define PY_MAX_GOLD	2000000000L	/* Maximum gold, limited by long int and 'rounded' down for visual appeal. ^^- */
#define PY_MAX_PLAYER_LEVEL	99	/* Maximum level attainable by a player (non-admin) */
#define PY_MAX_LEVEL		100	/* Maximum level allowed technically */

/*
 * Player "food" crucial values (20000 is upper limit in set_food())
 */
#define PY_FOOD_MAX	15000	/* Food value (Bloated) */
#define PY_FOOD_FULL	10000	/* Food value (Normal) */
#define PY_FOOD_ALERT	3000	/* Food value (Hungry) was 2000 */
#define PY_FOOD_WEAK	2000	/* Food value (Weak) was 1000 */
#define PY_FOOD_FAINT	1000	/* Food value (Fainting) was 500 */
#define PY_FOOD_STARVE	200	/* Food value (Starving) was 100 */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL		197		/* Regen factor*2^16 when full */
#define PY_REGEN_WEAK		98		/* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT		33		/* Regen factor*2^16 when fainting */
//#define PY_REGEN_HPBASE		1442		/* Min amount hp regen*2^16 */  <- doesn't counter single life drain.
//#define PY_REGEN_HPBASE		1642		/* Min amount hp regen*2^16 */  <- works well, a bit stronger regen rate.
#define PY_REGEN_HPBASE		1542		/* Min amount hp regen*2^16 */
//#define PY_REGEN_HPBASE		1492		/* Min amount hp regen*2^16 */  <- works negatively at ~<=215 HP, positively at ~>=260 HP
#define PY_REGEN_MNBASE		524		/* Min amount mana regen*2^16 */

/* Cut thresholds */
#define CUT_MORTAL_WOUND	800	/* Was 1000 */


/*** Option Definitions ***/
#define OPT_PAGES	9	/* at least: number of pages of options in = menu */
#define OPT_MAX		(198+1)	/* at least: 9 pages a 22 options (+1 for termination, paranoia in any case, as we xfer all options in one as a single string) */
#define OPT_MAX_154	154	/* 6+1 pages a 22 options, valid until 4.9.1.0.0.0 */
#define OPT_MAX_COMPAT	128	/* 64; 96 */
#define OPT_MAX_OLD	96	/* for clients <= 4.5.5 */

/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK	23

/*
 * Body parts
 */
#define BODY_WEAPON	0
#define BODY_TORSO	1
#define BODY_ARMS	2
#define BODY_FINGER	3
#define BODY_HEAD	4
#define BODY_LEGS	5
#define BODY_MAX	6

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD	24
#define INVEN_ARM	25
#define INVEN_BOW	26
#define INVEN_LEFT	27
#define INVEN_RIGHT	28
#define INVEN_NECK	29
#define INVEN_LITE	30
#define INVEN_BODY	31
#define INVEN_OUTER	32
#define INVEN_HEAD	33
#define INVEN_HANDS	34
#define INVEN_FEET	35

#define INVEN_AMMO	36 /* 1 quiver -- TORSO */
#define INVEN_TOOL	37 /* 1 tool -- ARMS */

#if 0	/* ToME ones - later, later :) */
#define INVEN_WIELD	24 /* 3 weapons -- WEAPONS */
#define INVEN_BOW	27 /* 1 bow -- WEAPON */
#define INVEN_RING	28 /* 6 rings -- FINGER */
#define INVEN_NECK	34 /* 2 amulets -- HEAD */
#define INVEN_LITE	36 /* 1 lite -- TORSO */
#define INVEN_BODY	37 /* 1 body -- TORSO */
#define INVEN_OUTER	38 /* 1 cloak -- TORSO */
#define INVEN_ARM	39 /* 3 arms -- ARMS */
#define INVEN_HEAD	42 /* 2 heads -- HEAD */
#define INVEN_HANDS	44 /* 3 hands -- ARMS */
#define INVEN_FEET	47 /* 2 feets -- LEGS */
#define INVEN_CARRY	49 /* 1 carried monster -- TORSO */
#define INVEN_AMMO	50 /* 1 quiver -- TORSO */
#define INVEN_TOOL	51 /* 1 tool -- ARMS */
#endif	/* 0 */


/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL	38	/* since they start at 0, max slot index is INVEN_TOTAL - 1 (!) */
/* Number of equipment slots, INVEN_TOTAL ... INVEN_TOTAL + INVEN_EQ - 1 */
#define INVEN_EQ	(INVEN_TOTAL - INVEN_WIELD)


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE			(99+1)


/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR	0
#define A_INT	1
#define A_WIS	2
#define A_DEX	3
#define A_CON	4
#define A_CHR	5

/*
 * Player race constants (hard-coded by save-files, arrays, etc)
 */
#define RACE_HUMAN	0
#define RACE_HALF_ELF	1
#define RACE_ELF	2
#define RACE_HOBBIT	3
#define RACE_GNOME	4
#define RACE_DWARF	5
#define RACE_HALF_ORC	6
#define RACE_HALF_TROLL	7
#define RACE_DUNADAN	8
#define RACE_HIGH_ELF	9
#define RACE_YEEK	10
#define RACE_GOBLIN	11
#define RACE_ENT	12
#define RACE_DRACONIAN	13
#ifdef ENABLE_KOBOLD
 #define RACE_KOBOLD	14
 #define RACE_DARK_ELF	15
 #define RACE_VAMPIRE	16
 //#ifdef ENABLE_MAIA
 #define RACE_MAIA	17
 //#endif
#else
 #define RACE_DARK_ELF	14
 #define RACE_VAMPIRE	15
 //#ifdef ENABLE_MAIA
 #define RACE_MAIA	16
 //#endif
#endif
/* (or simply replace all those defines with p_info.txt) */

/*
 * Player class constants (hard-coded by save-files, arrays, etc)
 */
#define CLASS_WARRIOR		0
#define CLASS_MAGE		1
#define CLASS_PRIEST		2
#define CLASS_ROGUE		3
#define CLASS_MIMIC		4
#define CLASS_ARCHER		5
#define CLASS_PALADIN		6
#define CLASS_RANGER		7
#define CLASS_ADVENTURER	8
//#define CLASS_BARD		9
#define CLASS_DRUID		9
#define CLASS_SHAMAN		10
#define CLASS_RUNEMASTER	11
#define CLASS_MINDCRAFTER	12
#ifdef ENABLE_DEATHKNIGHT
 #define CLASS_DEATHKNIGHT	13
 #ifdef ENABLE_HELLKNIGHT
  #define CLASS_HELLKNIGHT	14
  #ifdef ENABLE_CPRIEST
   #define CLASS_CPRIEST	15
  #endif
 #endif
#endif

/*
 * Races' class flags, which races allow which classes for choice
 * (must be same order as according CLASS_.. constants!)
 */
#define CF_NONE	0x0000
#define CF_ALL	0x1FFF	/* Note: Death/Hell Knights are left out intentionally, since they share a slot with Paladin */

#define CFW	0x0001	/* Warrior */
#define CFI	0x0002	/* Istar */
#define CFP	0x0004	/* Priest */
#define CFR	0x0008	/* Rogue */

#define CFM	0x0010	/* Mimic */
#define CFA	0x0020	/* Archer */
#define CFL	0x0040	/* Paladin */
#define CFN	0x0080	/* Ranger */

#define CFX	0x0100	/* Adventurer */
#define CFD	0x0200	/* Druid */
#define CFS	0x0400	/* Shaman */
#define CFU	0x0800	/* Runemaster */

#define CFC	0x1000	/* Mindcrafter */
#ifdef ENABLE_DEATHKNIGHT
 #define CFK	0x2000	/* Death Knight */
#endif
#if 0 /* not needed, since these cannot be created on birth! -- so we can save the flags for something else in the future */
 #ifdef ENABLE_HELLKNIGHT
  #define CFH	0x4000	/* Hell Knight */
 #endif
 #ifdef ENABLE_CPRIEST
  #define CFE	0x8000	/* Corrupted 'Priest' */
 #endif
#endif

/*
 * Traits' class flags, which traits are allowed for which race for choice
 */
#define RF_NONE	0x000000
#define RF_ALL	0xFFFFFF

#define RFU	0x000001	/* Human */
#define RFL	0x000002	/* Half-Elf */
#define RFE	0x000004	/* Elf */
#define RFH	0x000008	/* Hobbit */

#define RFG	0x000010	/* Gnome */
#define RFD	0x000020	/* Dwarf */
#define RFO	0x000040	/* Half-Orc */
#define RFT	0x000080	/* Half-Troll */

#define RFA	0x000100	/* Dunadan */
#define RFF	0x000200	/* High-Elf */
#define RFY	0x000400	/* Yeek */
#define RFI	0x000800	/* Goblin */

#define RFN	0x001000	/* Ent */
#define RFC	0x002000	/* Draconian */
#define RFK	0x004000	/* Dark-Elf */
#define RFV	0x008000	/* Vampire */

#define RFM	0x010000	/* Maia */
#define RFB	0x020000	/* Kobold */


/*
 * The traits
 */
#define TRAIT_NONE		0	/* N/A */

#define TRAIT_BLUE		1	/* Draconians */
#define TRAIT_WHITE		2
#define TRAIT_RED		3
#define TRAIT_BLACK		4
#define TRAIT_GREEN		5
#define TRAIT_MULTI		6
#define TRAIT_BRONZE		7
#define TRAIT_SILVER		8
#define TRAIT_GOLD		9
#define TRAIT_LAW		10
#define TRAIT_CHAOS		11
#define TRAIT_BALANCE		12
#define TRAIT_POWER		13

#define TRAIT_ENLIGHTENED	14	/* Maiar */
#define TRAIT_CORRUPTED		15


/*
 * Define the realms
 */
#define REALM_MAGERY		0
#define REALM_PRAYER		1
#define REALM_SORCERY		2
#define REALM_FIGHTING		3
#define REALM_SHADOW		4
#define REALM_HUNT		5
#define REALM_PSI		6
#define REALM_GHOST		7
#define MAX_REALM		8

/* hack needed in Handle_direction */
#define REALM_MIMIC		200
#define REALM_SCHOOL		201

/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

/* DEG PARTY Client defines */
#define CLIENT_PARTY_ROWHP	8
#define CLIENT_PARTY_COLHP	0

#define CLIENT_PARTY_ROWMP	9
#define CLIENT_PARTY_COLMP	0

#define CLIENT_PARTY_ROWMBR	11
#define CLIENT_PARTY_COLMBR	0

#define ROW_RACE		1
#define COL_RACE		0	/* <race name> */

#define ROW_CLASS		2
#define COL_CLASS		0	/* <class name> */

#define ROW_TITLE		3
#define COL_TITLE		0	/* <title> or <mode> */

#define ROW_LEVEL		4
#define COL_LEVEL		0	/* "LEVEL xxxxxx" */

#define ROW_EXP			5
#define COL_EXP			0	/* "EXP xxxxxxxx" */

#define ROW_GOLD		6
#define COL_GOLD		0	/* "AU xxxxxxxxx" */

#define ROW_STAT		9
#define COL_STAT		0	/* "xxx   xxxxxx" */

#define ROW_AC			16
#define COL_AC			0	/* "Cur AC xxxxx" */


#ifndef CONDENSED_HP_MP
 #define ROW_MAXHP		16
 #define COL_MAXHP		0	/* "Max HP xxxxx" */

 #define ROW_CURHP		17
 #define COL_CURHP		0	/* "Cur HP xxxxx" */

 #define ROW_MAXMP		18
 #define COL_MAXMP		0	/* "Max MP xxxxx" */

 #define ROW_CURMP		19
 #define COL_CURMP		0	/* "Cur MP xxxxx" */

 #define ROW_EXSTA		-1      /* extra status, requires CONDENSED_HP_MP ! */
 #define COL_EXSTA		-1
#else
 #define ROW_MAXHP		17
 #define COL_MAXHP		8	/* "Max HP xxxxx" */

 #define ROW_CURHP		17
 #define COL_CURHP		3	/* "Cur HP xxxxx" */

 #define ROW_MAXMP		18
 #define COL_MAXMP		8	/* "Max MP xxxxx" */

 #define ROW_CURMP		18
 #define COL_CURMP		3	/* "Cur MP xxxxx" */

 #define ROW_MAXST		19	/* current stamina */
 #define COL_MAXST		8

 #define ROW_CURST		19	/* current stamina */
 #define COL_CURST		3

 #define ROW_EXSTA		20      /* extra status, requires CONDENSED_HP_MP ! */
 #define COL_EXSTA		0
#endif


#define ROW_SANITY		15	/* "Sanity  100%" */
#define COL_SANITY		0

#if 1
#define ROW_INFO		21
#define COL_INFO		0	/* "xxxxxxxxxxxx" */
#endif	/* if 1 */

/* begin of 'bottom-aligned' status info, for large map size support - C. Blue */

#define ROW_CUT			(22 + HGT_PLUS)
#define COL_CUT			0	/* <cut> */

#define ROW_STUN		(23 + HGT_PLUS)
#define COL_STUN		39	/* <stun> */

#define ROW_HUNGRY		(23 + HGT_PLUS)
#define COL_HUNGRY		0	/* "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_BLIND		(23 + HGT_PLUS)
#define COL_BLIND		8	/* "Blind" */

#define ROW_CONFUSED		(23 + HGT_PLUS)
#define COL_CONFUSED		14	/* "Confused" */

#define ROW_AFRAID		(23 + HGT_PLUS)
#define COL_AFRAID		23	/* "Afraid" */

#define ROW_POISONED		(23 + HGT_PLUS)
#define COL_POISONED		30	/* "Poisoned" */

#define ROW_STATE		(23 + HGT_PLUS)
#define COL_STATE		39	/* <state> */

#define ROW_SPEED		(23 + HGT_PLUS)
#define COL_SPEED		51	/* "Slow (-NN)" or "Fast (+NN)" */

#define ROW_STUDY		(23 + HGT_PLUS)
#define COL_STUDY		62	/* "Study" */
#define ROW_BPR			(23 + HGT_PLUS)
#define COL_BPR			61	/* Blows/Round */

#define ROW_DEPTH		(23 + HGT_PLUS)
#define COL_DEPTH		69	/* "Lev NNN" / "NNNN ft" */

/* non-bottom-aligned stuff again */

#define ROW_XYPOS		21
#define COL_XYPOS		0

#define ROW_AFK			21
#define COL_AFK			7       /* "AFK" */

#define ROW_CUMBER		7
#define COL_CUMBER		0       /* encumberment icons bar */

#define ROW_LAG			8
#define COL_LAG			0       /* mini lag-o-meter */

/* Note: The following extra diplay info may begin at line 23 instead of 24, but will
   still only be visible in big_map mode because otherwise it'd overwrite other
   indicators that use that line (these are pushed to the bottom of the screen while
   in big_map mode, thereby freeing up line 23 for these new extra display info): */

#define ROW_RESIST_FIRE		23
#define COL_RESIST_FIRE		1

#define ROW_RESIST_COLD		23
#define COL_RESIST_COLD		2

#define ROW_RESIST_ELEC		23
#define COL_RESIST_ELEC		3

#define ROW_RESIST_ACID		23
#define COL_RESIST_ACID		4

#define ROW_RESIST_POIS		23
#define COL_RESIST_POIS		5

#define ROW_RESIST_MANA		23
#define COL_RESIST_MANA		6

#define ROW_TEMP_SHIELD		23
#define COL_TEMP_SHIELD		8

#define ROW_TEMP_ESP		25
#define COL_TEMP_ESP		1

#define ROW_TEMP_REGEN		24
#define COL_TEMP_REGEN		1

#define ROW_TEMP_TBRAND		24
#define COL_TEMP_TBRAND		5

#define ROW_DISPERSION		24
#define COL_DISPERSION		8

#define ROW_CHARM		25
#define COL_CHARM		5


/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE		0x00

/* Basic features */
#define FEAT_FLOOR		0x01
#define FEAT_FOUNTAIN		0x02
#define FEAT_GLYPH		0x03
#define FEAT_OPEN		0x04
#define FEAT_BROKEN		0x05
#define FEAT_LESS		0x06
#define FEAT_MORE		0x07

/* Quest features -KMW- */
#define FEAT_QUEST_ENTER	0x08
#define FEAT_QUEST_EXIT		0x09
#define FEAT_QUEST_DOWN		0x0A
#define FEAT_QUEST_UP		0x0B

/* Shafts -GSN- */
#define FEAT_SHAFT_DOWN		0x0D
#define FEAT_SHAFT_UP		0x0E

#define FEAT_EMPTY_FOUNTAIN	0x0F
#define FEAT_WEB		0x10
#define FEAT_TRAP		0x11

/* Features 0x12 - 0x1F -- unused */
/* Resurrected ones from Mangband/TomeNET */
#define FEAT_CROP		0x12
#define FEAT_LOOSE_DIRT		0x13
#define FEAT_HOME_OPEN		0x14	/* player's house door */
#define FEAT_SIGN		0x15
#define FEAT_PERM_CLEAR		0x16
#define FEAT_LOGS		0x17
#define FEAT_DRAWBRIDGE		0x18
#define FEAT_HOME		0x19	/* player's house door */
#define FEAT_WALL_HOUSE		0x1A	/* permanent wall for player houses */

/* Backward compatibility Hack */
#define FEAT_HOME_HEAD		0x19
#define FEAT_HOME_TAIL		0x19

/* New features, filling up the gaps in f_info */
#define FEAT_FOUNTAIN_BLOOD	0x1B	/* for Vampires */
/* Like house wall, but for upper storeys, not illuminated by lamp light therefore */
#define FEAT_WALL_HOUSEUPPER	0x1C

#define FEAT_FAKE_WALL		0x1D
#define FEAT_WOODEN_TABLE	0x1E
#define FEAT_FLOOR_SPAL		0x1F

/* Doors */
#define FEAT_DOOR_HEAD		0x20
#define FEAT_DOOR_TAIL		0x2F

/* Extra */
#define FEAT_SECRET		0x30
#define FEAT_RUBBLE		0x31

/* Seams */
#define FEAT_MAGMA		0x32
#define FEAT_QUARTZ		0x33
#define FEAT_MAGMA_H		0x34	/* hidden treasure -- not generated atm */
#define FEAT_QUARTZ_H		0x35	/* hidden treasure -- not generated atm */
#define FEAT_MAGMA_K		0x36	/* known treasure */
#define FEAT_QUARTZ_K		0x37	/* known treasure */

/* Walls */
#define FEAT_WALL_EXTRA		0x38
#define FEAT_WALL_INNER		0x39
#define FEAT_WALL_OUTER		0x3A
#define FEAT_WALL_SOLID		0x3B
#define FEAT_PERM_EXTRA		0x3C	/* shop/house walls */
#define FEAT_PERM_INNER		0x3D	/* inner vault walls (also used for Dungeon Keeper) */
#define FEAT_PERM_OUTER		0x3E	/* outer vault walls */
#define FEAT_PERM_SOLID		0x3F	/* dungeon border */
/* note: also check add_outer_wall() about FEAT_PERM_OUTER and FEAT_PERM_EXTRA */

/* Explosive rune */
#define FEAT_RUNE		0x40

/* Pattern (Amber) -- Not implemented workingly (supposed to prevent teleport and summoning onto it and doesn't get wiped by deto/rocket/disi) */
#define FEAT_PATTERN_START	0x41
#define FEAT_PATTERN_1		0x42
#define FEAT_PATTERN_2		0x43
#define FEAT_PATTERN_3		0x44
#define FEAT_PATTERN_4		0x45
#define FEAT_PATTERN_END	0x46
#define FEAT_PATTERN_OLD	0x47
#define FEAT_PATTERN_XTRA1	0x48
#define FEAT_PATTERN_XTRA2	0x49

/* Shops */
#define FEAT_SHOP		0x4A

/* Permanent walls for quests */
#define FEAT_QUEST1		0x4B
#define FEAT_QUEST2		0x4C
#define FEAT_QUEST3		0x4D
#define FEAT_QUEST4		0x4E

/* Permanent clear wall to fill up unused map areas (new for better visuals, especially w/ BIG_MAP) */
#define FEAT_PERM_FILL		0x4F

/* Permanent wall for Nether Realm/other dungeons (just for the visuals) */
#define FEAT_PERM_SPIRIT	0x50
#define FEAT_PERM_MOUNTAIN	0x51

#define FEAT_FLOOR_CLOUD	0x52

/* Additional terrains */
#define FEAT_SNOW		0x53
#define FEAT_SHAL_WATER		0x54
#define FEAT_DEEP_LAVA		0x55
#define FEAT_SHAL_LAVA		0x56
#define FEAT_DARK_PIT		0x57
#define FEAT_DIRT		0x58
#define FEAT_GRASS		0x59
#define FEAT_ICE		0x5A
#define FEAT_SAND		0x5B
#define FEAT_DEAD_TREE		0x5C
#define FEAT_ASH		0x5D
#define FEAT_MUD		0x5E
#define FEAT_ICE_WALL		0x5F
#define FEAT_TREE		0x60
#define FEAT_MOUNTAIN		0x61
#define FEAT_SANDWALL		0x62
#define FEAT_SANDWALL_H		0x63	/* hidden treasure (requires treasure detection to become visible) -- not generated atm */
#define FEAT_SANDWALL_K		0x64	/* known treasure */
#define FEAT_HIGH_MOUNTAIN	0x65
#define FEAT_NETHER_MIST	0x66
#define FEAT_GLIT_WATER		0x67	/* For Valinor */
#define FEAT_HIGH_MOUNT_SOLID	0x68	/* For Valinor */
#define FEAT_BETWEEN_TEMP	0x69	/* Just a marker for divine_gateway() */
#define FEAT_ABYSS		0x6A
#define FEAT_CLOUDYSKY		0x6B
#define FEAT_ABYSS_BOUNDARY	0x6C
#define FEAT_VOLCANIC		0x6D
#define FEAT_PUDDLE		0x6E	/* Like shallow water, but evaporates on its own after a while -- not yet implemented */

#define FEAT_CORDON_H		0x6F
#define FEAT_CORDON_V		0x70
#define FEAT_CORDON_DS		0x71
#define FEAT_CORDON_DB		0x72
#define FEAT_CORDON_N		0x73
#define FEAT_BARS_H		0x74
#define FEAT_BARS_V		0x75
#define FEAT_BARS_DS		0x76
#define FEAT_BARS_DB		0x77
#define FEAT_BARS_N		0x78 /* 120 */

#define FEAT_INN		134

#define FEAT_CYCLIC_LESS	135
#define FEAT_CYCLIC_MORE	136
#define FEAT_FLOOR_PERMANENT	137
#define FEAT_ALPHA		138	/* Transparent, keeps previously existing floor. Used as 'mask for merging' when loading t_*.prf layers on top of already existing floors. */

#define FEAT_EMBERS		141
#define FEAT_SMALL_FIRE		142
#define FEAT_SMALL_CAMPFIRE	143
#define FEAT_CAMPFIRE		144
#define FEAT_BURNING_TORCH	145
#define FEAT_BURNING_LAMP	146
#define FEAT_SMALL_SPHERE	147
#define FEAT_MEDIUM_SPHERE	148
#define FEAT_LARGE_SPHERE	149

#define FEAT_PERM_MAGMA		0x9F /* 159 */
#define FEAT_BETWEEN		0xA0 /* 160 */

/* Altars */
#define FEAT_ALTAR_HEAD		0xA1 /* 161 */
#define FEAT_ALTAR_TAIL		0xAB /* 171 */

#define FEAT_MARKER		0xAC /* 172 */
/* Feature 0xAD -- Underground Tunnel */
#define FEAT_TAINTED_WATER	0xAE /* 174 */
#define FEAT_MON_TRAP		0xAF /* 175 */
#define FEAT_BEACON		0xB0 /* 176, formerly FEAT_BETWEEN2, finally in use: for Dungeon Keeper event */
#define FEAT_LAVA_WALL		0xB1 /* 177 */
#define FEAT_GREAT_FIRE		0xB2 /* 178 */
#define FEAT_WAY_MORE		0xB3 /* 179 */
#define FEAT_WAY_LESS		0xB4 /* 180 */
/* Feature 0xB5 -- field */
#define FEAT_EKKAIA		0xB6 /* 182 */
#define FEAT_PERM_EXTRA_BOUND	0xB7 /* 183 */
#define FEAT_PERM_EXTRA_BOUND_SPEC_EXTCOL	0xB8 /* 184 -- special extended colour (testing) */
#define FEAT_PERM_EXTRA_BOUND_SPEC_ANICOL	0xB9 /* 185 -- special animated colour (testing) */

/* Features 0xB7 - 0xBA -- unused */

#define FEAT_DEEP_WATER		0xBB /* 187 */
#define FEAT_GLASS_WALL		0xBC /* 188 */
#define FEAT_ILLUS_WALL		0xBD /* 189 */
/* Feature 0xBE -- grass roof */
/* Feature 0xBF -- grass roof top */
/* Feature 0xC0 -- grass roof chimney */
/* Feature 0xC1 -- brick roof */
/* Feature 0xC2 -- brick roof top */
/* Feature 0xC3 -- brick roof chimney */
/* Feature 0xC4 -- window */
/* Feature 0xC5 -- small window */
/* Feature 0xC6 -- rain barrel */
#define FEAT_FLOWER		0xC7 /* 199 */
/* Feature 0xC8 -- cobblestone road */
/* Feature 0xC9 -- cobblestone with outlet */
#define FEAT_IVY		0xCA /* 202 */
#define FEAT_TOWN		0xCB /* 203 */
/* Feature 0xCC -- Underground Tunnel */
#define FEAT_FIRE		0xCD /* 205 */
/* Feature 0xCE -- pile of rubble (permanent) */
#define FEAT_ROCKY		0xCF /*207 */
/* Features 0xCF - 0xFF */
#define FEAT_AGOAL		208
#define FEAT_BGOAL		209
#define FEAT_PROTECT		210	/* Stables, AMC arena */
#define FEAT_DECO_WATER		211
#define FEAT_BUSH		219
//
#define FEAT_SEALED_DOOR	224	/* for pvp-arena, like Andur suggested */
#define FEAT_UNSEALED_DOOR	225
#define FEAT_XPROTECT		226	/* AMC arena corners */
#define FEAT_ESCAPE_DOOR	230	/* for quests - it's a one-way door!  */
#define FEAT_SICKBAY_DOOR	231	/* for insta-res in town (or in general), to avoid kill-instares-loops while afk */
#define FEAT_SICKBAY_AREA	232
#define FEAT_IRID_GATE		233
#define FEAT_GRAND_MIRROR	234
#define FEAT_SHATTERED_MIRROR	235
#define FEAT_BARRED_FLOOR	236

/* number of connected void gates or something? */
#define MAX_BETWEEN_EXITS	2

/* former Dirty Hack (XXX this can overlook spiked door!) */
#define is_door(feat) (f_info[feat].flags1 & FF1_DOOR)

#define is_stair(feat) \
	((feat) == FEAT_MORE || (feat) == FEAT_LESS || (feat) == FEAT_WAY_MORE || (feat) == FEAT_WAY_LESS || \
	(feat) == FEAT_BETWEEN || (feat) == FEAT_BEACON || (feat) == FEAT_CYCLIC_MORE || (feat) == FEAT_CYCLIC_LESS)

/* For aquatic monsters/players: These feats can always be passed without damaging/impairing them. */
#define is_always_passable(feat) \
	(is_door(feat) || is_stair(feat) || \
	(feat) == FEAT_FOUNTAIN || (feat) == FEAT_EMPTY_FOUNTAIN || (feat) == FEAT_FOUNTAIN_BLOOD)


/*
 * Number of effects
 */
#define MAX_EFFECTS		256	/* 256, 128 */
#define MAX_EFFECTS_PLAYER	256	/* 128, 32 */

#define EFF_WAVE		0x00000001U	/* A circle whose radius increase */
#define EFF_LAST		0x00000002U	/* The wave lasts */
#define EFF_STORM		0x00000004U	/* The area follows the player */
#define EFF_WALL		0x00000008U	/* A cloud shaped like a beam */
#define EFF_CROSSHAIR_A		0x00000010U	/* Arcade Server */
#define EFF_CROSSHAIR_B		0x00000020U	/* Arcade Server */
#define EFF_CROSSHAIR_C		0x00000040U	/* Arcade Server */
#define EFF_THINWAVE		0x00000080U	/* Same as wave, but thickness 1 instead of 3 (hits each target only once instead of three times) */
#define EFF_VORTEX		0x00000100U	/* The area follows the target - Kurzel */
#define EFF_SEEKER		0x00000200U	/* Real-time-moving homing projectile */
#define EFF_METEOR		0x00000400U	/* Announce that a meteor will be landing here, then have it crash down */
#define EFF_TEMP		0x00000800U	/* Arbitrary temporary flag for extra functionality, for example for casting a one-time sfx */
//hole
#define EFF_SELF		0x00100000U	/* Pendant to PROJECT_SELF: Effects created by projections with this flag receive EFF_SELF, to remain harmful to the caster himself too. */
#define EFF_DUMMY		0x00200000U	/* Effect deals no damage to anything */
#define EFF_FALLING_STAR	0x00400000U
#define EFF_THUNDER_VISUAL	0x00800000U	/* For 'Thunderstorm' spell electrocution */
#define EFF_LIGHTNING1		0x01000000U	/* For Nether Realm finishing */
#define EFF_LIGHTNING2		0x02000000U	/* For Nether Realm finishing */
#define EFF_LIGHTNING3		0x04000000U	/* For Nether Realm finishing */
#define EFF_RAINING		0x08000000U	/* New ideas for pushing the edge of Rogue-like gaming ^^ */
#define EFF_FIREWORKS1		0x10000000U	/* For NEW_YEARS_EVE =) - C. Blue*/
#define EFF_FIREWORKS2		0x20000000U	/* For new year's eve too. */
#define EFF_FIREWORKS3		0x40000000U	/* For new year's eve too. */
#define EFF_SNOWING		0x80000000U	/* For WINTER_SEASON */



/* Treasure classes aka 'kind themes' */
#define TC_JUNK		0
#define TC_TREASURE	1
#define TC_COMBAT	2
#define TC_MAGIC	3
#define TC_TOOLS	4
#define TC_AMOUNT	5	/* Amount of different treasure classes, listed above */


/*** Artifact indexes (see "lib/edit/a_info.txt") ***/


/* Randarts */
#define ART_RANDART		999

/* Lites */
#define ART_GALADRIEL		1
#define ART_ELENDIL		2
#define ART_THRAIN		3
#define ART_PALANTIR_ORTHANC	202
#define ART_UNDEATH		200
#define ART_STONE_LORE		15
#define ART_PALANTIR_ITHIL	208

/* Amulets */
#define ART_CARLAMMAS		4
#define ART_INGWE		5
#define ART_DWARVES		6
#define ART_ANCHOR		14
#define ART_ELESSAR		206
#define ART_EVENSTAR		207

/* Rings */
#define ART_FLAR		7
#define ART_BARAHIR		8
#define ART_TULKAS		9
#define ART_NARYA		10
#define ART_NENYA		11
#define ART_VILYA		12
#define ART_POWER		13
#define ART_PHASING		203
/* 14 used by the anchor of space-time */
/* 15 used by the stone of lore */

/* Dragon Scale */
#define ART_RAZORBACK		16
#define ART_BLADETURNER		17
#define ART_MEDIATOR		166

/* Hard Armour */
#define ART_HIMRING		167
#define ART_SOULKEEPER		19
#define ART_ISILDUR		20
#define ART_ROHIRRIM		21
#define ART_BELEGENNON		22
#define ART_CELEBORN		23
#define ART_ARVEDUI		24
#define ART_CASPANION		25

/* DragonRider flying suit */
#define ART_MARDRA		26
#define ART_TRON		27

/* Soft Armour */
#define ART_THALKETTOTH		28

/* Shields */
#define ART_THORIN		30
#define ART_CELEGORM		31
#define ART_ANARION		32
#define ART_GILGALAD		169
#define ART_HARADRIM		176

/* Helms and Crowns */
#define ART_MORGOTH		34
#define ART_BERUTHIEL		35
#define ART_THRANDUIL		36
#define ART_THENGEL		37
#define ART_HAMMERHAND		38
#define ART_DOR			39
#define ART_HOLHENNETH		40
#define ART_GORLIM		41
#define ART_GONDOR		42
#define ART_NUMENOR		43
#define ART_KNOWLEDGE		160
#define ART_LEBOHAUM		165
#define ART_CELEBRIMBOR		170

/* Cloaks */
#define ART_COLLUIN		44
#define ART_HOLCOLLETH		45
#define ART_THINGOL		46
#define ART_THORONGIL		47
#define ART_COLANNON		48
#define ART_LUTHIEN		49
#define ART_TUOR		50
#define ART_OCEANSOUL		217

/* Gloves */
#define ART_CAMBELEG		52
#define ART_CAMMITHRIM		53
#define ART_PAURHACH		54
#define ART_PAURNIMMEN		55
#define ART_PAURAEGEN		56
#define ART_PAURNEN		57
#define ART_CAMLOST		58
#define ART_FINGOLFIN		59
#define ART_EOL			178

/* Boots */
#define ART_FEANOR		60
#define ART_DAL			61
#define ART_THROR		62

/* Swords */
#define ART_NARSIL		164
#define ART_MAEDHROS		64
#define ART_ANGRIST		65
#define ART_NARTHANC		66
#define ART_NIMTHANC		67
#define ART_DETHANC		68
#define ART_RILIA		69
#define ART_BELANGIL		70
#define ART_CALRIS		71
#define ART_ARUNRUTH		72
#define ART_GLAMDRING		73
#define ART_AEGLIN		74
#define ART_ORCRIST		75
#define ART_GURTHANG		76
#define ART_ZARCUTHRA		77
#define ART_MORMEGIL		78
#define ART_GONDRICAM		79
#define ART_CRISDURIAN		80
#define ART_AGLARANG		81
#define ART_RINGIL		82
#define ART_ANDURIL		83
#define ART_ANGUIREL		84
#define ART_ELVAGIL		85
#define ART_FORASGIL		86
#define ART_CARETH		87
#define ART_STING		88
#define ART_HARADEKKET		89
#define ART_GILETTAR		90
#define ART_DOOMCALLER		91
#define ART_VORPAL_BLADE	92
#define ART_ERU			147

/* Polearms */
#define ART_THEODEN		93
#define ART_PAIN		94
#define ART_OSONDIR		95
#define ART_TIL			96
#define ART_AEGLOS		97
#define ART_OROME		98
#define ART_NIMLOTH		99
#define ART_EORLINGAS		100
#define ART_DURIN		101
#define ART_EONWE		102
#define ART_BALLI		103
#define ART_LOTHARANG		104
#define ART_MUNDWINE		105
#define ART_BARUKKHELED		106
#define ART_WRATH		107
#define ART_ULMO		108
#define ART_AVAVIR		109
#define ART_FUNDIN		175

/* The sword of the Dawn */
#define ART_DAWN		110

/* Blunt */
#define ART_MELKOR		18
#define ART_HURIN		33
#define ART_GROND		111
#define ART_TOTILA		112
#define ART_THUNDERFIST		113
#define ART_BLOODSPIKE		114
#define ART_FIRESTAR		115
#define ART_TARATOL		116
#define ART_AULE		117
#define ART_NAR			118
#define ART_ERIRIL		119
//#define ART_OLORIN		120
#define ART_RUYIWANG		120
#define ART_DEATHWREAKER	121
#define ART_TURMIL		122
#define ART_GOTHMOG		123
#define ART_SKULLCLEAVER	177

/* Axes */
#define ART_AXE_GOTHMOG		145

#define ART_NAIN		174

/* Bows */
#define ART_BELTHRONDING	124
#define ART_BARD		125
#define ART_CUBRAGOL		126
#define ART_UMBAR		171

/* Mage Staffs */
#define ART_GANDALF		127

/* Boomerangs */
#define ART_BEOR		128
#define ART_GLIMDRIR		129

/* Musical Instrument */
#define ART_ROBINTON		137
#define ART_PIEMUR		138
#define ART_MENOLLY		139
#define ART_DRUEDAIN		141
#define ART_ROHAN		142
#define ART_HELM		143
#define ART_BOROMIR		144

/* Diggers */
#define ART_EREBOR		140

#define ART_ORCHAST		156
#define ART_NIGHT		157
#define ART_NATUREBANE		158

/* ToME-NET additions */
#define ART_GIVEROFSLEEP	209
#define ART_METHODIQUE		211
#define ART_SCHMERZGLAUBE	212
#define ART_DOUBLEZEE		213
#define ART_BILBO		214
#define ART_HALFLINGS		215
#define ART_DWARVEN_ALE		216

/* More additions - C. Blue */
#define ART_MOLTOR		210 /* was ETERNALPEACE */
#define ART_OCEAN_SOUL		217
#define ART_CLOAK_DM		218
#define ART_IRONFOOT		219
#define ART_HELM_DURIN		220
#define ART_MOONSTONE		221
#define ART_RIPPER		222
#define ART_REAVER		223
#define ART_GUARDIAN		224
#define ART_ABYSS		225
#define ART_FORGOTTEN		226
#define ART_BLACKORE		227
#define ART_THUNDERBOLT		228
#define ART_ZODIA		229
#define ART_GOBLINS		230
#define ART_DOMINATION		231
#define ART_SOULGRIP		232
#define ART_AMUGROM		233
#define ART_WRATHVERGE		234
#define ART_ARTERYCUTTER	235
#define ART_HELLFIRE		236
#define ART_COBALTFOCUS		237
#define ART_SKYWALKER		238
#define ART_SUNSPIRE		239
#define ART_STORMSPIRE		240
#define ART_BLOODSCOURGE	241
#define ART_QUIETUS		242
#define ART_ICONOFLIFE		243
#define ART_SPIRITSHARD		244
#define ART_RIPSAW		245
#define ART_NIGHTCLAW		246
#define ART_MISERICORDIA	247
#define ART_HOPEDAWN		248
#define ART_IMPALER		249
#define ART_KRONOS		250
#define ART_TARNKAPPE		251
#define ART_AMBER		252
#define ART_SLEEPING		253
#define ART_STORMSHIELD		254
#define ART_PIETY		255
#define ART_WINDS		256
#define ART_FIONA		257
#define ART_SCARLETORDER	258
#define ART_THINKINGCAP		259
#define ART_MIRROROFGLORY	260
#define ART_GOGGLES_DM		261
#define ART_ARS_NUMENIS		262
#define ART_SOULCALLER		263
#define ART_VERIDIS_QUO		264
#define ART_SCYTHE_DM		265
#define ART_BOOTS_MOLTOR	266
#define ART_DAILIR		267
#define ART_PIERCER		268
#define ART_URUKHAI		269
#define ART_DREADNOUGHT		272
#define ART_HAVOC		274
#define ART_EOWYN		275
#define ART_SMASHER		276
#define ART_LAMFADA		277
#define ART_FIST		278
#define ART_ENDOFDAYS		279
#define ART_WARPSPEAR		280
#define ART_UTUMNO		281
#define ART_ANCHORING		282
#define ART_SEVENLEAGUE		283
#define ART_ANTIRIAD		284
#define ART_ANTIRIAD_DEPLETED	285
/* #define ART_ANGTIRCALAD	*/


/*** Ego-Item indices (see "lib/edit/e_info.txt") ***/

#define EGO_MMANA		1
#define EGO_MPOWER		2
#define EGO_MWIZARDRY		3
#define EGO_MSPELL		4
#define EGO_RESIST_ACID		5
#define EGO_RESIST_ELEC		6
#define EGO_RESIST_FIRE		7
#define EGO_RESIST_COLD		8
#define EGO_RESISTANCE		9
#define EGO_ELVENKIND		10
#define EGO_PERMANENCE		11
#define EGO_LEPROUS		12
#define EGO_IMMUNE		13
#define EGO_DEFENCE		14
#define EGO_JUMP		15
#define EGO_ENDURE_ACID		16
#define EGO_ENDURE_ELEC		17
#define EGO_ENDURE_FIRE		18
#define EGO_ENDURE_COLD		19
#define EGO_ENDURANCE		20
#define EGO_REFLECT		21
#define EGO_ELECTRIC		22
#define EGO_NOLDOR		23
#define EGO_INTELLIGENCE	24
#define EGO_WISDOM		25
#define EGO_BEAUTY		26
#define EGO_MAGI		27
#define EGO_MIGHT		28
#define EGO_LORDLINESS		29
#define EGO_SEEING		30
#define EGO_INFRAVISION		31
#define EGO_LITE		32
#define EGO_TELEPATHY		33
#define EGO_REGENERATION	34
#define EGO_TELEPORTATION	35
#define EGO_STUPIDITY		36
#define EGO_NAIVETY		37
#define EGO_UGLINESS		38
#define EGO_SICKLINESS		39
#define EGO_DWARVEN		40
#define EGO_PROTECTION		41
#define EGO_STEALTH		42
#define EGO_AMAN		43
#define EGO_AURA_FIRE		44
#define EGO_ENVELOPING		45
#define EGO_VULNERABILITY	46
#define EGO_IRRITATION		47
#define EGO_AURA_ELEC		48
#define EGO_FREE_ACTION		49
#define EGO_SLAYING		50
#define EGO_AGILITY		51
#define EGO_POWER		52
#define EGO_PEACE		53
#define EGO_CHARMING		54
#define EGO_WEAKNESS		55
#define EGO_CLUMSINESS		56
#define EGO_SLOW_DESCENT	57
#define EGO_QUIET		58
#define EGO_BOOTS_FA		59
#define EGO_SPEED		60
#define EGO_DWARVISHENDU	61
#define EGO_NOISE		62
#define EGO_SLOWNESS		63
#define EGO_ANNOYANCE		64
#define EGO_HA			65
#define EGO_DF			66
#define EGO_BLESSED_WEAPON	67
#define EGO_LIFE		68
#define EGO_WEST		69
#define EGO_ATTACKS		70
#define EGO_SLAYING_WEAPON	71
#define EGO_SPINNING		72
#define EGO_BRAND_ACID		73
#define EGO_BRAND_ELEC		74
#define EGO_BRAND_FIRE		75
#define EGO_BRAND_COLD		76
#define EGO_BRAND_POIS		77
#define EGO_CHAOTIC		78
#define EGO_EARTHQUAKES		80
#define EGO_SLAY_ANIMAL		81
#define EGO_SLAY_EVIL		82
#define EGO_SLAY_UNDEAD		83
#define EGO_SLAY_DEMON		84
#define EGO_SLAY_ORC		85
#define EGO_SLAY_TROLL		86
#define EGO_SLAY_GIANT		87
#define EGO_SLAY_DRAGON		88
#define EGO_KILL_ANIMAL		89
#define EGO_KILL_EVIL		90
#define EGO_KILL_UNDEAD		91
#define EGO_KILL_DEMON		92
#define EGO_KILL_ORC		93
#define EGO_KILL_TROLL		94
#define EGO_KILL_GIANT		95
#define EGO_KILL_DRAGON		96
#define EGO_VAMPIRIC		97
#define EGO_STAR_DF		98
#define EGO_DRAGON		99
#define EGO_GONDOLIN		100
#define EGO_DIGGING		101
#define EGO_SPECTRAL		102
#define EGO_MORGUL		103
#define EGO_NOTHINGNESS		104
#define EGO_ACCURACY		105
#define EGO_VELOCITY		106
#define EGO_EXTRA_MIGHT		107
#define EGO_EXTRA_SHOTS		108
#define EGO_LORIEN		109
#define EGO_HARADRIM		110
#define EGO_BUCKLAND		111
#define EGO_HURT_ANIMAL		112
#define EGO_HURT_EVIL		113
#define EGO_HURT_UNDEAD		114
#define EGO_POISONOUS		115
#define EGO_ACIDIC		116
#define EGO_ELEMENTAL		117
#define EGO_HURT_DEMON		118
#define EGO_HURT_DRAGON		119
#define EGO_HURT_ALL		120
#define EGO_LIGHTNING_BOLT	121
#define EGO_FLAME		122
#define EGO_FROST		123
#define EGO_WOUNDING		124
#define EGO_BACKBITING		125
#define EGO_SHATTERED		126
#define EGO_BLASTED		127
#define EGO_MUSIC_ELDAR		128
#define EGO_MUSIC_POWER		129
#define EGO_INST_DRAGONKIND	130
#define EGO_GNOMISH		131
#define EGO_DWARVISH		132
#define EGO_RQUICKNESS		133
#define EGO_RCHARGING		134
#define EGO_RISTARI		135

#define EGO_LBOLDNESS		137

#define EGO_LBRIGHTNESS		139
#define EGO_LSTAR_BRIGHTNESS	140
#define EGO_ENCHANTED		141
#define EGO_LINFRAVISION	142
#define EGO_LETERNAL_EYE	143

#define EGO_LFADING		145
#define EGO_DWARVEN_ARMOR	146
#define EGO_INDESTRUCTIBLE	147
#define EGO_CURSED		148
#define EGO_FIREPROOF_BOOK	149
#define EGO_PLENTY		150
#define EGO_TXMIGHT		151
#define EGO_TXSHOTS		152
#define EGO_TAUTO		153
#define EGO_TFULLAUTO		154
#define EGO_TWELLHIDDEN		155
#define EGO_TCOMPLICATED	156
#define EGO_TOBVIOUS		157
#define EGO_TDRAGON		158
#define EGO_TDEMON		159
#define EGO_TANIMAL		160
#define EGO_TUNDEAD		161
#define EGO_TEVIL		162
#define EGO_LITE_MAGI		163
#define EGO_VULNERABILITY2	164
#define EGO_VULNERABILITY3	165
#define EGO_PRESERVATION	166
#define EGO_SERENITY		167
#define EGO_NIGHT_DAY		168
#define EGO_CLOAK_MAGI		169
#define EGO_CLOAK_INVIS		170
#define EGO_CLOAK_BAT		171
#define EGO_THIEVERY		172
#define EGO_COMBAT		173
#define EGO_STABILITY		174
#define EGO_ELVENKIND2		175
#define EGO_FURY		176
#define EGO_PLENTY2		177

#define EGO_RSIMPLICITY		179
/* megahack */
#define EGO_CLOAK_LORDLY_RES	180
#define EGO_CLOAK_TELERI	181
#define EGO_MIRKWOOD		182
#define EGO_NUMENOR		183
#define EGO_AVARI		184
#define EGO_ISTARI		185
#define EGO_OFTHEMAGI		186
#define EGO_STORMBRINGER	187
#define EGO_BUDWEISER		188
#define EGO_HEINEKEN		189
#define EGO_MISTRUST		190
#define EGO_INSULATION		191
#define EGO_CONCENTRATION	192
#define EGO_BRILLIANCE		193
#define EGO_LIMMUNITY		194
#define EGO_LPERPETUITY		195
#define EGO_LPRESENTIMENT	196
#define EGO_ESP			197	/* amulet of telepathic awareness, formerly ESP */
#define EGO_GUINNESS		198
#define EGO_PERFECTION		199
#define EGO_MOONWOOD		200
#define EGO_DRAGONBONE		201
#define EGO_IMBUED		202
#define EGO_TRANSFORMATION	203
#define EGO_ETHEREAL		204
#define EGO_LEVITATION		205
#define EGO_HEAVY_IMMUNITY	206
#define EGO_HEAVY_SUSTENANCE	207
#define EGO_HEAVY_PRESERVANCE	208
#define EGO_HEAVY_SWIFTNESS	209
#define EGO_HEAVY_POWER		210
#define EGO_HEAVY_TELEPATHY	211
#define EGO_HEAVY_HELLFORGED	212
#define EGO_AURA_COLD		213

#define EGO_HEAVY_RUNED		215
#define EGO_WATERPROOF_BOOK	216
#define EGO_CORRUPTED		217

#define EGO_WATERPROOF		219
#define EGO_FIREPROOF		220
#define EGO_AURA_ELEC2		221
#define EGO_AURA_COLD2		222
#define EGO_AURA_FIRE2		223

#define EGO_ROBE_MAGI		224
#define EGO_FROCK_PIETY		225
#define EGO_MARTIAL		226

#define EGO_TEMPORARY		227


/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

/* ToME ones */
#define TV_SKELETON	1      /* Skeletons ('s') */
#define TV_BOTTLE	2      /* Empty bottles ('!') */
#define TV_FIRESTONE	3      /* For DragonRiders */
#define TV_BATERIE	4      /* For the Alchemists */
#define TV_SPIKE	5      /* Spikes ('~') */
#define TV_MSTAFF	6      /* Mage Staffs */
#define TV_CHEST	7      /* Chests ('~') */
#define TV_PARCHMENT	8      /* Parchments from Kamband */
#define TV_CORPSE	9      /* Monster corpses */
#define TV_EGG		10      /* Monster Eggs */
#define TV_JUNK		11      /* Sticks, Pottery, etc ('~') */
#define TV_TOOL		12      /* Tools */
#define TV_GAME		13	/* Heavy ball and chess pieces - can only be generated by admins */
#define TV_INSTRUMENT	14      /* Musical instruments */
#define TV_BOOMERANG	15      /* Boomerangs */
#define TV_SHOT		16      /* Ammo for slings */
#define TV_ARROW	17      /* Ammo for bows */
#define TV_BOLT		18      /* Ammo for x-bows */
#define TV_BOW		19      /* Slings/Bows/Xbows */
#define TV_DIGGING	20      /* Shovels/Picks */
#define TV_BLUNT	21      /* Priest Weapons */
#define TV_POLEARM	22      /* Pikes/Glaives/Spears/etc. */
#define TV_SWORD	23      /* Edged Weapons */
#define TV_AXE		24      /* Axes/Cleavers */
#define TV_BOOTS	30      /* Boots */
#define TV_GLOVES	31      /* Gloves */
#define TV_HELM		32      /* Helms */
#define TV_CROWN	33      /* Crowns */
#define TV_SHIELD	34      /* Shields */
#define TV_CLOAK	35      /* Cloaks */
#define TV_SOFT_ARMOR	36      /* Soft Armor */
#define TV_HARD_ARMOR	37      /* Hard Armor */
#define TV_DRAG_ARMOR	38      /* Dragon Scale Mail */
#define TV_LITE		39      /* Lites (including Specials) */
#define TV_AMULET	40      /* Amulets (including Specials) */
#define TV_RING		45      /* Rings (including Specials) */
#define TV_TRAPKIT	46      /* Trapkits */
#ifdef ENABLE_DEMOLITIONIST
 #define TV_CHARGE	47	/* Demolition charges for 'Digging' (or 'Excavation') skill */
 #define TV_CHEMICAL	48	/* Ingredients for crafting demolition charges for 'Digging' (or 'Excavation') skill */
#else
 #define TV_CHEMICAL	48	/* Just for building the client anyway */
#endif

/* pernM ones (resurrected) */
#define TV_KEY		51      /* Keys (';') */
#define TV_GOLEM        52       /* Golem parts */

#define TV_TOTEM	54      /* Summoner totems */
#define TV_STAFF	55
#define TV_WAND		65
#define TV_ROD		66
#define TV_ROD_MAIN	67
#define TV_SCROLL	70
#define TV_POTION	71
#define TV_POTION2	72      /* Second set of potion */
#define TV_FLASK	77
#define TV_FOOD		80

/* unused */
#define TV_PSI_BOOK	89
#define TV_MAGIC_BOOK	90
#define TV_PRAYER_BOOK	91
#define TV_SORCERY_BOOK	92
#define TV_FIGHT_BOOK	93
#define TV_SHADOW_BOOK	94
#define TV_HUNT_BOOK	95

#define TV_MONSTER	99	/* unused, just to get rid of the NOTHING_NOTICED */

/* unused */
#define is_realm_book(o_ptr) \
	(89 <= (o_ptr)->tval && (o_ptr)->tval <= 95)

#define TV_HYPNOS	99      /* unused -- To wield monsters !:) */
#define TV_GOLD		100     /* Gold can only be picked up by players(?) */
#define TV_RANDART	102     /* Random Artifacts -- unused */

#define TV_GEM		106	//gemstones
#define TV_RUNE		107	/* Runecraft */

#define TV_BOOK		111

#if 0   /* (reserved) we'll use TomeNET books :) */
#define TV_SYMBIOTIC_BOOK	112
#define TV_MUSIC_BOOK	113
#define TV_DRUID_BOOK	114
#define TV_DAEMON_BOOK	115
#endif  /* 0 */

#define TV_SUBINVEN	126

/* special items */
#define TV_SPECIAL	127

/* Maximum "tval" */
#define TV_MAX		127


/* some masks (originally just is_armour for XBM control) - C. Blue */
#define is_ammo(tval)	(((tval) == TV_SHOT) || ((tval) == TV_ARROW) || ((tval) == TV_BOLT))
#define is_melee_weapon(tval)	(((tval) == TV_SWORD) || ((tval) == TV_BLUNT) || ((tval) == TV_AXE) || ((tval) == TV_POLEARM))
#define is_melee_item(tval)	(is_melee_weapon(tval) || ((tval) == TV_MSTAFF))
#define is_ranged_weapon(tval)	((tval) == TV_BOW || (tval) == TV_BOOMERANG)
#define is_throwing_weapon(o_ptr) ( \
	((o_ptr)->tval == TV_SWORD && ((o_ptr)->sval == SV_DAGGER || (o_ptr)->sval == SV_MAIN_GAUCHE)) || \
	((o_ptr)->tval == TV_POLEARM && ((o_ptr)->sval == SV_HUNTING_SPEAR || (o_ptr)->sval == SV_SPEAR || (o_ptr)->sval == SV_TRIDENT || (o_ptr)->sval == SV_BROAD_SPEAR || (o_ptr)->sval == SV_TRIFURCATE_SPEAR)) || \
	(o_ptr)->tval == TV_AXE )
#define is_weapon(tval)		(is_melee_weapon(tval) || is_ranged_weapon(tval))
/* For shops that only offer 'basic' items. Rarity at least /4 or /5. Execptions or special considerations listed behind each type line, if any. */
#define is_rare_weapon(tval,sval) ( \
	((tval) == TV_SWORD && ((sval) >= SV_BLADE_OF_CHAOS || (sval) >= SV_BLUESTEEL_BLADE || (sval) >= SV_SHADOW_BLADE)) || /* dark sword (needed by unbelievers), unsure about shadow blade */ \
	((tval) == TV_BLUNT && ((sval) == SV_MACE_OF_DISRUPTION || (sval) == SV_DEMON_HAMMER || (sval) == SV_SCOURGE_OF_REPENTANCE)) || \
	((tval) == TV_AXE && ((sval) == SV_THUNDER_AXE || (sval) == SV_INFERNAL_AXE)) || /* hunting spear (low dice, just for fun) */ \
	((tval) == TV_POLEARM && ((sval) == SV_SCYTHE_OF_SLICING || (sval) == SV_DRAGON_LANCE)) )
#define is_nonmetallic_weapon(tval,sval) \
	(((tval) == TV_BLUNT && ((sval) == SV_CLUB || (sval) == SV_WHIP || (sval) == SV_QUARTERSTAFF)) || \
	((tval) == TV_BOOMERANG && ((sval) == SV_BOOM_WOOD || (sval) == SV_BOOM_S_WOOD)) || ((tval) == TV_BOW && ((sval) == SV_SLING || (sval) == SV_SHORT_BOW || (sval) == SV_LONG_BOW)))
	/* || (sval) == SV_THREE_PIECE_ROD) -- metal connectors, maybe enough */
#define is_slicing_polearm(sval) \
	((sval) == SV_SICKLE || (sval) == SV_FAUCHARD || (sval) == SV_RHOMPHAIA || (sval) == SV_GLAIVE || (sval) == SV_SCYTHE || (sval) == SV_SCYTHE_OF_SLICING)
#define is_magic_device(tval)	(((tval) == TV_WAND) || ((tval) == TV_STAFF) || ((tval) == TV_ROD))
#define is_rare_magic_device(tval,sval) ( \
	((tval) == TV_WAND && ((sval) == SV_WAND_ANNIHILATION || (sval) == SV_WAND_ROCKETS || (sval) == SV_WAND_WALL_CREATION || (sval) == SV_WAND_TELEPORT_TO)) || \
	/* allowing +perception+, healing, magi/power/holiness */ \
	((tval) == TV_STAFF && ((sval) == SV_STAFF_EARTHQUAKES || (sval) == SV_STAFF_DESTRUCTION || (sval) == SV_STAFF_SPEED || (sval) == SV_STAFF_GENOCIDE)) || \
	/* not allowing Speed/Healing so people aren't "forced" to train MD */ \
	((tval) == TV_ROD && ((sval) == SV_ROD_HAVOC || (sval) == SV_ROD_IDENTIFY || \
	    (sval) == SV_ROD_MAPPING || (sval) == SV_ROD_CURING || (sval) == SV_ROD_RESTORATION \
	    || (sval) == SV_ROD_SPEED || (sval) == SV_ROD_HEALING)) )
#define is_armour(tval)	\
	(((tval) == TV_BOOTS) || ((tval) == TV_GLOVES) || \
	((tval) == TV_HELM) || ((tval) == TV_CROWN) || \
	((tval) == TV_SHIELD) || ((tval) == TV_CLOAK) || \
	((tval) == TV_SOFT_ARMOR) || ((tval) == TV_HARD_ARMOR) || \
	((tval) == TV_DRAG_ARMOR))
#define is_rare_armour(tval,sval) ( \
	(((tval) == TV_HELM) && ((sval) == SV_DRAGON_HELM || (sval) == SV_MITHRIL_HELM || (sval) == SV_ADAMANTITE_HELM)) || \
	((tval) == TV_CROWN) || /* for telepathy crowns in Ironman dungeon stores (IDDC -2k especially) */ \
	(((tval) == TV_SHIELD) && (((sval) == SV_ORCISH_SHIELD) || ((sval) == SV_DRAGON_SHIELD) || ((sval) == SV_SHIELD_OF_DEFLECTION) \
	    || ((sval) == SV_MITHRIL_ANCILE) || ((sval) == SV_ADAMANTITE_AEGIS))) || \
	(((tval) == TV_GLOVES) && ((sval) == SV_SET_OF_ELVEN_GLOVES)) || \
	(((tval) == TV_CLOAK) && ((sval) == SV_KOLLA)) || \
	(((tval) == TV_HARD_ARMOR) && (sval) >= SV_MITHRIL_CHAIN_MAIL) || \
	((tval) == TV_DRAG_ARMOR) )
/* doesn't include WINNERS_ONLY armour: */
//	(((tval) == TV_HARD_ARMOR) && (((sval) == SV_MITHRIL_CHAIN_MAIL) || ((sval) == SV_MITHRIL_PLATE_MAIL) || ((sval) == SV_ADAMANTITE_PLATE_MAIL))) ||
#define is_top_armour(tval,sval) \
	(((tval) == TV_DRAG_ARMOR) && \
	((sval) == SV_DRAGON_POWER || (sval) == SV_DRAGON_SKY || \
	(sval) == SV_DRAGON_DEATH || (sval) == SV_DRAGON_SHINING || \
	(sval) == SV_DRAGON_MULTIHUED || (sval) == SV_DRAGON_BALANCE))
	/* ...and possibly all winners_only armour */
#define is_common_armour(tval,sval) \
	(is_armour(tval) && !is_rare_armour(tval,sval))
#define sv_dsm_low(sv) \
        (sv == SV_DRAGON_BLUE || sv == SV_DRAGON_WHITE || sv == SV_DRAGON_BLACK || \
	sv == SV_DRAGON_RED || sv == SV_DRAGON_GREEN)
#define sv_dsm_mid(sv) \
        (sv == SV_DRAGON_BRONZE || sv == SV_DRAGON_SILVER || sv == SV_DRAGON_GOLD || \
	sv == SV_DRAGON_PSEUDO)
/* for determining sound effects for wear/wield command: */
#define is_textile_armour(tval,sval) \
	(((tval) == TV_BOOTS && (sval) != SV_PAIR_OF_METAL_SHOD_BOOTS && (sval) != SV_PAIR_OF_WITAN_BOOTS) || \
	((tval) == TV_GLOVES && (sval) != SV_SET_OF_GAUNTLETS && (sval) != SV_SET_OF_CESTI) || \
	(tval) == TV_SOFT_ARMOR || (tval) == TV_CLOAK || \
	((tval) == TV_HELM && ((sval) == SV_CLOTH_CAP || (sval) == SV_HARD_LEATHER_CAP || (sval) == SV_GOGGLES_DM)) || \
	((tval) == TV_SHIELD && ((sval) == SV_SMALL_LEATHER_SHIELD || (sval) == SV_LARGE_LEATHER_SHIELD)))
/* what magic/roguish/martial artist would wear; ignores DSM */
#define is_flexible_armour(tval,sval) \
	(((tval) == TV_BOOTS && (sval) != SV_PAIR_OF_HARD_LEATHER_BOOTS && (sval) != SV_PAIR_OF_METAL_SHOD_BOOTS && (sval) != SV_PAIR_OF_WITAN_BOOTS) || \
	((tval) == TV_GLOVES && (sval) != SV_SET_OF_GAUNTLETS && (sval) != SV_SET_OF_CESTI) || \
	(tval) == TV_SOFT_ARMOR || (tval) == TV_CLOAK || \
	((tval) == TV_HELM && ((sval) == SV_CLOTH_CAP || (sval) == SV_HARD_LEATHER_CAP || (sval) == SV_GOGGLES_DM)))
/* what non-light melee fighters would wear; ignores DSM */
#define is_tough_armour(tval,sval) \
	(((tval) == TV_BOOTS && (sval) != SV_PAIR_OF_SOFT_LEATHER_BOOTS) || \
	((tval) == TV_GLOVES && (sval) != SV_SET_OF_LEATHER_GLOVES) || \
	(tval) == TV_HARD_ARMOR || (tval) == TV_CLOAK || \
	((tval) == TV_HELM && (sval) != SV_CLOTH_CAP && (sval) != SV_HARD_LEATHER_CAP && (sval) != SV_GOGGLES_DM) || \
	(tval == TV_SHIELD))
#ifndef ENABLE_DEMOLITIONIST
 #define is_cheap_misc(tval) \
	(is_ammo(tval) || (tval) == TV_FIRESTONE || (tval) == TV_SPIKE || (tval) == TV_JUNK)
#else
 #define is_cheap_misc(tval) \
	(is_ammo(tval) || (tval) == TV_FIRESTONE || (tval) == TV_SPIKE || (tval) == TV_JUNK || (tval) == TV_CHEMICAL)
#endif
#define is_ranged_item(Ind, o_ptr) \
	(is_ranged_weapon((o_ptr)->tval) || \
	is_ammo((o_ptr)->tval) || \
	(o_ptr)->tval == TV_BOOK || \
	(o_ptr)->tval == TV_WAND || \
	((o_ptr)->tval == TV_ROD && rod_requires_direction(Ind, o_ptr)))
#define is_firearm_trapkit(sval) \
	((sval) == SV_TRAPKIT_SLING || (sval) == SV_TRAPKIT_BOW || (sval) == SV_TRAPKIT_XBOW)
#ifndef NEW_SHIELDS_NO_AC
/* Note: This doesn't check artifact_p() or TR5_NO_ENCHANT, but only the base item type. */
#define is_enchantable(o_ptr) \
	(is_weapon((o_ptr)->tval) || is_ammo((o_ptr)->tval) || \
	(o_ptr)->tval == TV_MSTAFF || \
	((o_ptr)->tval == TV_TRAPKIT && is_firearm_trapkit((o_ptr)->sval)) || \
	is_armour((o_ptr)->tval) || (o_ptr)->tval == TV_DIGGING)
#else
/* Note: This doesn't check artifact_p() or TR5_NO_ENCHANT, but only the base item type. */
#define is_enchantable(o_ptr) \
	((is_weapon((o_ptr)->tval) || is_ammo((o_ptr)->tval) || \
	(o_ptr)->tval == TV_MSTAFF || \
	((o_ptr)->tval == TV_TRAPKIT && is_firearm_trapkit((o_ptr)->sval)) || \
	is_armour((o_ptr)->tval) || (o_ptr)->tval == TV_DIGGING) \
	&& (o_ptr->tval != TV_SHIELD))
#endif
/* more possibilities: is_potion, is_rune, is_jewelry, is_rare_armour(tval,sval) */


/* Ones borrowed from PernAngband.	- Jir - */
/*
 * Max sizes of the following arrays
 */
#define MAX_ROCKS	62	/* Used with rings (min 58) */
#define MAX_AMULETS	44	/* Used with amulets (min 44) */
#define MAX_WOODS	36	/* Used with staffs (min 32) */
#define MAX_METALS	39	/* Used with wands/rods (min 32/30) */
#ifndef EXPAND_TV_POTION
 #define MAX_COLORS	65	/* Used with potions (min 62) */
#else
 #define MAX_COLORS	66	/* Used with potions (min 62) */
#endif
#define STATIC_COLORS	6	/* The first n colour flavours, which aren't randomised */
#define MAX_SHROOM	22	/* Used with mushrooms (min 20) */
#define STATIC_SHROOMS	1	/* The first n colour flavours, which aren't randomised */
#define MAX_TITLES	73	/* Used with scrolls (min 55) */
#define MAX_SYLLABLES	164	/* Used with scrolls (see below) */


/* sval for TV_BOTTLE */
#define SV_EMPTY_BOTTLE			1

/* sval for TV_JUNK */
#define SV_ENERGY_CELL			2
#define SV_POTTERY			3
#define SV_GLASS_SHARD			5	/* remains of the grand mirror */
#define SV_WOODEN_STICK			6
#define SV_WOOD_PIECE			7
#define SV_GIFT_WRAPPING_START		10
#define SV_GIFT_WRAPPING_END		15

/* svals for TV_KEY */
#define SV_HOUSE_KEY			1
#define SV_GUILD_KEY			2

/* Sval for golems */
#define SV_GOLEM_WOOD			0
#define SV_GOLEM_COPPER			1
#define SV_GOLEM_IRON			2
#define SV_GOLEM_ALUM			3
#define SV_GOLEM_SILVER			4
#define SV_GOLEM_GOLD			5
#define SV_GOLEM_MITHRIL		6
#define SV_GOLEM_ADAM			7
#define SV_GOLEM_MATERIAL_MAX		7 /* marker for end of basic golem materials */
#define SV_GOLEM_ARM			8
#define SV_GOLEM_LEG			9
#define SV_GOLEM_ATTACK			200
#define SV_GOLEM_FOLLOW			201
#define SV_GOLEM_GUARD			202

/* Sval for bones */
#define SV_BROKEN_SKULL			1
#define SV_BROKEN_BONE			2

/* Svals for TV_GAME */
#define SV_GAME_BALL			1
#define SV_WHITE_PIECE			2
#define SV_BLACK_PIECE			3
#define SV_WHITE_PAWN			4
#define SV_WHITE_KING			5
#define SV_WHITE_QUEEN			6
#define SV_WHITE_ROOK			7
#define SV_WHITE_KNIGHT			8
#define SV_WHITE_BISHOP			9
#define SV_BLACK_PAWN			10
#define SV_BLACK_KING			11
#define SV_BLACK_QUEEN			12
#define SV_BLACK_ROOK			13
#define SV_BLACK_KNIGHT			14
#define SV_BLACK_BISHOP			15
#define SV_SNOWBALL			16
#define SV_WHITE_DAME			17
#define SV_BLACK_DAME			18

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION	12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_RUINED			0
#define SV_CHEST_SMALL_WOODEN		1
#define SV_CHEST_SMALL_IRON		2
#define SV_CHEST_SMALL_STEEL		3
#define SV_CHEST_MIN_LARGE		4	/* marker */
#define SV_CHEST_LARGE_WOODEN		5
#define SV_CHEST_LARGE_IRON		6
#define SV_CHEST_LARGE_STEEL		7

#if 0 //deprecated
/*
 * Special "sval" limit -- first "good" magic/prayer book
 */
 #define SV_BOOK_MIN_GOOD	4
#endif

/*
 * Special "sval" limit -- last gold
 */
#define SV_GOLD_MAX		18


/* from ToMe */

/* The "sval" codes for TV_TOOL */
#define SV_TOOL_CLIMB			0
#define SV_PORTABLE_HOLE		1
#define SV_TOOL_PICKLOCK		2
#define SV_TOOL_MONEY_BELT		3
#define SV_TOOL_THEFT_PREVENTION	4
#define SV_TOOL_TARPAULIN		5
#define SV_TOOL_FLINT			6
#define SV_TOOL_WRAPPING		7
#ifdef ENABLE_DEMOLITIONIST
 #define SV_TOOL_GRINDER		8
#endif

/* The "sval" codes for TV_MSTAFF */
#define SV_MSTAFF 			1

/* The "sval" codes for TV_FIRESTONE */
#define SV_FIRESTONE			3
#define SV_FIRE_SMALL			6

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT			0	/* pebbles */
#define SV_AMMO_NORMAL			1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY			2	/* seeker arrows and bolts, mithril shots */
/* (pernM ammo) */
#define SV_AMMO_MAGIC			3	/* magic arrows, bolts, shots */
#define SV_AMMO_SILVER			4	/* silver arrows and bolts */
#define SV_AMMO_CHARRED			5	/* burnt ammo (used for flare missile skill) */

/* The "sval" codes for TV_INSTRUMENT */
#define SV_FLUTE			1
#define SV_BANJO			2
#define SV_LUTE				3
#define SV_MANDOLIN			4
#define SV_DRUM				5
#define SV_HARP				6
#define SV_HORN				7

/* The "sval" codes for TV_TRAPKIT */
#define SV_TRAPKIT_SLING		1
#define SV_TRAPKIT_BOW			2
#define SV_TRAPKIT_XBOW			3
#define SV_TRAPKIT_POTION		4	/* 'Fumes Trap Kit' */
#define SV_TRAPKIT_SCROLL_RUNE		5	/* 'Magic Trap Kit' */
#define SV_TRAPKIT_DEVICE		6	/* 'Device Trap Kit' */

/* The "sval" codes for TV_BOOMERANG */
#define SV_BOOM_S_WOOD			1	/* 2d3  */
#define SV_BOOM_WOOD			2	/* 2d5  */
#define SV_BOOM_S_METAL			3	/* 3d4  */
#define SV_BOOM_METAL			4	/* 3d6  */
#define SV_BOOM_S_RAZOR			5	/* 4d5  */
#define SV_BOOM_RAZOR			6	/* 4d7  */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING			2	/* (x2) */
#define SV_SHORT_BOW			12	/* (x2) */
#define SV_LONG_BOW			13	/* (x3) */
#define SV_LIGHT_XBOW			23	/* (x3) */
#define SV_HEAVY_XBOW			24	/* (x4) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL			1
#define SV_GNOMISH_SHOVEL		2
#define SV_DWARVEN_SHOVEL		3
#define SV_PICK				4
#define SV_ORCISH_PICK			5
#define SV_DWARVEN_PICK			6
#define SV_MATTOCK			7
#define SV_PICK_MOLTOR			8

/* The "sval" values for TV_BLUNT */
#define SV_CLUB				1	/* 1d4  */
#define SV_WHIP				2	/* 1d6  */
#define SV_QUARTERSTAFF			3	/* 1d9  */
#define SV_NUNCHAKU			4	/* 2d3  */
#define SV_MACE				5	/* 2d4  */
#define SV_BALL_AND_CHAIN		6	/* 2d4  */
#define SV_WAR_MAUL			8	/* 3d3  */
#define SV_WAR_HAMMER			10	/* 2d5  */
#define SV_THREE_PIECE_ROD		11	/* 3d3  */
#define SV_MORNING_STAR			12	/* 2d6  */
#define SV_FLAIL			13	/* 2d6  */
#define SV_LEAD_FILLED_MACE		15	/* 3d4  */
#define SV_TWO_HANDED_FLAIL		18	/* 3d6  */
#define SV_GREAT_HAMMER			19	/* 4d6  */
#define SV_MACE_OF_DISRUPTION		20	/* 5d8  */
#define SV_SCOURGE			21	/* 4d2  */
#define SV_DEMON_HAMMER			22	/* 6d6  */
#define SV_SCOURGE_OF_REPENTANCE	23	/* 4d3	*/
#define SV_GROND			50	/* 3d4  */

/* The "sval" values for TV_AXE */
#define SV_CLEAVER			1	/* 1d5 */
#define SV_DBITTED			2	/* 2d4 */
#define SV_TOMAHAWK			3	/* 2d4 */
#define SV_HATCHET			5	/* 2d3 */
#define SV_LIGHT_WAR_AXE		8	/* 2d5 */
#define SV_BEAKED_AXE			10	/* 2d6 */
#define SV_BROAD_AXE			11	/* 2d6 */
#define SV_BATTLE_AXE			22	/* 2d8 */
#define SV_GREAT_AXE			25	/* 4d4 */
#define SV_HEAVY_WAR_AXE		28	/* 3d8 */
#define SV_SLAUGHTER_AXE		30	/* 5d7 */
#define SV_INFERNAL_AXE			32	/* 7d6 */
#define SV_THUNDER_AXE			33	/* 6d8 */

/* The "sval" values for TV_POLEARM */
#define SV_HUNTING_SPEAR		1	/* 1d6 */
#define SV_SPEAR			2	/* 1d6 */
#define SV_SICKLE			3	/* 2d3 */
#define SV_AWL_PIKE			4	/* 1d8 */
#define SV_TRIDENT			5	/* 1d9 */
#define SV_FAUCHARD			6	/* 1d10 */
#define SV_BROAD_SPEAR			7	/* 1d9 */
#define SV_PIKE				8	/* 2d5 */
#define SV_RHOMPHAIA			9	/* 2d4 */
#define SV_DRAGON_LANCE			10	/* 4d10 */
#define SV_GLAIVE			13	/* 2d6 */
#define SV_HALBERD			15	/* 3d4 */
#define SV_GUISARME			16	/* 2d5 */
#define SV_SCYTHE			17	/* 5d3 */
#define SV_LANCE			20	/* 2d8 */
#define SV_TRIFURCATE_SPEAR		26	/* 2d9 */
#define SV_HEAVY_LANCE			29	/* 4d8 */
#define SV_SCYTHE_OF_SLICING		30	/* 8d4 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER		1  /* 1d1 */
#define SV_BROKEN_SWORD			2  /* 1d2 */
#define SV_DAGGER			4  /* 1d4 */
#define SV_MAIN_GAUCHE			5  /* 1d5 */
#define SV_RAPIER			7  /* 1d6 */
#define SV_SMALL_SWORD			8  /* 1d6 */
#define SV_BASILLARD			9  /* 1d8 */
#define SV_SHORT_SWORD			10  /* 1d7 */
#define SV_SABRE			11  /* 1d7 */
#define SV_CUTLASS			12  /* 1d7 */
#define SV_TULWAR			15  /* 2d4 */
#define SV_BROAD_SWORD			16  /* 2d5 */
#define SV_LONG_SWORD			17  /* 2d5 */
#define SV_SCIMITAR			18  /* 2d5 */
#define SV_KATANA			20  /* 3d4 */
#define SV_BASTARD_SWORD		21  /* 3d4 */
#define SV_GREAT_SCIMITAR		22  /* 4d5 */
#define SV_CLAYMORE			23  /* 2d8 */
#define SV_ESPADON			24  /* 2d9 */
#define SV_TWO_HANDED_SWORD		25  /* 3d6 */
#define SV_FLAMBERGE			26  /* 3d7 */
#define SV_EXECUTIONERS_SWORD		28  /* 4d5 */
#define SV_ZWEIHANDER			29  /* 4d6 */
#define SV_BLADE_OF_CHAOS		30  /* 6d5 */
#define SV_SHADOW_BLADE			31  /* 4d4 */
#define SV_BLUESTEEL_BLADE		32  /* 3d9 */
#define SV_DARK_SWORD			33  /* 3d7 */

/* The "sval" codes for TV_SHIELD -- note that we don't have 'explicite' wooden shields.. */
#define SV_SMALL_LEATHER_SHIELD		2
#define SV_SMALL_METAL_SHIELD		3
#define SV_LARGE_LEATHER_SHIELD		4
#define SV_LARGE_METAL_SHIELD		5
#define SV_DRAGON_SHIELD		6
#define SV_ORCISH_SHIELD		7
#define SV_SHIELD_OF_DEFLECTION		10
#define SV_MITHRIL_ANCILE		11
#define SV_ADAMANTITE_AEGIS		12

/* The "sval" codes for TV_HELM */
#define SV_CLOTH_CAP			1
#define SV_HARD_LEATHER_CAP		2
#define SV_METAL_CAP			3
#define SV_IRON_HELM			5
#define SV_STEEL_HELM			6
#define SV_DRAGON_HELM			7
#define SV_MITHRIL_HELM			10
#define SV_ADAMANTITE_HELM		11
#define SV_GOGGLES_DM			15 /* artifact goggles of the dungeon master */

/* The "sval" codes for TV_CROWN */
#define SV_IRON_CROWN			10
#define SV_GOLDEN_CROWN			11
#define SV_JEWELED_CROWN		12
#define SV_SILVER_CROWN			13
#define SV_MORGOTH			50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS	2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS	3
#define SV_PAIR_OF_METAL_SHOD_BOOTS	6
#define SV_PAIR_OF_WITAN_BOOTS		8
#define SV_SMOKIN_BOOTS_MOLTOR		9

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK			1
#define SV_ELVEN_CLOAK			2
#define SV_FUR_CLOAK			3
#define SV_SHADOW_CLOAK			6
#define SV_KOLLA			7
#define SV_SBSILK_CLOAK			8

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES	1
#define SV_SET_OF_GAUNTLETS		2
#define SV_SET_OF_ELVEN_GLOVES		4
#define SV_SET_OF_CESTI			5

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_FILTHY_RAG			1
#define SV_ROBE				2
#define SV_PAPER_ARMOR			3  /* 4 */
#define SV_SOFT_LEATHER_ARMOR		4
#define SV_SOFT_STUDDED_LEATHER		5
#define SV_HARD_LEATHER_ARMOR		6
#define SV_HARD_STUDDED_LEATHER		7
#define SV_RHINO_HIDE_ARMOR		8
#define SV_CORD_ARMOR			9  /*  6 */
#define SV_PADDED_ARMOR			10  /*  4 */
#define SV_LEATHER_SCALE_MAIL		11
#define SV_LEATHER_JACK			12
#define SV_WIRE_FLEECE			13
#define SV_STONE_AND_HIDE_ARMOR		15  /* 15 */
#define SV_DRAGONRIDER_SUIT		16
#define SV_WYVERNHIDE_ARMOR		17
#define SV_SHIRT			18
#define SV_FROCK			20
#define SV_TUNIC			21
#define SV_GOWN				22
#define SV_LEATHER_FROCK		23
#define SV_COSTUME			24 /* Halloween costume */

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_RUSTY_CHAIN_MAIL		1  /* 14- */
#define SV_RING_MAIL			2  /* 12  */
#define SV_METAL_SCALE_MAIL		3  /* 13  */
#define SV_CHAIN_MAIL			4  /* 14  */
#define SV_DOUBLE_RING_MAIL		5  /* 15  */
#define SV_AUGMENTED_CHAIN_MAIL		6  /* 16  */
#define SV_DOUBLE_CHAIN_MAIL		7  /* 16  */
#define SV_BAR_CHAIN_MAIL		8  /* 18  */
#define SV_METAL_BRIGANDINE_ARMOUR	9  /* 19  */
#define SV_SPLINT_MAIL			10  /* 19  */
#define SV_PARTIAL_PLATE_ARMOUR		12  /* 22  */
#define SV_METAL_LAMELLAR_ARMOUR	13  /* 23  */
#define SV_FULL_PLATE_ARMOUR		15  /* 25  */
#define SV_RIBBED_PLATE_ARMOUR		18  /* 28  */
#define SV_MITHRIL_CHAIN_MAIL		20  /* 28+ */
#define SV_MITHRIL_PLATE_MAIL		25  /* 35+ */
#define SV_ADAMANTITE_PLATE_MAIL	30  /* 40+ */

/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK			1
#define SV_DRAGON_BLUE			2
#define SV_DRAGON_WHITE			3
#define SV_DRAGON_RED			4
#define SV_DRAGON_GREEN			5
#define SV_DRAGON_MULTIHUED		6
#define SV_DRAGON_PSEUDO		8
#define SV_DRAGON_SHINING		10
#define SV_DRAGON_LAW			12
#define SV_DRAGON_BRONZE		14
#define SV_DRAGON_GOLD			16
#define SV_DRAGON_CHAOS			18
#define SV_DRAGON_BALANCE		20
#define SV_DRAGON_POWER			30
#define SV_DRAGON_DEATH			40
#define SV_DRAGON_CRYSTAL		41
#define SV_DRAGON_DRACOLICH		42
#define SV_DRAGON_DRACOLISK		43
#define SV_DRAGON_SKY			44
#define SV_DRAGON_SILVER		45

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH			0
#define SV_LITE_LANTERN			1
#define SV_LITE_TORCH_EVER		2
#define SV_LITE_DWARVEN			3
#define SV_LITE_FEANORIAN		4
#define SV_LITE_GALADRIEL		100
#define SV_LITE_ELENDIL			101
#define SV_LITE_THRAIN			102
#define SV_LITE_UNDEATH			103
#define SV_LITE_PALANTIR		104
#define SV_ANCHOR_SPACETIME		105
#define SV_STONE_LORE			106
#define SV_LITE_PALANTIR_ITHIL		107


/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM			0
#define SV_AMULET_TELEPORT		1
#define SV_AMULET_ADORNMENT		2
#define SV_AMULET_SLOW_DIGEST		3
#define SV_AMULET_RESIST_ACID		4
#define SV_AMULET_SEARCHING		5
#define SV_AMULET_BRILLIANCE		6
#define SV_AMULET_CHARISMA		7
#define SV_AMULET_THE_MAGI		8
#define SV_AMULET_REFLECTION		9
#define SV_AMULET_CARLAMMAS		10
#define SV_AMULET_INGWE			11
#define SV_AMULET_DWARVES		12
#define SV_AMULET_NO_MAGIC		13
#define SV_AMULET_NO_TELE		14
#define SV_AMULET_RESISTANCE		15
#define SV_AMULET_NOTHING		16
#define SV_AMULET_SERPENT		17
#define SV_AMULET_TORIS_MEJISTOS	18
#define SV_AMULET_ELESSAR		19
#define SV_AMULET_EVENSTAR		20
#define SV_AMULET_SUSTENANCE		21
#define SV_AMULET_ESP			22
#define SV_AMULET_TRICKERY		23
#define SV_AMULET_WEAPONMASTERY		24
#define SV_AMULET_DEVOTION		25
#define SV_AMULET_INFRA			26
#define SV_AMULET_REGENERATION		27
#define SV_AMULET_WISDOM		28
#define SV_AMULET_RESIST_ELEC		29
#define SV_AMULET_TERKEN		30
#define SV_AMULET_SPEED			31
#define SV_AMULET_HIGHLANDS		32	/* for highlander games */
#define SV_AMULET_THE_MOON		33
#define SV_AMULET_RAGE			34
#define SV_AMULET_LIFE_SAVING		35
#define SV_AMULET_MANA_CHARGING		36
#define SV_AMULET_INVINCIBILITY		37	/* for admins */
#define SV_AMULET_GROM			38
#define SV_AMULET_LUCK			39	/* Talisman */
#define SV_AMULET_SSHARD		40	/* Spirit Shard (artifact) */
#define SV_AMULET_INVULNERABILITY	41	/* for admins */
#define SV_AMULET_HIGHLANDS2		42	/* for highlander games, with ESP */
#define SV_AMULET_IMMORTALITY		43	/* for admins */

/* The sval codes for TV_RING */
#define SV_RING_WOE			0
#define SV_RING_AGGRAVATION		1
#define SV_RING_WEAKNESS		2
#define SV_RING_STUPIDITY		3
#define SV_RING_TELEPORTATION		4
#define SV_RING_SPECIAL			5
#define SV_RING_SLOW_DIGESTION		6
#define SV_RING_FEATHER_FALL		7
#define SV_RING_RESIST_FIRE		8
#define SV_RING_RESIST_COLD		9
#if 0
 #define SV_RING_SUSTAIN_MIGHT		10
 #define SV_RING_SUSTAIN_BRILLIANCE	11
 #define SV_RING_SUSTAIN_ABILITY	12
 #define SV_RING_SUSTAIN_READYWIT	13
 #define SV_RING_SUSTAIN_STEADINESS	14
 #define SV_RING_SUSTAIN_CUNNINGNESS	15
#else
 #define SV_RING_STEADINESS		10
 #define SV_RING_TENACITY		11
 #define SV_RING_PREPAREDNESS		12
 #define SV_RING_GALLANTRY		13
#endif
#define SV_RING_PROTECTION		16
#define SV_RING_ACID			17
#define SV_RING_FLAMES			18
#define SV_RING_ICE			19
#define SV_RING_RESIST_POIS		20
#define SV_RING_FREE_ACTION		21
#define SV_RING_SEE_INVIS		22
#define SV_RING_SEARCHING		23
#define SV_RING_MIGHT			24
#define SV_RING_READYWIT		25
#define SV_RING_TOUGHNESS		26
#define SV_RING_CUNNINGNESS		27
#define SV_RING_ACCURACY		28
#define SV_RING_DAMAGE			29
#define SV_RING_SLAYING			30
#define SV_RING_SPEED			31
#define SV_RING_BARAHIR			32
#define SV_RING_TULKAS			33
#define SV_RING_NARYA			34
#define SV_RING_NENYA			35
#define SV_RING_VILYA			36
#define SV_RING_POWER			37
#define SV_RING_RES_FEAR		38
#define SV_RING_RES_LD			39
#define SV_RING_RES_NETHER		40
#define SV_RING_RES_NEXUS		41
#define SV_RING_RES_SOUND		42
#define SV_RING_RES_CONFUSION		43
#define SV_RING_RES_SHARDS		44
#define SV_RING_RES_DISENCHANT		45
#define SV_RING_RES_CHAOS		46
#define SV_RING_RES_BLINDNESS		47
#define SV_RING_LORDLY			48
#define SV_RING_ATTACKS			49
#define SV_RING_NOTHING			50
#define SV_RING_PRECONITION		51
#define SV_RING_FLAR			52
#define SV_RING_INVIS			53
#define SV_RING_LEVITATION		54
#define SV_RING_WRAITH			55
#define SV_RING_ELEC			56
#define SV_RING_DURIN			57
#define SV_RING_CRIT			58
//hole
#define SV_RING_POLYMORPH		60
#define SV_RING_STEALTH			61


/* The "sval" codes for TV_STAFF */
#define SV_STAFF_DARKNESS		0
#define SV_STAFF_SLOWNESS		1
#define SV_STAFF_HASTE_MONSTERS		2
#define SV_STAFF_SUMMONING		3
#define SV_STAFF_TELEPORTATION		4
#define SV_STAFF_IDENTIFY		5
#define SV_STAFF_REMOVE_CURSE		6
#define SV_STAFF_STARLITE		7
#define SV_STAFF_LITE			8
#define SV_STAFF_MAPPING		9
#define SV_STAFF_DETECT_GOLD		10
#define SV_STAFF_DETECT_ITEM		11
#define SV_STAFF_DETECT_TRAP		12
#define SV_STAFF_DETECT_DOOR		13
#define SV_STAFF_DETECT_INVIS		14
#define SV_STAFF_DETECT_EVIL		15
#define SV_STAFF_CURE_SERIOUS		16
#define SV_STAFF_CURING			17
#define SV_STAFF_HEALING		18
#define SV_STAFF_THE_MAGI		19
#define SV_STAFF_SLEEP_MONSTERS		20
#define SV_STAFF_SLOW_MONSTERS		21
#define SV_STAFF_SPEED			22
#define SV_STAFF_PROBING		23
#define SV_STAFF_DISPEL_EVIL		24
#define SV_STAFF_POWER			25
#define SV_STAFF_HOLINESS		26
#define SV_STAFF_GENOCIDE		27
#define SV_STAFF_EARTHQUAKES		28
#define SV_STAFF_DESTRUCTION		29
#define SV_STAFF_NOTHING		30
#define SV_STAFF_WISHING		31
#define SV_STAFF_GANDALF		32	/* sorta hack? (tval=6) */
#define SV_STAFF_STAR_IDENTIFY		33

/* jk - the first valuable staff */
#define SV_STAFF_NASTY_STAFF		4

/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_MONSTER		0
#define SV_WAND_HASTE_MONSTER		1
#define SV_WAND_CLONE_MONSTER		2
#define SV_WAND_TELEPORT_AWAY		3
#define SV_WAND_DISARMING		4
#define SV_WAND_TRAP_DOOR_DEST		5
#define SV_WAND_STONE_TO_MUD		6
#define SV_WAND_LITE			7
#define SV_WAND_SLEEP_MONSTER		8
#define SV_WAND_SLOW_MONSTER		9
#define SV_WAND_CONFUSE_MONSTER		10
#define SV_WAND_FEAR_MONSTER		11
#define SV_WAND_DRAIN_LIFE		12
#define SV_WAND_POLYMORPH		13
#define SV_WAND_STINKING_CLOUD		14
#define SV_WAND_MAGIC_MISSILE		15
#define SV_WAND_ACID_BOLT		16
#define SV_WAND_CHARM_MONSTER		17
#define SV_WAND_FIRE_BOLT		18
#define SV_WAND_COLD_BOLT		19
#define SV_WAND_ACID_BALL		20
#define SV_WAND_ELEC_BALL		21
#define SV_WAND_FIRE_BALL		22
#define SV_WAND_COLD_BALL		23
#define SV_WAND_WONDER			24
#define SV_WAND_ANNIHILATION		25
#define SV_WAND_DRAGON_FIRE		26
#define SV_WAND_DRAGON_COLD		27
#define SV_WAND_DRAGON_BREATH		28
#define SV_WAND_ROCKETS			29
#define SV_WAND_NOTHING			30
#define SV_WAND_WALL_CREATION		31
#define SV_WAND_THRAIN			32
/* ToME-NET additions(?) */
#define SV_WAND_ELEC_BOLT		33
#define SV_WAND_TELEPORT_TO		34

/* jk - the first valuable wand */
#define SV_WAND_NASTY_WAND		3

/* The "sval" codes for TV_ROD(Rod Tips) */
#define SV_ROD_NOTHING			0
#define SV_ROD_DETECT_DOOR		1
#define SV_ROD_IDENTIFY			2
#define SV_ROD_RECALL			3
#define SV_ROD_ILLUMINATION		4
#define SV_ROD_MAPPING			5
#define SV_ROD_DETECTION		6
#define SV_ROD_PROBING			7
#define SV_ROD_CURING			8
#define SV_ROD_HEALING			9
#define SV_ROD_RESTORATION		10
#define SV_ROD_SPEED			11
/* xxx (aimed) */
#define SV_ROD_TELEPORT_AWAY		13
#define SV_ROD_DISARMING		14
#define SV_ROD_LITE			15
#define SV_ROD_SLEEP_MONSTER		16
#define SV_ROD_SLOW_MONSTER		17
#define SV_ROD_DRAIN_LIFE		18
#define SV_ROD_POLYMORPH		19
#define SV_ROD_ACID_BOLT		20
#define SV_ROD_ELEC_BOLT		21
#define SV_ROD_FIRE_BOLT		22
#define SV_ROD_COLD_BOLT		23
#define SV_ROD_ACID_BALL		24
#define SV_ROD_ELEC_BALL		25
#define SV_ROD_FIRE_BALL		26
#define SV_ROD_COLD_BALL		27
#define SV_ROD_HAVOC			28
#define SV_ROD_DETECT_TRAP		29
#define SV_ROD_HOME			30


/* The "sval" codes for TV_ROD_MAIN(Rods) */
/* Note that the sval is the max mana capacity of the rod */

#define SV_ROD_WOODEN		10
#define SV_ROD_COPPER		20
#define SV_ROD_IRON		50
#define SV_ROD_ALUMINIUM	75
#define SV_ROD_SILVER		100
#define SV_ROD_GOLDEN		125
#define SV_ROD_MITHRIL		160
#define SV_ROD_ADMANTITE	200


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS		0
#define SV_SCROLL_AGGRAVATE_MONSTER	1
#define SV_SCROLL_CURSE_ARMOR		2
#define SV_SCROLL_CURSE_WEAPON		3
#define SV_SCROLL_SUMMON_MONSTER	4
#define SV_SCROLL_SUMMON_UNDEAD		5
#define SV_SCROLL_SUMMON_MINE		6
#define SV_SCROLL_TRAP_CREATION		7
#define SV_SCROLL_PHASE_DOOR		8
#define SV_SCROLL_TELEPORT		9
#define SV_SCROLL_TELEPORT_LEVEL	10
#define SV_SCROLL_WORD_OF_RECALL	11
#define SV_SCROLL_IDENTIFY		12
#define SV_SCROLL_STAR_IDENTIFY		13
#define SV_SCROLL_REMOVE_CURSE		14
#define SV_SCROLL_STAR_REMOVE_CURSE	15
#define SV_SCROLL_ENCHANT_ARMOR		16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT	17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM	18
#define SV_SCROLL_ENCHANT_WEAPON_PVAL	19
#define SV_SCROLL_STAR_ENCHANT_ARMOR	20
#define SV_SCROLL_STAR_ENCHANT_WEAPON	21
#define SV_SCROLL_RECHARGING		22
#define SV_SCROLL_RESET_RECALL		23
#define SV_SCROLL_LIGHT			24
#define SV_SCROLL_MAPPING		25
#define SV_SCROLL_DETECT_GOLD		26
#define SV_SCROLL_DETECT_ITEM		27
#define SV_SCROLL_DETECT_TRAP		28
#define SV_SCROLL_DETECT_DOOR		29
#define SV_SCROLL_DETECT_INVIS		30
#define SV_SCROLL_DIVINATION		31
#define SV_SCROLL_SATISFY_HUNGER	32
#define SV_SCROLL_BLESSING		33
#define SV_SCROLL_HOLY_CHANT		34
#define SV_SCROLL_HOLY_PRAYER		35
#define SV_SCROLL_MONSTER_CONFUSION	36
#define SV_SCROLL_PROTECTION_FROM_EVIL	37
#define SV_SCROLL_RUNE_OF_PROTECTION	38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION	39
#define SV_SCROLL_DEINCARNATION		40
#define SV_SCROLL_STAR_DESTRUCTION	41
#define SV_SCROLL_DISPEL_UNDEAD		42
#define SV_SCROLL_MASS_RESURECTION	43
#define SV_SCROLL_GENOCIDE		44
#define SV_SCROLL_OBLITERATION		45
#define SV_SCROLL_ACQUIREMENT		46
#define SV_SCROLL_STAR_ACQUIREMENT	47
#define SV_SCROLL_FIRE			48
#define SV_SCROLL_ICE			49
#define SV_SCROLL_CHAOS			50
#define SV_SCROLL_RUMOR			51
/* #define SV_SCROLL_ARTIFACT		52 */
#define SV_SCROLL_ARTIFACT_CREATION	52
#define SV_SCROLL_NOTHING		53
#define SV_SCROLL_SPELL			54
/* ToME-NET additions */
#define SV_SCROLL_GOLEM			55
#define SV_SCROLL_LIFE			56
#define SV_SCROLL_HOUSE			57
#define SV_SCROLL_BLOOD_BOND		58
#define SV_SCROLL_LOTTERY		59
#define SV_SCROLL_ID_ALL		60
#define SV_SCROLL_VERMIN_CONTROL	61
#define SV_SCROLL_CANCELLATION		62
#define SV_SCROLL_WILDERNESS_MAP	63
/* more stuff - C. Blue */
#define SV_SCROLL_CONJURE_MONSTER	64
#define SV_SCROLL_SLEEPING		65
/* DEG Stuff to make game more party friendly */
#define SV_SCROLL_TELEPORT_TO_PARTY	66
#define SV_SCROLL_STAR_TELEPORT_TO_PARTY	67
#define SV_SCROLL_PARTY_RECALL		68
#define SV_SCROLL_EMERGENCY_RECALL	69
#define SV_SCROLL_EMERGENCY_PARTY_RECALL	70
#define SV_SCROLL_CHEQUE		71 /* for player houses; read to redeem, easily. */
#define SV_SCROLL_FIREWORK		72 /* new years eve */


/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER			0
#define SV_POTION_APPLE_JUICE		1
#define SV_POTION_SLIME_MOLD		2
#define SV_POTION_BLOOD			3
#define SV_POTION_SALT_WATER		5
#define SV_POTION_POISON		6
#define SV_POTION_BLINDNESS		7
#define SV_POTION_INVIS			8
#define SV_POTION_CONFUSION		9
#define SV_POTION_SLOWNESS		10
//#define SV_POTION_MUTATION		10
/* used for EXPAND_TV_POTION		10 */
#define SV_POTION_SLEEP			11
//#define SV_POTION_LEARNING		40 /* not used. see SV_POTION2_LEARNING instead */
/* used for EXPAND_TV_POTION		12 */
#define SV_POTION_LOSE_MEMORIES		12
/* xxx -- used for EXPAND_TV_POTION	14 */
#define SV_POTION_RUINATION		13
#define SV_POTION_DEC_STR		14
#define SV_POTION_DEC_INT		15
#define SV_POTION_DEC_WIS		16
#define SV_POTION_DEC_DEX		17
#define SV_POTION_DEC_CON		18
#define SV_POTION_DEC_CHR		19
#define SV_POTION_DETONATIONS		20
#define SV_POTION_DEATH			21
#define SV_POTION_STAR_RESTORE_MANA	22
#define SV_POTION_RESTORE_MANA		23
#define SV_POTION_INFRAVISION		24
#define SV_POTION_DETECT_INVIS		25
#define SV_POTION_SLOW_POISON		26
#define SV_POTION_CURE_POISON		27
#define SV_POTION_BOLDNESS		28
#define SV_POTION_SPEED			29
#define SV_POTION_RESIST_HEAT		30
#define SV_POTION_RESIST_COLD		31
#define SV_POTION_HEROISM		32
#define SV_POTION_BERSERK_STRENGTH	33
#define SV_POTION_CURE_LIGHT		34
#define SV_POTION_CURE_SERIOUS		35
#define SV_POTION_CURE_CRITICAL		36
#define SV_POTION_STAR_HEALING		37
#define SV_POTION_HEALING		38
#define SV_POTION_LIFE			39
#define SV_POTION_RESTORE_EXP		41
#define SV_POTION_RES_STR		42
#define SV_POTION_RES_INT		43
#define SV_POTION_RES_WIS		44
#define SV_POTION_RES_DEX		45
#define SV_POTION_RES_CON		46
#define SV_POTION_RES_CHR		47
#define SV_POTION_INC_STR		48
#define SV_POTION_INC_INT		49
#define SV_POTION_INC_WIS		50
#define SV_POTION_INC_DEX		51
#define SV_POTION_INC_CON		52
#define SV_POTION_INC_CHR		53
/* xxx -- used for EXPAND_TV_POTION	54 */
#define SV_POTION_INVULNERABILITY	54
#define SV_POTION_AUGMENTATION		55
#define SV_POTION_ENLIGHTENMENT		56
#define SV_POTION_STAR_ENLIGHTENMENT	57
#define SV_POTION_SELF_KNOWLEDGE	58
#define SV_POTION_EXPERIENCE		59
#define SV_POTION_RESISTANCE		60
#define SV_POTION_CURING		61
/*disabled: #define SV_POTION_NEW_LIFE	63
  used for EXPAND_TV_POTION		63 */

#ifndef EXPAND_TV_POTION
 #define SV_POTION_LAST			64	/* used for handling fountains */
#else
 #define SV_POTION_LAST			65	/* used for handling fountains */
#endif

/* for EXPAND_TV_POTION, always defined for conversion in load2.c: */
#define SV_POTION_CHAUVE_SOURIS		4
#define SV_POTION_LEARNING		40
#define SV_POTION_CURE_LIGHT_SANITY	62
#define SV_POTION_CURE_SERIOUS_SANITY	63
#define SV_POTION_CURE_CRITICAL_SANITY	64
#define SV_POTION_CURE_SANITY		65


/*
 * NOTE: due to hard-coded flavor code, adding SV_POTION is bad idea.
 * Add it to SV_POTION2 instead.
 * (flavor variator is under construction.)		- Jir -
 */

/* The "sval" codes for TV_POTION2 */
#define SV_POTION2_MIMIC_ABOMINATION	1
#define SV_POTION2_MIMIC_WOLF		2
#define SV_POTION2_MIMIC_APE		3
#define SV_POTION2_MIMIC_GOAT		4
#define SV_POTION2_MIMIC_INSECT		5
#define SV_POTION2_MIMIC_SPARROW	6
#define SV_POTION2_MIMIC_STATUE		7
#define SV_POTION2_MIMIC_VAMPIRE	8
#define SV_POTION2_MIMIC_SPIDER		9
#define SV_POTION2_MIMIC_MANA_BALL	10
#define SV_POTION2_MIMIC_FIRE_CLOUD	11
#define SV_POTION2_MIMIC_COLD_CLOUD	12
#define SV_POTION2_MIMIC_CHAOS_CLOUD	13
#define SV_POTION2_CURE_LIGHT_SANITY	14
#define SV_POTION2_CURE_SERIOUS_SANITY	15
#define SV_POTION2_CURE_CRITICAL_SANITY	16
#define SV_POTION2_CURE_SANITY		17
#define SV_POTION2_CURE_WATER		18

#define SV_POTION2_CHAUVE_SOURIS	19
#define SV_POTION2_LEARNING		20

#define SV_POTION2_AMBER		21	/* artifact potion */

#ifndef EXPAND_TV_POTION
 #define SV_POTION2_LAST		21
#else
 #define SV_POTION2_LAST		0
#endif

/* sval for TV_FLASK */
/* note: there is only 1 flask, ie flask of oil.
   this might be assumed in lots of places in the code.*/
#define SV_FLASK_OIL			0
#ifdef ENABLE_DEMOLITIONIST
 #define SV_FLASK_ACID			1
#endif

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_UNMAGIC			0
#define SV_FOOD_BLINDNESS		1
#define SV_FOOD_PARANOIA		2
#define SV_FOOD_CONFUSION		3
#define SV_FOOD_HALLUCINATION		4
#define SV_FOOD_PARALYSIS		5
#define SV_FOOD_WEAKNESS		6
#define SV_FOOD_SICKNESS		7
#define SV_FOOD_STUPIDITY		8
#define SV_FOOD_NAIVETY			9
#define SV_FOOD_UNHEALTH		10
#define SV_FOOD_DISEASE			11
#define SV_FOOD_CURE_POISON		12
#define SV_FOOD_CURE_BLINDNESS		13
#define SV_FOOD_CURE_PARANOIA		14
#define SV_FOOD_CURE_CONFUSION		15
#define SV_FOOD_CURE_SERIOUS		16
#define SV_FOOD_RESTORE_STR		17
#define SV_FOOD_RESTORE_CON		18
#define SV_FOOD_RESTORING		19
#define SV_FOOD_POISON			20
#define SV_FOOD_REGEN			21
#define SV_FOOD_MUSHROOMS_MAX		99 /* marker where mushroom svals end */
/* many missing mushrooms */
/* mangband-oriented wilderness crops */
#define	SV_FOOD_POTATO			100
#define SV_FOOD_HEAD_OF_CABBAGE		101
#define SV_FOOD_CARROT			102
#define SV_FOOD_BEET			103
#define	SV_FOOD_SQUASH			104
#define	SV_FOOD_EAR_OF_CORN		105
#define SV_FOOD_RAW_MAX			199 /* unused - marker where raw ingredient svals end, that could be cooked ^^- */
/* normal foods again */
#define SV_FOOD_BISCUIT			202
#define SV_FOOD_JERKY			203
#define SV_FOOD_RATION			205
#define SV_FOOD_SLIME_MOLD		206
#define SV_FOOD_WAYBREAD		207
#define SV_FOOD_PINT_OF_ALE		208
#define SV_FOOD_PINT_OF_WINE		209
#define SV_FOOD_ATHELAS			210
#define SV_FOOD_GREAT_HEALTH		211	/* annuled for now */
#define SV_FOOD_FORTUNE_COOKIE		212
#define SV_FOOD_KHAZAD			213

/* The "sval" codes for TV_BATERIE */
#define SV_BATERIE_POISON		1
#define SV_BATERIE_EXPLOSION		2
#define SV_BATERIE_TELEPORT		3
#define SV_BATERIE_COLD			4
#define SV_BATERIE_FIRE			5
#define SV_BATERIE_ACID			6
#define SV_BATERIE_LIFE			7
#define SV_BATERIE_CONFUSION		8
#define SV_BATERIE_LITE			9
#define SV_BATERIE_CHAOS		10
#define SV_BATERIE_TIME			11
#define SV_BATERIE_MAGIC		12
#define SV_BATERIE_XTRA_LIFE		13
#define SV_BATERIE_DARKNESS		14
#define SV_BATERIE_KNOWLEDGE		15
#define SV_BATERIE_FORCE		16
#define SV_BATERIE_LIGHTNING		17
#define SV_BATERIE_MANA			18

/* The "sval" codes for TV_CORPSE */
#define SV_CORPSE_CORPSE		1
#define SV_CORPSE_SKELETON		2
#define SV_CORPSE_HEAD			3
#define SV_CORPSE_SKULL			4
#define SV_CORPSE_MEAT			5

/* The "sval" codes for TV_PARCHMENT */
	/* Basic informational parchments */
#define SV_PARCHMENT_NEWBIE		50
#define SV_PARCHMENT_DEATH		51
#define SV_PARCHMENT_NEWS		52

	/* Deeds, given as a reward for certain events */
#define SV_DEED_HIGHLANDER		60 /* for winner */
#define SV_DEED2_HIGHLANDER		61 /* for participant */
#define SV_DEED_PVP_MAX			62 /* reaching top level in pvp mode */
#define SV_DEED_PVP_MID			63 /* reaching top level in pvp mode */
#define SV_DEED_PVP_MASS		64 /* killing a lot of opponents in pvp mode */
#define SV_DEED_PVP_START		65 /* birth item for pvp mode chars */
#define SV_DEED_DUNGEONKEEPER		66 /* for winner */
#define SV_DEED2_DUNGEONKEEPER		67 /* for participant */

	/* Inheritances given as consolidation for deaths of high chars */
#define SV_INHERIT_KNOW			70	/* flavour knowledge */
#define SV_INHERIT_ATTR			71	/* boost/max 1+ attribute(s) */
#define SV_INHERIT_GOLD			72	/* just gold */
#define SV_INHERIT_ITEM			73	/* like highlander reward */
#define SV_INHERIT_ART			74	/* artifact creation */

/* for TV_BOOK */
/* 0..49 are school tomes */
#define SV_TOME_CHAOS			24
#define SV_BOOK_COMBO			50 /* 50..99 are handbooks, 50 is beginner cantrips */
#define SV_SPELLBOOK			255
#define SV_CUSTOM_TOME_1		100 /* player-made personalized tomes */
#define SV_CUSTOM_TOME_2		101
#define SV_CUSTOM_TOME_3		102

#define is_custom_tome(sval)	((sval) >= SV_CUSTOM_TOME_1 && (sval) <= SV_CUSTOM_TOME_3)

/* For precious stones (TV_PRECIOUS_STONE) */
/* order is from least rare to most rare (thanks, http://magmawiki.com/index.php/40d:Gem and some creative writing) */
#define PRECIOUS_STONE_MAX_TIER1_START	1
#define PRECIOUS_STONE_MAX_TIER1_END	3

#define PRECIOUS_STONE_MAX_TIER2_START	11
#define PRECIOUS_STONE_MAX_TIER2_END	18

#define PRECIOUS_STONE_MAX_TIER3_START	21
#define PRECIOUS_STONE_MAX_TIER3_END	28

#define PRECIOUS_STONE_MAX_TIER4_START	31
#define PRECIOUS_STONE_MAX_TIER4_END	32

/* "cheap" tier; keep this to a minimum since we dont want lowbies to run around with too many stones */
#define SV_PRECIOUS_STONE_JADE		1
#define SV_PRECIOUS_STONE_CARNELIAN	2
#define SV_PRECIOUS_STONE_OPAL		3

/* "medium" tier */
#define SV_PRECIOUS_STONE_MELANITE	11
#define SV_PRECIOUS_STONE_TOURMALINE	12
#define SV_PRECIOUS_STONE_AMETHYST	13
#define SV_PRECIOUS_STONE_AQUAMARINE	14
#define SV_PRECIOUS_STONE_MOONSTONE	15
#define SV_PRECIOUS_STONE_CHRYSOBERYL	16
#define SV_PRECIOUS_STONE_TOPAZ		17
#define SV_PRECIOUS_STONE_CATS_EYE	18

/* "rare" tier */
#define SV_PRECIOUS_STONE_RUBY			21
#define SV_PRECIOUS_STONE_STAR_SAPPHIRE		22
#define SV_PRECIOUS_STONE_INDIGO_TOURMALINE	23
#define SV_PRECIOUS_STONE_FAINT_YELLOW_DIAMOND	24
#define SV_PRECIOUS_STONE_DIAMOND		25
#define SV_PRECIOUS_STONE_BLACK_DIAMOND		26
#define SV_PRECIOUS_STONE_YELLOW_DIAMOND	27
#define SV_PRECIOUS_STOE_TSAVORITE		28

/* "unobtainium" tier (Thanks, Andur) */
#define SV_PRECIOUS_STONE_QUASAR	31
#define SV_PRECIOUS_STONE_ZUONIUM	32

/* sub-section of "unobtainium": specific mobs drop this. take out of the group */
#define SV_PRECIOUS_STONE_DORS_EYE	41 // Dor's Eye... Guess where it's going to be dropped by?

/* Extend 'Digging' skill to become more like an 'Excavation' skill, adding craftable demolition charges
   that can also be applied to ranged ammunition or traps for various effects  - C. Blue */
#ifdef ENABLE_DEMOLITIONIST
/* Notes about ingredients regarding the crafting process (anyone read the Dr Stone manga?) -
   charcoal: burn trees :D, saltpeter (bird guano, dung / chile saltpetre from arid regions esp desert! sandwalls!), sulfur (volcanic and undersea, mining!, red d/D),
   ammonia (alternative to metal-saltpeter): heat animal dung (camels^^') - maybe even extract from poison/gas breath? oO far stretch yeah,
    maybe just make it already 'ammonia salt' straight away aka Gwihabaite (ammonia-saltpeter, ready for use as saltpeter alternative),
    we can consider it to be more porous and combinable with lamp oil, just those two are fit for industrial mining operations already! (94%-6% ANFO style):
     less potent and not waterproof but easier to use/cheaper,
   metal powder: specifically aluminium, but maybe too rare,
   (metal)hydroxides(*): salt water + rust(!) (not exactly, and unfeasible metal types, but w/e) -> 'caustic metal ash',
   metalperoxide: metaloxides (or ammonia) + hydroxides(*) (soooorta...again, so it'll just be MORE saltwater with rust, lul) -> 'potent caustic metal ash' (not feasible in medieval context),
   perchlorates: acid (let's just assume it's hydrochloric acid by chance -_-) + aluminium (we dont have magnesium..) or kalium (from saltpeter maybe?) -> 'caustic salt' (not feasible in medieval context)
   ^ acid: sulfur+saltpeter with steam and heat, so +water+lampoil =p, or:
   ^ vitriol (works as acid replacement - when creating perchlorate too? as metal is not a liquid? ah w/e just allow..): mining (volcanic)/dragons.
   ..rust: metal powder + (salt) water. Or use some kind of 'grinding tool' on rusty armour or on normal metal items to obtain (not 'reactive' though) metal powder first.
    */
/* Optionally enable simplifications of ingredients and formulas: */
 #define NO_RUST_NO_HYDROXIDE		/* Note: Rusty items can still be ground and will just turn into normal metal powder instead, assuming the item was only partially rusted ^^. */
 #ifdef NO_RUST_NO_HYDROXIDE
  #define CHEMICALS_NUM 9
 #else
  #define CHEMICALS_NUM 11
 #endif
 #define NO_OIL_ACID			/* We don't need lamp oil to create acid, as heating is implied by our fire-type light souce (which is needed though!) */
/* TV_CHARGE svals */
 #define SV_CHARGE_BLAST		1	/* Charges can be thrown for immediate detonation or activated to detonate after a few seconds or put into trap kits? */
 #define SV_CHARGE_XBLAST		2
 #define SV_CHARGE_SBLAST		3	/* Surgically creates a line of floor (anti-wallcreation) */
 #define SV_CHARGE_QUAKE		4
 #define SV_CHARGE_DESTRUCTION		5
 #define SV_CHARGE_FIRE			6
 #define SV_CHARGE_FIRESTORM		7
 #define SV_CHARGE_FIREWALL		8	/* inscribe N/NE/E/SE/S/SW/W/NW for direction? */
 #define SV_CHARGE_WRECKING		9	/* create rubble */
 #define SV_CHARGE_CASCADING		10	/* wall creation; inscribe for dir? */
 #define SV_CHARGE_TACTICAL		11	/* stone prison */
 #define SV_CHARGE_FLASHBOMB		12	/* blind effect */
 #define SV_CHARGE_CONCUSSION		13	/* extra stun effect */
 #define SV_CHARGE_XCONCUSSION		14	/* extra STUN effect */
 #define SV_CHARGE_UNDERGROUND		15	/* create water/lava (blast open a hidden underground vein) */
/* TV_CHEMICAL svals (11 ingredients, 9 with NO_RUST_NO_HYDROXIDE enabled) */
 #define SV_CHARCOAL		1	/* small amount, your basic fuel ingredient to burn shits (>' ')> */
 #define SV_SULFUR		2	/* small amount, easens combustion */
 #define SV_SALTPETRE		3	/* large amount, oxygen source boosting combustion speed */
 #define SV_AMMONIA_SALT	4	/* alternative to saltpetre, provides option: just lamp oil as 2nd ingredient! (huge amount salt, tiny amount oil) */
 #define SV_METAL_POWDER	5	/* for flashy effects *_* */
 #define SV_METAL_HYDROXIDE	6	/* [optional] additional tier I oxygen source - make shit more potent */
 #define SV_METAL_PEROXIDE	7	/* additional tier II oxygen source - make shit MORE potent */
 #define SV_METAL_PERCHLORATE	8	/* additional tier III oxygen source - make shit *MORE* potent */
 #define SV_VITRIOL		9	/* (sulphates) alternative for flask of acid */
 #define SV_RUST		10	/* [optional] metaloxide.. we limit it to iron I guess.. */
 #define SV_WOOD_CHIPS		11
 #define SV_MIXTURE		99	/* Mixture of the above ingredients. Uses xtra1/2/3 to bitwise store the ingredients that went into it so far, the 3 variables indicating the amounts of each bit, eg 2xsalpeter+1x... */
/* Helper indices for ingredients -- IMPORTANT: For ingredients in TV_CHEMICAL these must match the sval up to 10! */
 #define CI_CC	1
 #define CI_SU	2
 #define CI_SP	3
 #define CI_AS	4
 #define CI_MP	5
 #define CI_MH	6
 #define CI_ME	7
 #define CI_MC	8
 #define CI_VI	9
 #define CI_RU	10
 #define CI_LO	11
 #define CI_WA	12
 #define CI_SW	13
 #define CI_AC	14
/* Helper flags for the ingredient svals -- IMPORTANT: the CI_ values must match the flag leftshift to get the CF_! Eg: ammonia = 1 << (CI_AS - 1) = CF_AS */
 #define CF_CC		0x0001
 #define CF_SU		0x0002
 #define CF_SP		0x0004
 #define CF_AS		0x0008
 #define CF_MP		0x0010
 #define CF_MH		0x0020
 #define CF_ME		0x0040
 #define CF_MC		0x0080
 #define CF_VI		0x0100
 #define CF_RU		0x0200
 #define CF_LO		0x0400
 #define CF_WA		0x0800
 #define CF_SW		0x1000
 #define CF_AC		0x2000
#endif


#ifdef ENABLE_SUBINVEN
 /* Starter inventory index that stands for "inside subinventory" and gets multiplied by the subinventory's inventory index.
    Only condition: It must be >= INVEN_TOTAL, so it can fully encode it. [100] */
 #define SUBINVEN_INVEN_MUL 100
 /* Unify inventory colour of subinventories. If not defined, they will have different colours depending on their group type. */
 #define SUBINVEN_UNIFIED_COLOUR
 /* Allow chests to be used as storage containers after having opened them once? */
 #define SUBINVEN_CHESTS
 /* Allow only one of each subinven group type per player?
    Ie 1 Alchemy Satchel + 1 Chest (all chests belong into the same 'group' together, the 'chests' group), etc.. */
 #define SUBINVEN_LIMIT_GROUP
 /* Max space inside any single sub-inventory (pendant to INVEN_TOTAL).
    Subinventories currently don't feature an 'overflow' slot unlike normal inventories.
    We currently have 9 (11 with rust+hydroxide) chemicals (the reason of implementing subinventories actually). */
 #define SUBINVEN_PACK INVEN_PACK

 /* -- Sizes of different subinven types -- We use k_info pval -> object bpval for specifying the size, in k_info. -- */
  /* SV_SI_SATCHEL: */
 /* NO_RUST_NO_HYDROXIDE? -> 9 vs 11 types of chemicals, of which 6 vs 7 are found almost-directly, and 7 vs 8..9 are trivially crafted. Currently satchels can hold mixtures too. */
#endif

/* svals for TV_SUBINVEN */
#define SV_SI_SATCHEL			0	/* Stores DEMOLITIONIST ingredients */
#define SV_SI_TRAPKIT_BAG		1
#define SV_SI_MDEVP_WRAPPING		2
#define SV_SI_POTION_BELT		3
#define SV_SI_CHEST_CONVERSION		100	/* marker for converting looted chests to subinven-chests. Chests should be the last items in the inventory sorting order, so items get stowed into their specific bags first. */
#define SV_SI_CHEST_SMALL_WOODEN	101	/* TV_CHEST option: Convert tval on opening one successfully (ie not ruined) to TV_SUBINVEN */
#define SV_SI_CHEST_SMALL_IRON		102
#define SV_SI_CHEST_SMALL_STEEL		103
#define SV_SI_CHEST_MIN_LARGE		104	/* marker */
#define SV_SI_CHEST_LARGE_WOODEN	105
#define SV_SI_CHEST_LARGE_IRON		106
#define SV_SI_CHEST_LARGE_STEEL		107

/* Only allow one subinven from each type group per player?
   (We only define helper markers for those groups that have more than one member,
   so not for the alchemy satchel, but indeed for the different types of chests.) */
#define SV_SI_GROUP_CHEST_MIN		SV_SI_CHEST_SMALL_WOODEN	/* Define chest markers even outside of SUBINVEN_LIMIT_GROUP, as they are useful for store_will_buy() checks on TV_SUBINVEN. */
#define SV_SI_GROUP_CHEST_MAX		SV_SI_CHEST_LARGE_STEEL

/* svals for TV_SPECIAL */
#define SV_SEAL				0	/* for invalid items */
#define SV_CUSTOM_OBJECT		1	/* custom/fun/vanity objects, definable by admins via (user-read-only) inscription and xtraN flags: */
						/* xtra1 = ap,
						   xtra2 = cp,
						   xtra3 = commands/susceptibilities:
						    0x0001 eat, 0x0002 quaff, 0x0004 read, 0x0008 can rust (equip damage from water),
						    0x0010 activate-no-am, 0x0020 activate-am, 0x0040 activate-dir-no-am, 0x0080 activate-dir-am,
						    0x0100 wear/wield an specify a specific equipment slot:
						      tval2 = wear/wield slot. -- TODO: implement fully
						    0x0200 wear/wield faking another item, using fake tval/sval to determine equipment slot:
						      tval2 = fake tval, sval2 = fake sval. -- TODO: implement fully
						    0x0300 (mask), in both cases:
						     xtra6 = fake bpval [, xtra7 = fake name2, xtra8 = fake name2b, xtra9 = fake pval]. -- TODO: implement (fully)?
						    0x0400 hates impact, 0x0800 hates water, 0x1000 hates elec, 0x2000 hates cold, 0x4000 hates fire, 0x8000 hates acid;
						   xtra4 = handedness for wielding:
						    0x0001 COULD2H, 0x0002 SHOULD2H, 0x0004, MUST2H. -- TODO: implement
						   xtra5 = custom fake k-info diz via LUA custom_object_diz().
						   (xtra6/7/8/9 = reserved for xtra3 & 0x200, see above.) */
#define SV_QUEST			2	/* a custom quest item (not to be confused with questors) */
//SV_GIFT_WRAPPING_START..SV_GIFT_WRAPPING_END: 10..19 (used up to 15)	/* An item wrapped as a gift */


/*** General flag values ***/


/*
 * Special cave grid flags -- note that they must never all be set (0xFFFFFFFF) as that would collide with RLE!
 */
#define CAVE_MARK	0x00000001U	/* memorized feature */
#define CAVE_GLOW	0x00000002U	/* self-illuminating */
#define CAVE_ICKY	0x00000004U	/* part of a vault */
#define CAVE_ROOM	0x00000008U	/* part of a room */

#define CAVE_LITE	0x00000010U	/* lite flag  */
#define CAVE_VIEW	0x00000020U	/* view flag */
#define CAVE_TEMP	0x00000040U	/* temp flag */
#define CAVE_XTRA	0x00000080U	/* misc flag, used for temporary short-term operations just like CAVE_TEMP. Hance not feasible for actual storage of any info. */

/* Hack for p_ptr->cave_flag, which is only 1 byte in size: */
#define CAVE_AOVL	CAVE_TEMP	/* Mark grid if it displays an overlay visual that could get auto-updated, ie monsters: A monster can move away automatically, rendering the overlay out of date. */

/* -- note: p_ptr->cave_flag[] is only 1 byte in size, so it uses only the above flags. The rest are for c_ptr->info which is 4 bytes. -- */

#define CAVE_NOPK	0x00000100U	/* no pkill (arena?, tavern) */
#define CAVE_STCK	0x00000200U	/* sticky (no-tele vault), not icky (prison?) */
#define CAVE_DARKEN	0x00000400U	/* world surface at night - change colours to darker variants (NOTE: Not combined w/ any other flags1, yet not moved to flags2 as it is too close to CAVE_GLOW on day/night changes idea-wise!) */
#define CAVE_ICKY_PERMA	0x00000800U 	/* part of a perma-walled vault */

#define CAVE_PROT	0x00001000U	/* no monster spawn/teleport/summon/movement on; no players teleport/recall to; no item stacking; cannot drop true arts; no traps/charges; cannot steal; no sunburn */
#define CAVE_NEST_PIT	0x00002000U	/* grid is part of a monster nest and target for monster placement */
#define CAVE_NO_MONSTER	0x00004000U	/* protected from monster-spawn + cannot be monster teleport/summon/movement destination */
#define CAVE_NO_PROB	0x00008000U	/* Cannot enter this grid via Probability Travel (but can exit) */

#define CAVE_LITE_VAMP	0x00010000U	/* lite flag for RACE_VAMPIRE 'light' */
#define CAVE_LITE_WHITE	0x00020000U	/* lite flag for non-fiery light sources */
#define CAVE_WATERY	0x00040000U	/* For doors/stairs: Are they adjacent to water grids? (NOTE: Not combined w/ any other flags1, yet used in function that might be interested in NO_MONSTER etc flags from flags1, so kept here!) */
#define CAVE_JAIL	0x00080000U	/* part of a jail: for special colour/lighting of jail walls */

#define CAVE_LITE_TYPE_CHANGED	0x00100000U	/* Temp flag for lighting code: Required when when player with non-CAVE_LITE_WHITE light source crosses static CAVE_LITE_WHITE grids, or they won't be redrawn after re-receiving their CAVE_LITE_WHITE colour. - C. Blue */
#define CAVE_GLOW_HACK		0x00200000U	/* bad hack for hard-coded questor lights for now // self-illuminating */
#define CAVE_GLOW_HACK_LAMP	0x00400000U 	/* bad hack for hard-coded questor lights for now // self-illuminating, in fire-flickering style (TERM_LAMP) */
#define CAVE_WIDE_LITE		0x00800000U	/* Behaves regarding lighting as if it was always visible to the player (so a light shimmer can be seen from afar w/o LoS) */

#define CAVE_ENCASED		0x01000000U	/* For digging (FEAT_QUARTZ/MAGMA_x): Treasure veins that are pretty remotely encased in rock, requiring more effort than hallway/room-adjacent ez veins. */

/*
 * Special cave grid flags2 -- note that they must never all be set (0xFFFFFFFF) as that would collide with RLE!
 */
#define CAVE2_MAGELOCK	0x00000001U	/* Anti-exploit: Remember magelocked doors so they don't give exp repeatedly */
#define CAVE2_GUILD_SUS	0x00000002U	/* floor of a suspended guild hall, due to the guild's leaderlessnes */
#define CAVE2_NOYIELD	0x00000004U	/* Will not yield any items or treasure when tunneled */
#define CAVE2_MINED	0x00000008U	/* Just for warning_tunnel_hidden, set when a treasure vein was mined on this grid */

#define CAVE2_SWITCH	0x00000010U	/* Players can always switch position here, like on staircase grids (for grids around stores) */
#define CAVE2_DECAL	0x00000020U	/* Impossible to interact with anything on this grid or the grid itself except for looking at it (only implemented for monsters atm, who get 'friendly' flag set from this) */
#define CAVE2_SCRT	0x00000040U	/* Secret grid, cannot be uncovered by magic mapping or similar means, but only manually by looking at it directly via line of sight. */
#define CAVE2_REFUGE	0x00000080U	/* IDDC refuge grid */

//super hypothetical: maybe add CAVE_LITE_MON in the future, for monster-lit grids.


#if 0	/* for future expansion.. */
/* To what extent shall we enlarge it?
 * we'll do 'smells of carrot' thingie? :) */
#define CAVE_TRDT	0x0800    /* trap detected */
#define CAVE_IDNT	0x1000    /* grid identified (fountains) */
#define CAVE_SPEC	0x2000    /* special mark(quests) */
#define CAVE_FREE	0x4000    /* no random generation on it */
#define CAVE_DETECT	0x8000    /* Traps detected here */
#define CAVE_PLIT	0x0    /* Player lit grid */
#define CAVE_MLIT	0x0    /* Monster lit grid */
#endif /* 0 */


/*
 * Bit flags for the "project()" function
 *
 */
#define PROJECT_JUMP	0x00000001U	/* Jump directly to the target location (this is a hack) */
#define PROJECT_BEAM	0x00000002U	/* Work as a beam weapon (affect every grid passed through) */
#define PROJECT_THRU	0x00000004U	/* Continue "through" the target (used for "bolts"/"beams") */
#define PROJECT_STOP	0x00000008U	/* Stop as soon as we hit a monster (used for "bolts") */

#define PROJECT_GRID	0x00000010U	/* Affect each grid in the "blast area" in some way */
#define PROJECT_ITEM	0x00000020U	/* Affect each object in the "blast area" in some way */
#define PROJECT_KILL	0x00000040U	/* Affect each monster in the "blast area" in some way */
#define PROJECT_HIDE	0x00000080U	/* Hack -- disable "visual" feedback from projection */

#define PROJECT_STAY	0x00000100U	/* Create an 'effect' on the grid (cloud/wall/special fx) */
#define PROJECT_SELF	0x00000200U	/* Affect the projector too */
#define PROJECT_DUMY	0x00000400U	/* Don't affect anything or anybody (just visual fx, used for EFF_FIREWORKS etc.) */
#define PROJECT_GRAV	0x00000800U	/* Affected by gravity ie running along the ground. Example: Fire Wall. (Will hence stop at FEAT_DARK_PIT) */

#define PROJECT_PLAY	0x00001000U	/* Affect friendly players too, including the projector. (for GF_HEALINGCLOUD) */
#define PROJECT_NORF	0x00002000U	/* cannot be deflected by REFLECT monster flag */
#define PROJECT_FULL	0x00004000U	/* Deal full damage over radius spread (May dehack many things with this! - Kurzel) */
#define PROJECT_EVSG	0x00008000U	/* 'Entity vs Grid': It's a bolt spell that can hit EITHER mon/py OR floor/item. */

#define PROJECT_NODO	0x00010000U	/* cannot be dodged (basically used in the same places as NORF) */
#define PROJECT_LODF	0x00020000U	/* can not often be deflected by shield-blocking. */
#define PROJECT_NODF	0x00040000U	/* cannot be deflected by shield-blocking at all. */
#define PROJECT_RNAF	0x00080000U	/* has no adverse effects if resisted (added for time runecraft on high-elven characters) */

#define PROJECT_STAR	0x00100000U	/* Cast 8 rays and hit the central grid at target location. - Kurzel */
#define PROJECT_TRAP	0x00200000U	/* Caused by a set-up incident, added for blast charges (ENABLE_DEMOLITIONIST) to allow larger GF_DETONATION radius */
#define PROJECT_BOUN	0x00400000U	/* Attack has bounced at least once */
#define PROJECT_MKIL	0x00800000U	/* Specialty: Cast by monsters, yet also affect other monsters! Aka friendly fire for monsters. Added to provide anti-cheeze for badass disintegration-summoners. */

#define PROJECT_XDAM	0x01000000U	/* Designate extremly high damage output, for special handling in very specific situations */

/* ToME expansions */
#if 0	/* soon */
#define PROJECT_VIEWABLE	0x00000100U   /* Affect monsters in LOS */
#define PROJECT_METEOR_SHOWER	0x00000200U   /* Affect random grids */
#define PROJECT_BLAST		0x00000400U   /* Like Mega_blast, but will only affect viewable grids */
#define PROJECT_PANEL		0x00000800U   /* Affect everything in the panel. */
#define PROJECT_ALL		0x00001000U   /* Affect every single grid. */
#define PROJECT_WALL		0x00002000U
#define PROJECT_MANA_PATH	0x00004000U   /* Follow a mana path. */
#define PROJECT_ABSORB_MANA	0x00008000U   /* The spell increase in power as it absord grid's mana. */
#endif	/* 0 */


/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT	0x01
#define ENCH_TODAM	0x02
#define ENCH_TOAC	0x04
#define ENCH_STOLEN	0x08
#define ENCH_EQUIP	0x10


/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID		0x00000001U
#define SM_RES_ELEC		0x00000002U
#define SM_RES_FIRE		0x00000004U
#define SM_RES_COLD		0x00000008U
#define SM_RES_POIS	0x00000010U
#define SM_RES_NETH	0x00000020U
#define SM_RES_LITE	0x00000040U
#define SM_RES_DARK	0x00000080U
#define SM_RES_FEAR		0x00000100U
#define SM_RES_CONF		0x00000200U
#define SM_RES_CHAOS		0x00000400U
#define SM_RES_DISEN		0x00000800U
#define SM_RES_BLIND	0x00001000U
#define SM_RES_NEXUS	0x00002000U
#define SM_RES_SOUND	0x00004000U
#define SM_RES_SHARD	0x00008000U
#define SM_OPP_ACID		0x00010000U
#define SM_OPP_ELEC		0x00020000U
#define SM_OPP_FIRE		0x00040000U
#define SM_OPP_COLD		0x00080000U
#define SM_OPP_POIS	0x00100000U
#define SM_RES_WATE	0x00200000U
#define SM_RES_MANA	0x00400000U
#define SM_RES_TIME	0x00800000U
#define SM_IMM_ACID		0x01000000U
#define SM_IMM_ELEC		0x02000000U
#define SM_IMM_FIRE		0x04000000U
#define SM_IMM_COLD		0x08000000U
#define SM_IMM_NETH	0x10000000U
#define SM_IMM_WATE	0x20000000U
#define SM_IMM_FREE	0x40000000U
#define SM_IMM_MANA	0x80000000U


/*
 * Bit flags for the "c_get_item" function
 */
#define USE_EQUIP		0x0001	/* Allow equip items */
#define USE_INVEN		0x0002	/* Allow inven items */
#define USE_FLOOR		0x0004	/* Allow floor items */
#define USE_EXTRA		0x0008	/* Allow extra items, aka call item by name instead of slot */
#define INVEN_FIRST		0x0010	/* Seach for inscription tag in inventory first */
#define SPECIAL_REQ		0x0020	/* Allow pressing '-' key to switch the request in a special way */
#define USE_LIMIT		0x0040	/* Allow spell level limit */
#define CHECK_MULTI		0x0080	/* For swap command with USE_EXTRA (search by name): Check multiple items and avoid ones that we've already equipped */
#define NEWEST			0x0100	/* Allow pressing '+' key to re-use the newest item we previously acquired */
#define CHECK_CHARGED		0x0200	/* For (Havoc) rods: Try to find non-charging ones */
#define NO_FAIL_MSG		0x0400	/* Don't display 'You do not have an eligible item.' message. Because our calling function will give a more specific message instead. */
#define EQUIP_FIRST		0x0800	/* Item selection: Display equipment first (for item 'A'ctivation) */
#ifdef ENABLE_SUBINVEN
 #define USE_SUBINVEN		0x1000	/* Allow subinventory items */
#endif
#define CHECK_CHARGED_READY	0x2000	/* For (Havoc) rods: Try to find non-charging ones, specifically ONLY allow readily usable items, not charging/empty ones. */
#ifdef ENABLE_SUBINVEN
 #define EXCLUDE_SUBINVEN	0x4000	/* For selecting a subinventory - forbid selecting items INSIDE a subinventory, as there cannot be subinventories within subinventories. */
#endif

/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE	0x00000001U	/* Combine the pack */
#define PN_REORDER	0x00000002U	/* Reorder the pack */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS	0x00000001U	/* Calculate boni */
#define PU_TORCH	0x00000002U	/* Calculate torch radius */
#define PU_SKILL_INFO	0x00000004U	/* Update client skill info */
#define PU_SANITY	0x00000008U     /* Calculate csane and msane */
#define PU_HP		0x00000010U	/* Calculate chp and mhp */
#define PU_MANA		0x00000020U	/* Calculate cmp and mmp */
/* xxx */
#define PU_SKILL_MOD	0x00000080U	/* Update client skill values/... */
/* xxx (many) */
/* xxx (many) */
#define PU_UN_VIEW	0x00010000U	/* Forget view */
#define PU_UN_LITE	0x00020000U	/* Forget lite */
/* xxx (many) */
#define PU_VIEW		0x00100000U	/* Update view */
#define PU_LITE		0x00200000U	/* Update lite */
/* xxx */
#define PU_MONSTERS	0x01000000U	/* Update monsters */
#define PU_DISTANCE	0x02000000U	/* Update distances */
/* xxx */
#define PU_FLOW		0x10000000U	/* Update flow */
#define PU_MUSIC	0x40000000U	/* Update music */
#define PU_LUA		0x80000000U	/* Update LUA scripts */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC		0x00000001U	/* Display Race/Class/Trait */
#define PR_TITLE	0x00000002U	/* Display Title */
#define PR_LEV		0x00000004U	/* Display Level */
#define PR_EXP		0x00000008U	/* Display Experience */
#define PR_STATS	0x00000010U	/* Display Stats */
#define PR_ARMOR	0x00000020U	/* Display Armor */
#define PR_HP		0x00000040U	/* Display Hitpoints */
#define PR_MANA		0x00000080U	/* Display Mana */
#define PR_GOLD		0x00000100U	/* Display Gold */
#define PR_DEPTH	0x00000200U	/* Display Depth */
#define PR_HISTORY	0x00000400U	/* Display History */
#define PR_HEALTH	0x00000800U	/* Display Health Bar */
#define PR_CUT		0x00001000U	/* Display Extra (Cut) */
#define PR_STUN		0x00002000U	/* Display Extra (Stun/Paralysis) */
#define PR_HUNGER	0x00004000U	/* Display Extra (Hunger) */
#define PR_VARIOUS	0x00008000U	/* Display Various info (age, etc.) */
#define PR_BLIND	0x00010000U	/* Display Extra (Blind/Hallu) */
#define PR_CONFUSED	0x00020000U	/* Display Extra (Confused) */
#define PR_AFRAID	0x00040000U	/* Display Extra (Afraid) */
#define PR_POISONED	0x00080000U	/* Display Extra (Poisoned) */
#define PR_STATE	0x00100000U	/* Display Extra (State) */
#define PR_SPEED	0x00200000U	/* Display Extra (Speed) */
#define PR_STUDY	0x00400000U	/* Display Extra (Study) */
#define PR_PLUSSES	0x00800000U	/* Display Plusses to Hit/Damage */
#define PR_EXTRA	0x01000000U	/* Display Extra Info */
#define PR_BASIC	0x02000000U	/* Display Basic Info */
#define PR_MAP		0x04000000U	/* Display Map */
#define PR_WIPE		0x08000000U	/* Hack -- Total Redraw */
#define PR_SKILLS	0x10000000U	/* Display Skills */
#define PR_SANITY	0x20000000U     /* Display Sanity */
#define PR_ENCUMBERMENT	0x40000000U	/* Display Encumberment status line */
#define PR_STAMINA	0x80000000U	/* Display Stamina */

#define PR_BPR_WRAITH	0x00400000U	/* Re-use (!) to display BpR and also Wraithform */

/*
 * Bit flags for the "p_ptr->redraw2" variable
 */
#define PR2_MAP_FWD	0x00000001U	/* Redraw the map just for a mind-linking player. (Also triggers visual title-bigmap-hack.) */
#define PR2_MAP_SCR	0x00000002U	/* Redraw just the scr map, not the ovl one */
#define PR2_CSHEET_FWD	0x00000004U	/* Redraw the character sheet (aka resend info for all its pages) just for mind-linking player. */
#define PR2_INDICATORS	0x00000008U	/* Redraw indicators for timed properties */

/*
 * Bit flags for the "prt_indicators" function
 */
#define IND_RES_FIRE    0x00000001U /* Active timed resistance to fire */
#define IND_RES_COLD    0x00000002U /* Active timed resistance to cold */
#define IND_RES_ELEC    0x00000004U /* Active timed resistance to electricity */
#define IND_RES_ACID    0x00000008U /* Active timed resistance to acid */
#define IND_RES_POIS    0x00000010U /* Active timed resistance to poison */
#define IND_RES_DIVINE  0x00000020U /* Active timed divine resistances (currently it's only mana res) */
#define IND_ESP         0x00000040U /* Active timed full ESP */
#define IND_MELEE_BRAND	0x00000080U /* Active timed melee weapon brand */
#define IND_REGEN	0x00000100U /* Active timed hp regeneration boost */
#define IND_DISPERSION	0x00000200U /* Active dispersion (not timed, switchable!) */
#define IND_CHARM	0x00000400U /* Active charm (not timed, switchable!). Note that 'Possess' is also just charm. */
#define IND_SHIELD1	0x00000800U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD2	0x00001000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD3	0x00002000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD4	0x00004000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD5	0x00008000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD6	0x00010000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */
#define IND_SHIELD7	0x00020000U /* Active timed (pseudo) reactive-shield spell (these are mutually exclusive) */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
/* flags also used by the client as term window flags */
#define PW_INVEN	0x00000001U	/* Display inven/equip */
#define PW_EQUIP	0x00000002U	/* Display equip/inven */
/*#define PW_SPELL	0x00000004U*/	/* Display spell list */
#define PW_PLAYER	0x00000004U	/* Display character -- unused */
#define PW_MSGNOCHAT	0x00000008U	/* Display messages except chat */
#define PW_MESSAGE	0x00000010U	/* Display messages */
#define PW_CHAT		0x00000020U	/* Display chat messages */
#define PW_MINIMAP	0x00000040U	/* Display minimap */
#define PW_LAGOMETER	0x00000080U	/* Display the lag-o-meter */
#define PW_PLAYERLIST	0x00000100U	/* Display player list */
#define PW_PLAYER2	0x00000200U	/* Display boni & resistances page of the character sheet ("Chh") */
#define PW_SUBINVEN	0x00000400U	/* Display subinventory contents */
/* flags currently not used by the client: */
#define PW_OVERHEAD	0x00001000U	/* Display overhead view */
#define PW_MONSTER	0x00002000U	/* Display monster recall */
#define PW_OBJECT	0x00004000U	/* Display object recall */
#define PW_ALLITEMS	0x00008000U	/* Display all inventory and equipment (all slots count as 'changed') */
#define PW_ALLITEMS_FWD	0x00010000U	/* Display all inventory for mind-linking player */
#if 1
 #define PW_INIT		0x00020000U	/* Various initialisations, that are too early to be done in Handle_login() or player_setup() to work. */
#else /* Since this is just needed initially for now, we don't need to use up a flag slot for it. */
 #ifdef ENABLE_SUBINVEN
  #define PW_SUBINVEN	0x00020000U	/* (Initially) send all subinventory contents to the player */
 #endif
#endif



/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ALL			0	/* allows all, including uniques */
#define SUMMON_ALL_U98			1	/* allows all, except uniques above race level 98 (No Sauron/NR uniques) */
#define SUMMON_MONSTER			2	/* allows all, but disallows all uniques */
/* the usual stuff */
#define SUMMON_ANT			11
#define SUMMON_SPIDER			12
#define SUMMON_HOUND			13
#define SUMMON_HYDRA			14
#define SUMMON_ANGEL			15
#define SUMMON_DEMON			16
#define SUMMON_UNDEAD			17
#define SUMMON_DRAGON			18
#define SUMMON_HI_UNDEAD		21
#define SUMMON_HI_DRAGON		22
#define SUMMON_NAZGUL			31
#define SUMMON_UNIQUE			32
/* additions from ToME */
#define SUMMON_BIZARRE1			33
#define SUMMON_BIZARRE2			34
#define SUMMON_BIZARRE3			35
#define SUMMON_BIZARRE4			36
#define SUMMON_BIZARRE5			37
#define SUMMON_BIZARRE6			38
#define SUMMON_HI_DEMON			39
#define SUMMON_KIN			40
#define SUMMON_DAWN			41
#define SUMMON_ANIMAL			42
#define SUMMON_ANIMAL_RANGER		43
#define SUMMON_HI_UNDEAD_NO_UNIQUES	44
#define SUMMON_HI_DRAGON_NO_UNIQUES	45
#define SUMMON_NO_UNIQUES		46
#define SUMMON_PHANTOM			47
#define SUMMON_ELEMENTAL		48
#define SUMMON_DRAGONRIDER		49
#define SUMMON_BLUE_HORROR		50
#define SUMMON_BUG			51
#define SUMMON_RNG			52
#define SUMMON_IMMOBILE			53
#define SUMMON_HUMAN			54
#define SUMMON_SHADOW			55
#define SUMMON_GHOST			56
#define SUMMON_QUYLTHULG		57
#define SUMMON_LUA			58
/* Again, TomeNET one(s)	- Jir - */
#define SUMMON_VERMIN			59
#define SUMMON_PATIENT			60 /* monsters that don't have any ranged attacks */
/* New stuff (RF0_) - C. Blue */
#define SUMMON_HI_MONSTER		61
#define SUMMON_HI_UNIQUE		62
#define SUMMON_SPOOK			63



/*
 * Spell types used by project(), and related functions.
 */
#define GF_ELEC			1
#define GF_POIS			2
#define GF_ACID			3
#define GF_COLD			4
#define GF_FIRE			5
#define GF_SHOT			6
#define GF_ARROW		7
#define GF_BOLT			8
#define GF_BOULDER		9
#define GF_MISSILE		10
#define GF_ACID_BLIND		11	/* fine dispersed acid (from throwing a flask): additional blind effect, but too weak to affect feat/obj. */
#define GF_PLASMA		12
#define GF_HOLY_ORB		13
#define GF_WATER		14
#define GF_LITE			15
#define GF_DARK			16
#define GF_LITE_WEAK		17
#define GF_DARK_WEAK		18
#define GF_SHARDS		20
#define GF_SOUND		21
#define GF_CONFUSION		22
#define GF_FORCE		23
#define GF_INERTIA		24
#define GF_MANA			26
#define GF_METEOR		27
#define GF_ICE			28
#define GF_CHAOS		30
#define GF_NETHER		31
#define GF_DISENCHANT		32
#define GF_NEXUS		33
#define GF_TIME			34
#define GF_GRAVITY		35
#define GF_KILL_WALL		40
#define GF_KILL_DOOR		41
#define GF_KILL_TRAP		42
#define GF_KILL_TRAP_DOOR	43
#define GF_MAKE_WALL		45
#define GF_MAKE_DOOR		46
#define GF_MAKE_TRAP		47
#define GF_OLD_CLONE		51
#define GF_OLD_POLY		52
#define GF_OLD_HEAL		53
#define GF_OLD_SPEED		54
#define GF_OLD_SLOW		55
#define GF_OLD_CONF		56
#define GF_OLD_SLEEP		57
#define GF_OLD_DRAIN		58
#define GF_AWAY_UNDEAD		61
#define GF_AWAY_EVIL		62
#define GF_AWAY_ALL		63
#define GF_TURN_UNDEAD		64
#define GF_TURN_EVIL		65
#define GF_TURN_ALL		66
#define GF_DISP_UNDEAD		67
#define GF_DISP_EVIL		68
#define GF_DISP_ALL		69

#define	GF_HEAL_PLAYER		70
#define	GF_STONE_WALL		71
#define	GF_EARTHQUAKE		72
#define	GF_WRAITH_PLAYER	73
#define	GF_SPEED_PLAYER		74
#define	GF_SHIELD_PLAYER	75
#define GF_RECALL_PLAYER	76
#define GF_STUN			77
#define GF_IDENTIFY		78
#define GF_PSI			79
#define GF_HOLY_FIRE		80
#define GF_DISINTEGRATE		81
#define GF_HELLFIRE		82 /* was HOLY_ORB */
#define GF_NETHER_WEAK		83 /* special version of GF_NETHER, solely for Vampires smashing Potions of Death */
#define GF_REMCURSE_PLAYER	84
#define GF_KILL_GLYPH		85
#define GF_STARLITE		86
#define GF_TERROR		87
#define GF_HAVOC		88
#define GF_INFERNO		89 /* damage-wise like GF_ROCKET, but no special sfx and doesn't hurt terrain (could be changed, dunno) */
#define GF_DETONATION		90 /* damage-wise like GF_ROCKET, but different sfx */
#define GF_ROCKET		91

/* for traps.h :) - C. Blue */
#define GF_REMFEAR		92
#define GF_HERO_MONSTER		93
#define GF_LIFEHEAL		94
#define GF_DEC_STR		95
#define GF_DEC_DEX		96
#define GF_DEC_CON		97
#define GF_RES_STR		98
#define GF_RES_DEX		99
#define GF_RES_CON		100
#define GF_INC_STR		101
#define GF_INC_DEX		102
#define GF_INC_CON		103
#define GF_AUGMENTATION		104
#define GF_RUINATION		105
#define GF_EXP			106
#define GF_MIND_SLOW		107
#define GF_TBRAND_POIS		108
#define GF_CODE			109
#define GF_NUKE			110
#define GF_BLIND		111
#define GF_HOLD			112	/* hold */
#define GF_DOMINATE		113	/* dominate */
#define GF_BLESS_PLAYER		114
#define GF_REMFEAR_PLAYER	115
#define GF_SATHUNGER_PLAYER	116
#define GF_RESFIRE_PLAYER	117
#define GF_RESCOLD_PLAYER	118
#define GF_CUREPOISON_PLAYER	119
#define GF_SEEINVIS_PLAYER	120
#define GF_SEEMAP_PLAYER	121
#define GF_CURECUT_PLAYER	122
#define GF_CURESTUN_PLAYER	123
#define GF_DETECTCREATURE_PLAYER	124
#define GF_DETECTDOOR_PLAYER	125
#define GF_DETECTTRAP_PLAYER	126
#define GF_TELEPORTLVL_PLAYER	127
#define GF_RESPOIS_PLAYER	128
#define GF_RESELEC_PLAYER	129
#define GF_RESACID_PLAYER	130
#define GF_HPINCREASE_PLAYER	131
#define GF_HERO_PLAYER		132
#define GF_SHERO_PLAYER		133

#define GF_UNBREATH		134
#define GF_WAVE			135

#define GF_TELEPORT_PLAYER 	136	/* UNUSED actually: only s_convey used it once */

#define GF_RESTORE_PLAYER 	137	/* C. Blue changes */
#define GF_VAPOUR		138	/* This is same as GF_WATER, just looks differently */
#define GF_CURE_PLAYER 		139
#define GF_RESURRECT_PLAYER 	140
#define GF_SANITY_PLAYER 	141
#define GF_ZEAL_PLAYER 		142
#define GF_DISP_DEMON		143
#define GF_SOULCURE_PLAYER	144
#define GF_MINDBOOST_PLAYER	145
#define GF_REMCONF_PLAYER	146
#define GF_REMIMAGE_PLAYER	147
#define GF_SLOWPOISON_PLAYER 	148
#define GF_CURING		149

/* Zangband changes */
#define GF_TELE_TO		150
#define GF_HAND_DOOM		151
#define GF_STASIS		152

/* For the new priest spell I'm conjuring - the_sandman */
#define GF_CURSE		153
/* Here comes the druid items - the_sandman */
#define GF_HEALINGCLOUD		154
#define GF_WATERPOISON		155
#define GF_ICEPOISON		156
#define GF_EXTRA_STATS		157
#define GF_EXTRA_TOHIT		158

#define GF_PUSH 		159 /* Moltor */
#define GF_SILENCE		160 /* for new mindcrafters */
#define GF_CHARMIGNORE		161
#define GF_STOP			162 /* special fx: scroll of rune of protection in a monster trap - C. Blue */
#define GF_CAUSE		163 /* 'Curse' actually, the monster spell */
#define GF_FLARE		164 /* Combination of LITE_WEAK and FIRE damage, for Flare Missile */
#define GF_LIFE_SLOW		165 /* Same as GF_OLD_SLOW aka 'Slow Monsters', but based on fatigue, therefore doesn't affect creatures that know no fatigue. */
#define GF_NO_REGEN		166

#define GF_THUNDER		189 /* To replace the hacky 'triple-bolt' of the thunderstorm spell */
#define GF_ANNIHILATION		192 /* To differentiate drain effect from hacky non-drain effect for wands */

/* For snowflakes on WINTER_SEASON. Could use 0 for type, but let's complete it. -C. Blue */
#define GF_SNOWFLAKE		200
/* For fireworks on NEW_YEARS_EVE - C. Blue */
#define GF_FW_FIRE		201
#define GF_FW_ELEC		202
#define GF_FW_POIS		203
#define GF_FW_LITE		204
#define GF_FW_YCLD		205
#define GF_FW_SHDM		206
#define GF_FW_MULT		207
/* well, let's try to bring weather and seasons? */
#define GF_RAINDROP		208
#define GF_LEAF			209 /* unused, just added here for inspiration - C. Blue */
/* full-screen warnings or other important notifications that players oughtn't overlook - C. Blue */
//ugly though, since they are wpos-bound -..
// #define GF_TEXT_UPDATE	210 /* 'your game version is outdated..' */
#define GF_SHOW_LIGHTNING	211
#define GF_THUNDER_VISUAL	212

#define GF_CROSSHAIR		250 /* what's this for? appearently unused; moved it to 250 */


#if 0	/* Let's implement one by one.. */
#define GF_DISP_DEMON		70      /* New types for Zangband begin here... */
#define GF_DISP_LIVING		71
#define GF_NUKE			73
#define GF_STASIS		75
#define GF_STONE_WALL		76
#define GF_DEATH_RAY		77
#define GF_STUN			78
#define GF_HOLY_FIRE		79
#define GF_HELLFIRE		80
#define GF_DISINTEGRATE		81
#define GF_CHARM		82
#define GF_CONTROL_UNDEAD	83
#define GF_CONTROL_ANIMAL	84
#define GF_PSI			85
#define GF_PSI_DRAIN		86
#define GF_TELEKINESIS		87
#define GF_JAM_DOOR		88
#define GF_DOMINATION		89
#define GF_DISP_GOOD		90
#define GF_IDENTIFY		91
#define GF_RAISE		92
#define GF_STAR_IDENTIFY	93
#define GF_DESTRUCTION		94
#define GF_STUN_CONF		95
#define GF_STUN_DAM		96
#define GF_CONF_DAM		98
#define GF_STAR_CHARM		99
#define GF_IMPLOSION		100
#define GF_LAVA_FLOW		101
#define GF_FEAR			102
#define GF_BETWEEN_GATE		103
#define GF_WINDS_MANA		104
#define GF_DEATH		105
#define GF_CONTROL_DEMON	106
#define GF_RAISE_DEMON		107
#define GF_TRAP_DEMONSOUL	108
#define GF_ATTACK		109
/* Increased it (from 152) to 153 - the_sandman*/
/* Increaing it again by ... 3-- to 156 :-) - the_sandman */
#define MAX_GF			156	/* appearently unused, if 0'ed */
#endif	/* 0 */

/*
 * Some things which induce learning
 */
#define DRS_ACID	1
#define DRS_ELEC	2
#define DRS_FIRE	3
#define DRS_COLD	4
#define DRS_POIS	5
#define DRS_NETH	6
#define DRS_LITE	7
#define DRS_DARK	8
#define DRS_FEAR	9
#define DRS_CONF	10
#define DRS_CHAOS	11
#define DRS_DISEN	12
#define DRS_BLIND	13
#define DRS_NEXUS	14
#define DRS_SOUND	15
#define DRS_SHARD	16
#define DRS_FREE	30
#define DRS_SMANA	31
#define DRS_MANA	32
#define DRS_WATER	33
#define DRS_TIME	34



#if 0 //deprecated
/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
 #define ART_MIN_NORMAL		16
#endif


/*
 * Hack -- special "xtra" object powers -- UNUSED, see ETRx_ flags instead --
 */
/* Sustain one stat */
#define EGO_XTRA_SUSTAIN	1
/* High resist */
#define EGO_XTRA_POWER		2
/* Special ability */
#define EGO_XTRA_ABILITY	3



/*** Object flag values ***/


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR		0x01
#define CHEST_LOSE_CON		0x02
#define CHEST_POISON		0x04
#define CHEST_PARALYZE		0x08
#define CHEST_EXPLODE		0x10
#define CHEST_SUMMON		0x20



/*
 * Special "Item Flags"
 */
#define ID_SENSE	0x0001	/* Item has been "sensed" */
#define ID_FIXED	0x0002	/* Item has been "haggled" */
#define ID_EMPTY	0x0004	/* Item charges are known (Wand/Staff only) */
#define ID_KNOWN	0x0008	/* Item abilities are known */
#define ID_RUMOUR	0x0010	/* Item background is known */
#define ID_MENTAL	0x0020	/* Item information is known (*ID*-ed) */
#define ID_CURSED	0x0040	/* Item is temporarily cursed */
#define ID_BROKEN	0x0080	/* Item is permanently worthless */
#define ID_SENSED_ONCE	0x0100	/* Item was at least sensed once, maybe even IDed. (anti-exploit) */
#define ID_SENSE_HEAVY	0x0200	/* Item was deeply pseudo-identified (felt_heavy) */
#define ID_NO_HIDDEN	0x0400	/* Item obviously cannot have hidden powers and hence *ID*ing it wouldn't have any effect */



/*
 * As of 2.7.8, the "object flags" are valid for all objects, and as
 * of 2.7.9, these flags are not actually stored with the object.
 *
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat boni, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "Stat Sustainers",
 * actual immunities, and resistances).  Note that "Hold Life" is really an
 * "immunity" to ExpLoss, and "Free Action" is "immunity to paralysis".
 *
 * Note that "flags3" contains everything else -- including the three "CURSED"
 * flags, and the "BLESSED" flag, several "item display" parameters, some new
 * flags for powerful Bows, and flags which affect the player in a "general"
 * way (LITE, TELEPATHY, SEE_INVIS, SLOW_DIGEST, REGEN, FEATHER), including
 * all the "general" curses (TELEPORT, AGGRAVATE, EXP_DRAIN).  It also has
 * four new flags called "ITEM_IGNORE_XXX" which lets an item specify that
 * it can not be affected by various forms of destruction.  This is NOT as
 * powerful as actually granting resistance/immunity to the wearer.
 */

#define TR1_STR			0x00000001U	/* STR += "pval" */
#define TR1_INT			0x00000002U	/* INT += "pval" */
#define TR1_WIS			0x00000004U	/* WIS += "pval" */
#define TR1_DEX			0x00000008U	/* DEX += "pval" */
#define TR1_CON				0x00000010U	/* CON += "pval" */
#define TR1_CHR				0x00000020U	/* CHR += "pval" */
#define TR1_MANA			0x00000040U	/* SP += "pval" * SP / 10 */
/* #define TR1_SPELL_SPEED		0x00000080U */	/* Spell Speed += pval */
 #define TR1_SPELL			0x00000080U	/* Spell Speed += pval -- unused, remove me -- */
//HOLE
#define TR1_STEALTH		0x00000100U	/* Stealth += "pval" */
#define TR1_SEARCH		0x00000200U	/* Search += "pval" */
#define TR1_INFRA		0x00000400U	/* Infra += "pval" */
#define TR1_TUNNEL		0x00000800U	/* Tunnel += "pval" */
#define TR1_SPEED			0x00001000U	/* Speed += "pval" */
#define TR1_BLOWS			0x00002000U	/* Blows += "pval" */
#define TR1_LIFE			0x00004000U	/* Later */
#define TR1_VAMPIRIC			0x00008000U	/* XXX4 */
#define TR1_SLAY_ANIMAL		0x00010000U
#define TR1_SLAY_EVIL		0x00020000U
#define TR1_SLAY_UNDEAD		0x00040000U
#define TR1_SLAY_DEMON		0x00080000U
#define TR1_SLAY_ORC			0x00100000U
#define TR1_SLAY_TROLL			0x00200000U
#define TR1_SLAY_GIANT			0x00400000U
#define TR1_SLAY_DRAGON			0x00800000U
#define TR1_KILL_DRAGON		0x01000000U	/* Execute Dragon */
#define TR1_KILL_DEMON		0x02000000U	/* Execute Demon */
#define TR1_KILL_UNDEAD		0x04000000U	/* Execute Undead */
#define TR1_BRAND_POIS		0x08000000U
#define TR1_BRAND_ACID			0x10000000U
#define TR1_BRAND_ELEC			0x20000000U
#define TR1_BRAND_FIRE			0x40000000U
#define TR1_BRAND_COLD			0x80000000U

/* mask for all damage multipliers (brands & slays) */
#define TR1_MULTMASK		(TR1_BRAND_FIRE | TR1_BRAND_COLD | TR1_BRAND_ELEC | TR1_BRAND_ACID | TR1_BRAND_POIS | \
				TR1_SLAY_ANIMAL | TR1_SLAY_EVIL | TR1_SLAY_UNDEAD | TR1_SLAY_DEMON | TR1_SLAY_ORC | \
				TR1_SLAY_TROLL | TR1_SLAY_GIANT | TR1_SLAY_DRAGON | \
				TR1_KILL_DRAGON | TR1_KILL_DEMON | TR1_KILL_UNDEAD)

#define TR1_ATTR_MASK (TR1_STR | TR1_INT | TR1_WIS | TR1_DEX | TR1_CON | TR1_CHR)

/* Hack -- flag set 1 -- mask for "pval-dependant" flags. */
#if 0
#define TR1_PVAL_MASK	\
	(TR1_ATTR_MASK | TR1_MANA | TR1_SPELL_SPEED | \
	TR1_STEALTH | TR1_SEARCH | TR1_INFRA | TR1_TUNNEL | \
	TR1_SPEED | TR1_BLOWS | TR1_LIFE | TR1_XXX4)
#else
#define TR1_PVAL_MASK   \
	(TR1_ATTR_MASK | TR1_LIFE | \
	TR1_STEALTH | TR1_SEARCH | TR1_INFRA | TR1_TUNNEL | \
	TR1_SPEED | TR1_BLOWS | TR1_MANA | TR1_SPELL)
#endif	/* 0 */


/* ToME hack for trapkits */
#define TRAP2_AUTOMATIC_5	0x00000001U     /* Trap automatically rearms itself, 1 in 5 failure */
#define TRAP2_AUTOMATIC_99	0x00000002U     /* Trap automatically rearms itself */
#define TRAP2_KILL_GHOST	0x00000004U     /* Trap also affects PASS_WALL creatures */
#define TRAP2_TELEPORT_TO	0x00000008U     /* After everything else, teleport to player */
#define TRAP2_ONLY_DRAGON		0x00000010U     /* Affect only dragons & other AFFECTed creatures */
#define TRAP2_ONLY_DEMON		0x00000020U     /* Affect only demons & other AFFECTed creatures */
#define TRAP2_ONLY_ANIMAL	0x00000100U     /* Affect only animals & other AFFECTed creatures */
#define TRAP2_ONLY_UNDEAD	0x00000200U     /* Affect only undead & others */
#define TRAP2_ONLY_EVIL		0x00000400U     /* Affect only evil creatures &c. */

/* mask for monster-specific traps */
#define TRAP2_ONLY_MASK		(TRAP2_ONLY_DRAGON | TRAP2_ONLY_DEMON | TRAP2_ONLY_ANIMAL | \
				 TRAP2_ONLY_UNDEAD | TRAP2_ONLY_EVIL )

#define TR2_SUST_STR		0x00000001U
#define TR2_SUST_INT		0x00000002U
#define TR2_SUST_WIS		0x00000004U
#define TR2_SUST_DEX		0x00000008U
#define TR2_SUST_CON			0x00000010U
#define TR2_SUST_CHR			0x00000020U
#define TR2_RES_WATER			0x00000040U	/* Resist Water */
#define TR2_IM_NETHER			0x00000080U     /* Immunity to nether */
#define TR2_IM_ACID		0x00000100U
#define TR2_IM_ELEC		0x00000200U
#define TR2_IM_FIRE		0x00000400U
#define TR2_IM_COLD		0x00000800U
#define TR2_IM_POISON			0x00001000U
#define TR2_IM_WATER			0x00002000U	/* Water immunity, should also let you breathe under water */
#define TR2_FREE_ACT			0x00004000U	/* Free Action */
#define TR2_HOLD_LIFE	 		0x00008000U	/* Hold Life */
#define TR2_RES_ACID		0x00010000U
#define TR2_RES_ELEC		0x00020000U
#define TR2_RES_FIRE		0x00040000U
#define TR2_RES_COLD		0x00080000U
#define TR2_RES_POIS			0x00100000U
#define TR2_RES_FEAR			0x00200000U
#define TR2_RES_LITE			0x00400000U
#define TR2_RES_DARK			0x00800000U
#define TR2_RES_BLIND		0x01000000U
#define TR2_RES_CONF		0x02000000U
#define TR2_RES_SOUND		0x04000000U
#define TR2_RES_SHARDS		0x08000000U
#define TR2_RES_NETHER			0x10000000U
#define TR2_RES_NEXUS			0x20000000U
#define TR2_RES_CHAOS			0x40000000U
#define TR2_RES_DISEN			0x80000000U


#if 0
#define TR3_KNOWLEDGE			0x00000001U	/* Later */
#endif	/* 0 */
/* Flags from ToME - Jir - */

#define TR3_SH_FIRE		0x00000001U     /* Immolation (Fire) */
#define TR3_SH_ELEC		0x00000002U     /* Electric Sheath */
#define TR3_SH_COLD		0x00000004U		/* Winter's might/Snow grasp/Frostweaving (Cold aura) */
#define TR3_AUTO_CURSE		0x00000008U     /* The obj will recurse itself */
#define TR3_NO_TELE			0x00000010U     /* Anti-teleportation */
#define TR3_NO_MAGIC			0x00000020U     /* Anti-magic */
#define TR3_WRAITH			0x00000040U     /* Wraithform */
#define TR3_TY_CURSE			0x00000080U     /* The Ancient Curse */
#define TR3_EASY_KNOW		0x00000100U	/* Aware -> Known, aka no ID necessary. (May need *ID* though if this type of item can really gain name1/2/2b.) */
#define TR3_HIDE_TYPE		0x00000200U	/* Hide "pval" description */
#define TR3_SHOW_MODS		0x00000400U	/* Always show Tohit/Todam */
#define TR3_INSTA_ART		0x00000800U	/* Item must be a (true) artifact */
#define TR3_FEATHER			0x00001000U	/* Feather Falling */
#define TR3_LITE1			0x00002000U	/* Permanent Light */
#define TR3_SEE_INVIS			0x00004000U	/* See Invisible */
#define TR3_REGEN_MANA			0x00008000U	/* Item induces regeneration */
#define TR3_SLOW_DIGEST		0x00010000U	/* Item slows down digestion */
#define TR3_REGEN		0x00020000U	/* Item induces regeneration */
#define TR3_XTRA_MIGHT		0x00040000U	/* Bows get extra multiplier */
#define TR3_XTRA_SHOTS		0x00080000U	/* Bows get extra shots */
#define TR3_IGNORE_ACID			0x00100000U	/* Item ignores Acid Damage */
#define TR3_IGNORE_ELEC			0x00200000U	/* Item ignores Elec Damage */
#define TR3_IGNORE_FIRE			0x00400000U	/* Item ignores Fire Damage */
#define TR3_IGNORE_COLD			0x00800000U	/* Item ignores Cold Damage */
#define TR3_ACTIVATE		0x01000000U	/* Item can be activated */
#define TR3_DRAIN_EXP		0x02000000U	/* Item drains Experience */
#define TR3_TELEPORT		0x04000000U	/* Item teleports player */
#define TR3_AGGRAVATE		0x08000000U	/* Item aggravates monsters */
#define TR3_BLESSED			0x10000000U	/* Item is Blessed */
#define TR3_CURSED			0x20000000U	/* Item is Cursed */
#define TR3_HEAVY_CURSE			0x40000000U	/* Item is Heavily Cursed */
#define TR3_PERMA_CURSE			0x80000000U	/* Item is Perma Cursed */

#ifdef INVERSE_CURSED_RETAIN
 // Note about these two flags: TR3_BLESSED -- cursed items cannot have BLESSED flag, TR3_PERMA_CURSE -- not happening on randarts
 #define TR3_BAD_MASK (TR3_AUTO_CURSE | TR3_NO_TELE | TR3_NO_MAGIC | TR3_TY_CURSE | TR3_DRAIN_EXP | TR3_TELEPORT | TR3_AGGRAVATE | TR3_CURSED | TR3_HEAVY_CURSE)
#endif


#define TR4_NEVER_BLOW		0x00000001U     /* Weapon can't attack */
 #define TR4_PRECOGNITION	0x00000002U     /* Like activating the cheat mode -- unused -- */
 #define TR4_BLACK_BREATH	0x00000004U     /* Tolkien's Black Breath -- unused -- */
#define TR4_RECHARGE            0x00000008U     /* For artifact Wands and Staffs */
#define TR4_LEVITATE			0x00000010U     /* This one and ONLY this one allow you to fly over trees */
#define TR4_DG_CURSE			0x00000020U     /* The Ancient Morgothian Curse */
#define TR4_SHOULD2H			0x00000040U     /* Can wield it 2 Handed */
#define TR4_MUST2H			0x00000080U     /* Must wield it 2 Handed */
#define TR4_COULD2H		0x00000100U     /* Can wield it 2 Handed */
#define TR4_CLONE		0x00000200U     /* Can clone monsters */
#define TR4_SPECIAL_GENE	0x00000400U     /* The object can only be generated in special conditions like quests, special dungeons, ... */
#define TR4_CLIMB		0x00000800U     /* Allow climbing mountains */
/* rods only -- consider make them like trapkits - Jir - */
 #define TR4_FAST_CAST			0x00001000U     /* Rod is x2 time faster to use -- unused -- */
 #define TR4_CAPACITY			0x00002000U     /* Rod can take x2 mana -- unused -- */
#define TR4_CHARGING			0x00004000U     /* Rod recharge faster */
 #define TR4_CHEAPNESS			0x00008000U     /* Rod spells are cheaper(in mana cost) to cast -- unused - */
#define TR4_FOUNTAIN		0x00010000U     /* Available as fountain (for potions) */
#define TR4_ANTIMAGIC_50	0x00020000U     /* Forbid magic */
#define TR4_ANTIMAGIC_30	0x00040000U     /* Forbid magic */
#define TR4_ANTIMAGIC_20	0x00080000U     /* Forbid magic */
#define TR4_ANTIMAGIC_10		0x00100000U     /* Forbid magic */
#define TR4_EASY_USE			0x00200000U     /* Easily activable */
 #define TR4_RECHARGED			0x00400000U     /* Object has been recharged once -- unused -- */
 #define TR3_NO_NORM_ART		0x00800000U	/* ??? -- unused -- */
 #define TR4_ULTIMATE		0x01000000U     /* ULTIMATE artifact -- unused -- */
#define TR4_AUTO_ID		0x02000000U     /* Id stuff on floor */
#define TR4_LITE2		0x04000000U     /* lite radius 2 */
#define TR4_LITE3		0x08000000U     /* lite radius 3 */
#define TR4_FUEL_LITE			0x10000000U     /* fuelable lite */
 #define TR4_ART_EXP			0x20000000U     /* Will accumulate xp -- unused -- */
#define TR4_CURSE_NO_DROP		0x40000000U     /* The obj wont be dropped */
 #define TR4_NO_RECHARGE		0x80000000U     /* Object Cannot be recharged -- practically unused -- */

#define TR4_NULL_MASK		0xFFFFFFFCU	//unused

#ifdef INVERSE_CURSED_RETAIN
 #define TR4_BAD_MASK (TR4_NEVER_BLOW | TR4_BLACK_BREATH | TR4_DG_CURSE | TR4_CLONE | TR4_CURSE_NO_DROP)
#endif


 #define TR5_TEMPORARY		0x00000001U		/* In timeout turns it is destroyed -- not implemented -- */
#define TR5_DRAIN_MANA		0x00000002U		/* Drains mana */
#define TR5_DRAIN_HP		0x00000004U		/* Drains hp */
#define TR5_VORPAL		0x00000008U		/* XXX5 */
#define TR5_IMPACT			0x00000010U	/* Cause Earthquakes */
#define TR5_CRIT			0x00000020U	/* More critical hits */
#define TR5_ATTR_MULTI			0x00000040U	/* Object shimmer -- only allowed in k_info */
 #define TR5_WOUNDING			0x00000080U	/* Wounds monsters -- not implemented -- (maybe give +hit/+dam bonus?) */
 #define TR5_FULL_NAME		0x00000100U		/* Uses direct name from k_info - a bunch of items have this seemingly randomly (mostly books?), but it's UNUSED appearently/not implemented -- */
#define TR5_LUCK		0x00000200U		/* Luck += pval */
//hole:
#define TR5_XXX			0x00000400U	//hole (was plasma res)
 #define TR5_LEVELS		0x00000800U		/* Can gain exp/exp levels !! -- unused -- */
#define TR5_FORCE_DEPTH			0x00001000U	/* Can only occur on depth >= its k_info level */
#define TR5_WHITE_LIGHT			0x00002000U	/* Light source colour is white instead of flame-yellow (for CAVE_LITE_COLOURS) */
#define TR5_IGNORE_DISEN		0x00004000U	/* For 'Arcane' ego power for Heavy winners-only armour */
#define TR5_RES_TELE			0x00008000U     /* Formerly for Sky Dragon Scale Mail -- now only used by Space-Time anchor. */
 #define TR5_DECAY		0x00010000U		/* Decay -- unused -- */
#define TR5_IGNORE_MANA		0x00020000U		/* Item ignores Mana Damage */
#define TR5_IGNORE_WATER	0x00040000U		/* Item ignores Water damage */
#define TR5_RES_TIME		0x00080000U
#define TR5_RES_MANA			0x00100000U
 #define TR5_REDUC_FIRE			0x00200000U	/* Later */
 #define TR5_REDUC_COLD			0x00400000U	/* Later */
 #define TR5_REDUC_ELEC			0x00800000U	/* Later */
 #define TR5_REDUC_ACID		0x01000000U		/* Later */
#define TR5_DISARM		0x02000000U
#define TR5_NO_ENCHANT		0x04000000U
#define TR5_CHAOTIC		0x08000000U
#define TR5_INVIS			0x10000000U
#define TR5_REFLECT			0x20000000U
#define TR5_PASS_WATER			0x40000000U
#define TR5_WINNERS_ONLY		0x80000000U

/* Hack -- flag set 5 -- mask for "pval-dependant" flags. */
#define TR5_PVAL_MASK   \
	(TR5_CRIT | TR5_LUCK | TR5_DISARM)

#ifdef INVERSE_CURSED_RETAIN
 #define TR5_BAD_MASK (TR5_DRAIN_MANA | TR5_DRAIN_HP | TR5_WHITE_LIGHT) /* Note: WHITE_LIGHT triggers anti_undead() and anti_demon() */
#endif


#define TR6_INSTA_EGO		0x00000001U		/* Similar to INSTA_ART, this item is always an ego item */
#define TR6_STARTUP		0x00000002U		/* For weapons: Can be picked for starter item on character creation, without passing the (level<=15 && dam>=0) check. */
 #define TR6_EVENT_HALLOWEEN	0x00000004U		/* Item not available if no event is running -- unused */
 #define TR6_EVENT_XMAS		0x00000008U		/* Item not available if no event is running -- unused */
/* Not yet implemented/used: Susceptibilities. Cold might be needed. For monsters, even susc-poison is implemented.
   For the player I think fire and cold are enough. (C. Blue) */
 #define TR6_SENS_FIRE			0x00000010U	/* makes user susceptible to fire -- unused */
 #define TR6_SENS_COLD			0x00000020U	/* makes user susceptible to cold -- unused  */
 #define TR6_SENS_ACID			0x00000040U	/* makes user susceptible to acid -- unused  */
 #define TR6_SENS_ELEC			0x00000080U	/* makes user susceptible to lightning -- unused  */
//Also, more curses could be added, like, slow/para/conf curses :D - C. Blue
#define TR6_OFTEN_EGO		0x00000100U		/* Item has higher chance to be generated with ego power */
#define TR6_UNBLESSED		0x00000200U		/* Item never receives flags that hurt an undead/demonic wielder, from ego or art powers */
#define TR6_RETURNING		0x00000400U		/* Item automatically returns to owner when thrown (artifact ammo does this already, without need for this flag) */


/* Character Sheet Boni Data Flags for Char/Byte PKT Transfer - Kurzel */
#define CB1_SFIRE	0x01
#define CB1_RFIRE	0x02
#define CB1_IFIRE	0x04
#define CB1_SCOLD	0x08
#define CB1_RCOLD	0x10
#define CB1_ICOLD	0x20
#define CB1_SELEC	0x40
#define CB1_RELEC	0x80

#define CB2_IELEC	0x01
#define CB2_SACID	0x02
#define CB2_RACID	0x04
#define CB2_IACID	0x08
#define CB2_SPOIS	0x10
#define CB2_RPOIS	0x20
#define CB2_IPOIS	0x40
#define CB2_RBLND	0x80

#define CB3_SLITE	0x01
#define CB3_RLITE	0x02
#define CB3_RDARK	0x04
#define CB3_RSOUN	0x08
#define CB3_RSHRD	0x10
#define CB3_RNEXU	0x20
#define CB3_RNETH	0x40
#define CB3_INETH	0x80

#define CB4_RCONF	0x01
#define CB4_RCHAO	0x02
#define CB4_RDISE	0x04
#define CB4_RWATR	0x08
#define CB4_IWATR	0x10
#define CB4_RTIME	0x20
#define CB4_RMANA	0x40
#define CB4_RMIND	0x80

#define CB5_XMIND	0x01
#define CB5_RFEAR	0x02
#define CB5_RPARA	0x04
#define CB5_STELE	0x08
#define CB5_RTELE	0x10
#define CB5_ITELE	0x20
#define CB5_RSINV	0x40
#define CB5_RINVS	0x80

#define CB6_RLIFE	0x01
#define CB6_RWRTH	0x02
#define CB6_RFFAL	0x04
#define CB6_RLVTN	0x08
#define CB6_RCLMB	0x10
#define CB6_SRGHP	0x20
#define CB6_RRGHP	0x40
#define CB6_SRGMP	0x80

#define CB7_RRGMP	0x01
#define CB7_RFOOD	0x02
#define CB7_IFOOD	0x04
#define CB7_RVAMP	0x08
#define CB7_RAUID	0x10
#define CB7_RREFL	0x20
#define CB7_RAMSH	0x40
#define CB7_RAGGR	0x80

#define CB8_ESPID	0x01
#define CB8_EANIM	0x02
#define CB8_SANIM	0x04
#define CB8_EORCS	0x08
#define CB8_SORCS	0x10
#define CB8_ETROL	0x20
#define CB8_STROL	0x40
#define CB8_EGIAN	0x80

#define CB9_SGIAN	0x01
#define CB9_EDRGN	0x02
#define CB9_SDRGN	0x04
#define CB9_KDRGN	0x08
#define CB9_EDEMN	0x10
#define CB9_SDEMN	0x20
#define CB9_KDEMN	0x40
#define CB9_EUNDD	0x80

#define CB10_SUNDD	0x01
#define CB10_KUNDD	0x02
#define CB10_EEVIL	0x04
#define CB10_SEVIL	0x08
#define CB10_EDGRI	0x10
#define CB10_EGOOD	0x20
#define CB10_ENONL	0x40
#define CB10_EUNIQ	0x80

#define CB11_BFIRE	0x01
#define CB11_AFIRE	0x02
#define CB11_BCOLD	0x04
#define CB11_ACOLD	0x08
#define CB11_BELEC	0x10
#define CB11_AELEC	0x20
#define CB11_BACID	0x40
#define CB11_BPOIS	0x80

#define CB12_BVORP	0x01
#define CB12_RSSTR	0x02
#define CB12_RSINT	0x04
#define CB12_RSWIS	0x08
#define CB12_RSDEX	0x10
#define CB12_RSCON	0x20
#define CB12_RSCHR	0x40
#define CB12_XHIDD	0x80

#define CB13_XSTAR	0x01
#define CB13_XCRSE	0x02
#define CB13_XNOEQ	0x04
#define CB13_XSWIM	0x08
#define CB13_XTREE	0x10
#define CB13_XWALL	0x20
#define CB13_XNCUT	0x40
#define CB13_XLITE	0x80

#define CB14_ILIFE	0x01
#define CB14_UMIND	0x02

/* Added CB14 CB15 and CB16 for now - Kurzel */


/* Item-generation restriction flags */
#define RESF_NONE		0x00000000U

#define RESF_WINNER		0x00000001U	/* allow TR5_WINNERS_ONLY items */
#define RESF_NOTRUEART		0x00000002U	/* prevent true artifacts */
#define RESF_NORANDART		0x00000004U	/* prevent random artifacts */
#define RESF_NODOUBLEEGO	0x00000008U	/* prevent double ego items */

#define RESF_NOHIDSM		0x00000010U	/* prevent generation of high dragon scale mails: Only base elements + poison, metallics and pseudo. */
#define RESF_LOWSPEED		0x00000020U	/* not more than +4 speed */
#define RESF_NOHISPEED		0x00000040U	/* not more than +6 speed */
#define RESF_LOWVALUE		0x00000080U	/* no items worth more than 35000 Au */

#define RESF_MIDVALUE		0x00000100U	/* no items worth more than 50000 Au */
#define RESF_NOHIVALUE		0x00000200U	/* no items worth more than 100000 Au */

#define RESF_NOETHEREAL		0x00000400U	/* no 'ethereal' ego power (ammo) */
#if 0 /* not implemented: */
 #define RESF_KINDMID		0x00000800U	/* k_info value of 500..10000 */
 #define RESF_KINDHI		0x00001000U	/* k_info value of 10000.. */
 #define RESF_EGOLOW		0x00002000U	/* e_info value of ..1000 */
 #define RESF_EGOMID		0x00004000U	/* e_info value of 1000..9000 */
#else /* use it for actual stuff.. */
 #define RESF_COND_FORCE	0x00000800U	/* force item drop of desired type according to conditions */
 #define RESF_COND_LSWORD	0x00001000U	/* force a sword (swordmen, rogues) */
 #define RESF_BOOST_PVAL	0x00002000U	/* for create_reward(): Boost lowish pvals for certain items to make them guaranteedly quite useful */
 #define RESF_CONDF_NOMSTAFF	0x00004000U	/* don't allow mage staves (persistent; for Saruman, when he chosen-drops a guaranteed one, this avoids duplicates) -- */
#endif
#define RESF_EGOHI		0x00008000U	/* e_info value of 9000.. */

#define RESF_LIFE		0x00010000U	/* allow +LIFE randarts */
#define RESF_DEBUG_ITEM		0x00020000U	/* generate a certain item (k_idx) for debugging purpose */
#define RESF_STOREFLAT		0x00040000U	/* generate all base item types with same probability */
#define RESF_FORCERANDART	0x00080000U	/* generate a random artifact */

#define RESF_NO_ENCHANT		0x00100000U	/* generate an 'average' item (no enchantments/ego powers/artifacts) */
#define RESF_SAURON		0x00200000U	/* don't generate The One Ring, as player has already slain Sauron. -- This flag is abused for no_soloist drops eg from Santa Claus! */

#define RESF_COND_SWORD		0x00400000U	/* don't allow weapons besides a sword (swordmen, rogues) */
#define RESF_COND_DARKSWORD	0x00800000U	/* don't allow weapons besides a dark sword (unbelievers) */

#define RESF_COND_BLUNT		0x01000000U	/* don't allow weapons besides a blunt weapon (priests) */
#define RESF_CONDF_NOSWORD	0x02000000U	/* don't allow swords (shamans) -- */
#define RESF_CONDF_MSTAFF	0x04000000U	/* force a mage staff (mages) */
#define RESF_COND_SLING		0x08000000U	/* don't allow weapons besides a sling (clears condition) or ammo (doesn't clear condition) (slingers) */

#define RESF_COND_RANGED	0x10000000U	/* don't allow weapons besides ranged weapons (clear condition) or ammo (doesn't clear condition) (archers) */
#define RESF_CONDF_RUNE		0x20000000U	/* force a rune (runemasters) */
#define RESF_COND2_LARMOUR	0x40000000U	/* mostly avoid dropping heavy armour (persistent) */
#define RESF_COND2_HARMOUR	0x80000000U	/* mostly avoid dropping light armour (persistent) */

#define RESF_LOW		(RESF_NOTRUEART | RESF_NORANDART | RESF_NODOUBLEEGO | RESF_NOHIDSM | RESF_LOWSPEED | RESF_LOWVALUE)	/* prevent generation of especially powerful items */
#define RESF_LOW2		(RESF_NOTRUEART | RESF_NORANDART | RESF_NODOUBLEEGO | RESF_NOHIDSM | RESF_LOWSPEED | RESF_MIDVALUE)	/* prevent generation of especially powerful items */
#define RESF_MID		(RESF_NOTRUEART | RESF_NORANDART | RESF_NOHIDSM | RESF_NOHISPEED | RESF_NOHIVALUE)	/* prevent generation of especially powerful high-level items */
#define RESF_MID2		(RESF_NOTRUEART | RESF_NORANDART | RESF_NOHIDSM | RESF_NOHISPEED)	/* prevent generation of especially powerful high-level items, but allow full ESP for example (no price limit) */
#define RESF_HIGH		RESF_NOART /* alias */
#define RESF_NOART		(RESF_NOTRUEART | RESF_NORANDART)	/* prevent generation of any artefacts */
#define RESF_WILD		RESF_NONE
#define RESF_STORE		(RESF_NOART | RESF_NOETHEREAL) /* not fully implemented yet (see get_obj_num... and kind_is..) */
#define RESF_STOREBM		(RESF_NOART | RESF_NOETHEREAL) /* not fully implemented yet (see get_obj_num... and kind_is..) */

#define RESF_COND_MASK		(RESF_COND_SWORD | RESF_COND_LSWORD | RESF_COND_DARKSWORD | RESF_COND_BLUNT | RESF_CONDF_NOSWORD | RESF_CONDF_MSTAFF | RESF_COND_SLING | RESF_COND_RANGED | RESF_CONDF_RUNE)


/* ESP defines */
#define ESP_ORC			0x00000001U
#define ESP_TROLL		0x00000002U
#define ESP_DRAGON		0x00000004U
#define ESP_GIANT		0x00000008U
#define ESP_DEMON		0x00000010U
#define ESP_UNDEAD		0x00000020U
#define ESP_EVIL		0x00000040U
#define ESP_ANIMAL		0x00000080U
#define ESP_DRAGONRIDER		0x00000100U
#define ESP_GOOD		0x00000200U
#define ESP_NONLIVING		0x00000400U
#define ESP_UNIQUE		0x00000800U
#define ESP_SPIDER		0x00001000U
/* #define ESP_PLAYER		0x08000000U */
#define R_ESP_LOW		0x10000000U /* animal,giant,orc,troll,dr,good,nonliving,spider */
#define R_ESP_HIGH		0x20000000U /* dragon,demon,undead,evil,unique */
#define R_ESP_ANY		0x40000000U /* random esp == R_ESP from ego flags */
#define ESP_ALL			0x80000000U

#define ESP_R_MASK		(R_ESP_LOW | R_ESP_HIGH | R_ESP_ANY)

#if 0 //unused
/* Number of group of flags to choose from */
 #define MAX_FLAG_GROUP		12
 #define NEW_GROUP_CHANCE	40      /* Chance to get a new group */
#endif


/*** Ego flags ***/
#define ETR1_SUSTAIN		0x00000001U	/* Ego-Item gives a Random Sustain */
#define ETR1_OLD_RESIST		0x00000002U	/* The old "extra power" random high resist */
#define ETR1_ABILITY		0x00000004U	/* Ego-Item has a random Sustain */
#define ETR1_R_ELEM		0x00000008U	/* Item resists Acid/Fire/Cold/Elec or Poison */
#define ETR1_R_LOW		0x00000010U	/* Item has a random low resist */
#define ETR1_R_HIGH		0x00000020U	/* Item has a random high resist */
#define ETR1_R_ANY		0x00000040U	/* Item has one additional resist */
#define ETR1_R_DRAGON		0x00000080U	/* Item gets "Dragon" Resist -- UNUSED//HOLE, verify implementation on use, because of hard-coded values */
#define ETR1_SLAY_WEAP		0x00000100U	/* Special 'Slaying' bonus */
#define ETR1_DAM_DIE		0x00000200U	/* Item has an additional dam die */
#define ETR1_DAM_SIZE		0x00000400U	/* Item has greater damage dice */
#define ETR1_PVAL_M1		0x00000800U	/* Item has +1 to pval */
#define ETR1_PVAL_M2		0x00001000U	/* Item has +(up to 2) to pval */
#define ETR1_PVAL_M3		0x00002000U	/* Item has +(up to 3) to pval */
#define ETR1_PVAL_M5		0x00004000U	/* Item has +(up to 5) to pval */
#define ETR1_AC_M5		0x00008000U	/* Item has +(up to 5) to AC */
#define ETR1_NO_DOUBLE_EGO	0x00010000U	/* Item may not have two ego powers */
#define ETR1_R_HIGH_IMMUNITY	0x00020000U	/* Item has a random high resistance or base immunity */
//HOLE
#define ETR1_R_ESP		0x01000000U	/* Item has a random ESP */
#define ETR1_NO_SEED		0x02000000U	/* Item doesn't have random seed */
#define ETR1_LOW_ABILITY	0x04000000U	/* like ABILITY without top esp */
#define ETR1_R_P_ABILITY	0x08000000U	/* Item has a random pval-affected ability */
#define ETR1_R_STAT		0x10000000U	/* Item affects a random stat */
#define ETR1_R_STAT_SUST	0x20000000U	/* Item affects a random stat & sustains it */
#define ETR1_R_IMMUNITY		0x40000000U	/* Item gives a random base immunity */
#define ETR1_LIMIT_BLOWS	0x80000000U	/* Only on 'Aman' weapons atm - reduces bpr */

#define ETR1_EASYKNOW_MASK	\
	(0xFFFFFFFF & ~(ETR1_DAM_DIE | ETR1_DAM_SIZE | ETR1_PVAL_M1 | \
	ETR1_PVAL_M2 | ETR1_PVAL_M3 | ETR1_PVAL_M5 | ETR1_LIMIT_BLOWS | \
	ETR1_AC_M5 | ETR1_NO_DOUBLE_EGO | ETR1_NO_SEED))

#define ETR2_R_SLAY		0x00000001U	/* random slay mod */

#define ETR2_EASYKNOW_MASK	0xFFFFFFFFU


/* "Biases" for random artifact gen */
#define BIAS_ELEC		1
#define BIAS_POIS		2
#define BIAS_FIRE		3
#define BIAS_COLD		4
#define BIAS_ACID		5
#define BIAS_STR		6
#define BIAS_INT		7
#define BIAS_WIS		8
#define BIAS_DEX		9
#define BIAS_CON		10
#define BIAS_CHR		11
#define BIAS_CHAOS		12
#define BIAS_PRIESTLY		13
#define BIAS_NECROMANTIC	14
#define BIAS_LAW		15
#define BIAS_ROGUE		16
#define BIAS_MAGE		17
#define BIAS_WARRIOR		18
#define BIAS_RANGER		19



/*** Monster blow constants ***/


/*
 * New monster blow methods
 */
#define RBM_NONE	0
#define RBM_HIT		1
#define RBM_TOUCH	2
#define RBM_PUNCH	3
#define RBM_KICK	4
#define RBM_CLAW	5
#define RBM_BITE	6
#define RBM_STING	7
#define RBM_XXX1	8
#define RBM_BUTT	9
#define RBM_CRUSH	10
#define RBM_ENGULF	11
/*#define RBM_XXX2	12 */
#define RBM_CRAWL	13
#define RBM_DROOL	14
#define RBM_SPIT	15
/*#define RBM_XXX3	16 */
#define RBM_GAZE	17
#define RBM_WAIL	18
#define RBM_SPORE	19
#define RBM_XXX4	20
#define RBM_BEG		21
#define RBM_INSULT	22
#define RBM_MOAN	23
/*#define RBM_XXX5	24 */

#define RBM_ANY		0
#define RBM_CHARGE	12
#define RBM_EXPLODE	16
#define RBM_SHOW	24

#define RBM_WHISPER	25

/*
 * New monster blow effects
 */
#define RBE_NONE	0
#define RBE_HURT	1
#define RBE_POISON	2
#define RBE_UN_BONUS	3
#define RBE_UN_POWER	4
#define RBE_EAT_GOLD	5
#define RBE_EAT_ITEM	6
#define RBE_EAT_FOOD	7
#define RBE_EAT_LITE	8
#define RBE_ACID	9
#define RBE_ELEC	10
#define RBE_FIRE	11
#define RBE_COLD	12
#define RBE_BLIND	13
#define RBE_CONFUSE	14
#define RBE_TERRIFY	15
#define RBE_PARALYZE	16
#define RBE_LOSE_STR	17
#define RBE_LOSE_INT	18
#define RBE_LOSE_WIS	19
#define RBE_LOSE_DEX	20
#define RBE_LOSE_CON	21
#define RBE_LOSE_CHR	22
#define RBE_LOSE_ALL	23
#define RBE_SHATTER	24
#define RBE_EXP_10	25
#define RBE_EXP_20	26
#define RBE_EXP_40	27
#define RBE_EXP_80	28

#define RBE_DISEASE	29
#define RBE_TIME	30
#define RBE_SANITY	31
#define RBE_HALLU	32
#define RBE_PARASITE	33

#define RBE_DISARM	34
#define RBE_FAMINE	35
#define RBE_SEDUCE	36

#define RBE_LITE	37	/* explosion-only effect. No actual hit! */
#define RBE_EAT_MANA	38

/*** Monster flag values (hard-coded) ***/


/*
 * New monster race bit flags
 */
#define RF1_UNIQUE			0x00000001U	/* Unique Monster */
#define RF1_RAND_100			0x00000002U	/* 100% random movement */
#define RF1_MALE			0x00000004U	/* Male gender */
#define RF1_FEMALE			0x00000008U	/* Female gender */
#define RF1_CHAR_CLEAR		0x00000010U	/* Absorbs symbol */
#define RF1_CHAR_MULTI		0x00000020U	/* Changes symbol */
#define RF1_ATTR_CLEAR		0x00000040U	/* Absorbs color */
#define RF1_ATTR_MULTI		0x00000080U	/* Changes color depending on breaths */
#define RF1_FORCE_DEPTH			0x00000100U	/* Start at "correct" depth */
#define RF1_FORCE_MAXHP			0x00000200U	/* Start with max hitpoints */
#define RF1_FORCE_SLEEP			0x00000400U	/* Start out with very low energy - but this is now deprecated since monsters even start out with negative energy nowadays to avoid insta-breath-kills - C. Blue */
#define RF1_RAND_5			0x00000800U	/* Moves very slightly randomly (5%) (for Panda, so it's not appearing totally 'passive' - C. Blue) */
#define RF1_FRIEND		0x00001000U	/* Arrive with a friend */
#define RF1_FRIENDS		0x00002000U	/* Arrive with some friends */
#define RF1_ESCORT		0x00004000U	/* Arrive with an escort */
#define RF1_ESCORTS		0x00008000U	/* Arrive with some escorts */
#define RF1_DROP_1			0x00010000U	/* Drop exactly 1 item/gold pile */
#define RF1_DROP_2			0x00020000U	/* Drop exactly 2 items/gold piles */
#define RF1_RAND_25			0x00040000U	/* Moves randomly (25%) */
#define RF1_RAND_50			0x00080000U	/* Moves randomly (50%) */
#define RF1_ONLY_GOLD		0x00100000U	/* Drop only gold */
#define RF1_ONLY_ITEM		0x00200000U	/* Drop only items */
#define RF1_DROP_60		0x00400000U	/* Drop an item/gold (60%) */
#define RF1_DROP_90		0x00800000U	/* Drop an item/gold (90%) */
#define RF1_DROP_1D2			0x01000000U	/* Drop 1d2 items/gold */
#define RF1_DROP_2D2			0x02000000U	/* Drop 2d2 items/gold */
#define RF1_DROP_3D2			0x04000000U	/* Drop 3d2 items/gold */
#define RF1_DROP_4D2			0x08000000U	/* Drop 4d2 items/gold */
#define RF1_DROP_GOOD		0x10000000U	/* Drop good items */
#define RF1_DROP_GREAT		0x20000000U	/* Drop great items */
#define RF1_DROP_USEFUL		0x40000000U	/* Drop "useful" items -- not implemented, unused (Dolphiner only) */
#define RF1_DROP_CHOSEN		0x80000000U	/* Drop "chosen" items */

/*
 * New monster race bit flags
 */
#define RF2_STUPID			0x00000001U	/* Monster is stupid */
#define RF2_SMART			0x00000002U	/* Monster is smart */
#define RF2_CAN_SPEAK			0x00000004U	/* TY: can speak */
#define RF2_REFLECTING			0x00000008U	/* Reflects bolts */
#define RF2_INVISIBLE		0x00000010U	/* Monster avoids vision */
#define RF2_COLD_BLOOD		0x00000020U	/* Monster avoids infra */
#define RF2_EMPTY_MIND		0x00000040U	/* Monster avoids telepathy */
#define RF2_WEIRD_MIND		0x00000080U	/* Monster avoids telepathy? */
#define RF2_DEATH_ORB			0x00000100U	/* Death Orb */
#define RF2_REGENERATE			0x00000200U	/* Monster regenerates */
#define RF2_SHAPECHANGER		0x00000400U	/* TY: shapechanger */
#define RF2_ATTR_ANY			0x00000800U	/* TY: Attr_any - can shimmer in any colour */
#define RF2_POWERFUL		0x00001000U	/* Monster has strong breath */
#define RF2_ELDRITCH_HORROR	0x00002000U	/* Sanity-blasting horror    */
#define RF2_AURA_FIRE		0x00004000U	/* Burns in melee */
#define RF2_AURA_ELEC		0x00008000U	/* Shocks in melee */
#define RF2_OPEN_DOOR			0x00010000U	/* Monster can open doors */
#define RF2_BASH_DOOR			0x00020000U	/* Monster can bash doors */
#define RF2_PASS_WALL			0x00040000U	/* Monster can pass walls */
#define RF2_KILL_WALL			0x00080000U	/* Monster can destroy walls */
#define RF2_MOVE_BODY		0x00100000U	/* Monster can move monsters */
#define RF2_KILL_BODY		0x00200000U	/* Monster can kill monsters */
#define RF2_TAKE_ITEM		0x00400000U	/* Monster can pick up items */
#define RF2_KILL_ITEM		0x00800000U	/* Monster can crush items */
#define RF2_NEVER_BLOW			0x01000000U	/* Never make physical blow */
#define RF2_NEVER_MOVE			0x02000000U	/* Never make physical move */
#define RF2_NEVER_ACT			0x04000000U	/* Monster doesn't perform any kind of movement, attacks, spells or whatever. */
#define RF2_NO_ESCORT			0x08000000U	/* monster will never occur in groups, like escorts or nests/pits */
#define RF2_NO_NEST		0x10000000U	/* monster will never occur in groups, like escorts or nests/pits */
#define RF2_ROAMING		0x20000000U	/* monster never spawns in vaults or pits (ie on CAVE_ICKY/CAVE_NEST_PIT grids) */
#define RF2_REGENERATE_T2	0x40000000U	/* Monster has half-troll-like regeneration */
#define RF2_REGENERATE_TH	0x80000000U	/* Monster has troll- or hydra-like regeneration */

#define RF2_NO_GROUP_MASK	(RF2_NO_ESCORT)		/* | RF2_NO_NEST */

/*
 * New monster race bit flags
 */
#define RF3_ORC			0x00000001U	/* Orc */
#define RF3_TROLL		0x00000002U	/* Troll */
#define RF3_GIANT		0x00000004U	/* Giant */
#define RF3_DRAGON		0x00000008U	/* Dragon */
#define RF3_DEMON			0x00000010U	/* Demon */
#define RF3_UNDEAD			0x00000020U	/* Undead */
#define RF3_EVIL			0x00000040U	/* Evil */
#define RF3_ANIMAL			0x00000080U	/* Animal */
#define RF3_DRAGONRIDER		0x00000100U	/* DG: DragonRider */
#define RF3_GOOD		0x00000200U	/* Good */
#define RF3_AURA_COLD		0x00000400U	/* Freezes in melee */
#define RF3_NONLIVING		0x00000800U	/* TY: Non-Living (?) */
#define RF3_HURT_LITE			0x00001000U	/* Hurt by lite */
#define RF3_HURT_ROCK			0x00002000U	/* Hurt by rock remover */
#define RF3_SUSCEP_FIRE			0x00004000U	/* Hurt badly by fire */
#define RF3_SUSCEP_COLD			0x00008000U	/* Hurt badly by cold */
#define RF3_IM_ACID		0x00010000U	/* Resist acid a lot */
#define RF3_IM_ELEC		0x00020000U	/* Resist elec a lot */
#define RF3_IM_FIRE		0x00040000U	/* Resist fire a lot */
#define RF3_IM_COLD		0x00080000U	/* Resist cold a lot */
#define RF3_IM_POIS			0x00100000U	/* Resist poison a lot */
#define RF3_RES_TELE			0x00200000U	/* Resist teleportation */
#define RF3_RES_NETH			0x00400000U	/* Resist nether a lot */
#define RF3_RES_WATE			0x00800000U	/* Resist water */
#define RF3_IM_WATER		0x01000000U	/* Water immunity, should also let you breathe under water */
#define RF3_RES_NEXU		0x02000000U	/* Resist nexus */
#define RF3_RES_DISE		0x04000000U	/* Resist disenchantment */
#define RF3_AI_HYBRID		0x08000000U	/* Monster is AI_ANNOY while target player isn't in melee (aka on adjacent grid) */
#define RF3_NO_FEAR			0x10000000U	/* Cannot be scared */
#define RF3_NO_STUN			0x20000000U	/* Cannot be stunned */
#define RF3_NO_CONF			0x40000000U	/* Cannot be confused */
#define RF3_NO_SLEEP			0x80000000U	/* Cannot be slept */

/*
 * New monster race bit flags
 */
#define RF4_SHRIEK		0x00000001U	/* Shriek for help */
#define RF4_UNMAGIC		0x00000002U	/* Cancel player's timed spell */
#define RF4_TRAPS		0x00000004U	/* Create Traps */
#define RF4_ROCKET		0x00000008U	/* TY: Rocket */
#define RF4_ARROW_1			0x00000010U	/* Fire an arrow (light) */
#define RF4_ARROW_2			0x00000020U	/* Fire a shot (heavy) */
#define RF4_ARROW_3			0x00000040U	/* Fire a bolt (heavy) */
#define RF4_ARROW_4			0x00000080U	/* Fire a missile (heavy) */
#define RF4_BR_ACID		0x00000100U	/* Breathe Acid */
#define RF4_BR_ELEC		0x00000200U	/* Breathe Elec */
#define RF4_BR_FIRE		0x00000400U	/* Breathe Fire */
#define RF4_BR_COLD		0x00000800U	/* Breathe Cold */
#define RF4_BR_POIS			0x00001000U	/* Breathe Poison */
#define RF4_BR_NETH			0x00002000U	/* Breathe Nether */
#define RF4_BR_LITE			0x00004000U	/* Breathe Lite */
#define RF4_BR_DARK			0x00008000U	/* Breathe Dark */
#define RF4_BR_CONF		0x00010000U	/* Breathe Confusion */
#define RF4_BR_SOUN		0x00020000U	/* Breathe Sound */
#define RF4_BR_CHAO		0x00040000U	/* Breathe Chaos */
#define RF4_BR_DISE		0x00080000U	/* Breathe Disenchant */
#define RF4_BR_NEXU			0x00100000U	/* Breathe Nexus */
#define RF4_BR_TIME			0x00200000U	/* Breathe Time */
#define RF4_BR_INER			0x00400000U	/* Breathe Inertia */
#define RF4_BR_GRAV			0x00800000U	/* Breathe Gravity */
#define RF4_BR_SHAR		0x01000000U	/* Breathe Shards */
#define RF4_BR_PLAS		0x02000000U	/* Breathe Plasma */
#define RF4_BR_WALL		0x04000000U	/* Breathe Force */
#define RF4_BR_MANA		0x08000000U	/* Breathe Mana */
#define RF4_BR_DISI			0x10000000U	/* Breathe Disintegration */
#define RF4_BR_NUKE			0x20000000U	/* TY: Toxic Breath */
#define RF4_MOAN			0x40000000U	/* For Halloween event :) -C. Blue */
#define RF4_BOULDER			0x80000000U	/* Hurl Boulder (Vanilla) */

#define RF4_PLAYER_SPELLS (RF4_SHRIEK | RF4_ROCKET | \
	RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | \
	RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | RF4_BR_COLD | RF4_BR_POIS | RF4_BR_NETH | \
	RF4_BR_LITE | RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | RF4_BR_CHAO | RF4_BR_DISE | \
	RF4_BR_NEXU | RF4_BR_TIME | RF4_BR_INER | RF4_BR_GRAV | RF4_BR_SHAR | RF4_BR_PLAS | \
	RF4_BR_WALL | RF4_BR_MANA | RF4_BR_DISI | RF4_BR_NUKE | RF4_BOULDER)
/* NOTE: BR_DISI is not considered as 'radius spell', since this can
 * eliminate walls between the caster and the player. */
#if 0
 #define RF4_RADIUS_SPELLS (0xafffff08U) /* Changed for Halloween event, now includes ranged MOAN. -C. Blue */
 //1010-1111-1111-1111-1111-1111-0000-1000
#else
 /* Note: RF4_BR_DISI and RF4_ROCKET _can_ be used for 'tunneling' by monsters just
    because they are _excluded_ here. Including them would break that. */
 #define RF4_RADIUS_SPELLS (RF4_MOAN | RF4_BR_NUKE | 0x0fffff00U)
#endif

/*
 * New monster race bit flags
 */
#define RF5_BA_ACID		0x00000001U	/* Acid Ball */
#define RF5_BA_ELEC		0x00000002U	/* Elec Ball */
#define RF5_BA_FIRE		0x00000004U	/* Fire Ball */
#define RF5_BA_COLD		0x00000008U	/* Cold Ball */
#define RF5_BA_POIS			0x00000010U	/* Poison Ball */
#define RF5_BA_NETH			0x00000020U	/* Nether Ball */
#define RF5_BA_WATE			0x00000040U	/* Water Ball */
#define RF5_BA_MANA			0x00000080U	/* Mana Storm */
#define RF5_BA_DARK		0x00000100U	/* Darkness Storm */
#define RF5_DRAIN_MANA		0x00000200U	/* Drain Mana */
#define RF5_MIND_BLAST		0x00000400U	/* Blast Mind */
#define RF5_BRAIN_SMASH		0x00000800U	/* Smash Brain */
#define RF5_CURSE			0x00001000U	/* Cause Light Wound */
#define RF5_BO_CODE			0x00002000U
#define RF5_BA_NUKE			0x00004000U	/* TY: Nuke Ball */
#define RF5_BA_CHAO			0x00008000U	/* Chaos Ball */
#define RF5_BO_ACID		0x00010000U	/* Acid Bolt */
#define RF5_BO_ELEC		0x00020000U	/* Elec Bolt */
#define RF5_BO_FIRE		0x00040000U	/* Fire Bolt */
#define RF5_BO_COLD		0x00080000U	/* Cold Bolt */
#define RF5_BO_POIS			0x00100000U	/* Poison Bolt (implemented but unused: Only used by Judge Mortis) */
#define RF5_BO_NETH			0x00200000U	/* Nether Bolt */
#define RF5_BO_WATE			0x00400000U	/* Water Bolt */
#define RF5_BO_MANA			0x00800000U	/* Mana Bolt */
#define RF5_BO_PLAS		0x01000000U	/* Plasma Bolt */
#define RF5_BO_ICEE		0x02000000U	/* Ice Bolt */
#define RF5_MISSILE		0x04000000U	/* Magic Missile */
#define RF5_SCARE		0x08000000U	/* Frighten Player */
#define RF5_BLIND			0x10000000U	/* Blind Player */
#define RF5_CONF			0x20000000U	/* Confuse Player */
#define RF5_SLOW			0x40000000U	/* Slow Player */
#define RF5_HOLD			0x80000000U	/* Paralyze Player */

#define RF5_PLAYER_SPELLS (0xffffffffU & ~(RF5_DRAIN_MANA))
#define RF5_RADIUS_SPELLS ( RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | \
		RF5_BA_COLD | RF5_BA_POIS | RF5_BA_NETH | RF5_BA_WATE | \
		RF5_BA_MANA | RF5_BA_DARK | RF5_BA_NUKE | RF5_BA_CHAO )

/*
 * New monster race bit flags
 */
#define RF6_HASTE		0x00000001U	/* Speed self */
#define RF6_HAND_DOOM		0x00000002U	/* Hand of Doom */
#define RF6_HEAL		0x00000004U	/* Heal self */
#define RF6_S_ANIMALS		0x00000008U	/* Summon animals */
#define RF6_BLINK			0x00000010U	/* Teleport Short */
#define RF6_TPORT			0x00000020U	/* Teleport Long */
#define RF6_RAISE_DEAD			0x00000040U	/* Raise Dead -- not implemented */
//HOLE^not implemented, but used in r_info
#define RF6_S_BUG			0x00000080U	/* Summon Software bug */
#define RF6_TELE_TO		0x00000100U	/* Move player to monster */
#define RF6_TELE_AWAY		0x00000200U	/* Move player far away */
#define RF6_TELE_LEVEL		0x00000400U	/* Move player vertically */
#define RF6_S_RNG		0x00000800U	/* Summon RNG */
#define RF6_DARKNESS			0x00001000U	/* Create Darkness */
#define RF6_S_ANIMAL			0x00002000U	/* Summon animals */
#define RF6_FORGET			0x00004000U	/* Cause amnesia */
#define RF6_S_DRAGONRIDER		0x00008000U	/* Summon DragonRiders */
#define RF6_S_KIN		0x00010000U	/* Summon "kin" */
#define RF6_S_HI_DEMONS		0x00020000U	/* Summon greater demons! */
#define RF6_S_MONSTER		0x00040000U	/* Summon Monster */
#define RF6_S_MONSTERS		0x00080000U	/* Summon Monsters */
#define RF6_S_ANTS			0x00100000U	/* Summon Ants */
#define RF6_S_SPIDERS			0x00200000U	/* Summon Spiders */
#define RF6_S_HOUNDS			0x00400000U	/* Summon Hounds */
#define RF6_S_HYDRAS			0x00800000U	/* Summon Hydras */
#define RF6_S_ANGEL		0x01000000U	/* Summon Angel */
#define RF6_S_DEMON		0x02000000U	/* Summon Demon */
#define RF6_S_UNDEAD		0x04000000U	/* Summon Undead */
#define RF6_S_DRAGON		0x08000000U	/* Summon Dragon */
#define RF6_S_HI_UNDEAD			0x10000000U	/* Summon Greater Undead */
#define RF6_S_HI_DRAGONS		0x20000000U	/* Summon Ancient Dragon */
#define RF6_S_NAZGUL			0x40000000U	/* Summon Unique Wraith */
#define RF6_S_UNIQUE			0x80000000U	/* Summon Unique Monster */

#define RF6_PLAYER_SPELLS (RF6_HASTE | RF6_HAND_DOOM | RF6_HEAL | \
		RF6_BLINK | RF6_TPORT | RF6_TELE_TO | RF6_TELE_AWAY)
#define RF6_RADIUS_SPELLS (0L)

/*
 * New monster race bit flags from ToME.		- Jir -
 */
#define RF7_AQUATIC		0x00000001U	/* Aquatic monster */
#define RF7_CAN_SWIM		0x00000002U	/* Monster can swim */
#define RF7_CAN_FLY		0x00000004U	/* Monster can fly */
#define RF7_FRIENDLY		0x00000008U	/* Monster is friendly */
#define RF7_PET				0x00000010U	/* Monster is a pet */
#define RF7_CAN_CLIMB			0x00000020U	/* Monster can climb */
#define RF7_SPIDER			0x00000040U	/* Monster is a spider (can pass webs) */
#define RF7_NAZGUL			0x00000080U	/* Monster is a Nazgul */
#define RF7_DG_CURSE		0x00000100U	/* If killed the monster grant a DG Curse to the player */
#define RF7_MORTAL		0x00000200U	/* Is it mortal? -- UNUSED -- [HOLE] */
#define RF7_NO_DEATH		0x00000400U	/* Cannot be killed */
#define RF7_NO_TARGET		0x00000800U	/* Cannot be targeted */
#define RF7_AI_ANNOY			0x00001000U	/* Try to tease the player */
#define RF7_AI_SPECIAL			0x00002000U	/* For quests */
#define RF7_NEUTRAL			0x00004000U	/* Monster is neutral */
#define RF7_DROPART			0x00008000U	/* not implemented - Drops an artifact */
#define RF7_DROPRANDART		0x00010000U	/* not implemented - Drops a random artifact */
#define RF7_AI_PLAYER		0x00020000U	/* not implemented */
#define RF7_NO_THEFT		0x00040000U	/* unused (stealing from monsters is disabled) */
#define RF7_ASTAR		0x00080000U	/* monster uses A* pathfinding (use with care, might strain CPU) */
#define RF7_NO_ESP			0x00100000U	/* monster isn't ESPable */
#define RF7_ATTR_BASE			0x00200000U	/* show base attr too. Atm works if a) only 1 breath and ATTR_MULTI (DRs) or b) ATTR_BNW is set */
#define RF7_VORTEX			0x00400000U	/* experimental: flicker extremely fast - not working atm */
#define RF7_OOD_20			0x00800000U	/* Cannot occur more than 20 levels OoD */
#define RF7_OOD_15		0x01000000U	/* Cannot occur more than 15 levels OoD */
#define RF7_OOD_10		0x02000000U	/* Cannot occur more than 10 levels OoD */
#define RF7_ATTR_BNW		0x04000000U	/* Monster flickers w/ TERM_BNW colour (ie black and white), also see SLOW_ATTR_BNW */
#define RF7_S_LOWEXP		0x08000000U	/* Summons/Clones give little exp */
#define RF7_S_NOEXP			0x10000000U	/* Summons/Clones don't give exp */
#define RF7_ATTR_BREATH			0x20000000U	/* Use client breath colouring (unused & not implemented) */
#define RF7_MULTIPLY			0x40000000U	/* Monster reproduces */
#define RF7_DISBELIEVE			0x80000000U	/* Antimagic shield */


/*
 * Monster race flags
 */
#define RF8_DUNGEON		0x00000001U	/* inverse of non-existing 'RF8_WILD_ONLY' */
#define RF8_WILD_TOWN		0x00000002U
#define RF8_WILD_EASY		0x00000004U
#define RF8_WILD_SHORE		0x00000008U
#define RF8_WILD_OCEAN			0x00000010U
#define RF8_WILD_WASTE			0x00000020U
#define RF8_WILD_WOOD			0x00000040U
#define RF8_WILD_VOLCANO		0x00000080U
#define RF8_WILD_LAKE		0x00000100U
#define RF8_WILD_MOUNTAIN	0x00000200U
#define RF8_WILD_GRASS		0x00000400U
#define RF8_NO_CUT		0x00000800U
#define RF8_CTHANGBAND			0x00001000U
#define RF8_PERNANGBAND			0x00002000U
#define RF8_ZANGBAND			0x00004000U
#define RF8_JOKEANGBAND			0x00008000U
#define RF8_ANGBAND		0x00010000U
#define RF8_BLUEBAND		0x00020000U	/* C. Blue's bestiary */
#define RF8_NO_AUTORET		0x00040000U	/* don't auto-retaliate against this monster */
#define RF8_WILD_DESERT		0x00080000U
#define RF8_WILD_ICE			0x00100000U
#define RF8_NETHER_REALM		0x00200000U	/* may only spawn in the Nether Realm */
#define RF8_PLURAL			0x00400000U	/* The monster's name is already in plural form */
#define RF8_NO_BLOCK			0x00800000U	/* This monster never blocks hits */
#define RF8_ALLOW_RUNNING	0x01000000U	/* Player may run even with this monster (awake) in LoS */
#define RF8_AVOID_PERMAWALLS	0x02000000U	/* spawns distant of permanent walls (maybe/only for Dor) */
#define RF8_PSEUDO_UNIQUE	0x04000000U	/* Not a unique monster (does not appear in the uniques list), but named/looks like one (added for Santa Claus); monster form cannot be learnt by mimics. Cannot be cloned. */
#define RF8_GENO_PERSIST	0x08000000U	/* Don't automatically genocide/compact this monster */
#define RF8_GENO_NO_THIN		0x10000000U	/* Don't genocide this monster when thinning out surface spawns */
#define RF8_FINAL_GUARDIAN		0x20000000U	/* Note! This flag is NOT set/used in r_info.txt! Instead, the monster is defined as FINAL_GUARDIAN_ in d_info.txt! */
#define RF8_WILD_SWAMP			0x40000000U	/* ToDo: Implement Swamp */
#define RF8_WILD_TOO			0x80000000U

#define RF8_WILD_TOO_MASK \
	( RF8_WILD_TOWN | RF8_WILD_EASY | RF8_WILD_SHORE | \
	  RF8_WILD_OCEAN | RF8_WILD_WASTE | RF8_WILD_WOOD | RF8_WILD_VOLCANO | \
	  RF8_WILD_LAKE | RF8_WILD_MOUNTAIN | RF8_WILD_GRASS | RF8_WILD_SWAMP | \
	  RF8_WILD_DESERT | RF8_WILD_ICE)

#define RF8_WILD_EASY_MASK \
	( RF8_WILD_TOWN | RF8_WILD_SHORE | \
	  RF8_WILD_WASTE | \
	  RF8_WILD_GRASS | RF8_WILD_SWAMP)


/*
 * Monster race flags
 */
#define RF9_DROP_CORPSE		0x00000001U
#define RF9_DROP_SKELETON	0x00000002U
#define RF9_HAS_LITE		0x00000004U		/* Carries a lite */
#define RF9_MIMIC		0x00000008U		/* REALLY looks like an object ... only nastier */
#define RF9_HAS_EGG			0x00000010U	/* Can be monster's eggs -- used in r_info but not in the code */
#define RF9_IMPRESSED			0x00000020U	/* The monster can follow you on each level until he dies */
#define RF9_SUSCEP_ACID			0x00000040U	/* Susceptible to acid */
#define RF9_SUSCEP_ELEC			0x00000080U	/* Susceptible to lightning */
#define RF9_SUSCEP_POIS		0x00000100U		/* Susceptible to poison */
#define RF9_KILL_TREES		0x00000200U		/* Monster can eat trees */
#define RF9_WYRM_PROTECT	0x00000400U		/* The monster is protected by great wyrms of power: They'll be summoned if it's killed */
#define RF9_NO_CREDIT		0x00000800U		/* Monster won't give any kill/form credit. */
#define RF9_ONLY_DEPTH			0x00001000U	/* The monster can only be generated at the GIVEN depth */
#define RF9_SPECIAL_GENE		0x00002000U	/* The monster can only be generated in special conditions like quests, special dungeons, ... NOTE: currently no effect! */
#define RF9_NO_REDUCE			0x00004000U	/* The monster cannot be afflicted by non-temporary stat-reducing effects */
#define RF9_RES_ACID			0x00008000U
#define RF9_RES_ELEC		0x00010000U
#define RF9_RES_FIRE		0x00020000U
#define RF9_RES_COLD		0x00040000U
#define RF9_RES_POIS		0x00080000U
#define RF9_RES_LITE			0x00100000U
#define RF9_RES_DARK			0x00200000U
#define RF9_RES_BLIND			0x00400000U
#define RF9_RES_SOUND			0x00800000U
#define RF9_RES_SHARDS		0x01000000U
#define RF9_RES_CHAOS		0x02000000U
#define RF9_RES_TIME		0x04000000U
#define RF9_RES_MANA		0x08000000U
#define RF9_VAMPIRIC			0x10000000U
#define RF9_IM_TELE			0x20000000U      /* Resist teleportation */
#define RF9_IM_PSI			0x40000000U	/* Immune to psi */
#define RF9_RES_PSI			0x80000000U	/* Resist psi */


/* New monster attack spells and stuff - C. Blue */
#define RF0_S_HI_MONSTER	0x00000001U
#define RF0_S_HI_MONSTERS	0x00000002U
#define RF0_S_HI_UNIQUE		0x00000004U
#define RF0_BO_DISE		0x00000008U
#define RF0_BA_DISE			0x00000010U
#define RF0_S_DEMONS			0x00000020U	/* Summon Demons -- unused */
#define RF0_S_DRAGONS			0x00000040U	/* Summon Dragons -- unused */
#define RF0_S_HI_DEMON			0x00000080U	/* Summon Greater Demon (Tzeentch) */
#define RF0_S_HI_DRAGON		0x00000100U		/* Summon Ancient Dragon -- unused */
#define RF0_BA_LITE		0x00000200U		/* Mirror: Globe of Light */
#define RF0_BO_WALL		0x00000400U		/* Mirror: Strike */
#define RF0_BA_HELLFIRE		0x00000800U		/* Mirror: Hellfire */
#define RF0_BO_LITE			0x00001000U	/* Mirror: Power Ray */
#define RF0_BO_DARK			0x00002000U	/* Mirror: Power Ray */
#define RF0_DISPEL			0x00004000U	/* Mirror: Vengenance [Corrupted] */
#define RF0_WATERPOISON			0x00008000U	/* Mirror: Toxic Moisture I/II */
#define RF0_ICEPOISON		0x00010000U		/* Mirror: Toxic Moisture III */
#define RF0_BO_CHAOS		0x00020000U		/* Mirror: Chaos Bolt (Shadow/HOff) */
#define RF0_DRAIN_LIFE		0x00040000U		/* Mirror: Drain Life (Shadow/Necro) */
#define RF0_BO_PSI		0x00080000U		/* Mirror: Psionic Blast [+Psi Storm] */
//hole

#define RF0_NONFAIL_LIMITER	24			/* note! RF0_OFFSET + this = Spells that cannot fail on casting, because they are not cast spells but 'skills'. */

#define RF0_BR_ICE		0x01000000U		/* For Bahamuth */
#define RF0_BR_WATER		0x02000000U		/* Finally no more antimagic field vs water hounds :p */
#define RF0_HEAL_PHYS		0x04000000U		/* Mirror: Heal by physical means, eg Potion of Healing */
#define RF0_BLINK_PHYS		0x08000000U		/* Mirror: Phase door scroll */
#define RF0_TPORT_PHYS			0x10000000U	/* Mirror: Teleportation scroll */
#define RF0_ADMINISTRATIVE_PUSH		0x20000000U	/* Push back */
#define RF0_METEOR_SWARM		0x40000000U	/* Targetted delayed orbital attack */
#define RF0_ADMINISTRATIVE_HOLD		0x80000000U	/* Irresistible paralysis */

/* Note: Even if RF0_HEAL_PHYS was ever enabled for non-mirror monsters, it is still NOT a player-spell ever,
         as it intrinsically depends on an item (potion of healing */
#define RF0_PLAYER_SPELLS (RF0_BO_DISE | RF0_BA_DISE | RF0_BR_ICE | RF0_BR_WATER)
#define RF0_RADIUS_SPELLS (RF0_BA_DISE | RF0_BR_ICE | RF0_BR_WATER | RF0_BA_LITE | RF0_BA_HELLFIRE | RF0_WATERPOISON | RF0_ICEPOISON)


/* Additional basic flags (ie not spell-flags, 'S:') */
//#define RFA_NO_INTERCEPT	0x00000001U		/* Cannot intercept this monster */


/* currently disabled r_info.txt flags (not implemented or some other reason) */
#define RF1_DISABLE_MASK	(0x0U)
#define RF2_DISABLE_MASK	(0x0U)
#define RF3_DISABLE_MASK	(0x0U)
#define RF4_DISABLE_MASK	(0x0U)

#define RF5_DISABLE_MASK	(RF5_BO_POIS)
#define RF6_DISABLE_MASK	(RF6_RAISE_DEAD | RF6_HAND_DOOM)
#define RF7_DISABLE_MASK	(0x0U)

#define RF8_DISABLE_MASK	(0x0U)
#define RF9_DISABLE_MASK	(0x0U)

#define RF0_DISABLE_MASK	(0x0U)
#define RFA_DISABLE_MASK	(0x0U)

/*
 * Hack -- choose "intelligent" spells when desperate
 */
/* I suspect the usefulness of this mask.. */

#if 0 /* I think it's possible that this accidentally prevents the monster from casting when it could and should - C. Blue */
 #define RF4_INT_MASK \
	(RF4_UNMAGIC | RF4_TRAPS)

 #define RF5_INT_MASK \
	(RF5_HOLD | RF5_SLOW | RF5_CONF | RF5_BLIND | RF5_SCARE)

 #define RF6_INT_MASK \
	(RF6_BLINK |  RF6_TPORT | RF6_TELE_LEVEL | RF6_TELE_AWAY | \
	RF6_HEAL | RF6_HASTE | RF6_S_ANIMAL | \
	RF6_S_KIN | RF6_S_HI_DEMONS | RF6_S_MONSTER | RF6_S_MONSTERS | \
	RF6_S_ANTS | RF6_S_SPIDERS | RF6_S_HOUNDS | RF6_S_HYDRAS | \
	RF6_S_ANGEL | RF6_S_DRAGON | RF6_S_UNDEAD | RF6_S_DEMON | \
	RF6_S_HI_DRAGONS | RF6_S_HI_UNDEAD | RF6_S_NAZGUL | RF6_S_UNIQUE | \
	RF6_S_DRAGONRIDER | RF6_S_BUG | RF6_S_RNG | RF6_S_ANIMALS)

 #define RF0_INT_MASK \
	(RF0_S_HI_MONSTER | RF0_S_HI_MONSTERS | RF0_S_HI_UNIQUE | RF0_S_DEMONS | RF0_S_DRAGONS | RF0_S_HI_DEMON | RF0_S_HI_DRAGON | RF0_HEAL_PHYS | RF0_BLINK_PHYS | RF0_TPORT_PHYS)
#else
 #define RF4_INT_MASK (0L)
 #define RF5_INT_MASK (0L)
 #define RF6_INT_MASK (0L)
 #define RF0_INT_MASK (0L)
#endif
/*
 * Spells castable even when farther than MAX_RANGE
 */
#define RF4_INDIRECT_MASK \
	(RF4_MOAN)
/*	(0L)	-	Ranged MOAN needed for Halloween event -C. Blue */

#define RF5_INDIRECT_MASK \
	(0L)

#define RF6_INDIRECT_MASK \
	(RF6_HASTE | RF6_BLINK | RF6_TPORT | RF6_HEAL)

#define RF0_INDIRECT_MASK \
	(RF0_HEAL_PHYS | RF0_BLINK_PHYS | RF0_TPORT_PHYS)


/*
 * Spells castable only when within the sight
 */
#define RF4_DIRECT_MASK \
	(RF4_SHRIEK | RF4_UNMAGIC | RF4_TRAPS | RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | RF4_BOULDER)

#define RF5_DIRECT_MASK \
	(RF5_DRAIN_MANA | RF5_MIND_BLAST | RF5_BRAIN_SMASH | RF5_CURSE | \
	 RF5_BO_CODE | RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE | \
	 RF5_SCARE | RF5_BLIND | RF5_CONF | RF5_SLOW | RF5_HOLD)


#define RF6_DIRECT_MASK \
	(RF6_TELE_TO | RF6_TELE_AWAY | RF6_TELE_LEVEL | RF6_DARKNESS | \
	 RF6_FORGET)

#define RF0_DIRECT_MASK \
	(RF0_BO_DISE | RF0_BO_WALL | RF0_BO_LITE | RF0_BO_DARK | RF0_DISPEL | RF0_BO_CHAOS | RF0_DRAIN_LIFE | RF0_BO_PSI)


/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 */
#define RF4_BOLT_MASK \
	(RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | RF4_BOULDER)

#define RF5_BOLT_MASK \
	(RF5_BO_CODE | RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | \
	RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
	RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_BOLT_MASK \
	(0L)

#define RF0_BOLT_MASK \
	(RF0_BO_DISE | RF0_BO_WALL | RF0_BO_LITE | RF0_BO_DARK | RF0_BO_CHAOS)
	/* (Dispel and PSI are considered 'grid bolts' instead that do not need to travel.) */


/* Hack -- summon spells */

#define RF4_SUMMON_MASK \
	(0L)

#define RF5_SUMMON_MASK \
	(0L)

#define RF6_SUMMON_MASK \
	(RF6_S_KIN | RF6_S_HI_DEMONS | RF6_S_MONSTER | RF6_S_MONSTERS | RF6_S_ANTS | \
	RF6_S_SPIDERS | RF6_S_HOUNDS | RF6_S_HYDRAS | RF6_S_ANGEL | RF6_S_DEMON | \
	RF6_S_UNDEAD | RF6_S_DRAGON | RF6_S_HI_UNDEAD | RF6_S_HI_DRAGONS | \
	RF6_S_NAZGUL | RF6_S_UNIQUE | RF6_S_DRAGONRIDER | RF6_S_BUG | RF6_S_RNG | RF6_S_ANIMAL | RF6_S_ANIMALS)

#define RF0_SUMMON_MASK \
	(RF0_S_HI_MONSTER | RF0_S_HI_MONSTERS | RF0_S_HI_UNIQUE | RF0_S_DEMONS | RF0_S_DRAGONS | RF0_S_HI_DEMON | RF0_S_HI_DRAGON)


/*
 * Spells that allow the caster to escape
 */
#define RF4_ESCAPE_MASK \
	(0L)

#define RF5_ESCAPE_MASK \
	(0L)

#define RF6_ESCAPE_MASK \
	(RF6_BLINK | RF6_TPORT | RF6_TELE_AWAY | RF6_TELE_LEVEL)

#define RF0_ESCAPE_MASK \
	(RF0_BLINK_PHYS | RF0_TPORT_PHYS)

/*
 * Spells that hurt the player directly
 */
#define RF4_ATTACK_MASK \
	(RF4_ROCKET | RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | \
	 RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | RF4_BR_COLD | RF4_BR_POIS | \
	 RF4_BR_NETH | RF4_BR_LITE | RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | \
	 RF4_BR_CHAO | RF4_BR_DISE | RF4_BR_NEXU | RF4_BR_TIME | RF4_BR_INER | \
	 RF4_BR_GRAV | RF4_BR_SHAR | RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | \
	 RF4_BR_NUKE | RF4_BR_DISI | RF4_BOULDER)

#define RF5_ATTACK_MASK \
	(RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | RF5_BA_POIS | \
	 RF5_BA_NETH | RF5_BA_WATE | RF5_BA_MANA | RF5_BA_DARK | \
	 RF5_BA_NUKE | RF5_BA_CHAO | \
	 RF5_MIND_BLAST | RF5_BRAIN_SMASH | RF5_CURSE | \
	 RF5_BO_CODE | RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | \
	 RF5_BO_COLD | RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
	 RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_ATTACK_MASK \
	(RF6_HAND_DOOM)

#define RF0_ATTACK_MASK \
	(RF0_BO_DISE | RF0_BA_DISE | RF0_BR_ICE | RF0_BR_WATER | \
	RF0_BA_LITE | RF0_BO_WALL | RF0_BA_HELLFIRE | RF0_BO_LITE | RF0_BO_DARK | RF0_DISPEL | \
	RF0_WATERPOISON | RF0_ICEPOISON | RF0_BO_CHAOS | RF0_DRAIN_LIFE | RF0_BO_PSI)

/*
 * Spells that improve the caster's tactical position
 */
#define RF4_TACTIC_MASK \
	(0L)

#define RF5_TACTIC_MASK \
	(0L)

#define RF6_TACTIC_MASK \
	(RF6_BLINK)

#define RF0_TACTIC_MASK \
	(RF0_BLINK_PHYS)

/*
 * Annoying spells
 */
#define RF4_ANNOY_MASK \
	(RF4_SHRIEK | RF4_UNMAGIC | RF4_TRAPS | RF4_MOAN)
/*	(RF4_SHRIEK | RF4_UNMAGIC)  ranged MOAN added for Halloween event. -C. Blue */

#define RF5_ANNOY_MASK \
	(RF5_DRAIN_MANA | RF5_MIND_BLAST | RF5_BRAIN_SMASH | \
	 RF5_SCARE | RF5_BLIND | RF5_CONF | RF5_SLOW | RF5_HOLD)

#define RF6_ANNOY_MASK \
	(RF6_TELE_TO | RF6_DARKNESS | RF6_FORGET)

#define RF0_ANNOY_MASK \
	(0L)

/*
 * Spells that increase the caster's relative speed
 */
#define RF4_HASTE_MASK \
	(0L)

#define RF5_HASTE_MASK \
	(RF5_SLOW | RF5_HOLD)

#define RF6_HASTE_MASK \
	(RF6_HASTE)

#define RF0_HASTE_MASK \
	(0L)

/*
 * Healing spells
 */
#define RF4_HEAL_MASK \
	(0L)

#define RF5_HEAL_MASK \
	(0L)

#define RF6_HEAL_MASK \
	(RF6_HEAL)

#define RF0_HEAL_MASK \
	(RF0_HEAL_PHYS)

/* Masks to find out if a monster is really a spellcaster,
   which uses magic spells, or if the 'spells' are merely
   actions as firing arrows, breathing or hurling boulders.. - C. Blue */

/* RF4_TRAPS and RF6_FORGET don't count as spells (trapping / telepathy) */

#define	RF4_SPELLCASTER_MASK \
	(0L)

#define	RF5_SPELLCASTER_MASK \
	(RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | RF5_BA_POIS | \
	RF5_BA_NETH | RF5_BA_WATE | RF5_BA_MANA | RF5_BA_DARK | \
	RF5_DRAIN_MANA | RF5_CURSE | RF5_BA_NUKE | RF5_BA_CHAO | \
	RF5_BO_CODE | RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | RF5_BO_POIS |\
	RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | RF5_BO_PLAS | \
	RF5_BO_ICEE | RF5_SCARE | RF5_BLIND | RF5_CONF | RF5_SLOW | RF5_HOLD)

#define RF6_SPELLCASTER_MASK \
	(RF6_HASTE | RF6_HAND_DOOM | RF6_HEAL | RF6_S_ANIMALS | RF6_BLINK | RF6_TPORT | \
	RF6_RAISE_DEAD | RF6_S_BUG | RF6_TELE_TO | RF6_TELE_AWAY | RF6_TELE_LEVEL | RF6_S_RNG | RF6_DARKNESS | \
	RF6_S_DRAGONRIDER | RF6_S_KIN | RF6_S_HI_DEMONS | RF6_S_MONSTER | RF6_S_MONSTERS | RF6_S_ANTS | \
	RF6_S_SPIDERS | RF6_S_HOUNDS | RF6_S_HYDRAS | RF6_S_ANGEL | RF6_S_DEMON | RF6_S_UNDEAD | RF6_S_DRAGON | \
	RF6_S_HI_UNDEAD | RF6_S_HI_DRAGONS | RF6_S_NAZGUL | RF6_S_UNIQUE | RF6_S_ANIMAL)

#define RF0_SPELLCASTER_MASK \
	(RF0_S_HI_MONSTER | RF0_S_HI_MONSTERS | RF0_S_HI_UNIQUE | RF0_BO_DISE | RF0_BA_DISE | RF0_S_DEMONS | RF0_S_DRAGONS | RF0_S_HI_DEMON | RF0_S_HI_DRAGON | \
	RF0_BA_LITE | RF0_BO_WALL | RF0_BA_HELLFIRE | RF0_BO_LITE | RF0_BO_DARK | RF0_DISPEL | RF0_WATERPOISON | RF0_ICEPOISON | RF0_BO_CHAOS | RF0_DRAIN_LIFE | RF0_BO_PSI | \
	RF0_HEAL_PHYS | RF0_BLINK_PHYS | RF0_TPORT_PHYS)


/*
	Different types of terrain, used for the wilderness.
	-APD-

	HACK -- I am temporarily using these numbers to determine
	how many monsters to generate.
*/

#define		WILD_LAKE		0
#define		WILD_GRASSLAND		1
#define		WILD_FOREST		2
#define		WILD_VOLCANO		3
#define		WILD_SHORE1		4 /* temporary */
#define		WILD_SHORE2		5 /* temporary */
#define		WILD_OCEANBED1		6 /* temporary */
#define		WILD_WASTELAND		7
#define		WILD_UNDEFINED		8
#define		WILD_CLONE		9 /* we should copy the terrain type of a neighbor */
#define		WILD_TOWN		10
#define		WILD_OCEAN		11
#define		WILD_RIVER		12
#define		WILD_COAST		13
#define		WILD_MOUNTAIN		14
#define		WILD_DENSEFOREST	15
#define		WILD_OCEANBED2		16 /* temporary */
#define		WILD_DESERT		17 /* new, similar to WILD_WASTELAND probably */
#define		WILD_ICE		18 /* new, polar style */
#define		WILD_SWAMP		20

/* different buildings */
#define		WILD_LOG_CABIN		0
#define		WILD_ROCK_HOME		1
#define		WILD_PERM_HOME		2
#define		WILD_SHACK		3
#define		WILD_TOWN_HOME		4

/* types of crops */
#define		WILD_CROP_POTATO	0
#define		WILD_CROP_CABBAGE	1
#define		WILD_CROP_CARROT	2
#define		WILD_CROP_BEET		3
#define		WILD_CROP_MUSHROOM	4
#define		WILD_CROP_SQUASH	5
#define		WILD_CROP_CORN		6
#define WILD_CROP_TYPES 7

/* used for wilderness generation */
#define		DIR_NORTH		0
#define		DIR_EAST		1
#define		DIR_SOUTH		2
#define		DIR_WEST		3

/* wilderness flags */
/* flags belonging to (+) family may be cleared to cause the according
   effect when desired, any time in the code, it's harmless ;)
   (the wilderness generation function will set them again after processing.) */
#define	WILD_F_GENERATED	0x00000001U	/* wilderness has been generated once - actually unused now after splitting it up into more detailed flags below, which are marked (+) - C. Blue */
#define	WILD_F_INHABITED	0x00000002U	/* if unset, add some monsters on day/night change (part of the (+) flag family actually, semantically) */
#define	WILD_F_IN_MEMORY	0x00000004U
#define	WILD_F_UP		0x00000008U	/* these are to show dungeons etc. */
#define	WILD_F_DOWN		0x00000010U
#define WILD_F_LOCKUP		0x00000020U	/* lock to prevent creation */
#define WILD_F_LOCKDOWN		0x00000040U

#define WILD_F_INVADERS		0x00000080U	/* (+) if unset, spawn some invaders */
#define WILD_F_HOME_OWNERS	0x00000100U	/* (+) if unset, respawn home-owners */
#define WILD_F_BONES		0x00000200U	/* (+) if unset, spawn some bones */
#define WILD_F_FOOD		0x00000400U	/* (+) if unset, spawn some food (not regrowing gardens, see below for that one) */
#define WILD_F_OBJECTS		0x00000800U	/* (+) if unset, spawn some objects */
#define WILD_F_CASH		0x00001000U	/* (+) if unset, spawn some cash */
#define WILD_F_GARDENS		0x00002000U	/* (+) if unset, regrow gardens */


/*** Features flags -- DG ***/
#define FF1_NO_WALK		0x00000001U
#define FF1_NO_VISION		0x00000002U /* unused*/
//HOLE^
#define FF1_CAN_FEATHER		0x00000004U
#define FF1_CAN_PASS		0x00000008U
#define FF1_FLOOR		0x00000010U
#define FF1_WALL		0x00000020U
#define FF1_PERMANENT		0x00000040U
#define FF1_CAN_LEVITATE	0x00000080U
#define FF1_REMEMBER		0x00000100U	/* Causes cave_plain_floor_grid() to be false, ie it's not a plain, boring grid but something to remember, ie getting/keeping CAVE_MARK. */
#define FF1_NOTICE		0x00000200U	/* Will be eligible target of 'l'ook command */
#define FF1_DONT_NOTICE_RUNNING	0x00000400U
#define FF1_CAN_RUN		0x00000800U
#define FF1_DOOR		0x00001000U
 #define FF1_SUPPORT_LIGHT	0x00002000U	/* -- currently NO EFFECT! -- */
//HOLE^
#define FF1_CAN_CLIMB		0x00004000U
#define FF1_TUNNELABLE		0x00008000U
#define FF1_WEB			0x00010000U
#define FF1_ALLOW_TELE		0x00020000U
#define FF1_SLOW_RUNNING_1	0x00040000U	/* half speed */
#define FF1_SLOW_RUNNING_2	0x00080000U	/* quarter speed */
#define FF1_SLOW_LEVITATING_1	0x00100000U
#define FF1_SLOW_LEVITATING_2	0x00200000U
#define FF1_SLOW_CLIMBING_1	0x00400000U
#define FF1_SLOW_CLIMBING_2	0x00800000U
#define FF1_SLOW_WALKING_1	0x01000000U
#define FF1_SLOW_WALKING_2	0x02000000U
#define FF1_SLOW_SWIMMING_1	0x04000000U
#define FF1_SLOW_SWIMMING_2	0x08000000U
#define FF1_PROTECTED		0x10000000U	/* monsters cannot teleport to nor spawn on this grid */
#define FF1_LOS			0x20000000U	/* can shoot/cast/throw through this one, but may not be able to walk through (FEAT_DARK_PIT) */
#define FF1_BLOCK_LOS		0x40000000U	/* can't shoot/cast/throw through this one, but may be able to walk through ('easy door') */
#define FF1_BLOCK_CONTACT	0x80000000U	/* like BLOCK_LOS, except players can see across it even if they cant attack (nor can monsters) */

/* for switching places with another player: */
#define FF1_SWITCH_MASK \
	(FF1_FLOOR | FF1_CAN_FEATHER | FF1_CAN_LEVITATE | FF1_CAN_RUN | FF1_CAN_CLIMB)


#define FF2_LAMP_LITE		0x00000001U	/* Gets coloured by wall_lighting. Implies SPECIAL_LITE. */
#define FF2_LAMP_LITE_SNOW	0x00000002U	/* Gets coloured by wall_lighting, if it's winter season, due to assumed snow-covering. Implies SPECIAL_LITE if successful. */
#define FF2_SPECIAL_LITE	0x00000004U	/* Gets coloured slate/gets slightly darkened by special fx: no LoS/no GLOW. This is implied by LAMP_LITE and successful LAMP_LITE_SNOW. */
#define FF2_NIGHT_DARK		0x00000008U	/* Stays darkened at night, unaffected by glow (magical light) or lite (lamps) */
#define FF2_NO_SHADE		0x00000010U	/* Don't shade to TERM_SLATE in view_shade_floor (or vault walls become indistinguishable from granite, without magic light) */
#define FF2_NO_LITE_WHITEN	0x00000020U	/* Won't change to WHITE or L_WHITE lamp light colour. For tiles that are affected from yellow light but retain their colour in white light. */
#define FF2_LAMP_LITE_OPTIONAL	0x00000040U	/* For more floor/wall grids: Get coloured by floor/wall_lighting, if user has toggled the according option. */
#define FF2_NO_ARTICLE		0x00000080U	/* floor feat doesn't have an article ('a(n)'/'the') in front of it when being described */
#define FF2_GLOW		0x00000100U	/* Always visible, lit via CAVE_GLOW. */
#define FF2_ENTER_FROM_SPECIAL	0x00000200U	/* This grid can only be entered if the player is standing on CAVE_ICKY or FF1_PROTECTED */
#define FF2_NO_PROB		0x00000400U	/* Don't allow probability travel onto this grid */
#define FF2_ATTR_MULTI		0x00000800U	/* Ignore feat's base colour, instead cycle through the S-line colours each time the player refreshes his view on the feat. */
#define FF2_SHINE		0x00001000U	/* Shines light on surrounding grids, causing (CAVE_GLOW_HACK | CAVE_GLOW) on them and itself, for permanent lighting. */
    /* TODO: unlight shine'd upon grids upon destruction of this grid; handle live-causes of LoS-blocking between this grid and the shine'd upon grids (eg someone tree'ing, quake..)! */
#define FF2_SHINE_FIRE		0x00002000U	/* Changes FF2_SHINE effect to fiery light (instead of neutral aka white light). */
#define FF2_SHINE2		0x00004000U	/* rad 2. Stacks with FF2_SHINE. */
//hole
#define FF2_BOUNDARY		0x80000000U	/* Is permanent wall that serves as boundary of a dungeon level - cannot even be crossed by admins */


/*** Dungeon type flags -- DG ***/

#define DF1_PRINCIPAL		0x00000001U	/* Is a principal dungeon --- These don't provide certain boni meant for incentivising visiting -- currently not impemented */
#define DF1_MAZE		0x00000002U	/* Is a maze-type dungeon */
#define DF1_SMALLEST		0x00000004U	/* Creates VERY small levels like The Maze */
#define DF1_SMALL		0x00000008U	/* Creates small levels like Dol Goldor */

#define DF1_BIG			0x00000010U	/* Creates big levels like Moria, and Angband dungeons */
#define DF1_NO_DOORS		0x00000020U	/* No doors on rooms, like Barrowdowns, Old Forest etc) */
#define DF1_WATER_RIVER		0x00000040U	/* Allow a single water streamer on a level */
#define DF1_LAVA_RIVER		0x00000080U	/* Allow a single lava streamer on a level */

#define DF1_WATER_RIVERS	0x00000100U	/* Allow multiple water streamers on a level */
#define DF1_LAVA_RIVERS		0x00000200U	/* Allow multiple lava streamers on a level */
#define DF1_CAVE		0x00000400U	/* Allow rooms */
#define DF1_CAVERN		0x00000800U	/* Allow cavern rooms */

#define DF1_NO_UP		0x00001000U	/* Disallow up stairs */
#define DF1_HOT			0x00002000U	/* Corpses on ground and in pack decay quicker through heat */
#define DF1_COLD		0x00004000U	/* Corpses on ground and in pack decay quicker through cold */
#define DF1_FORCE_DOWN		0x00008000U	/* No up stairs generated */

#define DF1_FORGET		0x00010000U	/* Features are forgotten, like the Maze and Illusory Castle */
#define DF1_NO_DESTROY		0x00020000U	/* No destroyed levels in dungeon */
#define DF1_SAND_VEIN		0x00040000U	/* Like in the sandworm lair */
#define DF1_CIRCULAR_ROOMS	0x00080000U	/* Allow circular rooms */

#define DF1_EMPTY		0x00100000U	/* All arena levels */
#define DF1_UNLISTED		0x00200000U	/* This dungeon won't be listed in players' dungeon lists (~8, cmd4.c) or info stores (eg mathom house, store.c) */
#define DF1_FLAT		0x00400000U	/* Creates paths to next areas at edge of level, like Barrowdowns */
#define DF1_TOWER		0x00800000U	/* You start at bottom and go up rather than the reverse */

#define DF1_RANDOM_TOWNS	0x01000000U	/* Allow random towns -- this flag is a relic and not implemented */
#define DF1_DOUBLE		0x02000000U	/* Creates double-walled dungeon like Helcaraxe and Erebor --- UNUSED */
#define DF1_LIFE_LEVEL		0x04000000U	/* Creates dungeon level on modified 'game of life' algorithm --- UH, CHECK */
#define DF1_EVOLVE		0x08000000U	/* Evolving, pulsing levels like Heart of the Earth --- UNUSED */

#define DF1_ADJUST_LEVEL_1	0x10000000U	/* Minimum monster level will be equal to dungeon level --- UNUSED */
#define DF1_ADJUST_LEVEL_2	0x20000000U	/* Minimum monster level will be double the dungeon level --- UNUSED */
#define DF1_NO_RECALL		0x40000000U	/* No recall allowed; also includes everything NO_RECALL_INTO does! */
#define DF1_NO_STREAMERS	0x80000000U	/* No streamers (water, lava, trees) */

/* all flags that may modify a custom 'wilderness' (type 0) dungeon's appearance, 'theming' it,
   without changing its main flags (set by admin on dungeon creation) too much */
#define DF1_THEME_MASK \
	(DF1_MAZE | DF1_SMALL | DF1_SMALLEST | DF1_BIG | DF1_NO_DOORS | DF1_WATER_RIVER | DF1_LAVA_RIVER | \
	DF1_WATER_RIVERS | DF1_WATER_RIVERS | DF1_CAVE | DF1_CAVERN | DF1_HOT | DF1_COLD | \
	DF1_FORGET | DF1_NO_DESTROY | DF1_SAND_VEIN | DF1_CIRCULAR_ROOMS | DF1_EMPTY | \
	DF1_DOUBLE | DF1_LIFE_LEVEL | DF1_EVOLVE | DF1_NO_STREAMERS)


/* dungeon flags for dungeon_type
 * they should be renamed to DFx_*
 */
/* XXX One problem - master-command from client can only handle flags
 * from 0x01 to 0x80!  FIXME
 */

/* Maybe better DF2_PRELOADED? */
#define DF2_RANDOM		0x00000001U /* random dungeon - not preloaded */
/* DF2_IRON => DF1_NO_RECALL + DF1_FORCE_DOWN */
#define DF2_IRON		0x00000002U /* one way dungeon - return portal at max level */
#define DF2_HELL		0x00000004U /* hellish dungeon - forces hellish mode on all */
/* DF2_NO_MAP => DF1_FORGET */
/*#define DF2_NO_MAP		0x00000008U *//* player never gains level knowledge */
#define DF2_NO_RECALL_INTO	0x00000008U /* Player may not recall downwards into this dungeon \
					       upwards into this tower. Added it especially for Nether Realm - C. Blue \
					       Note: this also prevents probability travel while inside, \
					             floating into it, and sending items via telekinesis, \
					             and it prevents ghost-floating deeper into it. */
#define DF2_NO_MAGIC_MAP	0x00000010U /* non magic-mappable */
#define DF2_MISC_STORES		0x00000020U /* spawn low-level dungeon stores such as under "RPG Server" rules */
#define DF2_TOWNS_IRONRECALL	0x00000040U /* DF2_IRON: if level allows premature recalling then it has a town */
#define DF2_NO_DEATH		0x00000080U /* death penalty is reduced */

#define DF2_IRONFIX1		0x00000100U /* DF2_IRON: but you may recall every 250 ft */
#define DF2_IRONFIX2		0x00000200U /* DF2_IRON: but you may recall every 500 ft */
#define DF2_IRONFIX3		0x00000400U /* DF2_IRON: but you may recall every 750 ft */
#define DF2_IRONFIX4		0x00000800U /* DF2_IRON: but you may recall every 1000 ft */

#define DF2_IRONRND1		0x00001000U /* DF2_IRON: but each dlvl has 20% chance of allowing recall */
#define DF2_IRONRND2		0x00002000U /* DF2_IRON: but each dlvl has 10% chance of allowing recall */
#define DF2_IRONRND3		0x00004000U /* DF2_IRON: but each dlvl has 7% chance of allowing recall */
#define DF2_IRONRND4		0x00008000U /* DF2_IRON: but each dlvl has 5% chance of allowing recall */

#define DF2_NO_ENTRY_STAIR	0x00010000U /* Can't be entered by staircases */
#define DF2_NO_ENTRY_WOR	0x00020000U /* Can't be entered by word-of-recall (plain and less restrictive than NO_RECALL_INTO) */
#define DF2_NO_ENTRY_PROB	0x00040000U /* Can't be entered by probability travel */
#define DF2_NO_ENTRY_FLOAT	0x00080000U /* Can't be entered by floating */

#define DF2_NO_EXIT_STAIR	0x00100000U /* Can't be exited by staircases */
#define DF2_NO_EXIT_WOR		0x00200000U /* Can't be exited by word-of-recall */
#define DF2_NO_EXIT_PROB	0x00400000U /* Can't be exited by probability travel */
#define DF2_NO_EXIT_FLOAT	0x00800000U /* Can't be exited by floating */

#define DF2_NO_STAIRS_UP	0x01000000U /* no '<' staircases inside */
#define DF2_NO_STAIRS_DOWN	0x02000000U /* no '>' staircases inside */
#define DF2_TOWNS_FIX		0x04000000U /* generated towns every n levels (for HUGE ironman) */
#define DF2_TOWNS_RND		0x08000000U /* generated towns with n% chance (for HUGE ironman) */

#define DF2_ADJUST_LEVEL_1_2	0x10000000U /* Minimum monster level will be half the dungeon level --- UNUSED */
#define DF2_NO_SHAFT		0x20000000U /* No shafts --- UNUSED (#if0'ed) */
#define DF2_ADJUST_LEVEL_PLAYER	0x40000000U /* Uses player level*2 instead of dungeon level for other ADJUST_LEVEL flags */
#define DF2_DELETED		0x80000000U /* Deleted, but not yet removed */

#define DF2_NO_ENTRY_MASK	(DF2_NO_ENTRY_STAIR | DF2_NO_ENTRY_WOR | DF2_NO_ENTRY_PROB | DF2_NO_ENTRY_FLOAT)
#define DF2_NO_EXIT_MASK	(DF2_NO_EXIT_STAIR | DF2_NO_EXIT_WOR | DF2_NO_EXIT_PROB | DF2_NO_EXIT_FLOAT)

/* all flags that may modify a custom 'wilderness' (type 0) dungeon's appearance, 'theming' it,
   without changing its main flags (set by admin on dungeon creation) too much */
#define DF2_THEME_MASK \
	(DF2_NO_MAGIC_MAP | \
	DF2_ADJUST_LEVEL_1_2)


/* moar flags */
#define DF3_JAIL_DUNGEON	0x00000001U	/* purpose is just to display the name "Jail Dungeon" in dungeon list */
#define DF3_HIDDENLIB		0x00000002U	/* allow generation of 'Hidden Library' dungeon store (added for IDDC) (overrides DF3_NO_SIMPLE_STORES) */
#define DF3_NO_SIMPLE_STORES	0x00000004U	/* disallow generation misc ironman helper stores and of low-level dungeon stores (was herbalist, but excluded it for now, so it may actually spawn in IDDC) (should be set for IDDC) */
#define DF3_NO_DUNGEON_BONUS	0x00000008U	/* This dungeon never yields bonus experience from dungeon_bonus[] (rare exploration) (should be set for IDDC) */

#define DF3_EXP_5		0x00000010U	/* Add +5% bonus to experience gains while inside this dungeon */
#define DF3_EXP_10		0x00000020U	/* Add +10% bonus to experience gains while inside this dungeon */
#define DF3_EXP_20		0x00000040U	/* Add +20% bonus to experience gains while inside this dungeon */
#define DF3_LUCK_1		0x00000080U	/* Add +1 luck while inside this dungeon */

#define DF3_LUCK_5		0x00000100U	/* Add +5 luck while inside this dungeon */
#define DF3_LUCK_20		0x00000200U	/* Add +20 luck while inside this dungeon */
#define DF3_LUCK_PROG_IDDC	0x00000400U	/* Add luck progressively while inside this dungeon, for Ironman Deep Dive Challenge */
#define DF3_SHORT_IDDC		0x00000800U	/* As theme in IDDC, this dungeon only has half as many floors as usual */

#define DF3_DERARE_MONSTERS	0x00001000U	/* Treat rarity of all monsters as '1' aka most common */
#define DF3_MANY_MONSTERS	0x00002000U	/* Spawn 1.5x as many monsters as usual */
#define DF3_VMANY_MONSTERS	0x00004000U	/* Spawn twice as many monsters as usual */
#define DF3_DEEPSUPPLY		0x00008000U	/* allow generation of dungeon stores offering supplies, on deep floors (added for IDDC) (overrides DF3_NO_SIMPLE_STORES) */

#define DF3_NO_WALL_STREAMERS	0x00010000U	/* No streamers (any wall types) */
#define DF3_NOT_EMPTY		0x00020000U	/* Disallow arena levels */
#define DF3_NOT_WATERY		0x00040000U	/* No 'watery' dungeon -> no water rivers */
#define DF3_FEW_ROOMS		0x00080000U	/* Less room_build() calls for any sort of struct (including vaults) */

#define DF3_NO_VAULTS		0x00100000U	/* Less room_build() calls for any sort of struct (including vaults) */
#define DF3_NO_MAZE		0x00200000U	/* don't build (perma)mazes */
#define DF3_NO_EMPTY		0x00400000U	/* don't build empty levels (arenas) */
#define DF3_NO_DESTROYED	0x00800000U	/* don't build 'destroyed' levels */

#define DF3_NO_TELE		0x01000000U	/* Disallow any teleportation (to go with NO_SUMMON -- for new experimental dungeoneering). Implies LF1_NO_MAGIC! */
#define DF3_NO_ESP		0x02000000U	/* Disallow any ESP */
#define DF3_NO_SUMMON		0x04000000U	/* Disallow any summoning (to go with NO_TELE -- for new experimental dungeoneering) */
#define DF3_LIMIT_ESP		0x08000000U	/* All ESP gets its range limited */

#define DF3_DARK		0x10000000U	/* All unlit levels */
#define DF3_NO_DARK		0x20000000U	/* Don't build unlit levels */
#define DF3_SALT_WATER		0x40000000U	/* Dungeon has salt water instead of freshwater */
#define DF3_CYCLIC_STAIRS	0x80000000U	/* Final level gets further stairs in dungeon's traversal direction generated that will lead out via (wpos-z-hack). This will inhibit LF1_IRON_RECALL flag! */

/* all flags that may modify a custom 'wilderness' (type 0) dungeon's appearance, 'theming' it,
   without changing its main flags (set by admin on dungeon creation) too much */
#define DF3_THEME_MASK \
	(DF3_DERARE_MONSTERS | DF3_MANY_MONSTERS | DF3_VMANY_MONSTERS | \
	DF3_NO_WALL_STREAMERS | DF3_NOT_EMPTY | DF3_NOT_WATERY | DF3_FEW_ROOMS | DF3_NO_VAULTS | DF3_NO_MAZE | DF3_NO_EMPTY | DF3_NO_DARK | DF3_NO_DESTROYED)


/* level flags for dun_level */
#define LF1_DUNGEON_TOWN	0x00000001U /* is a dungeon town! (why was there a flag hole at 0x1 here? oO) */
#define LF1_ASK_LEAVE		0x00000002U /* XXX */
#define LF1_NO_STAIR		0x00000004U /* XXX ok */
#define LF1_SPECIAL		0x00000008U /* XXX */

#define LF1_NO_NEW_MONSTER	0x00000010U /* XXX ok */
#define LF1_DESC		0x00000020U /* XXX */
#define LF1_NO_GENO		0x00000040U
#define LF1_NO_MAP		0x00000080U /* player never gains level knowledge */

#define LF1_NO_MAGIC_MAP	0x00000100U /* player never does magic mapping */
#define LF1_NO_DESTROY		0x00000200U /* Cannot use Destruction spells/Earthquakes */
#define LF1_NO_MAGIC		0x00000400U /* very nasty */
#define LF1_NO_GHOST		0x00000800U /* Players who die on this level are erased completely! */

#define LF1_IRON_RECALL		0x00001000U /* Recalling is allowed on this floor of an IRONMAN dungeon/tower */
#define LF1_RANDOM_TOWN		0x00002000U /* it's a random (dungeon) town (for tracking in IDDC) */
#define LF1_CUSTOM_GATEWAY	0x00004000U /* Marker that on this floor a custom gateway has been placed by a player (limiter) */
#define LF1_FAST_DIVE		0x00008000U /* Floor is in the process of being generated by a fast diver: ghost/probability travel */

#define LF1_WATER		0x01000000U	/* for DIGGING: water rivers or base grids are being used */
#define LF1_LAVA		0x02000000U	/* for DIGGING: lava rivers or base grids are being used */
#define LF1_NO_WATER		0x04000000U	/* for DIGGING: water rivers or base grids are being used */
#define LF1_NO_LAVA		0x08000000U	/* for DIGGING: lava rivers or base grids are being used */

#define LF1_DEEP_WATER		0x10000000U	/* Dungeon uses deep water as floor tile: Make all water streamers/rivers deep too */
#define LF1_DEEP_LAVA		0x20000000U	/* Dungeon uses deep lava as floor tile: Make all lava streamers/rivers deep too */
#define LF1_SPAWN_MARKER	0x40000000U	/* Mark that a special monster has already been spawned; Added for Nether Guards in the Nether Realm */
#define LF1_NO_MULTIPLY		0x80000000U /* for scrolls of vermin control */

#define LF1_FEELING_MASK \
	(LF1_NO_GENO | LF1_NO_MAP | LF1_NO_MAGIC_MAP | \
	 LF1_NO_DESTROY | LF1_NO_MAGIC | LF1_NO_GHOST)
/*
 * Possible flags for the future:
 *
 * (generation:)
 * LF1_ALL_PERMAWALL
 * LF1_WATERY
 * LF1_LAVA
 *
 * (gameplay:)
 */

/* extra level flags for dun_level -- for 'extra feeling' generation */
#define LF2_UNIQUE		0x00000001U	/* a unique monster has been generated */
#define LF2_OOD			0x00000002U	/* a freely roaming ood has been generated */
#define LF2_OOD_FREE		0x00000004U	/* a freely roaming ood has been generated */
#define LF2_OOD_HI		0x00000008U	/* a freely roaming ood has been generated */

#define LF2_VAULT		0x00000010U	/* a vault has been generated */
#define LF2_VAULT_OPEN		0x00000020U	/* a non-closed vault has been generated (ew) */
#define LF2_VAULT_HI		0x00000040U	/* a highly ood in vault been generated */
#define LF2_PITNEST		0x00000080U	/* pit/nest on level */

#define LF2_PITNEST_HI		0x00000100U	/* high threat pit/nest on level */
#define LF2_ITEM_OOD		0x00000200U	/* ood item on level */
#define LF2_ARTIFACT		0x00000400U	/* artifact on level */
#define LF2_INDOORS		0x00000800U	/* world surface (sector000 usually) is treated like a dungeon floor, causing no sun burn to vampires */

#define LF2_NO_RUN		0x00001000U	/* Cannot run on this level, walk only */
#define LF2_NO_TELE		0x00002000U	/* Cannot use phase/tele on this level */
#define LF2_NO_DETECT		0x00004000U	/* Cannot use detection on this level */
#define LF2_NO_ESP		0x00008000U	/* ESP is disabled on this level */

#define LF2_ESP			0x00010000U	/* Everyone on the level automatically gains full ESP */
#define LF2_NO_SPEED		0x00020000U	/* Everyone on the level moves at most at +0 speed */
#define LF2_NO_RES_HEAL		0x00040000U	/* Players on the level will have no elemental resistances/immunities and unable to utilise healing magic/potions */
#define LF2_LIMIT_ESP		0x00080000U	/* All ESP gets limited in range */

#define LF2_FAIR_TERRAIN_DAM	0x00100000U	/* Terain damage each player takes is roughly a fixed percentage of his max HP */
#define LF2_DUN_BOSS		0x00200000U
#define LF2_COLLAPSING		0x00400000U	/* audiovisual show when Zu-Aon is defeated ;) - C. Blue */
#define LF2_NO_SUMMON		0x00800000U	/* disallow any summoning (to go with NO_TELE :) for new experimental dungeoneering) */

#define LF2_NO_LIVE_SPAWN	0x01000000U	/* disallow any live-spawn of monsters (like in IDDC, could be used for that actually) */
#define LF2_NO_SPAWN		0x02000000U	/* disallow any monster spawn, even at level generation time. Monsters must be placed manually, hard-codedly, if desired. */
#define LF2_BROKEN		0x04000000U	/* Control generation of broken feats. */
#define LF2_NO_RUNES		0x08000000U	/* Disallow runes of protection on this floor */

#define LF2_CYCLIC_STAIRS	0x10000000U	/* This level (final level) will generate further stairs in dungeon traversal direction, leading out (via wpos-z-hack). This will inhibit LF1_IRON_RECALL flag! */
#define LF2_NO_MARTYR_SAC	0x20000000U	/* This level does not allow any divine/hellish favour: No Martyr/Blood Sacrifice */
#define LF2_NO_TRAPS		0x40000000U	/* Disallow any traps and monster traps on this floor */
#define LF2_STATIC		0x80000000U	/* Floor is static until this flag is cleared */


/* vault flags for v_info */
#define VF1_FORCE_FLAGS		0x00000001U
#define VF1_NO_TELEPORT		0x00000002U
#define VF1_NO_GENO		0x00000004U
#define VF1_NO_MAP		0x00000008U	/* player never gains level knowledge */

#define VF1_NO_MAGIC_MAP	0x00000010U	/* player never does magic mapping */
#define VF1_NO_DESTROY		0x00000020U
#define VF1_NO_MAGIC		0x00000040U /* very nasty */

#define VF1_NO_EASY_TRUEARTS	0x00100000U /* on shallow levels, this vault won't contain any truearts */
#define VF1_NO_EASY_RANDARTS	0x00200000U /* on shallow levels, this vault won't contain any randarts */
#define VF1_RARE_TRUEARTS	0x00400000U /* reduced chance to contain truearts */
#define VF1_RARE_RANDARTS	0x00800000U /* reduced chance to contain randarts */

#define VF1_NO_TRUEARTS		0x01000000U /* this vault won't contain any truearts (except if a monster drops one) */
#define VF1_NO_RANDARTS		0x02000000U /* this vault won't contain any randarts (except if a monster drops one) */

#define VF1_NO_PENETR		0x10000000U /* river/lava never penetrates vault */
#define VF1_HIVES		0x20000000U /* put same vaults like beehives */
#define VF1_NO_MIRROR		0x40000000U /* not suitable for mirroring */
#define VF1_NO_ROTATE		0x80000000U /* not suitable for rotation */



/*** ----- Macro Definitions ----- ***/


#ifdef CLIENT_SIDE
 /*
  * Hack -- Old-style names for X11 clients
  */
 #define term_screen	(ang_term[0])
 #define term_mirror	(ang_term[1])
 #define term_recall	(ang_term[2])
 #define term_choice	(ang_term[3])
 #define term_term_4	(ang_term[4])
 #define term_term_5	(ang_term[5])
 #define term_term_6	(ang_term[6])
 #define term_term_7	(ang_term[7])
 #define term_term_8	(ang_term[8])
 #define term_term_9	(ang_term[9])
#endif


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(IND, T) \
    (Players[IND]->obj_aware[(T)->k_idx])

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(IND, T) \
    (Players[IND]->obj_tried[(T)->k_idx])

/*
 * Determine if a given inventory item is "felt"
 */
#define object_felt_p(IND, T) \
    (Players[IND]->obj_felt[(T)->k_idx])
#define object_felt_heavy_p(IND, T) \
    (Players[IND]->obj_felt_heavy[(T)->k_idx])


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware" ( + not "Arts" nor "ego")
 */
#define object_known_p(IND, T) \
    (((T)->ident & ID_KNOWN) || \
     (k_info[(T)->k_idx].easy_know && Players[IND]->obj_aware[(T)->k_idx] && \
	 !(T)->name1 && !(T)->name2 && !(T)->name2b))

#define object_fully_known_p(IND, T) \
	(object_known_p(IND,T) && ((T)->ident & (ID_MENTAL | ID_NO_HIDDEN)))


/*
 * Return the "attr" for a given item.
 * Allow user redefinition of "aware" items.
 * Default to the "base" attr for unaware items
 */
#if 0
 #define object_attr(T) \
    ((k_info[(T)->k_idx].aware) ? \
     (k_info[(T)->k_idx].x_attr) : \
     (k_info[(T)->k_idx].d_attr))

 #define object_attr(T) \
    (k_info[(T)->k_idx].x_attr)

 #define object_attr(T) \
    (p_ptr->k_attr[(T)->k_idx])

#endif

#define object_attr(T) \
    ((p_ptr->obj_aware[(T)->k_idx]) ? \
     (p_ptr->k_attr[(T)->k_idx]) : \
     (p_ptr->d_attr[(T)->k_idx]))

/*
 * Return the "char" for a given item.
 * Allow user redefinition of "aware" items.
 * Default to the "base" char for unaware items
 */
#if 0
 #define object_char(T) \
    ((k_info[(T)->k_idx].aware) ? \
     (k_info[(T)->k_idx].x_char) : \
     (k_info[(T)->k_idx].d_char))

 #define object_char(T) \
    (k_info[(T)->k_idx].x_char)

 #define object_char(T) \
    (p_ptr->k_char[(T)->k_idx])
#endif

#define object_char(T) \
    ((p_ptr->obj_aware[(T)->k_idx]) ? \
     (p_ptr->k_char[(T)->k_idx]) : \
     (p_ptr->d_char[(T)->k_idx]))



/*
 * Artifacts use the "name1" field
 */
#define artifact_p(T) \
	((T)->name1 ? TRUE : FALSE)

#define true_artifact_p(T) \
	(artifact_p(T) && ((T)->name1 != ART_RANDART))

/* artifacts that aren't supposed to show up in non-admins' art lists */
#define admin_artifact_p(T) \
	((T)->name1 == ART_CLOAK_DM || (T)->name1 == ART_GOGGLES_DM || (T)->name1 == ART_SCYTHE_DM)

/* artifacts that can occur multiple times legally */
#define multiple_artifact_p(T) \
	((T)->name1 == ART_MORGOTH || (T)->name1 == ART_GROND || admin_artifact_p(T))

/* artifacts that as an exception can by used by winners -
   note that checking for both TR5_WINNERS_ONLY and the actual artifact idx' is redundant actually */
#define winner_artifact_p(T) \
	(true_artifact_p(T) && \
	((k_info[(T)->k_idx].flags5 & TR5_WINNERS_ONLY) || \
	(T)->name1 == ART_MORGOTH || (T)->name1 == ART_GROND || \
	(T)->name1 == ART_PHASING || \
	(T)->name1 == ART_MIRROROFGLORY || (T)->name1 == ART_DREADNOUGHT))

/* artifacts that cannot be deposited on an empty/deallocated dun/wild floor,
   nor being dropped inside houses (if cfg.anti_arts_hoard is on.) */
#define undepositable_artifact_p(T) \
	(true_artifact_p(T) && !multiple_artifact_p(T))

/* artifacts that are not reset on server artifact resets.
   NOTE: for winner_artefacts that AREN'T multiple_artifacts it's debatable! */
#define resettable_artifact_p(T) \
	(true_artifact_p(T) && !( \
	admin_artifact_p(T) || \
	(winner_artifact_p(T) && multiple_artifact_p(T)) \
	))

/* items that are supposed to act like artifacts in certain situations.
   Example: Stormbringer resists Nazgul, although it's just an ego item. */
#define like_artifact_p(T) \
	(artifact_p(T) || \
	((T)->name2 == EGO_STORMBRINGER) || ((T)->name2b == EGO_STORMBRINGER) \
	)

/* artifacts that cannot be destroyed by any means (especially RF2_KILL_ITEM/RF2_TAKE_ITEM except maybe by admin 'k'. */
#define indestructible_artifact_p(T) \
	((T)->name1 == ART_MORGOTH || (T)->name1 == ART_GROND || (T)->name1 == ART_PHASING || admin_artifact_p(T))

/* allow Ring of Phasing to be permanent until someone else beats Zu-Aon */
#define RING_OF_PHASING_NO_TIMEOUT


/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 || (T)->name2b ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define is_ego_p(T, e) \
	(((T)->name2 == (e)) || ((T)->name2b == (e)))
/*	((T)->name2 == (e)) */


/*
 * Broken items.
 */
#define broken_p(T) \
	((T)->ident & ID_BROKEN)

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->ident & ID_CURSED)



/*
 * Determines if a map location is fully inside the outer walls
 */
#define in_bounds(Y,X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < MAX_HGT - 1) && ((X) < MAX_WID - 1))

/*
 * Determines if a map location is on or inside the outer walls,
 * loosest check for seg fault */
#define in_bounds_array(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < MAX_HGT) && ((X) < MAX_WID))

/* replacement of in_bounds. */
#define in_bounds_floor(l_ptr,Y,X) \
   (l_ptr ? \
	(((Y) > 0) && ((X) > 0) && ((Y) < (l_ptr)->hgt - 1) && ((X) < (l_ptr)->wid - 1)) \
	: in_bounds(Y,X))

/*   (((Y) > 0) && ((X) > 0) && ((Y) < (l_ptr)->hgt) && ((X) < (l_ptr)->wid))  */

/* For dungeon decoration */
#define in_bounds_wide(Y,X) \
   (((Y) >= 2) && ((X) >= 2) && ((Y) < MAX_HGT - 2) && ((X) < MAX_WID - 2))

/* wilderness (world map sector) version of in_bounds */
#define in_bounds_wild(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < MAX_WILD_Y) && ((X) < MAX_WILD_X))


/*
 * Determines if a map location is currently "on screen" -RAK-
 * Note that "panel_contains(Y,X)" always implies "in_bounds2(Y,X)".
 */
#define panel_contains(Y,X) \
  (((Y) >= p_ptr->panel_row_min) && ((Y) <= p_ptr->panel_row_max) && \
   ((X) >= p_ptr->panel_col_min) && ((X) <= p_ptr->panel_col_max))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an extremely fast single bit check below.
 */
#define cave_floor_bold(ZCAVE,Y,X) \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR)

/* Adding FF1_LOS to have LOS across FEAT_DARK_PIT grids */
#define cave_los(ZCAVE,Y,X) \
	(((f_info[ZCAVE[Y][X].feat].flags1 & FF1_LOS) || (f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR)) && \
	!(f_info[ZCAVE[Y][X].feat].flags1 & FF1_BLOCK_LOS))

/* Complete check for projections/shots */
#define cave_contact(ZCAVE,Y,X) \
	(((f_info[ZCAVE[Y][X].feat].flags1 & FF1_LOS) || (f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR)) && \
	!(f_info[ZCAVE[Y][X].feat].flags1 & (FF1_BLOCK_LOS | FF1_BLOCK_CONTACT)))

/* a 'wall los' which ignores non-perma-walls (for los_wall()) */
#define cave_los_wall(ZCAVE,Y,X) \
	(!(f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT))
//hm, isn't this needed?:  || !(f_info[ZCAVE[Y][X].feat].flags1 & FF1_WALL))

/* Replaces cave_los() for projection-blockade checks, so project() can directly target
   certain wall-like feats that aren't really walls, such as mountains and trees */
#define cave_proj(ZCAVE,Y,X) \
	(cave_los(ZCAVE,Y,X) || \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_CAN_CLIMB) || \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_CAN_LEVITATE))

/*
#define cave_block_los(ZCAVE,Y,X) \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_BLOCK_LOS)*/

/* Is a grid any sort of removable wall? */
#define cave_dig_wall(ZCAVE,Y,X) \
	(!(f_info[ZCAVE[Y][X].feat].flags1 & (FF1_FLOOR | FF1_PERMANENT)))

/*
 * Determine if a "legal" grid is a "floor" grid or a passable grid
 * due to special abilities of a player, making it same to floor grid. (for run_test())
 * (NEW_RUNNING_FEAT)
92  == FEAT_DEAD_TREE
96  == FEAT_TREE
202 == FEAT_IVY
219 == FEAT_BUSH
84  == FEAT_SHAL_WATER
103 == FEAT_GLIT_WATER -- no, this is just wall/decoration
174 == FEAT_TAINTED_WATER
187 == FEAT_DEEP_WATER

97  == FEAT_MOUNTAIN
 */
#define cave_running_bold(p_ptr,ZCAVE,Y,X) \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) || \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_CAN_LEVITATE) && p_ptr->levitate) || \
	((ZCAVE[Y][X].feat == FEAT_DEAD_TREE || ZCAVE[Y][X].feat == FEAT_TREE || ZCAVE[Y][X].feat == FEAT_BUSH) && (p_ptr->pass_trees || p_ptr->levitate)) || /* fly is redundant, covered a line above */ \
	((ZCAVE[Y][X].feat == FEAT_SHAL_WATER || ZCAVE[Y][X].feat == FEAT_TAINTED_WATER || ZCAVE[Y][X].feat == FEAT_DEEP_WATER) && p_ptr->can_swim))
/* adding this to prevent annoying stops when running in barrow-downs while tree-passing --
   note last line, added for Paths of the Dead, allowing to run over pits */
#define cave_running_bold_notrees(p_ptr,ZCAVE,Y,X) \
	( ((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) || \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_CAN_LEVITATE) && p_ptr->levitate) || \
	((ZCAVE[Y][X].feat == FEAT_SHAL_WATER || ZCAVE[Y][X].feat == FEAT_TAINTED_WATER || ZCAVE[Y][X].feat == FEAT_DEEP_WATER) && p_ptr->can_swim)) \
	&& !(ZCAVE[Y][X].feat == FEAT_DEAD_TREE || ZCAVE[Y][X].feat == FEAT_TREE || ZCAVE[Y][X].feat == FEAT_BUSH || \
	    ZCAVE[Y][X].feat == FEAT_DARK_PIT) )
/* adding this to prevent annoying stops when running in barrow-downs while tree-passing --
   note last line, added for Paths of the Dead, so players running through hallways don't stop at pits */
#define cave_running_bold_trees(p_ptr,ZCAVE,Y,X) \
	(((ZCAVE[Y][X].feat == FEAT_DEAD_TREE || ZCAVE[Y][X].feat == FEAT_TREE || ZCAVE[Y][X].feat == FEAT_BUSH) && (p_ptr->pass_trees || p_ptr->levitate)) || \
	((ZCAVE[Y][X].feat == FEAT_DARK_PIT) && p_ptr->levitate))

/* for summoning on mountains */
#define cave_empty_mountain(ZCAVE,Y,X) \
    (cave_mountain_bold(ZCAVE,Y,X) && \
     !(ZCAVE[Y][X].m_idx))
#define cave_mountain_bold(ZCAVE,Y,X) \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_CAN_CLIMB)

/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 */
#define cave_clean_bold(ZCAVE,Y,X) \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) && \
	 !(f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT) && \
	 (ZCAVE[Y][X].o_idx == 0))
#if 0
    ((ZCAVE[Y][X].feat >= FEAT_FLOOR) && \
     (ZCAVE[Y][X].feat <= FEAT_MUD) && \
     (!ZCAVE[Y][X].o_idx))
/*     (ZCAVE[Y][X].feat <= FEAT_LOOSE_DIRT) && \   */
#endif	/* 0 */

/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid any player
 */
#define cave_empty_bold(ZCAVE,Y,X) \
    (cave_floor_bold(ZCAVE,Y,X) && \
     !(ZCAVE[Y][X].m_idx))

/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 * Line 3 -- forbid normal monsters
 * Line 4 -- forbid any player
 */
/* Hrm, the new one allows to create stairs/fountains etc on a open door.
 * Should it be banned? */
#define cave_naked_bold(ZCAVE,Y,X) \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) && \
	 !(f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT) && \
	  (ZCAVE[Y][X].o_idx == 0) && \
	  (ZCAVE[Y][X].m_idx == 0))
/* For teleportation maybe: allow landing on items? */
#define cave_free_bold(ZCAVE,Y,X) \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) && \
	 (!(f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT) || f_info[ZCAVE[Y][X].feat].flags1 & FF1_ALLOW_TELE) && \
	  (ZCAVE[Y][X].m_idx == 0))

#if 0
    ((ZCAVE[Y][X].feat >= FEAT_FLOOR) && \
     (ZCAVE[Y][X].feat <= FEAT_MUD) && \
     !(ZCAVE[Y][X].o_idx) && \
     !(ZCAVE[Y][X].m_idx))
/*     (ZCAVE[Y][X].feat <= FEAT_DIRT) && \ */
#endif	/* 0 */

#define cave_naked_bold2(Y,X) \
	((f_info[ZCAVE[Y][X].feat].flags1 & FF1_FLOOR) && \
	  (ZCAVE[Y][X].o_idx == 0) && \
	  (ZCAVE[Y][X].m_idx == 0))


/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1 -- perma-walls
 * Line 2-3 -- stairs
 * Line 4-5 -- shop doors
 * Lines 5-6 -- home doors
 */
#define cave_perma_bold(ZCAVE,Y,X) \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT)
#if 0
    ((ZCAVE[Y][X].feat >= FEAT_PERM_EXTRA) || \
     ((ZCAVE[Y][X].feat == FEAT_LESS) || \
      (ZCAVE[Y][X].feat == FEAT_MORE)) || \
     ((ZCAVE[Y][X].feat >= FEAT_SHOP_HEAD) && \
      (ZCAVE[Y][X].feat <= FEAT_SHOP_TAIL)) || \
     ((ZCAVE[Y][X].feat >= FEAT_HOME_HEAD) && \
			(ZCAVE[Y][X].feat <= FEAT_HOME_TAIL)))
#endif	/* 0 */

#define cave_perma_bold2(ZCAVE,Y,X) \
	 ((f_info[ZCAVE[Y][X].feat].flags1 & FF1_PERMANENT) && !(f_info[ZCAVE[Y][X].feat].flags1 & FF1_ALLOW_TELE))

/*
 * Is a given location "valid" for placing things?
 *
 * Permanent grids are never "valid" (see above).
 *
 * Hack -- a grid with an artifact in it is never valid.
 *
 * This function is often "combined" with "cave_floor_bold(Y,X)"
 * or one of the other similar macros above.
 *
 * Line 1 -- forbid perma-grids
 * Line 2-3 -- forbid grids containing artifacts
 * Line 4 -- forbit house doors
 */
#if 0	/* moved to cave.c */
 #define cave_valid_bold(ZCAVE,Y,X) \
    (!cave_perma_bold(ZCAVE,Y,X) && \
     (!ZCAVE[Y][X].o_idx || \
      !artifact_p(&o_list[ZCAVE[Y][X].o_idx])))
#endif	/* 0 */

/*
 * Grid based version of "cave_floor_bold()"
 */
#define cave_floor_grid(C) \
    (f_info[(C)->feat].flags1 & FF1_FLOOR)

/* Grid based version of "cave_dig_wall()" */
#define cave_dig_wall_grid(C) \
	(!(f_info[(C)->feat].flags1 & (FF1_FLOOR | FF1_PERMANENT)))

/*
 * Grid based version of "cave_floor_bold()"
 */
#define cave_los_grid(C) \
    (((f_info[(C)->feat].flags1 & FF1_FLOOR) || (f_info[(C)->feat].flags1 & FF1_LOS)) && \
    !(f_info[(C)->feat].flags1 & FF1_BLOCK_LOS))

/*
 * Grid based version of "cave_plain_floor_bold()"
 */
#define cave_plain_floor_grid(C) \
	((f_info[(C)->feat].flags1 & FF1_FLOOR) && \
	 !(f_info[(C)->feat].flags1 & FF1_REMEMBER))


/*
 * Grid based version of "cave_clean_bold()"
 */
#define cave_clean_grid(C) \
    ((f_info[(C)->feat].flags1 & FF1_FLOOR) && (!(C)->o_idx))
#if 0
    (((C)->feat >= FEAT_FLOOR) && \
     ((C)->feat <= FEAT_DIRT) && \
     (!(C)->o_idx))
#endif	/* 0 */

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid(C) \
    (cave_floor_grid(C) && \
     !((C)->m_idx))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_naked_grid(C) \
    ((f_info[(C)->feat].flags1 & FF1_FLOOR) && \
     !((C)->o_idx) && \
     !((C)->m_idx) && \
     !((C) == &cave[py][px]))
#if 0
    (((C)->feat >= FEAT_FLOOR) && \
     ((C)->feat <= FEAT_DIRT) && \
     !((C)->o_idx) && \
     !((C)->m_idx))
#endif	/* 0 */


/*
 * Grid based version of "cave_perma_bold()"
 */
#define cave_perma_grid(C) \
       (f_info[(C)->feat].flags1 & FF1_PERMANENT)
#if 0
    (((C)->feat >= FEAT_PERM_EXTRA) || \
     (((C)->feat == FEAT_LESS) || \
      ((C)->feat == FEAT_MORE)) || \
     (((C)->feat >= FEAT_SHOP_HEAD) && \
      ((C)->feat <= FEAT_SHOP_TAIL)))
#endif	/* 0 */


/*
 * Grid based version of "cave_valid_bold()"
 */
#define cave_valid_grid(C) \
    (!cave_perma_grid(C) && \
     (!(C)->o_idx || \
      !artifact_p(&o_list[(C)->o_idx])))



/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(IND,Y,X) \
    ((Players[IND]->cave_flag[Y][X] & CAVE_VIEW) != 0)




/*
 * Determine if a creature can enter a certain grid - C. Blue
 * Every check that would return a "do_move = TRUE" is added below.
 * The two checks that check whether do_move wouldn't be set to TRUE are left out for now,
 * those will remain in the according places in melee2.c.
 * One check that checks for an opposing player is also left out, since this function might
 * be used for pets/golem monsters.
 * Summary: This macro performs all checks which wouldn't do more than setting do_move = TRUE.
 *          The checks that do more than that (like setting did_pass_wall) are excluded.
 */

#define creature_can_enter(R,C) \
    (cave_floor_grid(C) || /* Floor is open? */ \
    (((f_info[(C)->feat].flags1 & FF1_CAN_FEATHER) && ((R)->flags7 & RF7_CAN_FLY)) || /* Some monsters can fly */ \
    ((f_info[(C)->feat].flags1 & FF1_CAN_LEVITATE) && ((R)->flags7 & RF7_CAN_FLY))) || \
    /* Some monsters live in the woods natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
    /* else if <<c_ptr->feat==FEAT_TREE || c_ptr->feat==FEAT_EVIL_TREE || */ \
    (((C)->feat == FEAT_DEAD_TREE || (C)->feat == FEAT_TREE || (C)->feat == FEAT_BUSH) && \
    (((R)->flags8 & RF8_WILD_WOOD) || ((R)->flags3 & RF3_ANIMAL) || \
    /* KILL_WALL / PASS_WALL  monsters can hack down / pass trees */ \
    ((R)->flags2 & RF2_PASS_WALL) || ((R)->flags2 & RF2_KILL_WALL) || \
    /* POWERFUL monsters can hack down trees */ \
    ((R)->flags2 & RF2_POWERFUL))) || \
    /* Spiders can of course pass webs.. */ \
    ((f_info[(C)->feat].flags1 & FF1_WEB) && ((R)->flags7 & RF7_SPIDER)) || \
    /* Some monsters live in the mountains natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
    (((C)->feat == FEAT_MOUNTAIN) && \
    (((R)->flags8 & RF8_WILD_MOUNTAIN) || ((R)->flags8 & RF8_WILD_VOLCANO) || ((R)->flags7 & RF7_CAN_CLIMB))))

    //((C)->m_idx < 0)) /* Player ghost in wall XXX */
    // (((c_ptr->feat != FEAT_SHOP) && /* Tavern entrance?(need GetCS to check that) // if (c_ptr->feat == FEAT_SHOP_TAIL - 1) */
    // ((m_ptr->ai_state & AI_STATE_EFFECT) || monster_is_safe(m_idx, m_ptr, r_ptr, c_ptr))) && /* Tainted grid? */

/*
 * Extended version of the above. This one is used in find_hiding and find_safety - C. Blue
 * This version includes a full movement check of all possible grids, EXCEPT for
 * shops, AI_STATE vs monster_is_safe, bashable/openable features (doors).
 */

#define creature_can_enter2(R,C) \
(cave_floor_grid(C) || /* Floor is open? */ \
(((f_info[(C)->feat].flags1 & FF1_CAN_FEATHER) && ((R)->flags7 & RF7_CAN_FLY)) || /* Some monsters can fly */ \
((f_info[(C)->feat].flags1 & FF1_CAN_LEVITATE) && ((R)->flags7 & RF7_CAN_FLY))) || \
/* Some monsters live in the woods natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
/* else if <<c_ptr->feat==FEAT_TREE || c_ptr->feat==FEAT_EVIL_TREE || */ \
(((C)->feat == FEAT_DEAD_TREE || (C)->feat == FEAT_TREE || (C)->feat == FEAT_BUSH) && \
(((R)->flags8 & RF8_WILD_WOOD) || ((R)->flags3 & RF3_ANIMAL) || \
/* KILL_WALL / PASS_WALL  monsters can hack down / pass trees */ \
((R)->flags2 & RF2_PASS_WALL) || ((R)->flags2 & RF2_KILL_WALL) || \
/* POWERFUL monsters can hack down trees */ \
((R)->flags2 & RF2_POWERFUL))) || \
/* Spiders can of course pass webs.. */ \
((f_info[(C)->feat].flags1 & FF1_WEB) && ((R)->flags7 & RF7_SPIDER)) || \
/* Some monsters live in the mountains natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
(((C)->feat == FEAT_MOUNTAIN) && \
(((R)->flags8 & RF8_WILD_MOUNTAIN) || ((R)->flags8 & RF8_WILD_VOLCANO) || ((R)->flags7 & RF7_CAN_CLIMB))) || \
/* Monster moves through walls (and doors) */ \
/*  -- added check whether it's actually a WALL, to prevent monsters from crossing terrain they don't like (eg lava) */ \
/*              else if (r_ptr->flags2 & RF2_PASS_WALL) */ \
((f_info[(C)->feat].flags1 & FF1_WALL) && (f_info[(C)->feat].flags1 & FF1_CAN_PASS) && ((R)->flags2 & (RF2_PASS_WALL))) || \
/* Monster can crush walls (note: Morgoth isn't taken into account here, shouldn't matter much though) */ \
/*  -- added check whether it's actually a WALL, to prevent monsters from crossing terrain they don't like (eg lava) */ \
((f_info[(C)->feat].flags1 & FF1_WALL) &&!(f_info[(C)->feat].flags1 & FF1_PERMANENT) && ((R)->flags2 & (RF2_KILL_WALL))) || \
(C)->feat == FEAT_MON_TRAP) /* Floor is trapped? */ \

/* Extended version of the above, again! This one is used for monsters utilising A* path-finding. - C. Blue
   This version really covers ALL grids that the monster could somehow enter: It includes doors too. */
#define creature_can_enter3(R,C) \
(cave_floor_grid(C) || /* Floor is open? */ \
(((f_info[(C)->feat].flags1 & FF1_CAN_FEATHER) && ((R)->flags7 & RF7_CAN_FLY)) || /* Some monsters can fly */ \
((f_info[(C)->feat].flags1 & FF1_CAN_LEVITATE) && ((R)->flags7 & RF7_CAN_FLY))) || \
/* Some monsters live in the woods natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
/* else if <<c_ptr->feat==FEAT_TREE || c_ptr->feat==FEAT_EVIL_TREE || */ \
(((C)->feat == FEAT_DEAD_TREE || (C)->feat == FEAT_TREE || (C)->feat == FEAT_BUSH) && \
(((R)->flags8 & RF8_WILD_WOOD) || ((R)->flags3 & RF3_ANIMAL) || \
/* KILL_WALL / PASS_WALL  monsters can hack down / pass trees */ \
((R)->flags2 & RF2_PASS_WALL) || ((R)->flags2 & RF2_KILL_WALL) || \
/* POWERFUL monsters can hack down trees */ \
((R)->flags2 & RF2_POWERFUL))) || \
/* Spiders can of course pass webs.. */ \
((f_info[(C)->feat].flags1 & FF1_WEB) && ((R)->flags7 & RF7_SPIDER)) || \
/* Some monsters live in the mountains natively - Should be moved to monster_can_cross_terrain (C. Blue) */ \
(((C)->feat == FEAT_MOUNTAIN) && \
(((R)->flags8 & RF8_WILD_MOUNTAIN) || ((R)->flags8 & RF8_WILD_VOLCANO) || ((R)->flags7 & RF7_CAN_CLIMB))) || \
/* Monster moves through walls (and doors) */ \
/*  -- added check whether it's actually a WALL, to prevent monsters from crossing terrain they don't like (eg lava) */ \
/*              else if (r_ptr->flags2 & RF2_PASS_WALL) */ \
((f_info[(C)->feat].flags1 & FF1_WALL) && (f_info[(C)->feat].flags1 & FF1_CAN_PASS) && ((R)->flags2 & (RF2_PASS_WALL))) || \
/* Monster can crush walls (note: Morgoth isn't taken into account here, shouldn't matter much though) */ \
/*  -- added check whether it's actually a WALL, to prevent monsters from crossing terrain they don't like (eg lava) */ \
((f_info[(C)->feat].flags1 & FF1_WALL) &&!(f_info[(C)->feat].flags1 & FF1_PERMANENT) && ((R)->flags2 & (RF2_KILL_WALL))) || \
(C)->feat == FEAT_MON_TRAP || /* Floor is trapped? */ \
((((c_ptr->feat >= FEAT_DOOR_HEAD) && (c_ptr->feat <= FEAT_DOOR_TAIL)) || (c_ptr->feat == FEAT_SECRET)) && ((R)->flags2 & (RF2_KILL_WALL | RF2_OPEN_DOOR))))


/* A wall that doesn't "fill" the grid completely, ie could be passed without
   wraithform provided the required tools/abilities. */
#define cave_passable(ZCAVE,Y,X) \
	(f_info[ZCAVE[Y][X].feat].flags1 & FF1_SWITCH_MASK)



/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif


/*** Color constants ***/

/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define BASE_PALETTE_SIZE 16	/* Basic palette size, of non-animated colours (TERM_MULTI being the first animated one) */
#ifdef EXTENDED_COLOURS_PALANIM
 #define CLIENT_PALETTE_SIZE (BASE_PALETTE_SIZE * 2)
#else
 #define CLIENT_PALETTE_SIZE BASE_PALETTE_SIZE
#endif

#define TERM_DARK	0	/* 'd' */	/* 0,0,0 */
#define TERM_WHITE	1	/* 'w' */	/* 4,4,4 */
#define TERM_SLATE	2	/* 's' */	/* 2,2,2 */
#define TERM_ORANGE	3	/* 'o' */	/* 4,2,0 */
#define TERM_RED	4	/* 'r' */	/* 3,0,0 */
#define TERM_GREEN	5	/* 'g' */	/* 0,2,1 */
#define TERM_BLUE	6	/* 'b' */	/* 0,0,4 */
#define TERM_UMBER	7	/* 'u' */	/* 2,1,0 */
#define TERM_L_DARK	8	/* 'D' */	/* 1,1,1 */
#define TERM_L_WHITE	9	/* 'W' */	/* 3,3,3 */
#define TERM_VIOLET	10	/* 'v' */	/* 4,0,4 */
#define TERM_YELLOW	11	/* 'y' */	/* 4,4,0 */
#define TERM_L_RED	12	/* 'R' */	/* 4,0,0 */
#define TERM_L_GREEN	13	/* 'G' */	/* 0,4,0 */
#define TERM_L_BLUE	14	/* 'B' */	/* 0,4,4 */
#define TERM_L_UMBER	15	/* 'U' */	/* 3,2,1 */

/* Non encoded shimmer attributes */
#define TERM_MULTI	16	/* all the main colours */
#define TERM_POIS	17	/* I Love this ;) */
#define TERM_FIRE	18	/* fireball */
#define TERM_COLD	19	/* cold */
#define TERM_ACID	20	/* acid, similar to darkness */
#define TERM_ELEC	21	/* elec */
#define TERM_CONF	22	/* umber/lumber */
#define TERM_SOUN	23	/* similar to lite */
#define TERM_SHAR	24	/* umber/slate */
#define TERM_LITE	25	/* similar to sound */
#define TERM_DARKNESS	26	/* similar to acid */

#define TERM_SHIELDM	27	/* mana shield */
#define TERM_SHIELDI	28	/* invulnerability */

#ifdef EXTENDED_TERM_COLOURS
 #define TERM_CURSE	29
 #define TERM_ANNI	30
#endif

#define TERM_HALF	31	/* only the brighter colours */

#ifdef EXTENDED_TERM_COLOURS
 #define TERM_OLD_BNW	0x20	/* 32: black & white MASK, for admin wizards */
 #define TERM_OLD_PVP	0x40	/* 64: black & red MASK, for active PvP-hostility (or stormbringer) */

 #define TERM_PSI	32
 #define TERM_NEXU	33
 #define TERM_NETH	34
 #define TERM_DISE	35
 #define TERM_INER	36
 #define TERM_FORC	37
 #define TERM_GRAV	38
 #define TERM_TIME	39
 #define TERM_METEOR	40
 #define TERM_MANA	41
 #define TERM_DISI	42
 #define TERM_WATE	43
 #define TERM_ICE	44
 #define TERM_PLAS	45
 #define TERM_DETO	46
 #define TERM_NUKE	47
 #define TERM_UNBREATH	48
 #define TERM_HOLYORB	49
 #define TERM_HOLYFIRE	50
 #define TERM_HELLFIRE	51
 #define TERM_THUNDER	52

 #define TERM_LAMP	53
 #define TERM_LAMP_DARK	54

 #define TERM_EMBER	55

 #ifdef ATMOSPHERIC_INTRO
  #define TERM_FIRETHIN	56
 #endif

 #define TERM_STARLITE	57
 #define TERM_HAVOC	58

 #define TERM_SELECTOR	59
 #define TERM_SMOOTHPAL	60
 #define TERM_SEL_RED	61
 #define TERM_SEL_BLUE	62
 #define TERM_SRCLITE	63	/* Looking for the watcher in the sky */

 #ifdef EXTENDED_COLOURS_PALANIM
  #define TERMA_OFFSET	64
  /* Clones of the 16 default colours, aka 'really used' colours (non-compounds), for palette animation. */
  #define TERMA_DARK	64
  #define TERMA_WHITE	65
  #define TERMA_SLATE	66
  #define TERMA_ORANGE	67
  #define TERMA_RED	68
  #define TERMA_GREEN	69
  #define TERMA_BLUE	70
  #define TERMA_UMBER	71
  #define TERMA_L_DARK	72
  #define TERMA_L_WHITE	73
  #define TERMA_VIOLET	74
  #define TERMA_YELLOW	75
  #define TERMA_L_RED	76
  #define TERMA_L_GREEN	77
  #define TERMA_L_BLUE	78
  #define TERMA_L_UMBER	79

  /* Problem: Not enough colours! So we need to change these masks to actual colours. */
  #define TERM_BNW	120	/* black & white, for admin wizards and pandas */
  #define TERM_BNWM	121	/* black & white + holyfire, for martyr */
  #define TERM_BNWSR	122	/* black & white + blue, for shadow running */
  #define TERM_BNWKS	123	/* black & white + psi, for kinetic shield */
  #define TERM_BNWKS2	124	/* black & white + orange, for kinetic shield running out */
  #define TERM_PVPBB	125	/* black/slate/yellow, for bloodbond */
  #define TERM_PVP	126	/* black/yellow/red, for active PvP-hostility (or stormbringer) */
  #define TERM_RESERVED	127	/* since 0xFF is reserved for RLE and 0x80 is for hilite_player, we need to reserve this colour too, so it won't get combined with 0x80 ever. */
  /* For comeback of hilite_player in 4.7.3: */
  #define TERM_HILITE_PLAYER	0x80	/* 128 */
  /* ..for compatibility with old clients: */
  #define TERM_OLD2_BNW	0x40	/* 64: black & white MASK, for admin wizards */
  #define TERM_OLD2_PVP	0x80	/* 128: black & red MASK, for active PvP-hostility (or stormbringer) */
  /* ..for more backward compatibility: */
  #define TERM_OLD3_BNW		248	/* black & white, for admin wizards and pandas */
  #define TERM_OLD3_BNWM	249	/* black & white + holyfire, for martyr */
  #define TERM_OLD3_BNWSR	250	/* black & white + blue, for shadow running */
  #define TERM_OLD3_BNWKS	251	/* black & white + psi, for kinetic shield */
  #define TERM_OLD3_BNWKS2	252	/* black & white + orange, for kinetic shield running out */
  #define TERM_OLD3_PVPBB	253	/* black/slate/yellow, for bloodbond */
  #define TERM_OLD3_PVP		254	/* black/yellow/red, for active PvP-hostility (or stormbringer) */
  /* Note: 0xFF (255) is reserved for RLE, see Send_line_info(). */
  #define TERM_RESERVED_RLE	255
 #else
  #define TERM_BNW	0x40	/* 64: black & white MASK, for admin wizards */
  #define TERM_PVP	0x80	/* 128: black & red MASK, for active PvP-hostility (or stormbringer) */
 #endif
#else
 #define TERM_BNW	0x20	/* 32: black & white MASK, for admin wizards */
 #define TERM_PVP	0x40	/* 64: black & red MASK, for active PvP-hostility (or stormbringer) */
 /* Reserved attr values - do not exceed */
 #define TERM_RESERVED	0x80	/* 128 */
#endif
#ifdef EXTENDED_BG_COLOURS
 #define TERMX_START	80
 #define TERMX_AMT	7
 #define TERMX_BLUE	80
 #define TERMX_GREEN	81
 #define TERMX_RED	82
 #define TERMX_YELLOW	83
 #define TERMX_GREY	84
 #define TERMX_WHITE	85
 #define TERMX_PURPLE	86
#endif


/*** Graphics constants ***/
/* All terminal characters above this value will be drawn as pictures if term has 'higher_pict' attribute set. */
/* If you want to change to higher value, additional changes to code will be needed (z-term/text_hook, ...). */
#define MAX_FONT_CHAR 255

/* Font hacks - note that the X11 hacks do not work on terminal/command-line
   clients (GCU) and neither on OSX clients that don't support X11! - C. Blue */
#define FONT_MAP_SOLID_WIN	127	/* Drawn as a solid block, for walls/bars */
#define FONT_MAP_SOLID_X11	2	/* Drawn as a solid block, for walls/bars */
#define FONT_MAP_VEIN_WIN	1	/* Drawn as a diamond, for walls/bars */
#define FONT_MAP_VEIN_X11	1	/* Drawn as a diamond, for walls/bars */


/*** Sound constants ***/
/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT	1
#define SOUND_MISS	2
#define SOUND_FLEE	3
#define SOUND_DROP	4
#define SOUND_KILL	5
#define SOUND_LEVEL	6
#define SOUND_DEATH	7
#define SOUND_WARN	8
/*
 * Mega-Hack -- maximum known sounds
 */
#define SOUND_MAX	8


/* New sound system I added in 2010, using SDL, and in 2022 migrated to SDL2. - C. Blue
   The above sound constants of the old system have no meaning anymore if this is active. */
#ifdef USE_SOUND_2010
 /* Volume sliders all go from 0 to 100, with [70] being default */
 #define AUDIO_VOLUME_DEFAULT 70

 #define SOUND_MAX_2010	400 /*for experimenting purpose - C. Blue*/
 #define MUSIC_MAX	200 /*for experimenting purpose - C. Blue*/

 /* for ovl_sfx_.. client options */
 #define SFX_TYPE_ATTACK	0
 #define SFX_TYPE_COMMAND	1
 #define SFX_TYPE_MISC		2
 #define SFX_TYPE_MON_ATTACK	3
 #define SFX_TYPE_MON_SPELL	4
 #define SFX_TYPE_MON_MISC	5
 #define SFX_TYPE_NO_OVERLAP	6
 /* special sound fx that "belong" to the looped background channel for
    'weather' or for 'ambient' sounds, yet use the normal sfx channels
    because they're one-time only: */
 #define SFX_TYPE_WEATHER	7	/* sfx uses 'weather' mixer settings instead of 'sound' */
 #define SFX_TYPE_AMBIENT	8
 #define SFX_TYPE_STOP		9	/* stop playing this sfx, if it is. stop playing any SFX_TYPE_NO_OVERLAP sfx if no sfx is specified. */
 #define SFX_TYPE_AMBIENT_LOCAL	10	/* Play a looping, local ambient sound effect, that changes panning for each player accordingly to their positions */

 /* new in 2013: for dedicated ambient sound fx channel only (inn fireplace!) -- all 'persistent' ambient sfx. */
 #define SFX_AMBIENT_NONE	-1
 #define SFX_AMBIENT_FIREPLACE	0
 #define SFX_AMBIENT_SHORE	1
 #define SFX_AMBIENT_LAKE	2
 #define SFX_AMBIENT_STORE_GENERAL	3
 #define SFX_AMBIENT_STORE_ARMOUR	4
 #define SFX_AMBIENT_STORE_WEAPON	5
 #define SFX_AMBIENT_STORE_TEMPLE	6
 #define SFX_AMBIENT_STORE_ALCHEMY	7
 #define SFX_AMBIENT_STORE_MAGIC	8
 #define SFX_AMBIENT_STORE_BLACK	9
 #define SFX_AMBIENT_STORE_BOOK		10
 #define SFX_AMBIENT_STORE_RUNE		11
 #define SFX_AMBIENT_STORE_MERCHANTS	12
 #define SFX_AMBIENT_STORE_OFFICIAL	13
 #define SFX_AMBIENT_STORE_CASINO	14
 #define SFX_AMBIENT_STORE_MISC		15

 /* Reduction in percent (on linear scale) of ambient/weather sfx
    depending on which grid the player is on (ie inside house or outside): [40] */
 #define GRID_SFX_REDUCTION	50

 /* Play slightly quieter shriek sfx to not blast people's ear drums =P [0..100] */
 #define SFX_SHRIEK_VOLUME	50
#endif


/*
 * Hack -- attempt to reduce various values
 */
#ifdef ANGBAND_LITE
 #undef MACRO_MAX
 #define MACRO_MAX	128
 #undef QUARK_MAX
 #define QUARK_MAX	128
 #undef MESSAGE_MAX
 #define MESSAGE_MAX	128
 #undef MESSAGE_BUF
 #define MESSAGE_BUF	4096
 #undef MESSAGE_HISTORY
 #define MESSAGE_HISTORY	30
#endif



/*
 * Ghost spell "realm"
 */
#define GHOST_SPELLS	7

/* Kings/Queens abilities */
#define KING_OWN	0

/* Generic temporary weapon branding, currently only used for melee weapons */
#define TBRAND_ELEC		0x0001
#define TBRAND_COLD		0x0002
#define TBRAND_FIRE		0x0004
#define TBRAND_ACID		0x0008
#define TBRAND_POIS		0x0010
//unused/not fully implemented:
#define TBRAND_BASE		(TBRAND_ELEC | TBRAND_COLD | TBRAND_FIRE | TBRAND_ACID)
#define TBRAND_CHAO		0x0020
#define TBRAND_VORP		0x0040
#define TBRAND_BALL_FIRE	0x0080
#define TBRAND_BALL_COLD	0x0100
#define TBRAND_BALL_ELEC	0x0200
#define TBRAND_BALL_ACID	0x0400
#define TBRAND_BALL_SOUN	0x0800
//hereticism:
#define TBRAND_HELLFIRE		0x1000
//unlife:
#define TBRAND_VAMPIRIC		0x2000
//aura of death: -- (these are not applied via set_..._brand() functions, and not implemented for arrow_brand, only melee.)
#define TBRAND_ICE		0x4000	/* note: no cut effect! */
#define TBRAND_PLASMA		0x8000	/* note: no stun effect! */

/* Client modes (e) */
#define CLIENT_NORMAL		0x0000
#define CLIENT_PARTY		0x0001

/* Diff mode (type is 'byte') */
#define MODE_NORMAL		0x0000	/* WARNING: This flag is ONLY valid to use in comparisons against MODE_MASK'ed mode flags! */
#define MODE_SOLO		0x0001	/* Soloist mode: Unworldly and cannot trade with anybody. */
# define MODE_MALE_OLD		0x0001	/* (flag kept atm for backward compat <= 4.7.1.1) */

#define MODE_HARD		0x0002	/* Player-flag only (not for items): Penalized */
#define MODE_NO_GHOST		0x0004	/* Player-flag only (not for items): traditional 'hellish' is 3 */
#define MODE_EVERLASTING	0x0008	/* Player and item flag: No death counter */
#define MODE_PVP		0x0010	/* Player and item flag: Specific PvP-mode character/item. */

#define MODE_XXX		0x0020	/* UNUSED //hole */
# define MODE_FRUIT_BAT_OLD	0x0020	/* (flag kept atm for backward compat <= 4.7.1.1) */

#define MODE_DED_IDDC		0x0040	/* Dedicated extra character slot for Ironman Deep Dive Challenge */
#define MODE_DED_PVP		0x0080	/* Dedicated extra character slot for PvP-mode */

/* Temporary control flags only used during char creation.
   NOTE: modes are u16b (were bytes even), but 'connp->sex' is int (and sex/dna_sex are s16b on client-side), so this is ok for just that purpose! */
#define MODE_MALE		0x0100
#define MODE_FRUIT_BAT		0x0200
#define MODE_DED_IDDC_OK	0x0400
#define MODE_DED_PVP_OK		0x0800

#define MODE_STARTER_ITEM	0x1000	/* Items only: Mark as 'starter item', making it potentially unsalable, depending on server settings. */

#define MODE_MASK		(MODE_SOLO | MODE_HARD | MODE_NO_GHOST | MODE_EVERLASTING | MODE_PVP)       /* "real" character modes, rather than 'softer modifiers' */



/* Monk martial arts... */
#define MAX_NONWINNER_MA	17 /* total_winners can use more techniques, see next line.. */
#define MAX_MA			19 /* total_winners have access to all techniques */
#define MA_KNEE			1
#define MA_SLOW			2
#define MA_ROYAL_SLOW		3


/* Mental links */
#define LINK_NONE		0
#define LINK_DOMINANT		1
#define LINK_DOMINATED		2

#define LINKF_VIEW		0x0001 /* Share view */
#define LINKF_MOV		0x0002 /* Share movments */
#define LINKF_PAIN		0x0004 /* Share hp & xp */
#define LINKF_OBJ		0x0008 /* Share obj things */
#define LINKF_MISC		0x0010 /* Share misc things */
#define LINKF_OPEN		0x0020 /* Mind Open */
/* Ready to receive items via telekinesis -
   to prevent exploiting this for PK! - C. Blue: */
#define LINKF_TELEKIN		0x0040
/* Additional link flags */
#define LINKF_HIDDEN		0x0080 /* No link status messages */
#define LINKF_VIEW_DEDICATED	0x0100 /* View dedicated for watching other player */
#define LINKF_MSG		0x0200 /* Share non-chat messages */
#define LINKF_CHAT		0x0400 /* Share chat messages */


/* Monster gaining levels */
#define MONSTER_LEVEL_MAX	500
#define MONSTER_TOO_WEAK	50
#define MONSTER_EXP(level)	((((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * (((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * (((level) > MONSTER_LEVEL_MAX)?MONSTER_LEVEL_MAX:(level)) * 9)
/* R_INFO is obsolete; use race_inf instead.	- Jir -	*/
#define R_INFO(m_ptr)		(r_info_get(m_ptr))

/*
 * Golem defines
 */
#define GOLEM_NONE		0x00
#define GOLEM_ATTACK		0x01
#define GOLEM_FOLLOW		0x02
#define GOLEM_GUARD		0x04

/* Mind defines (non-golem/pet monsters that have AI_HYBRID) - C. Blue */
#define HYBRID_NORMAL		0x0
#define HYBRID_ANNOY		0x1

/*
 * Monster AI-state defines	- Jir -
 */
#define AI_STATE_EFFECT		0x0001 /* monster wants to avoid a quite harmful GF_ effect on a grid */
#define AI_STATE_TERRAIN	0x0002
/*
#define AI_STATE_ANNOY		0x0004
#define AI_STATE_RUN		0x0008
*/

/*
 * Utility
 */
#define BITS(x)  (1 << (x))

/* Ego monsters defines from PernA	- Jir - */
#define MEGO_CHAR_ANY		127 /* note: also used for 'attr's */
#define MEGO_ADD		0
#define MEGO_SUB		1
#define MEGO_FIX		2
#define MEGO_PRC		3


/* pfft */
/* #define race_inf(m_ptr) (race_info_idx((m_ptr)->r_idx, (m_ptr)->ego, (m_ptr)->name3))
 */
#define race_inf(m_ptr) r_info_get(m_ptr)

/* wpos to old-fashioned wilderness 'height' */
/* #define wild_idx(p_ptr) (p_ptr->wpos.wx+p_ptr->wpos.wy*MAX_WILD_X); */
/* #define wild_idx(wpos) ((wpos).wx + (wpos).wy * MAX_WILD_X); */

/*
 * traps ported from PernAngband...
 * Hats off to the precedent coders!	- Jir -
 */
/* jk */
#define FTRAP_CHEST		0x00000001U /* may appear on chests */
#define FTRAP_DOOR		0x00000002U /* may appear on doors/floors */
#define FTRAP_FLOOR		0x00000004U /* may appear on floor */
#define FTRAP_CHANGE		0x00000008U /* Color changing */
#define FTRAP_SPECIAL_GENE	0x00000010U /* Dont randomly generate */
#define FTRAP_LEVEL_GEN		0x00000020U
#define FTRAP_XXX7		0x00000040U
#define FTRAP_XXX8		0x00000080U
#define FTRAP_XXX9		0x00000100U
#define FTRAP_XXX10		0x00000200U
#define FTRAP_XXX11		0x00000400U
#define FTRAP_XXX12		0x00000800U
#define FTRAP_XXX13		0x00001000U
#define FTRAP_XXX14		0x00002000U
#define FTRAP_XXX15		0x00004000U
#define FTRAP_XXX16		0x00008000U
#define FTRAP_LEVEL1		0x00010000U /* low level ball/bolt trap */
#define FTRAP_LEVEL2		0x00020000U /* medium level ball/bolt trap */
#define FTRAP_LEVEL3		0x00040000U /* high level ball/bolt trap */
#define FTRAP_LEVEL4		0x00080000U /* oops level ball/bolt trap */
#define FTRAP_XXX21		0x00100000U
#define FTRAP_XXX22		0x00200000U
#define FTRAP_XXX23		0x00400000U
#define FTRAP_XXX24		0x00800000U
#define FTRAP_XXX25		0x01000000U
#define FTRAP_XXX26		0x02000000U
#define FTRAP_XXX27		0x04000000U
#define FTRAP_XXX28		0x08000000U
#define FTRAP_XXX29		0x10000000U
#define FTRAP_XXX30		0x20000000U
#define FTRAP_EASY_ID		0x40000000U
#define FTRAP_NO_ID		0x80000000U	/* nominally implemented (but not used) */

/* jk */
#define STAT_DEC_TEMPORARY	1
#define STAT_DEC_NORMAL		2
#define STAT_DEC_PERMANENT	3

/* jk - which trap is which number */
#define TRAP_OF_WEAKNESS_I		1
#define TRAP_OF_WEAKNESS_II		2
#define TRAP_OF_WEAKNESS_III		3
#define TRAP_OF_INTELLIGENCE_I		4
#define TRAP_OF_INTELLIGENCE_II		5
#define TRAP_OF_INTELLIGENCE_III	6
#define TRAP_OF_WISDOM_I		7
#define TRAP_OF_WISDOM_II		8
#define TRAP_OF_WISDOM_III		9
#define TRAP_OF_FUMBLING_I		10
#define TRAP_OF_FUMBLING_II		11
#define TRAP_OF_FUMBLING_III		12
#define TRAP_OF_WASTING_I		13
#define TRAP_OF_WASTING_II		14
#define TRAP_OF_WASTING_III		15
#define TRAP_OF_BEAUTY_I		16
#define TRAP_OF_BEAUTY_II		17
#define TRAP_OF_BEAUTY_III		18

#define TRAP_OF_CURSE_WEAPON		20
#define TRAP_OF_CURSE_ARMOR		21
#define TRAP_OF_EARTHQUAKE		22
#define TRAP_OF_POISON_NEEDLE		23
#define TRAP_OF_SUMMON_MONSTER		24
#define TRAP_OF_SUMMON_UNDEAD		25
#define TRAP_OF_SUMMON_GREATER_UNDEAD	26
#define TRAP_OF_TELEPORT		27
#define TRAP_OF_PARALYZING		28
#define TRAP_OF_EXPLOSIVE_DEVICE	29
#define TRAP_OF_TELEPORT_AWAY		30
#define TRAP_OF_LOSE_MEMORY		31
#define TRAP_OF_BITTER_REGRET		32
#define TRAP_OF_BOWEL_CRAMPS		33
#define TRAP_OF_BLINDNESS_CONFUSION	34
#define TRAP_OF_AGGRAVATION		35
#define TRAP_OF_MULTIPLICATION		36
#define TRAP_OF_STEAL_ITEM		37
#define TRAP_OF_SUMMON_FAST_QUYLTHULGS	38
#define TRAP_OF_SINKING			39
#define TRAP_OF_MANA_DRAIN		40
#define TRAP_OF_MISSING_MONEY		41
#define TRAP_OF_NO_RETURN		42
#define TRAP_OF_SILENT_SWITCHING	43
#define TRAP_OF_WALLS			44
#define TRAP_OF_CALLING_OUT		45
#define TRAP_OF_SLIDING			46
#define TRAP_OF_CHARGES_DRAIN		47
#define TRAP_OF_STAIR_MOVEMENT		48
#define TRAP_OF_NEW			49
#define TRAP_OF_SCATTER_ITEMS		50
#define TRAP_OF_DECAY			51
#define TRAP_OF_WASTING_WANDS		52
#define TRAP_OF_FILLING			53
#define TRAP_OF_DRAIN_SPEED		54

#define TRAP_OF_ELEC_BOLT		60
#define TRAP_OF_POIS_BOLT		61
#define TRAP_OF_ACID_BOLT		62
#define TRAP_OF_COLD_BOLT		63
#define TRAP_OF_FIRE_BOLT		64
#define TRAP_OF_PLASMA_BOLT		65
#define TRAP_OF_WATER_BOLT		66
#define TRAP_OF_LITE_BOLT		67
#define TRAP_OF_DARK_BOLT		68
#define TRAP_OF_SHARDS_BOLT		69
#define TRAP_OF_SOUND_BOLT		70
#define TRAP_OF_CONFUSION_BOLT		71
#define TRAP_OF_FORCE_BOLT		72
#define TRAP_OF_INERTIA_BOLT		73
#define TRAP_OF_MANA_BOLT		74
#define TRAP_OF_ICE_BOLT		75
#define TRAP_OF_CHAOS_BOLT		76
#define TRAP_OF_NETHER_BOLT		77
#define TRAP_OF_DISENCHANT_BOLT		78
#define TRAP_OF_NEXUS_BOLT		79
#define TRAP_OF_TIME_BOLT		80
#define TRAP_OF_GRAVITY_BOLT		81

#define TRAP_OF_ELEC_BALL		82
#define TRAP_OF_POIS_BALL		83
#define TRAP_OF_ACID_BALL		84
#define TRAP_OF_COLD_BALL		85
#define TRAP_OF_FIRE_BALL		86
#define TRAP_OF_PLASMA_BALL		87
#define TRAP_OF_WATER_BALL		88
#define TRAP_OF_LITE_BALL		89
#define TRAP_OF_DARK_BALL		90
#define TRAP_OF_SHARDS_BALL		91
#define TRAP_OF_SOUND_BALL		92
#define TRAP_OF_CONFUSION_BALL		93
#define TRAP_OF_FORCE_BALL		94
#define TRAP_OF_INERTIA_BALL		95
#define TRAP_OF_MANA_BALL		96
#define TRAP_OF_ICE_BALL		97
#define TRAP_OF_CHAOS_BALL		98
#define TRAP_OF_NETHER_BALL		99
#define TRAP_OF_DISENCHANT_BALL		100
#define TRAP_OF_NEXUS_BALL		101
#define TRAP_OF_TIME_BALL		102
#define TRAP_OF_GRAVITY_BALL		103

#define TRAP_OF_ARROW_I			110
#define TRAP_OF_ARROW_II		111
#define TRAP_OF_ARROW_III		112
#define TRAP_OF_ARROW_IV		113
#define TRAP_OF_POISON_ARROW_I		114
#define TRAP_OF_POISON_ARROW_II		115
#define TRAP_OF_POISON_ARROW_III	116
#define TRAP_OF_POISON_ARROW_IV		117
#define TRAP_OF_DAGGER_I		118
#define TRAP_OF_DAGGER_II		119
#define TRAP_OF_POISON_DAGGER_I		120
#define TRAP_OF_POISON_DAGGER_II	121
#define TRAP_OF_ARROWS_I		122
#define TRAP_OF_ARROWS_II		123
#define TRAP_OF_ARROWS_III		124
#define TRAP_OF_ARROWS_IV		125
#define TRAP_OF_POISON_ARROWS_I		126
#define TRAP_OF_POISON_ARROWS_II	127
#define TRAP_OF_POISON_ARROWS_III	128
#define TRAP_OF_POISON_ARROWS_IV	129
#define TRAP_OF_DAGGERS_I		130
#define TRAP_OF_DAGGERS_II		131
#define TRAP_OF_POISON_DAGGERS_I	132
#define TRAP_OF_POISON_DAGGERS_II	133

#define TRAP_OF_DROP_ITEMS		140
#define TRAP_OF_DROP_ALL_ITEMS		141
#define TRAP_OF_DROP_EVERYTHING		142

/* -SC- */
#define TRAP_OF_FEMINITY		150
#define TRAP_OF_MASCULINITY		151
#define TRAP_OF_NEUTRALITY		152
#define TRAP_OF_AGING			153
#define TRAP_OF_GROWING			154
#define TRAP_OF_SHRINKING		155
#define TRAP_OF_ELDRITCH_HORROR		156
#define TRAP_OF_TANKER_DRAIN		157
#define TRAP_OF_DIVINE_ANGER		158
#define TRAP_OF_DIVINE_WRATH		159
#define TRAP_OF_HALLUCINATION		160

#define TRAP_OF_ROCKET			161
#define TRAP_OF_NUKE_BOLT		162
#define TRAP_OF_DEATH_RAY		163
#define TRAP_OF_HOLY_FIRE		164
#define TRAP_OF_HELLFIRE		165
#define TRAP_OF_PSI_BOLT		166
#define TRAP_OF_PSI_DRAIN		167
#define TRAP_OF_NUKE_BALL		168
#define TRAP_OF_PSI_BALL		169

/* DG */
#define TRAP_OF_ACQUIREMENT		170

/* Jir */
#define TRAP_OF_ALE			171
#define TRAP_OF_GARBAGE			172
#define TRAP_OF_HOSTILITY		173
#define TRAP_OF_CUISINE			174
#define TRAP_OF_UNMAGIC			175
#define TRAP_OF_VERMIN			176
#define TRAP_OF_RANDOM_EFFECT		177
#define TRAP_OF_AMNESIA			178
#define TRAP_OF_SILLINESS		179
#define TRAP_OF_GOODBYE_CHARLIE		180
#define TRAP_OF_PRESENT_EXCHANGE	181
#define TRAP_OF_GARBAGE_FILLING		182
#define TRAP_OF_CHASM			183
#define TRAP_OF_PIT			184
#define TRAP_OF_SEASONED_TRAVELLER	185
#define TRAP_OF_SCRIBBLE		186
#define TRAP_OF_SLUMP			187
#define TRAP_OF_OPHIUCHUS		188
#define TRAP_OF_LOST_LABOR		189
#define TRAP_OF_DESPAIR			190
#define TRAP_OF_RARE_BOOKS		191
#define TRAP_OF_WRONG_TARGET		192
#define TRAP_OF_CLEANING		193
#define TRAP_OF_PREPARE			194
#define TRAP_OF_MOAT_I			195
#define TRAP_OF_MOAT_II			196
#define TRAP_OF_DISINTEGRATION_I	197
#define TRAP_OF_DISINTEGRATION_II	198
#define TRAP_OF_BATTLE_FIELD		199
#define TRAP_OF_DEATH_MOLDS		200
#define TRAP_OF_DEATH_SWORDS		201
#define TRAP_OF_UNLIGHT			202
#define TRAP_OF_THIRST			203
#define TRAP_OF_FINGER_CATCHING		204
#define TRAP_OF_ANIMATE_COINS		205
#define TRAP_OF_REMITTANCE		206
#define TRAP_OF_HIDE_TRAPS		207
#define TRAP_OF_RESPAWN			208
#define TRAP_OF_JACK			209
#define TRAP_OF_SPREAD			210
#define TRAP_OF_LASER			211
#define TRAP_OF_ROCKETS			212
#define TRAP_OF_HEALING			213
#define TRAP_OF_SPOOKINESS		214

/*
 * Shield effect options
 */
#define SHIELD_NONE	0x0000
#define SHIELD_COUNTER	0x0001
#define SHIELD_FIRE	0x0002
//Runie Shields
#define SHIELD_ICE	0x0004 //Cold/Shards/Sound
#define SHIELD_PLASMA	0x0008 //Elec/Fire/Sound
//#define SHIELD_ELEC	0x0004
//#define SHIELD_FEAR	0x0008

/* special 'projector' types, used in project(). */
#define PROJECTOR_UNUSUAL	-1000
#define PROJECTOR_TRAP		-1001
#define PROJECTOR_POTION	-1002
#define PROJECTOR_TERRAIN	-1003
#define PROJECTOR_MON_TRAP	-1004
#define PROJECTOR_EFFECT	-1005
#define PROJECTOR_PLAYER	-1006
#define PROJECTOR_RUNE		-1007

/* target_who may have various special values for targetting hacks - test for actual monster/player here: */
#define TARGET_BEING(twho)	((twho) && (twho) >= 0 - MAX_PLAYERS && (twho) <= MAX_M_IDX)
#define TARGET_STATIONARY(twho)	((twho) < 0 - MAX_PLAYERS || (twho) > MAX_M_IDX)

//see true_artifact_p - #define TRUE_ARTS(o_ptr) ((artifact_p(o_ptr)) && (!o_ptr->name3))
#define PRICE_BOOST(value, base, step) \
			(value > base ? value << ((value - base)/step) : value )

#ifndef ENABLE_DEATHKNIGHT
 #define is_fighter(p_ptr) \
	((p_ptr->pclass == CLASS_WARRIOR) || (p_ptr->pclass == CLASS_PALADIN) || (p_ptr->pclass == CLASS_RANGER) || (p_ptr->pclass == CLASS_MIMIC))
#else
 #ifndef ENABLE_HELLKNIGHT
  #define is_fighter(p_ptr) \
	((p_ptr->pclass == CLASS_WARRIOR) || (p_ptr->pclass == CLASS_PALADIN) || (p_ptr->pclass == CLASS_RANGER) || (p_ptr->pclass == CLASS_MIMIC) || (p_ptr->pclass == CLASS_DEATHKNIGHT))
 #else
  #define is_fighter(p_ptr) \
	((p_ptr->pclass == CLASS_WARRIOR) || (p_ptr->pclass == CLASS_PALADIN) || (p_ptr->pclass == CLASS_RANGER) || (p_ptr->pclass == CLASS_MIMIC) || (p_ptr->pclass == CLASS_DEATHKNIGHT) || (p_ptr->pclass == CLASS_HELLKNIGHT))
 #endif
#endif

#define is_admin(p_ptr) (p_ptr->admin_wiz || p_ptr->admin_dm)
#define admin_p(Ind) (Players[Ind]->admin_wiz || Players[Ind]->admin_dm)

#define TOOL_EQUIPPED(p_ptr) ((p_ptr->inventory[INVEN_TOOL].k_idx && \
		p_ptr->inventory[INVEN_TOOL].tval == TV_TOOL) ? \
		p_ptr->inventory[INVEN_TOOL].sval : -1)

/* complete weight of all equipment parts */
#define equip_weight(p_ptr) \
	(p_ptr->inventory[INVEN_WIELD].weight \
	+ p_ptr->inventory[INVEN_ARM].weight \
	+ p_ptr->inventory[INVEN_BOW].weight \
	+ p_ptr->inventory[INVEN_LEFT].weight \
	+ p_ptr->inventory[INVEN_RIGHT].weight \
	+ p_ptr->inventory[INVEN_NECK].weight \
	+ p_ptr->inventory[INVEN_LITE].weight \
	+ p_ptr->inventory[INVEN_BODY].weight \
	+ p_ptr->inventory[INVEN_OUTER].weight \
	+ p_ptr->inventory[INVEN_HEAD].weight \
	+ p_ptr->inventory[INVEN_HANDS].weight \
	+ p_ptr->inventory[INVEN_FEET].weight \
	+ p_ptr->inventory[INVEN_AMMO].weight \
	+ p_ptr->inventory[INVEN_TOOL].weight)

/* armour weight of all armour items + shield currently equipped */
#define armour_weight(p_ptr) \
	( p_ptr->inventory[INVEN_BODY].weight \
	+ p_ptr->inventory[INVEN_HEAD].weight \
	+ ((p_ptr->inventory[INVEN_ARM].k_idx && p_ptr->inventory[INVEN_ARM].tval == TV_SHIELD) ? \
	    p_ptr->inventory[INVEN_ARM].weight : 0) \
	+ p_ptr->inventory[INVEN_OUTER].weight \
	+ p_ptr->inventory[INVEN_HANDS].weight \
	+ p_ptr->inventory[INVEN_FEET].weight)

/* armour weight without the shield (if any) */
#define worn_armour_weight(p_ptr) \
	( p_ptr->inventory[INVEN_BODY].weight \
	+ p_ptr->inventory[INVEN_HEAD].weight \
	+ p_ptr->inventory[INVEN_OUTER].weight \
	+ p_ptr->inventory[INVEN_HANDS].weight \
	+ p_ptr->inventory[INVEN_FEET].weight)

/* encumberment check for martial arts skill */
#define monk_heavy_armor(p_ptr) \
	(get_skill(p_ptr, SKILL_MARTIAL_ARTS) && \
	 armour_weight(p_ptr) > \
	 50 + get_skill_scale(p_ptr, SKILL_MARTIAL_ARTS, 220))

/* encumberment check for rogueish skill, abilities and techniques.
   Was 200+..50, but increased it to +60, for wearing Morgoth's crown + DSM
   without having to omit any other equipment slot. */
#define rogue_heavy_armor(p_ptr) \
	((p_ptr->pclass == CLASS_ROGUE || \
	  (get_skill(p_ptr, SKILL_DUAL) && \
	   p_ptr->inventory[INVEN_WIELD].k_idx && \
	   p_ptr->inventory[INVEN_ARM].k_idx && p_ptr->inventory[INVEN_ARM].tval != TV_SHIELD) || \
	   (get_skill(p_ptr, SKILL_DODGE)) || \
	   (get_skill(p_ptr, SKILL_CRITS))) && \
	 (armour_weight(p_ptr) > \
	 200 + get_skill_scale(p_ptr, SKILL_COMBAT, 70)))

/* Check for rogueish melee skills eligibility, that is Critical-Strike and Backstabbing. Note that polearms are now allowed as a specialty (experimental). */
#define rogue_armed_melee(o_ptr, p_ptr)	(((o_ptr)->tval == TV_SWORD || (o_ptr)->tval == TV_POLEARM) && (o_ptr)->weight <= 100 && !((p_ptr)->rogue_heavyarmor))
/* For mirror image crit translation */
#define rogue_armed_melee_any(p_ptr)	((is_melee_weapon((p_ptr)->inventory[INVEN_WIELD].tval) && rogue_armed_melee(&(p_ptr)->inventory[INVEN_WIELD], (p_ptr))) || \
					(is_melee_weapon((p_ptr)->inventory[INVEN_ARM].tval) && rogue_armed_melee(&(p_ptr)->inventory[INVEN_ARM], (p_ptr))))

/* maximum weapon weight to allow dual-wielding, 999 for no limit	[999] */
#define DUAL_MAX_WEIGHT 999


/* replacement of helper functions in cave.c */
/* prolly compilers will do this job anyway..? */
#if 0
#define level_speed(wpos) ((wpos)->wz ? level_speeds[getlevel(wpos)] * 5 : level_speeds[0] * 5)
#else /* NR = +20%..+37% slower than dlvl 127 (200 level_speed base) */
#define level_speed(wpos) \
	((wpos)->wz && !isdungeontown(wpos) ? (getlevel(wpos) <= 127 ? \
	    level_speeds[getlevel(wpos)] * 5 : \
	    (level_speeds[getlevel(wpos)] * (getlevel(wpos) + 60)) / 37) \
	: level_speeds[0] * 5)
#endif

#define inarea(apos, bpos) \
	((apos)->wx == (bpos)->wx && (apos)->wy == (bpos)->wy && (apos)->wz == (bpos)->wz)

/* alias */
#define wpcmp(apos, bpos) (inarea(apos, bpos))

#define wild_idx(wpos) \
	((wpos)->wx + (wpos)->wy * MAX_WILD_X)

/* NOTE: not all the towns should be on the surface, should they? */
#define isdungeontown(wpos) \
	(((wpos)->wz != 0) && (getfloor(wpos) != NULL) && (getfloor(wpos)->flags1 & LF1_DUNGEON_TOWN))
#define istown(wpos) \
	((!(wpos)->wz && wild_info[(wpos)->wy][(wpos)->wx].type == WILD_TOWN))
#define istownarea(wpos, rad) \
	(istown(wpos) || ((wpos)->wz == 0 && wild_info[(wpos)->wy][(wpos)->wx].radius <= rad))


/* paralysis should be handled by other means! (0..80, or 1000 if paralyzed. Usually 10..25.) */
#define UNAWARENESS(p_ptr) ( \
	(p_ptr->stun > 50 ? 10 : 0) + \
	(p_ptr->stun ? 15 : 0) + \
	(p_ptr->confused ? 25 : 0) + \
	(p_ptr->image ? 10 : 0) + \
	(p_ptr->blind ? 20 : 0) + \
	(p_ptr->paralyzed ? 1000 : 0) )

/*
#define inarea(apos, bpos) \
	(apos->wx==bpos->wx && apos->wy==bpos->wy && apos->wz==bpos->wz)
	(apos.wx==bpos.wx && apos.wy==bpos.wy && apos.wz==bpos.wz)
*/

/* Alias - to ease backporting :) */
#define object_prep(o_ptr, k_idx)	invcopy(o_ptr, k_idx)

/* Hooks, scripts */
#define HOOK_MONSTER_DEATH	0
#define HOOK_OPEN		1
#define HOOK_GEN_QUEST		2
#define HOOK_END_TURN		3
#define HOOK_FEELING		4
#define HOOK_NEW_MONSTER	5
#define HOOK_GEN_LEVEL		6
#define HOOK_BUILD_ROOM1	7
#define HOOK_NEW_LEVEL		8
#define HOOK_QUEST_FINISH	9
#define HOOK_QUEST_FAIL		10
#define HOOK_GIVE		11
#define HOOK_CHAR_DUMP		12
#define HOOK_INIT_QUEST		13
#define HOOK_WILD_GEN		14
#define HOOK_DROP		15
#define HOOK_IDENTIFY		16
#define HOOK_MOVE		17
#define HOOK_STAIR		18
#define HOOK_MONSTER_AI		19
#define HOOK_PLAYER_LEVEL	20
#define HOOK_WIELD		21
#define HOOK_INIT		22
#define HOOK_QUAFF		23
#define HOOK_AIM		24
#define HOOK_USE		25
#define HOOK_ACTIVATE		26
#define HOOK_ZAP		27
#define HOOK_READ		28
#define HOOK_CALC_BONUS		29
#define HOOK_PLAYER_FLAGS	30
#define HOOK_KEYPRESS		31
#define HOOK_CHAT		32
#define HOOK_MON_SPEAK		33
#define HOOK_MKEY		34
#define HOOK_BIRTH_OBJECTS	35
#define HOOK_ACTIVATE_DESC	36
#define HOOK_INIT_GAME		37
#define HOOK_ACTIVATE_POWER	38
#define HOOK_ITEM_NAME		39
#define HOOK_SAVE_GAME		40
#define HOOK_LOAD_GAME		41
#define HOOK_LEVEL_REGEN	42
#define HOOK_LEVEL_END_GEN	43
#define HOOK_BUILDING_ACTION	44
#define HOOK_PROCESS_WORLD	45
#define HOOK_WIELD_SLOT		46
#define HOOK_STORE_STOCK	47
#define HOOK_STORE_BUY		48
#define HOOK_GEN_LEVEL_BEGIN	49
#define HOOK_GET		50
#define HOOK_NPCTEST		51
#define MAX_HOOKS		52

/*
 * Mkeys are skill activations
 */
#if 0
 #define MKEY_SORCERY		1	/* unused */
 #define MKEY_MAGERY		2	/* unused */
 #define MKEY_SHADOW		4	/* unused */
 #define MKEY_PRAY		7	/* unused */
#endif

#define MKEY_DUAL_MODE		1	/* dual-wield mode: mainhand vs dualhand */
//#define MKEY_UNUSED		2	/*pft*/

#define MKEY_MIMICRY		3
#define MKEY_SHOOT_TILL_KILL	4	/* toggle this firing mode */
#define MKEY_MELEE		5	/* new fighter abilities */
#define MKEY_RANGED		6	/* not "Hunting" anymore, but new archer abilities */

#define MKEY_DODGE		8
//#define MKEY_FLETCHERY	9	/* constant to be unused when fletchery becomes subskill of archer abilities -- replaced by: */
#define MKEY_INTERCEPT		9

#define MKEY_TRAP		10
#define MKEY_SCHOOL		11
#define MKEY_RCRAFT		12

#define MKEY_STANCE		13	/* combat stances for warriors - C. Blue */
#define MKEY_PARRYBLOCK		14	/* check parry/block chance */

#define MKEY_AURA_FEAR		15	/* Make auras toggleable for greater utilization! - C. Blue */
#define MKEY_AURA_SHIVER	16
#define MKEY_AURA_DEATH		17

#define MKEY_BREATH		18
#define MKEY_PICK_BREATH	19


/*
 * Skills
 */
#define SKILL_MAX		50000           /* Maximun skill value */
#define SKILL_STEP		1000            /* 1 skill point */

#define SKILL_EXCLUSIVE		9999            /* Flag to tell exclusive skills */

#define SKILL_COMBAT		1
#define SKILL_MASTERY		2
#define SKILL_SWORD		3
#define SKILL_CRITS		4
#define SKILL_POLEARM		5
#define SKILL_BLUNT		6
#define SKILL_ARCHERY		7
#define SKILL_SLING		8
#define SKILL_BOW		9
#define SKILL_XBOW		10
#define SKILL_BACKSTAB		11
#define SKILL_MAGIC		12
//#define SKILL_CASTSPEED	13
#define SKILL_SHOOT_TILL_KILL	13
#define SKILL_SORCERY		14
#define SKILL_MAGERY		15
#define SKILL_MIMIC		16
#define SKILL_DEVICE		17
#define SKILL_SHADOW		18
#define SKILL_PRAY		19
#define SKILL_SPELLLENGTH	20
#define SKILL_SNEAKINESS	21
#define SKILL_DISARM		22
#define SKILL_STEALTH		23
#define SKILL_STEALING		24
#define SKILL_NECROMANCY	25
#define SKILL_ANTIMAGIC		26
/* #define SKILL_AURA_POWER	27 */
#define SKILL_TRAUMATURGY	27
#define SKILL_AURA_FEAR		28
#define SKILL_AURA_SHIVER	29
#define SKILL_AURA_DEATH	30
#define SKILL_HUNTING		31
#define SKILL_TECHNIQUE		32
#define SKILL_MISC		33
#define SKILL_AGILITY		34
#define SKILL_CALMNESS		35
#define SKILL_SWIM		36
#define SKILL_MARTIAL_ARTS	37
#define SKILL_RICOCHET		38
#define SKILL_BOOMERANG		39
#define SKILL_TRAINING		40
#define SKILL_INTERCEPT		41
#define SKILL_DODGE		42
#define SKILL_HEALTH		43
#define SKILL_DIG		44
#define SKILL_SPELLRAD		45
#define SKILL_TRAPPING		46
#define SKILL_AXE		47	/* hrm, bad order */

/* School skills */
#define SKILL_CONVEYANCE	48
#define SKILL_SPELL		49
#define SKILL_MANA		50
#define SKILL_FIRE		51
#define SKILL_AIR		52
#define SKILL_WATER		53
#define SKILL_NATURE		54
#define SKILL_EARTH		55
#define SKILL_DIVINATION	56
#define SKILL_TEMPORAL		57
#define SKILL_META		58
#define SKILL_MIND		59
#define SKILL_UDUN		60

/* for future use, if we ever can get these balanced in a sensible manner (seems unlikely without heavy changes to all other game elements oO) */
#define SKILL_SCHOOL_CRAFTING	61	/* dummy skill for clustering */
#define SKILL_WEAPONSMITHING	62
#define SKILL_ARMOURSMITHING	63
#define SKILL_FLETCHING		64
#define SKILL_JEWELCRAFT	65
#define SKILL_TOOLCRAFT		66
#define SKILL_TAILORING		67
#define SKILL_ALCHEMY		68
#define SKILL_ENCHANTING	69

#define SKILL_HOFFENSE		70
#define SKILL_HDEFENSE		71
#define SKILL_HCURING		72
#define SKILL_HSUPPORT		73

#define SKILL_DRUID_ARCANE	74
#define SKILL_DRUID_PHYSICAL	75

#define SKILL_ASTRAL		77

#define SKILL_DUAL		78 /* dual-wield for rogues */
#define SKILL_STANCE		79 /* combat stances for warriors */

#define SKILL_PPOWER		80 /* the new mindcrafter skills */
#define SKILL_ATTUNEMENT	81 /* the new mindcrafter skills */
#define SKILL_MINTRUSION	82 /* the new mindcrafter skills */

/* Dummy skills - just to make the mass of schools appear more ordered - C. Blue */
#define SKILL_SCHOOL_MAGIC	83
#define SKILL_SCHOOL_PRAYING	84
#define SKILL_SCHOOL_DRUIDISM	85
#define SKILL_SCHOOL_MINDCRAFT	86
//#ifdef ENABLE_OCCULT /* Occult */
 #define SKILL_OSHADOW		87
 #define SKILL_OSPIRIT		88
 /* and the dummy skill for sorting: */
 #define SKILL_SCHOOL_OCCULT	89
 //#ifdef ENABLE_OHERETICISM
  #define SKILL_OHERETICISM	94
 //#endif
 //#ifdef ENABLE_OUNLIFE
  #define SKILL_OUNLIFE		105
 //#endif
//#endif

/* additional ones */
#define SKILL_CLIMB		90
#define SKILL_LEVITATE		91
#define SKILL_FREEACT		92
#define SKILL_RESCONF		93
//94 defined above
#if 0	/* skills to come	- Jir - */
 #define SKILL_INNATE_POWER	/* in mimicry tree */
 #define SKILL_EGO_POWER
#endif	/* 0 */

#define SKILL_SCHOOL_RUNECRAFT  95
#define SKILL_R_LITE            96
#define SKILL_R_DARK            97
#define SKILL_R_NEXU            98
#define SKILL_R_NETH            99
#define SKILL_R_CHAO            100
#define SKILL_R_MANA            101

/* Sync with lib/game/k_info.txt and lib/scpt/runecraft.lua - Kurzel */
#define SV_R_LITE   0x01
#define SV_R_DARK   0x02
#define SV_R_NEXU   0x04
#define SV_R_NETH   0x08
#define SV_R_CHAO   0x10
#define SV_R_MANA   0x20
#define SV_R_CONF   (SV_R_LITE|SV_R_DARK)
#define SV_R_INER   (SV_R_LITE|SV_R_NEXU)
#define SV_R_ELEC   (SV_R_LITE|SV_R_NETH)
#define SV_R_FIRE   (SV_R_LITE|SV_R_CHAO)
#define SV_R_WATE   (SV_R_LITE|SV_R_MANA)
#define SV_R_GRAV   (SV_R_DARK|SV_R_NEXU)
#define SV_R_COLD   (SV_R_DARK|SV_R_NETH)
#define SV_R_ACID   (SV_R_DARK|SV_R_CHAO)
#define SV_R_POIS   (SV_R_DARK|SV_R_MANA)
#define SV_R_TIME   (SV_R_NEXU|SV_R_NETH)
#define SV_R_SOUN   (SV_R_NEXU|SV_R_CHAO)
#define SV_R_SHAR   (SV_R_NEXU|SV_R_MANA)
#define SV_R_HELL   (SV_R_NETH|SV_R_CHAO)
#define SV_R_FORC   (SV_R_NETH|SV_R_MANA)
#define SV_R_DISE   (SV_R_CHAO|SV_R_MANA)

/* for future use, so no client update will be required */
#define SKILL_SOULFEASTING	102	/* could switch with SKILL_NECROMANCY if ever needed */
#define SKILL_SUMMONING		103
#define SKILL_TAMING		104

//hole 105-108

#define SKILL_BLOOD_MAGIC	109 /* dummy */

/* For Draconians */
#define SKILL_BREATH		110
#define SKILL_PICK_BREATH	111

#define MAX_SKILLS              128


/* SKill flags - Note: Only the first byte is transferred to client-side */
#define SKF1_HIDDEN             0x00000001U	/* Starts hidden */
#define SKF1_AUTO_HIDE		0x00000002U	/* Starts hidden */
#define SKF1_DUMMY		0x00000004U	/* Just for visual ordering */
#define SKF1_MAX_1		0x00000008U	/* Skill maxes at 1.000 */
#define SKF1_MAX_10		0x00000010U	/* Skill maxes at 10.000 */
#define SKF1_MAX_20		0x00000020U	/* Skill maxes at 20.000 */
#define SKF1_MAX_25		0x00000040U	/* Skill maxes at 25.000 */
#define SKF1_AUTO_MAX		0x00000080U	/* Skill is always automatically at maximum */
/* --- the first byte ends here! --- */
#define SKF1_MKEY_SCHOOL	0x04000000U	/* mkey is school type */
#define SKF1_MKEY_HARDCODE	0x08000000U	/* mkey uses hard-coded routine */
#define SKF1_MKEY_SPELL		0x10000000U	/* mkey is realm spell type */
#define SKF1_MKEY_TVAL		0x20000000U	/* mkey uses specific tval(not used) */
#define SKF1_MKEY_ITEM		0x40000000U	/* mkey requires an item */
#define SKF1_MKEY_DIRECTION	0x80000000U	/* mkey requires direction */



#define MAX_AURAS 		3

#define AURA_FEAR		0
#define AURA_SHIVER		1
#define AURA_DEATH		2



/* Skill points per level (xtra2.c) */
#ifdef ARCADE_SERVER
 #define SKILL_NB_BASE		0
#else
 #define SKILL_NB_BASE		5
#endif




/*
 * Buildings actions
 */
#define BACT_RESEARCH_ITEM		1
#define BACT_TOWN_HISTORY		2
#define BACT_RACE_LEGENDS		3
#define BACT_GREET_KING			4
#define BACT_KING_LEGENDS		5
#define BACT_QUEST1			6
#define BACT_GOLD			7
#define BACT_POSTER			8
#define BACT_ARENA_RULES		9
#define BACT_ARENA			10
#define BACT_ARENA_LEGENDS		11
#define BACT_IN_BETWEEN			12
#define BACT_GAMBLE_RULES		13
#define BACT_CRAPS			14
#define BACT_SPIN_WHEEL			15
#define BACT_DICE_SLOTS			16
#define BACT_REST			17
#define BACT_FOOD			18
#define BACT_RUMORS			19
#define BACT_RESEARCH_MONSTER		20
#define BACT_COMPARE_WEAPONS		21
#define BACT_LEGENDS			22
#define BACT_ENCHANT_WEAPON		23
#define BACT_ENCHANT_ARMOR		24
#define BACT_RECHARGE			25
#define BACT_IDENTS			26
#define BACT_LEARN			27
#define BACT_HEALING			28
#define BACT_RESTORE			29
#define BACT_ENCHANT_ARROWS		30
#define BACT_ENCHANT_BOW		31
#define BACT_GREET			32
#define BACT_RECALL			33
#define BACT_TELEPORT_LEVEL		34
#define BACT_BUYFIRESTONE		35
#define BACT_COMEBACKTIME		36
#define BACT_MIMIC_NORMAL		37
#define BACT_VIEW_BOUNTIES		38
#define BACT_SELL_CORPSES		39
#define BACT_VIEW_QUEST_MON		40
#define BACT_SELL_QUEST_MON		41
#define BACT_DIVINATION			42
#define BACT_SELL			43
#define BACT_BUY			44
#define BACT_EXAMINE			45
#define BACT_STEAL			46
#define BACT_QUEST2			47
#define BACT_QUEST3			48
#define BACT_QUEST4			49
#define BACT_STAR_HEAL			50
#define BACT_REQUEST_ITEM		51
#define BACT_GET_LOAN			52
#define BACT_PAY_BACK_LOAN		53
#define BACT_DEPOSIT			54
#define BACT_WITHDRAW			55
#define BACT_EXTEND_HOUSE		56

#define BACT_CHEEZE_LIST		57
#define BACT_DEED_ITEM			58
#define BACT_DEED_BLESSING		59
#define BACT_GO				60
#define BACT_INSTANT_RES		61
#define BACT_EXPLORATIONS		62
#define BACT_RENAME_GUILD		63
#define BACT_STATIC			64
#ifdef SOLO_REKING
 #define BACT_SR_DONATE			65
#endif
#ifdef ENABLE_ITEM_ORDER
 #define BACT_ITEM_ORDER		66
#endif
#ifdef GLOBAL_DUNGEON_KNOWLEDGE
 #define BACT_DUNGEONS			67
#endif
#define BACT_SEND_ITEM			68
#define BACT_SEND_GOLD			69
#define BACT_SEND_ITEM_PAY		70
#define BACT_REPAIR_WEAPON		71
#define BACT_REPAIR_ARMOR		72
#define BACT_HIGHEST_LEVELS		73
#ifdef RESET_SKILL
 #define BACT_LOSE_MEMORIES_I		74
 #define BACT_LOSE_MEMORIES_II		75
#endif
#define BACT_CONTACT_OWNER		76
/* If one adds new BACT_ do NOT forget to increase max_bact in variables.c */
/* MAX_BA_IDX for TomeNET	- Jir - */
#define BACT_LIST_GUILDS		77


#define BACT_F_NOTHING		0x00
#define BACT_F_STORE_ITEM	0x01
#define BACT_F_INVENTORY	0x02
#define BACT_F_GOLD		0x04
#define BACT_F_STAR_ID	 	0x08
#define BACT_F_HARDCODE		0x80

/* Reskill flags */
#define RESKILL_F_UNDO		0x1
#ifdef RESET_SKILL
 #define RESKILL_F_RESET	0x2
#endif

/* Town types, not to be confused with town default indices */
#define TOWN_VANILLA	0
#define TOWN_BREE	1
#define TOWN_GONDOLIN	2
#define TOWN_MINAS_ANOR	3
#define TOWN_LOTHLORIEN	4
#define TOWN_KHAZADDUM	5	/* this town seems to be under construction in ToME */

/* Town default indices (hard-coding is ok since the order of allocation is fixed) */
#define TIDX_BREE	0
#define TIDX_GONDLIN	1
#define TIDX_MINAS_ANOR	2
#define TIDX_LORIEN	3
#define TIDX_KHAZAD	4

/* Town defines */
/* defines for random towns in the dungeon. (will be implemented in v5?)
 * For now, it's here just to deceive the parser. */
#define TOWN_RANDOM	20              /* First random town */
#define TOWN_DUNGEON	4               /* Maximun number of towns per dungeon */
#define TOWN_CHANCE	50              /* Chance of 1 town */

/* Limit terraforming in towns, to preserve intended layout somewhat?
 *  0 = not allowed to change
 *  32000 = no limit
 *  other number = use as limit
 * Note: The limit counts for both, creating and destroying related features.
         (Mostly, because we don't remember previous features, so we cannot
         restore them appropriately. So each change is probably a modification,
         and never a reversal to the original layout.) */
#define TOWN_TERRAFORM_TREES	1000	/* allow to carve some paths out? */
#define TOWN_TERRAFORM_WALLS	1000	/* allow to create cool but annoying speedways?^^ */
#define TOWN_TERRAFORM_WATER	0	/* dry up loth / water gondo? :/ */
#define TOWN_TERRAFORM_GLYPHS	100	/* provide some safety for beginners, in Bree */

/*
 * Defines of the different dungeon types
 */
#define DUNGEON_WILDERNESS	0
#define DUNGEON_MIRKWOOD	1
#define DUNGEON_MORDOR		2
#define DUNGEON_ANGBAND		3
#define DUNGEON_GALGALS		4
#define DUNGEON_VOLCANO		5
#define DUNGEON_HELL		6
#define DUNGEON_NUMENOR		7
#define DUNGEON_MANDOS		8
#define DUNGEON_MAZE		18
#define DUNGEON_DEATH		28
#define DUNGEON_DOL_GULDUR	23

/* Max depth of each dungeon(max_depth - min_depth) */
#define MAX_DUNGEON_DEPTH	128	/* UNUSED! */

#define DUNGEON_MODE_NONE	0
#define DUNGEON_MODE_AND	1
#define DUNGEON_MODE_NAND	2
#define DUNGEON_MODE_OR		3
#define DUNGEON_MODE_NOR	4

/* Object generation */
#define OBJ_GENE_TREASURE	20
#define OBJ_GENE_COMBAT		20
#define OBJ_GENE_MAGIC		20
#define OBJ_GENE_TOOL		20


/* Special powers */
#define MAX_POWERS		50      /* 2 should be enough but let's be on the *SAFE* side ;) */
#define MAX_KNOW_POWERS		2

/* evileye games */
#define EEGAME_CTF		1
#define EEGAME_RUGBY		2

/* erase items on the floor? */
#define ITEM_REMOVAL_NORMAL	0	/* this must always be 0 (assumed as default if not set to a different value) */
#define ITEM_REMOVAL_NEVER	1	/* Item will never 'timeout' */
#define ITEM_REMOVAL_HOUSE	2	/* Item is inside a house and because of that will never 'timeout' */
#define ITEM_REMOVAL_DEATH_WILD	3	/* Items are death loot, but not in dungeon (would be ITEM_REMOVAL_NEVER) but in the wilderness */
#define ITEM_REMOVAL_LONG_WILD	4	/* Item times out even much slower than from ITEM_REMOVAL_DEATH_WILD */
#define ITEM_REMOVAL_QUICK	5	/* To keep pvp-arena clean: 10 minutes timeout flat. */
#define ITEM_REMOVAL_MONTRAP	6	/* Item is part of a monster trap and hence should last quite a while */


/* Invalid (Nothing) items: Enable backtracing if we're using glibc */
#ifdef __GLIBC__
 #define BACKTRACE_NOTHINGS
#endif
/* Actually remove the invalid c_ptr->o_idx reference? */
#define FIX_NOTHINGS
#define FIX_NOTHINGS_ON_SIGHT


/* C. Blue - Automatic transport sequences for characters
   (kind of scripted transport for special situations) */
#define AT_BLINK	1	/* teleport short range; used after panic-save auto-recalling */
#define AT_TPORT	2	/* teleport long range */
#define AT_VALINOR	3	/* send player to the shores of Valinor */
#define AT_VALINOR2	4
#define AT_VALINOR3	5
#define AT_VALINOR4	6
#define AT_VALINOR5	7
#define AT_VALINOR6	8
#define AT_PARTY	9
#define AT_PARTY2	10
#define AT_MUMBLE	11
#define AT_VALINORX	12


/* Masks for restricted mimicry */
/*	Shaman: Animals, Giants, Dragon(rider)s, Elementals/Spirits, Ghosts.
	No undead/nonliving material beings; no Invisible Stalker/Unmaker/Death Orb. */
/*	!(r_info[ridx].flags3 & (RF3_UNDEAD | RF3_NONLIVING)) && !(r_info[ridx].d_char == 'O')) || \ */
#define mimic_shaman(ridx)	\
	(((ridx) == 0) || \
	(((r_info[ridx].flags3 & (RF3_ANIMAL | RF3_DRAGON | RF3_GIANT | RF3_DRAGONRIDER)) || \
	(r_info[ridx].d_char == 'H') || (r_info[ridx].d_char == 'T')) && \
 	!(r_info[ridx].flags3 & (RF3_UNDEAD | RF3_NONLIVING))) || \
	(r_info[ridx].d_char == 'G') || mimic_shaman_E(ridx) || (r_info[ridx].d_char == 'X') || \
	(r_info[ridx].d_char == 'g') || (r_info[ridx].d_char == 'A'))
#define mimic_shaman_E(ridx)	\
	((r_info[ridx].d_char == 'E') && !((ridx) == 514 || (ridx) == 815 || (ridx) == 975)) //invisible stalker, unmaker, death orb
#define mimic_shaman_fulleq(c)	(strchr("EGX", c))
/*	Druid: Selected Animals and animal-similar creatures. */
#define mimic_druid(ridx, plv)	\
	(((ridx) == 0) || \
	((plv) >= 5 && ((ridx) == 160 || (ridx) == 198)) || \
	((plv) >= 10 && ((ridx) == 191 || (ridx) == 154)) || \
	((plv) >= 15 && ((ridx) == 279 || (ridx) == 343)) || \
	((plv) >= 20 && ((ridx) == 414 || (ridx) == 335 || (ridx) == 898 || (ridx) == 963)) || \
	((plv) >= 25 && ((ridx) == 334 || (ridx) == 513)) || \
	((plv) >= 30 && ((ridx) == 440 || (ridx) == 641 || (ridx) == 482)) || \
	((plv) >= 35 && ((ridx) == 614 || (ridx) == 726 || (ridx) == 964)) || \
	((plv) >= 40 && ((ridx) == 688 || (ridx) == 640 || (ridx) == 740)) || \
	((plv) >= 45 && ((ridx) == 723 || (ridx) == 704)) || /* || (ridx) == 716 || \ */ \
	((plv) >= 50 && ((ridx) == 1069 || (ridx) == 778 || (ridx) == 775)) || /* 782 */ \
	((plv) >= 55 && ((ridx) == 1131)) || \
	((plv) >= 60 && ((ridx) == 1127)))
	/* possible postking additions - guiding ideas:
	   fire immunity for NR; very maybe pass wall for comfort.
	    1127 firebird, 739 ethereal hound? */
/* for vampires, who learn to transform into a vampire bat and back for transportation - C. Blue */
#ifndef VAMPIRIC_MIST
 #define mimic_vampire(ridx, plv)	\
	(((ridx) == 0) || \
	((plv) >= 20 && (ridx) == RI_VAMPIRE_BAT))
#else
 #define mimic_vampire(ridx, plv)	\
	(((ridx) == 0) || \
	((plv) >= 20 && (ridx) == RI_VAMPIRE_BAT) || \
	((plv) >= 35 && (ridx) == RI_VAMPIRIC_MIST))
#endif

#define mimic_hatchling(ridx)	\
	(((ridx) == 0) || \
	(r_info[ridx].flags3 & RF3_DRAGON))

/* Can the player operate doors (and other things?) or is it not possible because he doesn't have a material body needed for that? */
#define CANNOT_OPERATE_SPECTRAL (p_ptr->ghost || p_ptr->tim_wraith || (p_ptr->prace == RACE_VAMPIRE && p_ptr->body_monster == RI_VAMPIRIC_MIST))
/* Can the player operate doors (and other things?) or is it not possible because of the monster form he's using (despite being material)? */
#if 0 /* Druids can always operate doors even if their form cannot? */
 #define CANNOT_OPERATE_FORM (p_ptr->body_monster && p_ptr->pclass != CLASS_DRUID && !((r_info[p_ptr->body_monster].flags2 & RF2_OPEN_DOOR) || (r_info[p_ptr->body_monster].body_parts[BODY_FINGER] && r_info[p_ptr->body_monster].body_parts[BODY_WEAPON])))
#else /* Standard behaviour: No exception for druids. */
 #define CANNOT_OPERATE_FORM (p_ptr->body_monster && !((r_info[p_ptr->body_monster].flags2 & RF2_OPEN_DOOR) || (r_info[p_ptr->body_monster].body_parts[BODY_FINGER] && r_info[p_ptr->body_monster].body_parts[BODY_WEAPON])))
#endif
/* Can the player operate things? */
#define CANNOT_OPERATE (CANNOT_OPERATE_SPECTRAL || CANNOT_OPERATE_FORM)


/* for global_event - C. Blue */
#define MAX_GLOBAL_EVENT_TYPES	16	/* amount of different event types */
#define MAX_GLOBAL_EVENTS	16	/* max # of concurrently running events */
#define MAX_GE_PARTICIPANTS	64

/* types of global events: */
#define GE_NONE			0	/* <disabled> ie no event running */
#define GE_HIGHLANDER		1	/* Highlander Tournament */
#define GE_HIGHLANDER_NEW	2	/* [NOT YET IMPLEMENTED] (with highlander town and set-up cash+items etc) */
#define GE_ARENA_MONSTER	3	/* Areana Monster Challenge */
#define GE_GAME_RUGBY		4	/* [NOT YET IMPLEMENTED] Evileye's good ole game of rugby, now in event-form ;) */
#define GE_DUNGEON_KEEPER	5	/* 'Dungeon Keeper' Labyrinth */
#ifdef DM_MODULES
 #define GE_ADVENTURE		6	/* Load DM modules as part of an adventure! - Kurzel */
#endif

/* player flags while participating in global events (p_ptr->global_event_temp) */
#define PEVF_NONE		0x00000000U
#define PEVF_PASS_00		0x00000001U /* may enter/leave sector 0,0 */
#define PEVF_NOGHOST_00		0x00000002U /* will permanently die in sector 0,0 */
#define PEVF_SAFEDUN_00		0x00000004U /* won't die in dungeon/tower in 0,0 */
#define PEVF_AUTOPVP_00		0x00000008U /* will always be hostile to others in 0,0 */
#define PEVF_SEPDUN_00		0x00000010U /* unable to leave dungeon or tower in 0,0 via stairs */
#define PEVF_NO_RUN_00		0x00000020U /* can only walk but not run in 0,0 */
#define PEVF_NOTELE_00		0x00000040U /* cannot use phasing/teleportation in 0,0 */
#define PEVF_INDOORS_00		0x00000080U /* the 0,0 event is classified as indoors, so vampires don't get sun burn */
#define PEVF_ICKY_OK		0x00000100U /* allow wpos changes onto CAVE_ICKY grid */
#define PEVF_STCK_OK		0x00000200U /* allow wpos changes onto CAVE_STCK grid */

/* for achievements (top PvP mode rank) - C. Blue */
#define ACHV_PVP_MAX		1
#define ACHV_PVP_MID		2
#define ACHV_PVP_MASS		3

/* modify the base crit bonus to make it less linear, remotely similar to LUCK */
//#define BOOST_CRIT(xtra_crit)	(65 - (975 / ((xtra_crit) + 15))) /* 1:5, 2: 8, 3:11, 5:17, 7:21, 10:26, 15:33, 20:38 */
//xtra_crit = 60 - (600 / (xtra_crit + 10)); /* 1:6, 2:10, 3:15, 5:20, 7:25, 10:30, 15:36, 20:40 */
#define BOOST_CRIT(xtra_crit)	(66 - (1350 / ((xtra_crit) + 20))) /* 1:2, 2: 5, 3:8, 5:12, 7:16, 10:21, 15:28, 20:33 */


/* Auction system - mikaelh */
#ifdef AUCTION_SYSTEM

/* Minimum required value of an auctionable item */
#ifdef AUCTION_BETA
#define AUCTION_MINIMUM_VALUE		1
#else
#define AUCTION_MINIMUM_VALUE		1000
#endif

/* Auction fee in percents of the price */
#define AUCTION_FEE			1

/* Maximum amount of items per player */
#define AUCTION_MAX_ITEMS_PLAYER	48

/* Time limits */
#ifdef AUCTION_BETA
#define AUCTION_MINIMUM_DURATION	15	/* 15 seconds */
#define AUCTION_MAXIMUM_DURATION	604800  /* 7 days */
#else
#define AUCTION_MINIMUM_DURATION	3600	/* 1 hour */
#define AUCTION_MAXIMUM_DURATION	604800	/* 7 days */
#endif

/* Minimum starting price (in percents of the real value) */
#define AUCTION_MINIMUM_STARTING_PRICE	100

/* Maximum starting price (in percents of the real value) */
#define AUCTION_MAXIMUM_STARTING_PRICE	1000

/* Minimum buyout price (in percents of the real value) */
#define AUCTION_MINIMUM_BUYOUT_PRICE	100

/* Maximum buyout price (in percents of the real value) */
#define AUCTION_MAXIMUM_BUYOUT_PRICE	2000

/* Status codes */
#define AUCTION_STATUS_EMPTY		0
#define AUCTION_STATUS_SETUP		1
#define AUCTION_STATUS_BIDDING		2
#define AUCTION_STATUS_FINISHED		3
#define AUCTION_STATUS_CANCELLED	4

/* Flags */
#define AUCTION_FLAG_WINNER_PAID	1 /* If the winning bidder has paid for the item */
#define AUCTION_FLAG_SELLER_PAID	2 /* If money from the auction has been given to the seller */

/* Error codes */
#define	AUCTION_ERROR_INVALID_ID		-1 /* Invalid auction id */
#define AUCTION_ERROR_NOT_BIDDING		-2 /* Bidding hasn't yet started */
#define AUCTION_ERROR_OWN_ITEM			-3 /* Own item */
#define AUCTION_ERROR_OVERFLOW			-4 /* Overflow or invalid input */
#define AUCTION_ERROR_INVALID_SLOT		-5 /* Invalid inventory slot */
#define AUCTION_ERROR_EMPTY_SLOT		-6 /* Empty inventory slot */
#define AUCTION_ERROR_TOO_CHEAP			-7 /* Item is too cheap to be auctioned */
#define AUCTION_ERROR_ALREADY_STARTED		-8 /* Auction has already been started */
#define AUCTION_ERROR_NOT_SUPPORTED		-9 /* Action not supported for auction */
#define AUCTION_ERROR_INSUFFICIENT_MONEY	-10 /* Not enough money */
#define AUCTION_ERROR_TOO_SMALL			-11 /* Bid is too small */
#define AUCTION_ERROR_INSUFFICIENT_LEVEL	-12 /* Player doesn't satisfy the item's level requirement */
#define AUCTION_ERROR_EVERLASTING_ITEM		-13 /* Non-everlasting / everlasting separation */
#define AUCTION_ERROR_NONEVERLASTING_ITEM	-14 /* Non-everlasting / everlasting separation */
#define AUCTION_ERROR_INVALID_ACCOUNT		-15 /* Invalid account */
#define AUCTION_ERROR_INVALID_PRICE		-16 /* Invalid price */
#define AUCTION_ERROR_INVALID_DURATION		-17 /* Invalid duration */
#define AUCTION_ERROR_TOO_MANY			-18 /* Too many auctions */
#define AUCTION_ERROR_NO_BIDDING		-19 /* No bidding */
#define AUCTION_ERROR_NO_BUYOUT			-20 /* No buyout */
#define AUCTION_ERROR_EITHER_BID_OR_BUYOUT	-21 /* Either bidding or buyout needs to be allowed */

#endif

/* macro for debugging Doppelgaenger @s */
#define cave_midx_debug(wpos_, cy, cx, midx) { \
    if (midx < 0) { \
        if (-(midx) > NumPlayers) { s_printf("MIDX_DEBUG: out of range (%d of %d) (%s:%d)\n", -(midx), NumPlayers, __FILE__, __LINE__); } \
        if ((wpos_)->wx != Players[-(midx)]->wpos.wx) { s_printf("MIDX_DEBUG: wrong wpos wx (%d : %d) (%s:%d)\n", (wpos_)->wx, Players[-(midx)]->wpos.wx, __FILE__, __LINE__); } \
        if ((wpos_)->wy != Players[-(midx)]->wpos.wy) { s_printf("MIDX_DEBUG: wrong wpos wy (%d : %d) (%s:%d)\n", (wpos_)->wy, Players[-(midx)]->wpos.wy, __FILE__, __LINE__); } \
        if ((wpos_)->wz != Players[-(midx)]->wpos.wz) { s_printf("MIDX_DEBUG: wrong wpos wz (%d : %d) (%s:%d)\n", (wpos_)->wz, Players[-(midx)]->wpos.wz, __FILE__, __LINE__); } \
        if (Players[-(midx)]->py == cy) { \
            if (Players[-(midx)]->px != cx) { s_printf("MIDX_DEBUG: wrong x (%d : %d) (%s:%d)\n", cx, Players[-(midx)]->px, __FILE__, __LINE__); } \
        } else { \
            if (Players[-(midx)]->px != cx) { s_printf("MIDX_DEBUG: wrong x,y (%d : %d, %d : %d) (%s:%d)\n", cx, Players[-(midx)]->px, cy, Players[-(midx)]->py, __FILE__, __LINE__); } \
            else { s_printf("MIDX_DEBUG: wrong y (%d : %d) (%s:%d)\n", cy, Players[-(midx)]->py, __FILE__, __LINE__); } \
        } \
    } \
}


/* Client chat modes */
#define CHAT_MODE_NORMAL	0
#define CHAT_MODE_PARTY		1
#define CHAT_MODE_LEVEL		2
#define CHAT_MODE_GUILD		3

/* Mode bits for askfor_aux */
#define ASKFOR_PRIVATE		0x01
#define ASKFOR_CHATTING		0x02


/* Hard-coded coordinates keeping track of special worldmap locations */
/* Location of our protected and used-for-special-cases sector 'sector000'. Make sure that events that use this sector don't collide! */
#define WPOS_SECTOR000_X		0
#define WPOS_SECTOR000_Y		0
#define WPOS_SECTOR000_Z		0
/* Location of the special-events sector's dungeon (must be either -1 or 1, for dungeon or tower): */
#define WPOS_SECTOR000_Z_DUN	-1
/* If we want to get out of sector000, what coords can be used? (Used to kick/keep players out who don't participate): */
#define WPOS_SECTOR000_ADJAC_X	1
#define WPOS_SECTOR000_ADJAC_Y	1

/* Deathmatch location of global event 'Highlander Tournament': */
#define WPOS_HIGHLANDER_X	WPOS_SECTOR000_X
#define WPOS_HIGHLANDER_Y	WPOS_SECTOR000_Y
#define WPOS_HIGHLANDER_Z	WPOS_SECTOR000_Z
#define WPOS_HIGHLANDER_DUN_Z	WPOS_SECTOR000_Z_DUN	/* ...and preparation dungeon location. */

/* important: note connection of WPOS_ARENA_ and 'ge_special_sector' */
#define WPOS_ARENA_X		(cfg.town_x)		/* location of global event 'Arena Monster Challenge' */
#define WPOS_ARENA_Y		(cfg.town_y)
#define WPOS_ARENA_Z		2			/* Use top-most floor of the 'Training Tower' dungeon located at that x,y sector (Bree) */

#define WPOS_PVPARENA_X		WPOS_SECTOR000_X		/* location of pvp arena for MODE_PVP players */
#define WPOS_PVPARENA_Y		WPOS_SECTOR000_Y
#define WPOS_PVPARENA_Z		(-WPOS_SECTOR000_Z_DUN)	/* use opposite side of the sector00-dungeon, as to not interfere with any events! Because the PvP arena must be available 24/7! */
/* Note: PvP-Arena MUST be at 1st floor of its dungeon/tower, because DM_MODULES count on that and sit on it. (see below) ^^ */

/* Location of the Modules dungeon, also located in the event sector 0,0,
   but on the opposite side of the event dungeon and above the PvP-Arena (counting on pvp-arena always being on 1st floor!), so they don't collide: */
#define WPOS_SECTOR000_Z_MODULE	(2 * (-WPOS_SECTOR000_Z_DUN))

#ifdef ARCADE_SERVER
 #define WPOS_ARCADE_X		(cfg.town_x)
 #define WPOS_ARCADE_Y		(cfg.town_y)
 #define WPOS_ARCADE_Z		3		/* one floor higher than where the 'Training Tower' town dungeon ends */
#endif

/* WPOS_IRONDEEPDIVE_X/Y are defined in defines-local.h,
   since those values are server-specific. */


/* Inventory change types */
#define INVENTORY_CHANGE_SLIDE	1
#define INVENTORY_CHANGE_MOVE	2
#define INVENTORY_CHANGE_ERASE	3


/* Maximum amount of ping reception times logged for each player */
#define MAX_PING_RECVS_LOGGED	10


/* Request types for p_ptr->request_type - C. Blue */
#define RTYPE_STR	0
#define RTYPE_NUM	1
#define RTYPE_KEY	2
#define RTYPE_CFR	3

/* ..and request IDs for p_ptr->request_id */
#define RID_NONE		0	/* fixed */
#ifdef ENABLE_GO_GAME			/* go.c Go minigame */
 #define RID_GO			1
 #define RID_GO_START		2
 #define RID_GO_MOVE		3
#endif
#define RID_GUILD_RENAME	4
#define RID_GUILD_CREATE	5
#ifdef SOLO_REKING
 #define RID_SR_DONATE		6
#endif
#ifdef ENABLE_ITEM_ORDER
 #define RID_ITEM_ORDER		7
#endif
#define RID_SEND_ITEM		8
#define RID_SEND_GOLD		9
#define RID_SEND_ITEM2		10
#define RID_SEND_GOLD2		11
#define RID_SEND_FEE		12
#define RID_SEND_ITEM_PAY	13
#define RID_SEND_ITEM_PAY2	14
#define RID_SEND_FEE_PAY	15
#define RID_REPAIR_ARMOUR	16
#define RID_REPAIR_WEAPON	17
#ifdef RESET_SKILL
 #define RID_LOSE_MEMORIES_I	18
 #define RID_LOSE_MEMORIES_II	19
 #define RID_LOSE_MEMORIES_I_SKILL	20
 #define RID_LOSE_MEMORIES_II_SKILL	21
#endif
#define RID_CONTACT_OWNER	22
#define RID_QUEST		100	/* this is a broadband RID, going from its value up to value+MAX_Q_IDX-1 */
#define RID_QUEST_ACQUIRE	(RID_QUEST + MAX_Q_IDX)	/* this is a broadband RID, going from its value up to value+MAX_Q_IDX-1 */

/* House type flags */
#define HF_NONE		0x0000
#define HF_MOAT		0x0001
#define HF_RECT		0x0002	/* Rectangular house; used for non-trad-houses (currently ALL houses are HF_RECT) */
#define HF_STOCK	0x0004	/* house generated by town, ie the town area housing (generated once on first server startup), that can be bought by players */
#define HF_NOFLOOR	0x0008	/* courtyard generated without floor */
#define HF_JAIL		0x0010	/* generate with CAVE_STCK */
#define HF_APART	0x0020	/* build apartment (obsolete - DELETEME) */
#define HF_TRAD		0x0040	/* Vanilla style house */
#define HF_DELETED	0x0080	/* Ruined house - do not save/reload */
#define HF_SELFBUILT	0x0100	/* Was constructed by "builders" (aka scroll of house creation) */
#define HF_GUILD_SUS	0x0200	/* Guild hall of a currently leaderless guild: 'suspended' guild hall */

#define MAXCOORD 200		/* Maximum vertices on non-rect house */

/* House owner type flags */
#define OT_PLAYER	1
#define OT_GUILD	2
#define OT_PARTY	3
#define OT_CLASS	4
#define OT_RACE		5

/* house access flags */
#define ACF_NONE	0x00

#define ACF_PARTY		0x01
#define ACF_CLASS		0x02
#define ACF_RACE		0x04
#define ACF_LEVEL		0x08
#define ACF_WINNER		0x10
#define ACF_FALLENWINNER	0x20
#define ACF_NOGHOST		0x40
#define ACF_STORE		0x80	/* older idea, I implemented it differently now (see PLAYER_STORES) - C. Blue */


/* account flags */
#define ACC_TRIAL	0x00000001U	/* Account is awaiting validation */
#define ACC_ADMIN	0x00000002U	/* Account members are admins */
#define ACC_MULTI	0x00000004U	/* Simultaneous play */
#define ACC_NOSCORE	0x00000008U	/* No scoring allowed */
#define ACC_RESTRICTED	0x00000010U	/* is restricted (ie after cheezing) */
#define ACC_VRESTRICTED	0x00000020U	/* is restricted (ie after cheating) */
#define ACC_PRIVILEGED	0x00000040U	/* has privileged powers (ie for running quests) */
#define ACC_VPRIVILEGED	0x00000080U	/* has privileged powers (ie for running quests) */
#define ACC_PVP		0x00000100U	/* may kill other players */
#define ACC_NOPVP	0x00000200U	/* is not able to kill other players */
#define ACC_ANOPVP	0x00000400U	/* cannot kill other players; gets punished on trying */
#define ACC_GREETED	0x00000800U	/* This player has received a one-time greeting. */
#define ACC_QUIET	0x00001000U	/* may not chat or emote in public */
#define ACC_VQUIET	0x00002000U	/* may not chat or emote, be it public or private */
#define ACC_BANNED	0x00004000U	/* account is temporarily suspended */
#define ACC_DELD	0x00008000U	/* Delete account/members */

#define ACC_GUILD_ADDER	0x20000000U	/* Character who died last was a guild adder (for auto-re-add) */
#define ACC_WARN_SALE	0x40000000U	/* 'Warn' that he has sold items in a player store */
#define ACC_WARN_REST	0x80000000U	/* Received a one-time warning about resting */


/* CS_flags - Cave special types */
#define CS_NONE		0
#define CS_DNADOOR	1
#define CS_KEYDOOR	2
#define CS_TRAPS	3	/* CS stands for Cave Special */
#define CS_INSCRIP	4	/* ok ;) i'll follow that from now */
#define CS_FOUNTAIN	5
#define CS_BETWEEN	6	/* petit jump type */
#define CS_BEACON	7	/* now used for events */
#define CS_MON_TRAP	8	/* monster traps */
#define CS_SHOP		9	/* shop/building */
#define CS_MIMIC	10	/* mimic-ing feature (eg. secret door) */
#define CS_RUNE		11	/* runecraft glyphs */

/* heheh it's kludge.. */
#define sc_is_pointer(type)	(type < 3 || type == 4 || type > 10)


/* Quest types */
#define QUEST_RANDOM	0x01	/* Random quest, not set by the DM */
#define QUEST_MONSTER	0x02	/* Kill some normal monsters. */
#define QUEST_UNIQUE	0x04	/* Kill unique monster (unkilled by players) */
#define QUEST_OBJECT	0x08	/* Find some object. Must not be owned, or found in the town. */
#define QUEST_RACE	0x10	/* Race quest - ie, not personal */
#define QUEST_GUILD	0x20	/* Guildmaster's quest (no prize) */


/* Guild flags */
#define GFLG_NONE		0x00000000U
#define GFLG_EVERLASTING	0x00000001U	/* it's an everlasting-mode guild (for auto_readd) */
#define GFLG_PVP		0x00000002U	/* it's a pvp-mode guild (for auto_readd) - currently not eligible */
#define GFLG_AUTO_READD		0x00000004U	/* automatically adds a player again after his char died, within 20 minutes */
#define GFLG_ALLOW_ADDERS	0x00000008U	/* enable adding more people by designated 'adders' (see PGF_ADDER below) */

/* Player guild flags */
#define PGF_NONE		0x00000000U
#define PGF_ADDER		0x00000001U	/* player may add other players to the guild although he's not the leader */



#define in_bree(wpos) ((wpos)->wx == cfg.town_x && (wpos)->wy == cfg.town_y && (wpos)->wz == 0)
#define in_trainingtower(wpos) ((wpos)->wx == cfg.town_x && (wpos)->wy == cfg.town_y && (wpos)->wz > 0)

/* check if a player is in the Nether Realms */
//#define in_netherrealm(wpos) (getlevel(wpos) >= netherrealm_start)
#define in_netherrealm(wpos) ((wpos)->wx == netherrealm_wpos_x && (wpos)->wy == netherrealm_wpos_y && (wpos)->wz * netherrealm_wpos_z > 0)
#define at_netherrealm(wpos) ((wpos)->wx == netherrealm_wpos_x && (wpos)->wy == netherrealm_wpos_y && (wpos)->wz * netherrealm_wpos_z >= 0)
#define on_netherrealm(wpos) ((wpos)->wx == netherrealm_wpos_x && (wpos)->wy == netherrealm_wpos_y && !(wpos)->wz)
#define netherrealm_bottom(wpos) ((wpos)->wx == netherrealm_wpos_x && (wpos)->wy == netherrealm_wpos_y && (wpos)->wz == netherrealm_end_wz)

#define in_hallsofmandos(wpos) ((wpos)->wx == hallsofmandos_wpos_x && (wpos)->wy == hallsofmandos_wpos_y && (wpos)->wz * hallsofmandos_wpos_z > 0)
#define in_mtdoom(wpos) ((wpos)->wx == mtdoom_wpos_x && (wpos)->wy == mtdoom_wpos_y && (wpos)->wz * mtdoom_wpos_z > 0)

/* Restrict escape from final Nether Realm level to WoR + ghost floating? (no stairs+no probtrav!) */
//#define NETHERREALM_BOTTOM_RESTRICT

/* check if a player is in Valinor */
#define in_valinor(wpos) ((wpos)->wx == valinor_wpos_x && (wpos)->wy == valinor_wpos_y && (wpos)->wz * valinor_wpos_z > 0)

/* quickly check if a given wpos is within certain special dungeons */
#define in_irondeepdive(wpos) \
	((wpos)->wx == WPOS_IRONDEEPDIVE_X && (wpos)->wy == WPOS_IRONDEEPDIVE_Y && (wpos)->wz * WPOS_IRONDEEPDIVE_Z > 0)
#define at_irondeepdive(wpos) \
	((wpos)->wx == WPOS_IRONDEEPDIVE_X && (wpos)->wy == WPOS_IRONDEEPDIVE_Y && (wpos)->wz * WPOS_IRONDEEPDIVE_Z >= 0)
#define on_irondeepdive(wpos) \
	((wpos)->wx == WPOS_IRONDEEPDIVE_X && (wpos)->wy == WPOS_IRONDEEPDIVE_Y && !(wpos)->wz)

/* in sector000, and it is active (separated)? */
#define in_sector00(wpos) \
	(sector000separation && (wpos)->wx == WPOS_SECTOR000_X && (wpos)->wy == WPOS_SECTOR000_Y)
#define in_sector000(wpos) \
	(sector000separation && (wpos)->wx == WPOS_SECTOR000_X && (wpos)->wy == WPOS_SECTOR000_Y && (wpos)->wz == WPOS_SECTOR000_Z)
#define in_sector000_dun(wpos) \
	(sector000separation && (wpos)->wx == WPOS_SECTOR000_X && (wpos)->wy == WPOS_SECTOR000_Y && (wpos)->wz * WPOS_SECTOR000_Z_DUN > 0)
#ifdef DM_MODULES
 #define in_module(wpos) \
	((wpos)->wx == WPOS_SECTOR000_X && (wpos)->wy == WPOS_SECTOR000_Y && \
	(wpos)->wz * SGN(WPOS_SECTOR000_Z_MODULE) >= WPOS_SECTOR000_Z_MODULE * SGN(WPOS_SECTOR000_Z_MODULE) && /* pseudo-EQV, lul */ \
	(wpos)->wz * SGN(WPOS_SECTOR000_Z_MODULE) <= WPOS_SECTOR000_Z_MODULE * SGN(WPOS_SECTOR000_Z_MODULE) + DM_MODULES_DUNGEON_SIZE - 1)
#endif

/* in the arena monster challenge? (which should be in TT) */
#define in_arena(wpos) \
	((wpos)->wx == WPOS_ARENA_X && (wpos)->wy == WPOS_ARENA_Y && (wpos)->wz == WPOS_ARENA_Z)

/* in the PvP arena? (which should be on 0,0) */
#define in_pvparena(wpos) \
	((wpos)->wx == WPOS_PVPARENA_X && (wpos)->wy == WPOS_PVPARENA_Y && (wpos)->wz == WPOS_PVPARENA_Z)

/* Is given wpos-pointer one of the two fixed towns, Menegroth or Nargothrond
   at dlvl 40 and 80 respectively, in the Ironman Deep Dive Challenge dungeon? */
#define IDDC_TOWN1_FIXED 40
#define IDDC_TOWN2_FIXED 80
#define IDDC_TOWN1_WILD 20
#define IDDC_TOWN2_WILD 60
#define is_fixed_irondeepdive_town(wpos, dlev) \
	(in_irondeepdive(wpos) && \
        ((dlev) == IDDC_TOWN1_FIXED || (dlev) == IDDC_TOWN2_FIXED))
/* For guaranteed 'wild' towns at the intermediate floors of 1k and 3k */
#define is_extra_fixed_irondeepdive_town(wpos, dlev) \
	(in_irondeepdive(wpos) && \
        ((dlev) == IDDC_TOWN1_WILD || (dlev) == IDDC_TOWN2_WILD))

/* Are we on the final floor and therefore eligile for recalling out? */
#define irondeepdive_bottom(wpos) \
	((wpos)->wx == WPOS_IRONDEEPDIVE_X && (wpos)->wy == WPOS_IRONDEEPDIVE_Y && (wpos)->wz * WPOS_IRONDEEPDIVE_Z == 127)

/* Will we definitely fail to recall out of IDDC? */
#define iddc_recall_fail(p_ptr, l_ptr) \
	(in_irondeepdive(&p_ptr->wpos) && (p_ptr->mode & MODE_DED_IDDC) && \
	!(irondeepdive_bottom(&p_ptr->wpos) || \
	 (l_ptr && (l_ptr->flags1 & LF1_IRON_RECALL) && p_ptr->wpos.wz >= 100)))

/* quickly check if a given wpos is inside the highlander dungeon */
#define in_highlander_dun(wpos) \
	((wpos)->wx == WPOS_HIGHLANDER_X && (wpos)->wy == WPOS_HIGHLANDER_Y && (wpos)->wz * WPOS_HIGHLANDER_DUN_Z > 0)
#define in_highlander(wpos) \
	((wpos)->wx == WPOS_HIGHLANDER_X && (wpos)->wy == WPOS_HIGHLANDER_Y && (wpos)->wz == WPOS_HIGHLANDER_Z)

#define in_deathfate(wpos) \
	((wpos)->wx == WPOS_DF_X && (wpos)->wy == WPOS_DF_Y && (wpos)->wz == WPOS_DF_Z)
#define in_deathfate2(wpos) \
	((wpos)->wx == WPOS_DF_X && (wpos)->wy == WPOS_DF_Y && (wpos)->wz == -WPOS_DF_Z)
#define in_deathfate_x(wpos) \
	((wpos)->wx == WPOS_DF_X && (wpos)->wy == WPOS_DF_Y && (wpos)->wz)

/* constants for get_item() to be transmitted to the client for choosing an item_tester_hook */
#define ITH_NONE	0
#define ITH_RECHARGE	1
#define ITH_ENCH_AC	2
#define ITH_ENCH_WEAP	3
#define ITH_CUSTOM_TOME	4
#define ITH_RUNE_ENCHANT	5
#define ITH_ENCH_AC_NO_SHIELD 6
#define ITH_ID		7
#define ITH_STARID	8
#define ITH_CHEMICAL	9	/* for ENABLE_DEMOLITIONIST */
/* keen hack: 4.6.0+ clients use ITH_ codes >= 50 and in turn signed char overflow < 0
   for transmitting max_weight for picking items for telekinesis. - C. Blue */
#define ITH_MAX_WEIGHT	50

/* Macros for less direct hard-coding of melee/ranged techniques */
/* Melee techniques */
#define MT_NONE		0x0000

#define MT_SPRINT	0x0001
#define MT_TAUNT	0x0002
#define MT_DIRT		0x0004
#define MT_BASH		0x0008

#if 0
 #define MT_STAB	0x0010
 #define MT_SLICE	0x0020
 #define MT_QUAKE	0x0040
 #define MT_SWEEP	0x0080
#endif

#define MT_DISTRACT	0x0010
#define MT_POISON	0x0020
#define MT_TRACKANIM	0x0040
#define MT_DETNOISE	0x0080

#define MT_FLASH	0x0100
#define MT_STEAMBLAST	0x0200
#define MT_SPIN		0x0400
#define MT_ASSA		0x0800

#define MT_BERSERK	0x1000
#define MT_JUMP		0x2000
#define MT_SJUMP	0x4000
#define MT_SRUN		0x8000

/* Ranged techniques */
#define RT_NONE		0x0000

#define RT_FLARE	0x0001
#define RT_PRECS	0x0002
#define RT_CRAFT	0x0004
#define RT_DOUBLE	0x0008

#define RT_BARRAGE	0x0010
#define RT_XXX0020	0x0020
#define RT_XXX0040	0x0040
#define RT_XXX0080	0x0080

#define RT_XXX0100	0x0100
#define RT_XXX0200	0x0200
#define RT_XXX0400	0x0400
#define RT_XXX0800	0x0800

#define RT_XXX1000	0x1000
#define RT_XXX2000	0x2000
#define RT_XXX4000	0x4000
#define RT_XXX8000	0x8000

/* Chance for weapons / digging tools / p_ptr->impact to cause an earthquake, even if all case-specific rolls already succeeded.
   Unified value for digging and fighting here, as characters could use their weapons as digging tools just as well. */
#define QUAKE_CHANCE	50

/* More readable than !is_older_than (in common/common.c) */
#define is_atleast(vtptr, ma, mi, pa, ex, br, bu) (!is_older_than(vtptr, ma, mi, pa, ex, br, bu))

/* Monster special 'status' (s16b) */
#define M_STATUS_NONE		0
#define M_STATUS_FRIENDLY	0x0001	/* Monster is friendy */


/* Helper function */
#define isalphanum(C) (isalpha(C) || isdigit(C))

/* For debugging - fixed */
//#define __GRID_DEBUG(Ind, wpos, feat, location, info)	if ((feat) == FEAT_XPROTECT && !in_trainingtower(wpos)) s_printf("__GRID_DEBUG: %s, %d - (%d) '%s' (%d,%d,%d)\n", location, info, Ind, (Ind) > 0 ? Players[Ind]->name : "-", (wpos)->wx, (wpos)->wy, (wpos)->wz);
