/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.quality.AbstractCodeQualityTask;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.plugins.quality.internal.CheckstyleAction;
import org.gradle.api.plugins.quality.internal.CheckstyleActionParameters;
import org.gradle.api.plugins.quality.internal.CheckstyleReportsImpl;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;

@CacheableTask
public abstract class Checkstyle
extends AbstractCodeQualityTask
implements Reporting<CheckstyleReports> {
    private FileCollection checkstyleClasspath;
    private FileCollection classpath;
    private TextResource config;
    private Map<String, Object> configProperties = new LinkedHashMap<String, Object>();
    private final CheckstyleReports reports;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean showViolations = true;
    private final DirectoryProperty configDirectory = this.getObjectFactory().directoryProperty();
    private final Property<Boolean> enableExternalDtdLoad;

    public Checkstyle() {
        this.reports = (CheckstyleReports)this.getObjectFactory().newInstance(CheckstyleReportsImpl.class, new Object[]{this});
        this.enableExternalDtdLoad = this.getObjectFactory().property(Boolean.class).convention((Object)false);
    }

    @Internal
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile((Object)configFile));
    }

    public CheckstyleReports reports(@DelegatesTo(value=CheckstyleReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public CheckstyleReports reports(Action<? super CheckstyleReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @TaskAction
    public void run() {
        this.runWithProcessIsolation();
    }

    private void runWithProcessIsolation() {
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> {
            this.configureForkOptions(spec.getForkOptions());
            spec.getForkOptions().getSystemProperties().put("checkstyle.enableExternalDtdLoad", ((Boolean)this.enableExternalDtdLoad.get()).toString());
        });
        workQueue.submit(CheckstyleAction.class, this::setupParameters);
    }

    private void setupParameters(CheckstyleActionParameters parameters) {
        parameters.getAntLibraryClasspath().setFrom((Iterable)this.getCheckstyleClasspath());
        parameters.getConfig().set(this.getConfigFile());
        parameters.getMaxErrors().set((Object)this.getMaxErrors());
        parameters.getMaxWarnings().set((Object)this.getMaxWarnings());
        parameters.getIgnoreFailures().set((Object)this.getIgnoreFailures());
        parameters.getConfigDirectory().set((Provider)this.getConfigDirectory());
        parameters.getShowViolations().set((Object)this.isShowViolations());
        parameters.getSource().setFrom((Iterable)this.getSource());
        parameters.getIsHtmlRequired().set((Provider)this.getReports().getHtml().getRequired());
        parameters.getIsXmlRequired().set((Provider)this.getReports().getXml().getRequired());
        parameters.getIsSarifRequired().set((Provider)this.getReports().getSarif().getRequired());
        parameters.getXmlOuputLocation().set((Provider)this.getReports().getXml().getOutputLocation());
        parameters.getHtmlOuputLocation().set((Provider)this.getReports().getHtml().getOutputLocation());
        parameters.getSarifOutputLocation().set((Provider)this.getReports().getSarif().getOutputLocation());
        parameters.getTemporaryDir().set(this.getTemporaryDir());
        parameters.getConfigProperties().set(this.getConfigProperties());
        TextResource stylesheetString = this.getReports().getHtml().getStylesheet();
        if (stylesheetString != null) {
            parameters.getStylesheetString().set((Object)stylesheetString.asString());
        }
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getCheckstyleClasspath() {
        return this.checkstyleClasspath;
    }

    public void setCheckstyleClasspath(FileCollection checkstyleClasspath) {
        this.checkstyleClasspath = checkstyleClasspath;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Nullable
    @Optional
    @Input
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(@Nullable Map<String, Object> configProperties) {
        this.configProperties = configProperties;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public DirectoryProperty getConfigDirectory() {
        return this.configDirectory;
    }

    @Nested
    public final CheckstyleReports getReports() {
        return this.reports;
    }

    @Input
    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Input
    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    @Console
    public boolean isShowViolations() {
        return this.showViolations;
    }

    public void setShowViolations(boolean showViolations) {
        this.showViolations = showViolations;
    }

    @Incubating
    @Input
    public Property<Boolean> getEnableExternalDtdLoad() {
        return this.enableExternalDtdLoad;
    }

    @Internal
    public boolean isIgnoreFailures() {
        return this.getIgnoreFailures();
    }
}

