/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import pcgen.base.util.FormatManager;
import pcgen.base.util.Indirect;

public class BasicIndirect<T>
implements Indirect<T> {
    private final FormatManager<T> formatManager;
    private final T object;

    public BasicIndirect(FormatManager<T> fmtManager, T obj) {
        if (fmtManager == null) {
            throw new IllegalArgumentException("Manager may not be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object may not be null");
        }
        if (!fmtManager.getManagedClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Object of class " + obj.getClass() + " is not compatible with provided Format Manager: " + fmtManager.getManagedClass());
        }
        this.object = obj;
        this.formatManager = fmtManager;
    }

    @Override
    public T resolvesTo() {
        return this.object;
    }

    @Override
    public String getUnconverted() {
        return this.formatManager.unconvert(this.object);
    }

    public String toString() {
        return String.valueOf(this.object);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicIndirect) {
            BasicIndirect other = (BasicIndirect)obj;
            return this.formatManager.equals(other.formatManager) && this.object.equals(other.object);
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

