/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class HPRollToken
extends Token {
    public static final String TOKENNAME = "HPROLL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String retString = "";
        String bString = aTok.nextToken();
        int levelOffset = Integer.parseInt(aTok.nextToken()) - 1;
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        if (bString.startsWith(TOKENNAME)) {
            bString = "ROLL";
        }
        if (levelOffset >= pc.getDisplay().getLevelInfoSize() || levelOffset < 0) {
            return "0";
        }
        if ("ROLL".equals(bString)) {
            retString = Integer.toString(HPRollToken.getRollToken(pc, levelOffset));
        } else if ("STAT".equals(bString)) {
            retString = Integer.toString(HPRollToken.getStatToken(pc.getDisplay()));
        } else if ("TOTAL".equals(bString)) {
            retString = Integer.toString(HPRollToken.getTotalToken(pc, levelOffset));
        }
        return retString;
    }

    public static int getRollToken(PlayerCharacter pc, int level) {
        CharacterDisplay display = pc.getDisplay();
        int classLevel = display.getLevelInfoClassLevel(level) - 1;
        int hpRoll = 0;
        PCClass pcClass = pc.getClassKeyed(display.getLevelInfoClassKeyName(level));
        if (pcClass != null) {
            PCClassLevel pcl = display.getActiveClassLevel(pcClass, classLevel);
            Integer hp = display.getHP(pcl);
            hpRoll = hp == null ? 0 : hp;
        }
        return hpRoll;
    }

    public static int getStatToken(CharacterDisplay display) {
        return (int)display.getStatBonusTo("HP", "BONUS");
    }

    public static int getTotalToken(PlayerCharacter pc, int level) {
        return HPRollToken.getRollToken(pc, level) + HPRollToken.getStatToken(pc.getDisplay());
    }
}

