/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.plugin.Combatant;
import gmgen.plugin.State;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.Fraction;
import org.jdom.Content;
import org.jdom.Element;
import pcgen.util.Logging;

public class XMLCombatant
extends Combatant {
    protected float cr;
    protected int xp;
    private Element combatant;

    public XMLCombatant(Element combatant) {
        this.combatant = combatant;
        try {
            combatant.getChild("Attributes").getChild("Strength").getAttribute("value").getIntValue();
            int dexVal = combatant.getChild("Attributes").getChild("Dexterity").getAttribute("value").getIntValue();
            int conVal = combatant.getChild("Attributes").getChild("Constitution").getAttribute("value").getIntValue();
            combatant.getChild("Attributes").getChild("Intelligence").getAttribute("value").getIntValue();
            combatant.getChild("Attributes").getChild("Wisdom").getAttribute("value").getIntValue();
            combatant.getChild("Attributes").getChild("Charisma").getAttribute("value").getIntValue();
            this.xp = combatant.getChild("General").getChild("Experience").getAttribute("total").getIntValue();
            this.cr = combatant.getChild("General").getChild("CR").getAttribute("value").getFloatValue();
            int hpVal = combatant.getChild("Combat").getChild("HitPoints").getAttribute("max").getIntValue();
            int hpCurrVal = combatant.getChild("Combat").getChild("HitPoints").getAttribute("current").getIntValue();
            int hpSubdual = 0;
            try {
                hpSubdual = combatant.getChild("Combat").getChild("HitPoints").getAttribute("subdual").getIntValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.setCombatantType(combatant.getAttribute("type").getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            String sInitBonus = combatant.getChild("Combat").getChild("Initiative").getAttribute("Misc").getValue();
            int initBonus = 0;
            if (sInitBonus.startsWith("+")) {
                sInitBonus = sInitBonus.substring(1);
                initBonus = Integer.parseInt(sInitBonus);
            } else {
                initBonus = Integer.parseInt(sInitBonus);
            }
            this.createSystemVals(dexVal, conVal, hpVal, hpCurrVal, hpSubdual, initBonus);
            try {
                this.init.setCurrentInitiative(combatant.getChild("Combat").getChild("Initiative").getAttribute("current").getIntValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.hitPoints.setState(State.getState(combatant.getChild("Combat").getChild("HitPoints").getAttribute("subdual").getValue()));
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    public XMLCombatant(String name, String player, int dexVal, int conVal, int hpVal, int hpCurrVal, int hpSubdual, int initBonus, String type, float cr) {
        this(name, player, 10, dexVal, conVal, 10, 10, 10, 0, 0, 0, hpVal, hpCurrVal, hpSubdual, initBonus, type, cr, 0);
    }

    public XMLCombatant(String name, String player, int strVal, int dexVal, int conVal, int intVal, int wisVal, int chaVal, int fortSave, int refSave, int willSave, int hpVal, int hpCurrVal, int hpSubdual, int initBonus, String type, float cr, int xp) {
        this.comType = type;
        this.xp = xp;
        this.createSystemVals(dexVal, conVal, hpVal, hpCurrVal, hpSubdual, initBonus);
        int dexMod = this.init.getAttribute().getModifier();
        int miscMod = initBonus - dexMod;
        this.combatant = new Element("Character");
        this.combatant.setAttribute("name", name);
        this.combatant.setAttribute("player", player);
        Element attributes = new Element("Attributes");
        attributes.addContent((Content)new Element("Strength").setAttribute("value", Integer.toString(strVal)));
        attributes.addContent((Content)new Element("Dexterity").setAttribute("value", Integer.toString(dexVal)));
        attributes.addContent((Content)new Element("Constitution").setAttribute("value", Integer.toString(conVal)));
        attributes.addContent((Content)new Element("Intelligence").setAttribute("value", Integer.toString(intVal)));
        attributes.addContent((Content)new Element("Wisdom").setAttribute("value", Integer.toString(wisVal)));
        attributes.addContent((Content)new Element("Charisma").setAttribute("value", Integer.toString(chaVal)));
        this.combatant.addContent((Content)attributes);
        Element saves = new Element("Saves");
        saves.addContent((Content)new Element("Fortitude").setAttribute("total", Integer.toString(fortSave)));
        saves.addContent((Content)new Element("Reflex").setAttribute("total", Integer.toString(refSave)));
        saves.addContent((Content)new Element("Will").setAttribute("total", Integer.toString(willSave)));
        this.combatant.addContent((Content)saves);
        Element general = new Element("General");
        general.addContent((Content)new Element("Experience").setAttribute("total", Integer.toString(0)));
        general.addContent((Content)new Element("CR").setAttribute("value", Float.toString(cr)));
        this.combatant.addContent((Content)general);
        this.cr = cr;
        Element combat = new Element("Combat");
        combat.addContent((Content)new Element("Initiative").setAttribute("mod", this.formatBonus(initBonus)).setAttribute("Dex", this.formatBonus(dexMod)).setAttribute("Misc", this.formatBonus(miscMod)));
        combat.addContent((Content)new Element("HitPoints").setAttribute("max", Integer.toString(hpVal)).setAttribute("current", Integer.toString(hpCurrVal)));
        this.combatant.addContent((Content)combat);
    }

    public int getAttribute(String name) {
        try {
            return this.combatant.getChild("Attributes").getChild(name).getAttribute("value").getIntValue();
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
            return 10;
        }
    }

    public void setAttribute(String name, int value) {
        try {
            this.combatant.getChild("Attributes").getChild(name).setAttribute("value", Integer.toString(value));
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    @Override
    public void setCR(float cr) {
        this.cr = cr;
    }

    @Override
    public float getCR() {
        return this.cr;
    }

    public String getCRForOutput() {
        String retString = "";
        String crAsString = Float.toString(this.cr);
        String decimalPlaceValue = crAsString.substring(crAsString.length() - 2);
        if (this.cr > 0.0f && this.cr < 1.0f) {
            Fraction fraction = Fraction.getFraction(this.cr);
            int denominator = fraction.getDenominator();
            int numerator = fraction.getNumerator();
            retString = numerator + "/" + denominator;
        } else if (this.cr >= 1.0f || this.cr == 0.0f) {
            int newCr = -99;
            if (decimalPlaceValue.equals(".0")) {
                newCr = (int)this.cr;
            }
            retString = newCr > -99 ? retString + newCr : retString + this.cr;
        }
        return retString;
    }

    public Element getElement() {
        return this.combatant;
    }

    public void setInitBonus(int initBonus) {
        this.init.setBonus(initBonus);
    }

    @Override
    public void setName(String name) {
        this.combatant.getAttribute("name").setValue(name);
    }

    @Override
    public String getName() {
        return this.combatant.getAttribute("name").getValue();
    }

    public void setPlayer(String player) {
        this.combatant.getAttribute("player").setValue(player);
    }

    @Override
    public String getPlayer() {
        return this.combatant.getAttribute("player").getValue();
    }

    public void setSave(String name, int value) {
        try {
            this.combatant.getChild("Saves").getChild(name).setAttribute("total", Integer.toString(value));
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    public int getSave(String name) {
        try {
            String saveBonus = this.combatant.getChild("Saves").getChild(name).getAttribute("total").getValue();
            if (saveBonus.startsWith("+")) {
                saveBonus = saveBonus.substring(1);
            }
            return Integer.parseInt(saveBonus);
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public Element getSaveElement() {
        Element retElement = (Element)this.combatant.clone();
        retElement.detach();
        int dexMod = this.init.getAttribute().getModifier();
        int initBonus = this.init.getModifier();
        int miscMod = this.init.getBonus();
        retElement.getChild("Attributes").getChild("Dexterity").setAttribute("value", Integer.toString(this.init.getAttribute().getValue()));
        retElement.getChild("Attributes").getChild("Constitution").setAttribute("value", Integer.toString(this.hitPoints.getAttribute().getValue()));
        retElement.getChild("Combat").getChild("HitPoints").setAttribute("max", Integer.toString(this.hitPoints.getMax()));
        retElement.getChild("Combat").getChild("HitPoints").setAttribute("current", Integer.toString(this.hitPoints.getCurrent()));
        retElement.getChild("Combat").getChild("HitPoints").setAttribute("subdual", Integer.toString(this.hitPoints.getSubdual()));
        retElement.getChild("Combat").getChild("HitPoints").setAttribute("state", this.hitPoints.getState().name());
        retElement.getChild("Combat").getChild("Initiative").setAttribute("mod", this.formatBonus(initBonus));
        retElement.getChild("Combat").getChild("Initiative").setAttribute("Dex", this.formatBonus(dexMod));
        retElement.getChild("Combat").getChild("Initiative").setAttribute("Misc", this.formatBonus(miscMod));
        if (this.init.getCurrentInitiative() > 0) {
            retElement.getChild("Combat").getChild("Initiative").setAttribute("current", Integer.toString(this.init.getCurrentInitiative()));
        }
        retElement.getChild("General").getChild("CR").setAttribute("value", Float.toString(this.cr));
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("type", this.getCombatantType());
        return retElement;
    }

    @Override
    public void setXP(int xp) {
        this.xp = xp;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public void editRow(List<String> columnOrder, int colNumber, Object data) {
        String columnName = columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus(State.getState(strData));
        } else if (columnName.equals("+")) {
            this.setInitBonus(Integer.parseInt(strData));
        } else if (columnName.equals("Init")) {
            this.init.setCurrentInitiative(Integer.parseInt(strData));
        } else if (columnName.equals("#")) {
            this.setNumber(Integer.parseInt(strData));
        } else if (columnName.equals("HP")) {
            this.hitPoints.setCurrent(Integer.parseInt(strData));
        } else if (columnName.equals("HP Max")) {
            this.hitPoints.setMax(Integer.parseInt(strData));
        } else if (columnName.equals("Dur")) {
            this.setDuration(Integer.parseInt(strData));
        } else if (columnName.equals("Type")) {
            this.setCombatantType(strData);
        }
    }

    private void createSystemVals(int dexVal, int conVal, int hpVal, int hpCurrVal, int subdual, int initBonus) {
        this.init = new SystemInitiative(new SystemAttribute("Dexterity", dexVal), initBonus);
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", conVal), hpVal, hpCurrVal);
        this.hitPoints.setSubdual(subdual);
    }

    private String formatBonus(int bonus) {
        if (bonus >= 0) {
            return "+" + bonus;
        }
        return String.valueOf(bonus);
    }

    @Override
    public String toHtmlString() {
        return new PcRenderer().getHtmlText();
    }

    protected class PcRenderer {
        protected PcRenderer() {
        }

        public String getHtmlText() {
            StringBuilder statBuf = new StringBuilder();
            statBuf.append("<html>");
            statBuf.append(this.getStatBlockHeader());
            statBuf.append("<body class='Normal' lang='EN-US'>");
            statBuf.append(this.getStatBlockTitle());
            statBuf.append(this.getStatBlockCore());
            statBuf.append("</html>");
            return statBuf.toString();
        }

        protected String getStatBlockHeader() {
            StringBuilder statBuf = new StringBuilder();
            statBuf.append("<head><title>");
            statBuf.append(XMLCombatant.this.getName());
            statBuf.append(" - ");
            statBuf.append(XMLCombatant.this.getPlayer());
            statBuf.append(" in GMGEN Statblock Format");
            statBuf.append("</title>");
            statBuf.append("<style type='text/css'>");
            statBuf.append("a:link {color: #006699}");
            statBuf.append("a:visited {color: #006699}");
            statBuf.append("a:hover {color: #006699}");
            statBuf.append("a:active {color: #006699}");
            statBuf.append(".type {color:#555555;font-weight:bold}");
            statBuf.append(".highlight {color:#FF0000}");
            statBuf.append(".dialog {color:#006699}");
            statBuf.append("</style></head>");
            return statBuf.toString();
        }

        protected String getStatBlockTitle() {
            StringBuilder statBuf = new StringBuilder();
            statBuf.append("<p class='gork'><font size='+1'><b>");
            statBuf.append(XMLCombatant.this.getName());
            statBuf.append("</b></font></p>");
            return statBuf.toString();
        }

        protected String getStatBlockCore() {
            StringBuilder statBuf = new StringBuilder();
            statBuf.append("<font class='type'>CR</font> ");
            statBuf.append(XMLCombatant.this.getCRForOutput());
            statBuf.append("; ");
            statBuf.append("<font class='type'>hp</font> ");
            statBuf.append(XMLCombatant.this.hitPoints.getCurrent());
            statBuf.append("/");
            statBuf.append(XMLCombatant.this.hitPoints.getMax());
            statBuf.append("<br>");
            statBuf.append("<font class='type'>Init</font> <font class='highlight'>");
            statBuf.append(XMLCombatant.this.init.getCurrentInitiative() >= 0 ? "+" : "");
            statBuf.append(XMLCombatant.this.init.getCurrentInitiative());
            statBuf.append("</font> (");
            statBuf.append(XMLCombatant.this.init.getAttribute().getModifier() >= 0 ? "+" : "");
            statBuf.append(XMLCombatant.this.init.getAttribute().getModifier());
            statBuf.append(" Dex, ");
            statBuf.append(XMLCombatant.this.init.getBonus() >= 0 ? "+" : "");
            statBuf.append(XMLCombatant.this.init.getBonus());
            statBuf.append(" Misc) ");
            statBuf.append("<br>");
            statBuf.append("<font class='type'>Saves:</font> Fort <font class='highlight'>");
            statBuf.append("<a href='save:FORTITUDE\\");
            int fortitudeSave = XMLCombatant.this.getSave("Fortitude");
            statBuf.append(fortitudeSave >= 0 ? "+" : "");
            statBuf.append(fortitudeSave);
            statBuf.append("' class='highlight'>");
            statBuf.append(fortitudeSave >= 0 ? "+" : "");
            statBuf.append(fortitudeSave);
            statBuf.append("</a>");
            statBuf.append("</font>, Ref <font class='highlight'>");
            statBuf.append("<a href='save:REFLEX\\");
            int reflexSave = XMLCombatant.this.getSave("Reflex");
            statBuf.append(reflexSave >= 0 ? "+" : "");
            statBuf.append(reflexSave);
            statBuf.append("' class='highlight'>");
            statBuf.append(reflexSave >= 0 ? "+" : "");
            statBuf.append(reflexSave);
            statBuf.append("</a>");
            statBuf.append("</font>, Will <font class='highlight'>");
            statBuf.append("<a href='save:WILL\\");
            int willSave = XMLCombatant.this.getSave("Will");
            statBuf.append(willSave >= 0 ? "+" : "");
            statBuf.append(willSave);
            statBuf.append("' class='highlight'>");
            statBuf.append(willSave >= 0 ? "+" : "");
            statBuf.append(willSave);
            statBuf.append("</a>");
            statBuf.append("</font> ");
            statBuf.append("<br>");
            ArrayList<SystemAttribute> statList = new ArrayList<SystemAttribute>();
            statList.add(new SystemAttribute("Str", XMLCombatant.this.getAttribute("Strength")));
            statList.add(new SystemAttribute("Con", XMLCombatant.this.getAttribute("Constitution")));
            statList.add(new SystemAttribute("Dex", XMLCombatant.this.getAttribute("Dexterity")));
            statList.add(new SystemAttribute("Int", XMLCombatant.this.getAttribute("Intelligence")));
            statList.add(new SystemAttribute("Wis", XMLCombatant.this.getAttribute("Wisdom")));
            statList.add(new SystemAttribute("Cha", XMLCombatant.this.getAttribute("Charisma")));
            for (SystemAttribute stat : statList) {
                statBuf.append("<font class='type'>");
                statBuf.append(stat.getName());
                statBuf.append("</font> ");
                statBuf.append(stat.getValue());
                statBuf.append("&nbsp;(");
                statBuf.append("<a href='check:");
                statBuf.append(stat.getName());
                statBuf.append("\\1d20");
                int statModifier = stat.getModifier();
                statBuf.append(statModifier >= 0 ? "+" : "");
                statBuf.append(statModifier);
                statBuf.append("' class='dialog'>");
                statBuf.append(statModifier >= 0 ? "+" : "");
                statBuf.append(statModifier);
                statBuf.append("</a>) ");
            }
            statBuf.append("</p>");
            return statBuf.toString();
        }
    }
}

