/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.facet.BonusChangeFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.SkillFacet;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.SkillUtilities;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.SkillDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.AbstractListFacade;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.gui2.facade.CharacterLevelFacadeImpl;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class CharacterLevelsFacadeImpl
extends AbstractListFacade<CharacterLevelFacade>
implements CharacterLevelsFacade,
DataFacetChangeListener<CharID, Skill>,
BonusChangeFacet.BonusChangeListener {
    private PlayerCharacter theCharacter;
    private CharacterDisplay charDisplay;
    private UIDelegate delegate;
    private List<ClassFacade> classLevels;
    private List<CharacterLevelFacade> charLevels;
    private final TodoManager todoManager;
    private CharID charID;
    private final DataSetFacade dataSetFacade;
    private CharacterFacadeImpl characterFacadeImpl;

    CharacterLevelsFacadeImpl(PlayerCharacter pc, UIDelegate delegate, TodoManager todoManager, DataSetFacade dataSetFacade, CharacterFacadeImpl characterFacadeImpl) {
        this.theCharacter = pc;
        this.characterFacadeImpl = characterFacadeImpl;
        this.charDisplay = pc.getDisplay();
        this.delegate = delegate;
        this.todoManager = todoManager;
        this.dataSetFacade = dataSetFacade;
        this.initForCharacter();
    }

    protected void closeCharacter() {
        SkillFacet skillFacet = FacetLibrary.getFacet(SkillFacet.class);
        skillFacet.removeDataFacetChangeListener(this);
        BonusChangeFacet bcf = FacetLibrary.getFacet(BonusChangeFacet.class);
        for (SkillFacade skillFacade : this.dataSetFacade.getSkills()) {
            bcf.removeBonusChangeListener(this, "SKILLRANK", skillFacade.getKeyName().toUpperCase());
        }
        this.theCharacter = null;
        this.charDisplay = null;
        this.charID = null;
    }

    private void initForCharacter() {
        this.classLevels = new ArrayList<ClassFacade>();
        this.charLevels = new ArrayList<CharacterLevelFacade>();
        this.refreshClassList();
        this.charID = this.theCharacter.getCharID();
        SkillFacet skillFacet = FacetLibrary.getFacet(SkillFacet.class);
        skillFacet.addDataFacetChangeListener(this);
        BonusChangeFacet bcf = FacetLibrary.getFacet(BonusChangeFacet.class);
        for (SkillFacade skillFacade : this.dataSetFacade.getSkills()) {
            bcf.addBonusChangeListener(this, "SKILLRANK", skillFacade.getKeyName().toUpperCase());
        }
    }

    @Override
    public CharacterLevelFacade getElementAt(int index) {
        if (index < 0 || index >= this.charLevels.size()) {
            return null;
        }
        return this.charLevels.get(index);
    }

    @Override
    public int getSize() {
        return this.charLevels.size();
    }

    private void clearContents() {
        this.charLevels.clear();
        this.fireElementsChanged(this);
    }

    private void addElement(CharacterLevelFacadeImpl levelFI) {
        int index = this.charLevels.size();
        this.charLevels.add(levelFI);
        this.fireElementAdded(this, levelFI, index);
    }

    private void removeElement(int i) {
        this.fireElementRemoved(this, this.charLevels.remove(i), i);
    }

    private void refreshClassList() {
        ArrayList<PCClass> newClasses = this.charDisplay.getClassList();
        Collection<PCLevelInfo> levelInfo = this.charDisplay.getLevelInfo();
        HashMap<String, Integer> levelCount = new HashMap<String, Integer>();
        HashMap<String, PCClass> classMap = new HashMap<String, PCClass>();
        for (PCClass pcClass : newClasses) {
            levelCount.put(pcClass.getKeyName(), 1);
            classMap.put(pcClass.getKeyName(), pcClass);
        }
        this.classLevels.clear();
        this.clearContents();
        for (PCLevelInfo lvlInfo : levelInfo) {
            String classKeyName = lvlInfo.getClassKeyName();
            PCClass currClass = (PCClass)classMap.get(classKeyName);
            if (currClass == null) {
                Logging.errorPrint("No PCClass found for '" + classKeyName + "' in character's class list: " + newClasses);
                return;
            }
            int clsLvlNum = (Integer)levelCount.get(classKeyName);
            levelCount.put(classKeyName, clsLvlNum + 1);
            this.classLevels.add(currClass);
            CharacterLevelFacadeImpl levelFI = new CharacterLevelFacadeImpl(currClass, this.classLevels.size());
            this.addElement(levelFI);
        }
        this.updateSkillsTodo();
    }

    @Override
    public ClassFacade getClassTaken(CharacterLevelFacade level) {
        if (level == null || !(level instanceof CharacterLevelFacadeImpl)) {
            return null;
        }
        return this.classLevels.get(this.getLevelIndex(level));
    }

    private PCClassLevel getClassLevel(CharacterLevelFacade level) {
        if (level == null || !(level instanceof CharacterLevelFacadeImpl)) {
            return null;
        }
        CharacterLevelFacadeImpl levelImpl = (CharacterLevelFacadeImpl)level;
        int lvlIdx = levelImpl.getCharacterLevel() - 1;
        String classKeyName = this.charDisplay.getLevelInfoClassKeyName(lvlIdx);
        PCClass aClass = this.theCharacter.getClassKeyed(classKeyName);
        if (aClass != null) {
            int clsLvl = this.charDisplay.getLevelInfoClassLevel(lvlIdx);
            PCClassLevel pcl = this.charDisplay.getActiveClassLevel(aClass, clsLvl - 1);
            return pcl;
        }
        return null;
    }

    @Override
    public int getHPGained(CharacterLevelFacade level) {
        int numHp = this.getHPRolled(level);
        if ((numHp += (int)this.charDisplay.getStatBonusTo("HP", "BONUS")) < 1) {
            numHp = 1;
        }
        return numHp;
    }

    @Override
    public int getHPRolled(CharacterLevelFacade level) {
        PCClassLevel classLevel = this.getClassLevel(level);
        if (classLevel == null) {
            return 0;
        }
        return this.charDisplay.getHP(classLevel);
    }

    @Override
    public void setHPRolled(CharacterLevelFacade level, int hp) {
        PCClassLevel classLevel = this.getClassLevel(level);
        if (classLevel != null) {
            this.theCharacter.setHP(classLevel, hp);
            this.fireHitPointEvent(this, this.getLevelIndex(level), false);
        }
    }

    PCLevelInfo getLevelInfo(CharacterLevelFacade level) {
        if (level == null || !(level instanceof CharacterLevelFacadeImpl)) {
            return null;
        }
        return this.charDisplay.getLevelInfo(this.getLevelIndex(level));
    }

    private int getLevelIndex(CharacterLevelFacade level) {
        CharacterLevelFacadeImpl levelImpl = (CharacterLevelFacadeImpl)level;
        if (levelImpl == null) {
            return 0;
        }
        return levelImpl.getCharacterLevel() - 1;
    }

    @Override
    public int getGainedSkillPoints(CharacterLevelFacade level) {
        PCLevelInfo classLevel = this.getLevelInfo(level);
        if (classLevel == null) {
            return 0;
        }
        return classLevel.getSkillPointsGained(this.theCharacter);
    }

    @Override
    public float getMaxRanks(CharacterLevelFacade level, SkillCost cost, boolean isClassForMaxRanks) {
        if (cost == null || level == null || !(level instanceof CharacterLevelFacadeImpl)) {
            return 0.0f;
        }
        if (cost.getCost() == 0) {
            return Float.NaN;
        }
        SkillCost costForMaxRanks = isClassForMaxRanks ? SkillCost.CLASS : cost;
        CharacterLevelFacadeImpl levelImpl = (CharacterLevelFacadeImpl)level;
        if (costForMaxRanks == SkillCost.CLASS) {
            return SkillUtilities.maxClassSkillForLevel(levelImpl.getCharacterLevel(), this.theCharacter).floatValue();
        }
        if (costForMaxRanks == SkillCost.CROSS_CLASS) {
            return SkillUtilities.maxCrossClassSkillForLevel(levelImpl.getCharacterLevel(), this.theCharacter).floatValue();
        }
        if (costForMaxRanks == SkillCost.EXCLUSIVE) {
            return SkillUtilities.maxClassSkillForLevel(levelImpl.getCharacterLevel(), this.theCharacter).floatValue();
        }
        return Float.NaN;
    }

    @Override
    public int getRankCost(CharacterLevelFacade level, SkillCost cost) {
        return cost.getCost();
    }

    @Override
    public SkillCost getSkillCost(CharacterLevelFacade level, SkillFacade skill) {
        if (level != null && level instanceof CharacterLevelFacadeImpl && this.charDisplay != null) {
            String classKeyName = this.charDisplay.getLevelInfoClassKeyName(this.getLevelIndex(level));
            PCClass aClass = this.theCharacter.getClassKeyed(classKeyName);
            if (skill instanceof Skill) {
                return this.theCharacter.getSkillCostForClass((Skill)skill, aClass);
            }
        }
        return null;
    }

    @Override
    public boolean isClassSkillForMaxRanks(CharacterLevelFacade level, SkillFacade skill) {
        for (int i = 0; i < this.charLevels.size(); ++i) {
            CharacterLevelFacade testLevel = this.getElementAt(i);
            if (this.getSkillCost(testLevel, skill) == SkillCost.CLASS) {
                return true;
            }
            if (testLevel != level) continue;
            return false;
        }
        return false;
    }

    @Override
    public int getSkillModifier(CharacterLevelFacade level, SkillFacade skill) {
        if (skill instanceof Skill) {
            return SkillModifier.modifier((Skill)skill, this.theCharacter);
        }
        return 0;
    }

    @Override
    public float getSkillRanks(CharacterLevelFacade level, SkillFacade skill) {
        if (skill instanceof Skill) {
            return SkillRankControl.getTotalRank(this.theCharacter, (Skill)skill).floatValue();
        }
        return 0.0f;
    }

    @Override
    public int getSkillTotal(CharacterLevelFacade level, SkillFacade skill) {
        if (skill instanceof Skill) {
            Float ranks = SkillRankControl.getTotalRank(this.theCharacter, (Skill)skill);
            Integer mods = SkillModifier.modifier((Skill)skill, this.theCharacter);
            return mods + ranks.intValue();
        }
        return 0;
    }

    @Override
    public CharacterLevelsFacade.SkillBreakdown getSkillBreakdown(CharacterLevelFacade level, SkillFacade skill) {
        CharacterLevelsFacade.SkillBreakdown sb = new CharacterLevelsFacade.SkillBreakdown();
        if (skill instanceof Skill) {
            sb.ranks = SkillRankControl.getTotalRank(this.theCharacter, (Skill)skill).floatValue();
            sb.modifier = SkillModifier.modifier((Skill)skill, this.theCharacter);
            sb.total = sb.modifier + (int)sb.ranks;
        }
        return sb;
    }

    @Override
    public int getSpentSkillPoints(CharacterLevelFacade level) {
        PCLevelInfo classLevel = this.getLevelInfo(level);
        if (classLevel == null) {
            return 0;
        }
        return classLevel.getSkillPointsGained(this.theCharacter) - classLevel.getSkillPointsRemaining();
    }

    @Override
    public int getRemainingSkillPoints(CharacterLevelFacade level) {
        PCLevelInfo classLevel = this.getLevelInfo(level);
        if (classLevel == null) {
            return 0;
        }
        return classLevel.getSkillPointsRemaining();
    }

    @Override
    public boolean investSkillPoints(CharacterLevelFacade level, SkillFacade skill, int points) {
        String classKeyName;
        PCClass aClass;
        String errMessage;
        int skillPool;
        if (points == 0 || level == null || !(level instanceof CharacterLevelFacadeImpl)) {
            Logging.errorPrint("Invalid request to investSkillPoints in " + skill + ". Points: " + points + " level: " + level);
            return false;
        }
        PCLevelInfo classLevel = this.getLevelInfo(level);
        if (Globals.getGameModeHasPointPool()) {
            skillPool = this.theCharacter.getSkillPoints();
        } else {
            skillPool = classLevel.getSkillPointsRemaining();
            if (!(points >= 0 || skillPool - points <= classLevel.getSkillPointsGained(this.theCharacter) && this.classHasRanksIn(skill, ((CharacterLevelFacadeImpl)level).getSelectedClass()))) {
                level = this.findLevelWithSpentSkillPoints(points, skill);
                if (level == null) {
                    this.delegate.showInfoMessage("PCGen", LanguageBundle.getFormattedString("in_iskErr_message_05", skill));
                    return false;
                }
                classLevel = this.getLevelInfo(level);
                skillPool = classLevel.getSkillPointsRemaining();
            }
        }
        if (points > 0 && points > skillPool) {
            this.delegate.showInfoMessage("PCGen", LanguageBundle.getFormattedString("in_iskErr_message_04a", String.valueOf(skillPool)));
            return false;
        }
        SkillCost sc = this.getSkillCost(level, skill);
        if (sc == null) {
            Logging.errorPrint("Failed to get skillcost for skill " + skill + ". Could not process request to invest " + points + " in the skill");
            return false;
        }
        if (sc.equals((Object)SkillCost.EXCLUSIVE)) {
            this.delegate.showInfoMessage("PCGen", LanguageBundle.getString("in_iskErr_message_06"));
            return false;
        }
        double cost = sc.getCost();
        double rank = (double)points / cost;
        Skill aSkill = (Skill)skill;
        boolean hasSkill = this.charDisplay.hasSkill(aSkill);
        if (!hasSkill) {
            SkillDisplay.updateSkillsOutputOrder(this.theCharacter, aSkill);
        }
        if ("".equals(errMessage = SkillRankControl.modRanks(rank, aClass = this.theCharacter.getClassKeyed(classKeyName = this.charDisplay.getLevelInfoClassKeyName(this.getLevelIndex(level))), false, this.theCharacter, aSkill))) {
            classLevel.setSkillPointsRemaining(skillPool - points);
        }
        if (ChooseActivation.hasNewChooseToken(aSkill) && this.characterFacadeImpl != null) {
            this.characterFacadeImpl.postLevellingUpdates();
        }
        if (errMessage.length() > 0) {
            this.delegate.showInfoMessage("PCGen", errMessage);
            return false;
        }
        this.updateSkillsTodo();
        this.fireSkillPointEvent(this, this.getLevelIndex(level), false);
        this.fireSkillBonusEvent(this, this.getLevelIndex(level), false);
        return true;
    }

    @Override
    public CharacterLevelFacade findNextLevelForSkill(SkillFacade skill, CharacterLevelFacade baseLevel, float newRank) {
        Skill aSkill = (Skill)skill;
        SkillCost skillCost = this.getSkillCost(baseLevel, aSkill);
        float maxRanks = this.getMaxRanks(baseLevel, skillCost, this.isClassSkillForMaxRanks(baseLevel, aSkill));
        float currRank = SkillRankControl.getTotalRank(this.theCharacter, aSkill).floatValue();
        if (newRank < currRank) {
            if (this.classHasRanksIn(skill, ((CharacterLevelFacadeImpl)baseLevel).getSelectedClass()) && !Float.isNaN(maxRanks) && maxRanks >= currRank && this.getSpentSkillPoints(baseLevel) > 0) {
                return baseLevel;
            }
            CharacterLevelFacade levelToRefundSkill = this.scanForLevelToRefundSkill(aSkill, currRank, (PCClass)this.getClassTaken(baseLevel));
            if (levelToRefundSkill != null) {
                return levelToRefundSkill;
            }
            levelToRefundSkill = this.scanForLevelToRefundSkill(aSkill, currRank, null);
            return levelToRefundSkill;
        }
        if (!Float.isNaN(maxRanks) && maxRanks >= newRank && this.getRemainingSkillPoints(baseLevel) > 0) {
            return baseLevel;
        }
        int baseLevelIndex = this.getLevelIndex(baseLevel);
        CharacterLevelFacade levelToBuySkill = this.scanForwardforLevelToBuySkill(aSkill, newRank, baseLevelIndex, SkillCost.CLASS);
        if (levelToBuySkill != null) {
            return levelToBuySkill;
        }
        levelToBuySkill = this.scanForwardforLevelToBuySkill(aSkill, newRank, 0, SkillCost.CLASS);
        if (levelToBuySkill != null) {
            return levelToBuySkill;
        }
        levelToBuySkill = this.scanForwardforLevelToBuySkill(aSkill, newRank, baseLevelIndex, null);
        if (levelToBuySkill != null) {
            return levelToBuySkill;
        }
        levelToBuySkill = this.scanForwardforLevelToBuySkill(aSkill, newRank, 0, null);
        return levelToBuySkill;
    }

    private CharacterLevelFacade scanForwardforLevelToBuySkill(Skill aSkill, float testRank, int baseLevelIndex, SkillCost costToMatch) {
        for (int i = baseLevelIndex; i < this.charLevels.size(); ++i) {
            float maxRanks;
            CharacterLevelFacade testLevel = this.getElementAt(i);
            if (this.getRemainingSkillPoints(testLevel) <= 0) continue;
            SkillCost skillCost = this.getSkillCost(testLevel, aSkill);
            if (costToMatch != null && skillCost.getCost() != costToMatch.getCost() || Float.isNaN(maxRanks = this.getMaxRanks(testLevel, skillCost, this.isClassSkillForMaxRanks(testLevel, aSkill))) || !(maxRanks >= testRank)) continue;
            return testLevel;
        }
        return null;
    }

    private CharacterLevelFacade scanForLevelToRefundSkill(Skill aSkill, float testRank, PCClass classToMatch) {
        for (int i = 0; i < this.charLevels.size(); ++i) {
            SkillCost skillCost;
            float maxRanks;
            CharacterLevelFacade testLevel = this.getElementAt(i);
            String lvlClassName = this.getLevelInfo(testLevel).getClassKeyName();
            if (classToMatch != null && !classToMatch.getKeyName().equals(lvlClassName) || !this.classHasRanksIn(aSkill, ((CharacterLevelFacadeImpl)testLevel).getSelectedClass()) || this.getSpentSkillPoints(testLevel) <= 0 || Float.isNaN(maxRanks = this.getMaxRanks(testLevel, skillCost = this.getSkillCost(testLevel, aSkill), this.isClassSkillForMaxRanks(testLevel, aSkill))) || !(maxRanks >= testRank)) continue;
            return testLevel;
        }
        return null;
    }

    private CharacterLevelFacade findLevelWithSpentSkillPoints(int points, SkillFacade skill) {
        for (int i = this.charLevels.size() - 1; i >= 0; --i) {
            CharacterLevelFacadeImpl levelFacade = (CharacterLevelFacadeImpl)this.charLevels.get(i);
            PCLevelInfo levelInfo = this.getLevelInfo(levelFacade);
            if (levelInfo.getSkillPointsRemaining() - points > levelInfo.getSkillPointsGained(this.theCharacter) || !this.classHasRanksIn(skill, levelFacade.getSelectedClass())) continue;
            return levelFacade;
        }
        return null;
    }

    private boolean classHasRanksIn(SkillFacade skill, ClassFacade pcClass) {
        Double rank = this.theCharacter.getSkillRankForClass((Skill)skill, (PCClass)pcClass);
        return rank != null && rank > 0.0;
    }

    protected void updateSkillsTodo() {
        int remainingPoints = this.calcRemainingSkillPoints();
        if (remainingPoints < 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SKILLS, "Skills", "in_iskTodoTooMany", 1));
            this.todoManager.removeTodo("in_iskTodoRemain");
        } else if (remainingPoints > 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SKILLS, "Skills", "in_iskTodoRemain", 1));
            this.todoManager.removeTodo("in_iskTodoTooMany");
        } else {
            this.todoManager.removeTodo("in_iskTodoRemain");
            this.todoManager.removeTodo("in_iskTodoTooMany");
        }
    }

    private int calcRemainingSkillPoints() {
        int numRemaining = 0;
        for (CharacterLevelFacade clf : this.charLevels) {
            numRemaining += this.getRemainingSkillPoints(clf);
        }
        return numRemaining;
    }

    @Override
    public void setGainedSkillPoints(CharacterLevelFacade level, int points) {
        int spentSkillPoints = this.getSpentSkillPoints(level);
        PCLevelInfo classLevel = this.getLevelInfo(level);
        classLevel.setSkillPointsGained(this.theCharacter, points);
        classLevel.setSkillPointsRemaining(points - spentSkillPoints);
        this.fireSkillPointEvent(this, this.getLevelIndex(level), false);
    }

    void addLevelOfClass(CharacterLevelFacadeImpl theClassLevel) {
        ClassFacade theClass = theClassLevel.getSelectedClass();
        this.classLevels.add(theClass);
        this.addElement(theClassLevel);
        this.updateSkillsTodo();
    }

    void removeLastLevel() {
        this.classLevels.remove(this.classLevels.size() - 1);
        this.removeElement(this.getSize() - 1);
        this.updateSkillsTodo();
    }

    void classListRefreshRequired() {
        this.refreshClassList();
        this.fireClassChangedEvent(this, 0, true);
        this.fireSkillBonusEvent(this, 0, true);
    }

    @Override
    public void addClassListener(CharacterLevelsFacade.ClassListener listener) {
        this.listenerList.add(CharacterLevelsFacade.ClassListener.class, listener);
    }

    @Override
    public void addHitPointListener(CharacterLevelsFacade.HitPointListener listener) {
        this.listenerList.add(CharacterLevelsFacade.HitPointListener.class, listener);
    }

    @Override
    public void addSkillBonusListener(CharacterLevelsFacade.SkillBonusListener listener) {
        this.listenerList.add(CharacterLevelsFacade.SkillBonusListener.class, listener);
    }

    @Override
    public void addSkillPointListener(CharacterLevelsFacade.SkillPointListener listener) {
        this.listenerList.add(CharacterLevelsFacade.SkillPointListener.class, listener);
    }

    @Override
    public void removeClassListener(CharacterLevelsFacade.ClassListener listener) {
        this.listenerList.remove(CharacterLevelsFacade.ClassListener.class, listener);
    }

    @Override
    public void removeHitPointListener(CharacterLevelsFacade.HitPointListener listener) {
        this.listenerList.remove(CharacterLevelsFacade.HitPointListener.class, listener);
    }

    @Override
    public void removeSkillBonusListener(CharacterLevelsFacade.SkillBonusListener listener) {
        this.listenerList.remove(CharacterLevelsFacade.SkillBonusListener.class, listener);
    }

    @Override
    public void removeSkillPointListener(CharacterLevelsFacade.SkillPointListener listener) {
        this.listenerList.remove(CharacterLevelsFacade.SkillPointListener.class, listener);
    }

    protected void fireClassChangedEvent(Object source, int baseLevelIndex, boolean stacks) {
        Object[] listeners = this.listenerList.getListenerList();
        CharacterLevelsFacade.CharacterLevelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CharacterLevelsFacade.ClassListener.class) continue;
            if (e == null) {
                e = new CharacterLevelsFacade.CharacterLevelEvent(source, baseLevelIndex, stacks);
            }
            ((CharacterLevelsFacade.ClassListener)listeners[i + 1]).classChanged(e);
        }
    }

    protected void fireHitPointEvent(Object source, int baseLevelIndex, boolean stacks) {
        Object[] listeners = this.listenerList.getListenerList();
        CharacterLevelsFacade.CharacterLevelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CharacterLevelsFacade.HitPointListener.class) continue;
            if (e == null) {
                e = new CharacterLevelsFacade.CharacterLevelEvent(source, baseLevelIndex, stacks);
            }
            ((CharacterLevelsFacade.HitPointListener)listeners[i + 1]).hitPointsChanged(e);
        }
    }

    protected void fireSkillPointEvent(Object source, int baseLevelIndex, boolean stacks) {
        Object[] listeners = this.listenerList.getListenerList();
        CharacterLevelsFacade.CharacterLevelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CharacterLevelsFacade.SkillPointListener.class) continue;
            if (e == null) {
                e = new CharacterLevelsFacade.CharacterLevelEvent(source, baseLevelIndex, stacks);
            }
            ((CharacterLevelsFacade.SkillPointListener)listeners[i + 1]).skillPointsChanged(e);
        }
    }

    protected void fireSkillBonusEvent(Object source, int baseLevelIndex, boolean stacks) {
        Object[] listeners = this.listenerList.getListenerList();
        CharacterLevelsFacade.CharacterLevelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CharacterLevelsFacade.SkillBonusListener.class) continue;
            if (e == null) {
                e = new CharacterLevelsFacade.CharacterLevelEvent(source, baseLevelIndex, stacks);
            }
            ((CharacterLevelsFacade.SkillBonusListener)listeners[i + 1]).skillBonusChanged(e);
        }
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Skill> dfce) {
        if (dfce.getCharID() != this.charID) {
            return;
        }
        Skill skill = dfce.getCDOMObject();
        if (this.theCharacter.getRank(skill).floatValue() > 0.0f) {
            this.fireSkillBonusEvent(this, 0, true);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Skill> dfce) {
        if (dfce.getCharID() != this.charID) {
            return;
        }
        this.fireSkillBonusEvent(this, 0, true);
    }

    @Override
    public void bonusChange(BonusChangeFacet.BonusChangeEvent bce) {
        if (bce.getCharID() != this.charID || bce.getOldVal() == null) {
            return;
        }
        this.fireSkillBonusEvent(this, 0, true);
    }
}

