/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.facade.core.ChooserFacade;
import pcgen.util.StringPClassUtil;
import pcgen.util.chooser.ChooserFactory;

public class ConcreteTransitionChoice<T>
implements TransitionChoice<T> {
    private final SelectableSet<? extends T> choices;
    private final Formula choiceCount;
    private boolean required = true;
    private ChoiceActor<T> choiceActor;
    private boolean allowStack = false;
    private Integer stackLimit = null;

    public ConcreteTransitionChoice(SelectableSet<? extends T> set, Formula count) {
        this.choices = set;
        this.choiceCount = count;
    }

    @Override
    public SelectableSet<? extends T> getChoices() {
        return this.choices;
    }

    @Override
    public Formula getCount() {
        return this.choiceCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConcreteTransitionChoice) {
            ConcreteTransitionChoice other = (ConcreteTransitionChoice)obj;
            if (this.choiceCount == other.choiceCount || this.choiceCount != null && this.choiceCount.equals(other.choiceCount)) {
                return this.choices.equals(other.choices);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.choices.hashCode() + 29 * (this.choiceCount == null ? -1 : this.choiceCount.hashCode());
    }

    @Override
    public Collection<? extends T> driveChoice(PlayerCharacter pc) {
        int numChoices = this.choiceCount.resolve(pc, "").intValue();
        boolean pickall = numChoices == Integer.MAX_VALUE;
        String title = this.choices.getTitle();
        if (title == null) {
            title = "Choose a " + StringPClassUtil.getStringFor(this.choices.getChoiceClass());
        }
        Collection<T> set = this.choices.getSet(pc);
        LinkedHashSet<T> allowed = new LinkedHashSet<T>();
        List<Object> assocList = pc.getAssocList(this, AssociationListKey.ADD);
        for (T item : set) {
            if (this.choiceActor != null && !this.choiceActor.allow(item, pc, this.allowStack)) continue;
            if (assocList != null && this.stackLimit != null && this.stackLimit > 0) {
                int takenCount = 0;
                for (Object choice : assocList) {
                    if (!choice.equals(item)) continue;
                    ++takenCount;
                }
                if (this.stackLimit <= takenCount) continue;
            }
            allowed.add(item);
        }
        if (pickall || numChoices == set.size()) {
            return allowed;
        }
        CDOMChooserFacadeImpl chooserFacade = new CDOMChooserFacadeImpl(title, new ArrayList(allowed), new ArrayList(), numChoices);
        chooserFacade.setAllowsDups(this.allowStack);
        chooserFacade.setRequireCompleteSelection(this.required);
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        return chooserFacade.getFinalSelected();
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    @Override
    public void setChoiceActor(ChoiceActor<T> actor) {
        this.choiceActor = actor;
    }

    @Override
    public void act(Collection<? extends T> choicesMade, CDOMObject owner, PlayerCharacter apc) {
        if (this.choiceActor == null) {
            throw new IllegalStateException("Cannot act without a defined ChoiceActor");
        }
        for (T choice : choicesMade) {
            this.choiceActor.applyChoice(owner, choice, apc);
            apc.addAssoc(this, AssociationListKey.ADD, choice);
        }
    }

    public T castChoice(Object item) {
        return (T)item;
    }

    @Override
    public void allowStack(boolean allow) {
        this.allowStack = allow;
    }

    @Override
    public void setStackLimit(int limit) {
        this.stackLimit = limit;
    }

    @Override
    public boolean allowsStacking() {
        return this.allowStack;
    }

    @Override
    public Integer getStackLimit() {
        return this.stackLimit;
    }

    @Override
    public ChoiceActor<T> getChoiceActor() {
        return this.choiceActor;
    }
}

