/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.settings;

import com.jgoodies.common.bean.Bean;
import java.util.prefs.Preferences;

public final class ChartSettings
extends Bean {
    public static final String PROPERTY_BRIGHTNESS = "brightness";
    public static final String PROPERTY_DEPTH = "depth";
    public static final String PROPERTY_SATURATION = "saturation";
    public static final String PROPERTY_ELEMENT_LIMIT = "elementLimit";
    public static final String PROPERTY_ELEMENT_THRESHOLD = "elementThreshold";
    public static final float MIN_BRIGHTNESS = 0.3f;
    private static final float DEFAULT_BRIGHTNESS = 0.9f;
    public static final float MAX_BRIGHTNESS = 1.0f;
    public static final int MIN_DEPTH = 1;
    private static final int DEFAULT_DEPTH = 5;
    public static final int MAX_DEPTH = 10;
    public static final int MIN_ELEMENT_LIMIT = 5;
    private static final int DEFAULT_ELEMENT_LIMIT = 13;
    public static final int MAX_ELEMENT_LIMIT = 20;
    public static final float MIN_ELEMENT_THRESHOLD = 0.0f;
    private static final float DEFAULT_ELEMENT_THRESHOLD = 0.01f;
    public static final float MAX_ELEMENT_THRESHOLD = 0.1f;
    public static final float MIN_SATURATION = 0.1f;
    private static final float DEFAULT_SATURATION = 0.5f;
    public static final float MAX_SATURATION = 1.0f;
    private float brightness = 0.9f;
    private int depth = 5;
    private int elementLimit = 13;
    private float elementThreshold = 0.01f;
    private float saturation = 0.5f;
    private static final String KEY_BRIGHTNESS = "chart.brightness";
    private static final String KEY_DEPTH = "chart.depth";
    private static final String KEY_ELEMENT_LIMIT = "chart.elementLimit";
    private static final String KEY_ELEMENT_THRESHOLD = "chart.element_threshold";
    private static final String KEY_SATURATION = "chart.saturation";

    ChartSettings() {
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float newBrightness) {
        float oldBrightness = this.getBrightness();
        this.brightness = newBrightness;
        this.firePropertyChange(PROPERTY_BRIGHTNESS, oldBrightness, newBrightness);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int newDepth) {
        int oldDepth = this.getDepth();
        this.depth = newDepth;
        this.firePropertyChange(PROPERTY_DEPTH, oldDepth, newDepth);
    }

    public int getElementLimit() {
        return this.elementLimit;
    }

    public void setElementLimit(int newValue) {
        float oldValue = this.getElementLimit();
        this.elementLimit = newValue;
        this.firePropertyChange(PROPERTY_ELEMENT_LIMIT, oldValue, (float)newValue);
    }

    public float getElementThreshold() {
        return this.elementThreshold;
    }

    public void setElementThreshold(float newThreshold) {
        float oldThreshold = this.getElementThreshold();
        this.elementThreshold = newThreshold;
        this.firePropertyChange(PROPERTY_ELEMENT_THRESHOLD, oldThreshold, newThreshold);
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float newSaturation) {
        float oldSaturation = this.getSaturation();
        this.saturation = newSaturation;
        this.firePropertyChange(PROPERTY_SATURATION, oldSaturation, newSaturation);
    }

    public void restoreFrom(Preferences prefs) {
        this.setBrightness(ChartSettings.boundedValue(prefs.getFloat(KEY_BRIGHTNESS, -1.0f), 0.3f, 1.0f, 0.9f));
        this.setDepth(ChartSettings.boundedValue(prefs.getInt(KEY_DEPTH, -1), 1, 10, 5));
        this.setElementLimit(ChartSettings.boundedValue(prefs.getInt(KEY_ELEMENT_LIMIT, -1), 5, 20, 13));
        this.setElementThreshold(ChartSettings.boundedValue(prefs.getFloat(KEY_ELEMENT_THRESHOLD, -1.0f), 0.0f, 0.1f, 0.01f));
        this.setSaturation(ChartSettings.boundedValue(prefs.getFloat(KEY_SATURATION, -1.0f), 0.1f, 1.0f, 0.5f));
    }

    public void storeIn(Preferences prefs) {
        prefs.putFloat(KEY_BRIGHTNESS, this.getBrightness());
        prefs.putInt(KEY_DEPTH, this.getDepth());
        prefs.putInt(KEY_ELEMENT_LIMIT, this.getElementLimit());
        prefs.putFloat(KEY_ELEMENT_THRESHOLD, this.getElementThreshold());
        prefs.putFloat(KEY_SATURATION, this.getSaturation());
    }

    private static float boundedValue(float f, float min, float max, float defaultValue) {
        return min <= f && f <= max ? f : defaultValue;
    }

    private static int boundedValue(int i, int min, int max, int defaultValue) {
        return min <= i && i <= max ? i : defaultValue;
    }
}

