/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.icon;

import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.components.util.CompoundIcon;
import com.jgoodies.fluent.internal.FluentResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;

public final class AppIcons {
    private AppIcons() {
    }

    public static Icon createFilledCircle(String text) {
        return AppIcons.createFilledCircle(text, 32, Color.BLACK, new Color(224, 224, 224));
    }

    public static Icon createFilledCircle(String text, int size, Color foreground, Color background) {
        return new CompoundIcon(WindowsIcon.FULL_CIRCLE_MASK.toIcon(size, background), new MiniTextIcon(text, foreground), CompoundIcon.Anchor.CENTER);
    }

    static final class MiniTextIcon
    implements Icon {
        private final String text;
        private final Color foreground;
        private final int width;
        private final int height;

        MiniTextIcon(String text, Color foreground) {
            this.text = text;
            this.foreground = foreground;
            JLabel label = new JLabel(text);
            label.setFont(MiniTextIcon.captionFont());
            this.width = label.getPreferredSize().width;
            this.height = label.getPreferredSize().height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Font oldFont = g.getFont();
            Color oldColor = g.getColor();
            g.setFont(MiniTextIcon.captionFont());
            g.setColor(this.foreground);
            g.drawString(this.text, x, y + 13);
            g.setFont(oldFont);
            g.setColor(oldColor);
        }

        private static Font captionFont() {
            return FluentResources.getInstance().getTileTitleFont().deriveFont(11.0f);
        }
    }
}

