/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.scan;

import JTrrntzip.DummyLogCallback;
import JTrrntzip.SimpleTorrentZipOptions;
import JTrrntzip.TorrentZip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.CRC32;
import java.util.zip.ZipError;
import jrm.compressors.SevenZipArchive;
import jrm.compressors.zipfs.ZipFileSystemProvider;
import jrm.digest.MDigest;
import jrm.io.chd.CHDInfoReader;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.Log;
import jrm.misc.Settings;
import jrm.profile.Profile;
import jrm.profile.data.Archive;
import jrm.profile.data.Container;
import jrm.profile.data.Directory;
import jrm.profile.data.Disk;
import jrm.profile.data.Entry;
import jrm.profile.data.Rom;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.ProgressHandler;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public final class DirScan {
    private final List<Container> containers = Collections.synchronizedList(new ArrayList());
    private final Map<String, Container> containers_byname;
    private final Map<String, Entry> entries_bycrc = Collections.synchronizedMap(new HashMap());
    private final Map<String, Entry> entries_bysha1 = Collections.synchronizedMap(new HashMap());
    private final Map<String, Entry> entries_bymd5 = Collections.synchronizedMap(new HashMap());
    private final boolean need_sha1_or_md5;
    private final boolean md5_disks;
    private final boolean md5_roms;
    private final boolean sha1_disks;
    private final boolean sha1_roms;
    private HashSet<String> suspicious_crc = null;
    private final File dir;
    private final ProgressHandler handler;
    private EnumSet<Options> options;

    private void init7zJBinding() {
        if (!SevenZip.isInitializedSuccessfully()) {
            try {
                SevenZip.initSevenZipFromPlatformJAR((File)Settings.getTmpPath(true).toFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static EnumSet<Options> getOptions(Profile profile, boolean is_dest) {
        EnumSet<Options> options = EnumSet.noneOf(Options.class);
        if (is_dest) {
            options.add(Options.IS_DEST);
        }
        if (profile != null) {
            FormatOptions format;
            if (profile.getProperty("need_sha1_or_md5", false)) {
                options.add(Options.NEED_SHA1_OR_MD5);
            }
            if (profile.getProperty("use_parallelism", false)) {
                options.add(Options.USE_PARALLELISM);
            }
            if (profile.getProperty("archives_and_chd_as_roms", false)) {
                options.add(Options.ARCHIVES_AND_CHD_AS_ROMS);
            }
            if (FormatOptions.TZIP == (format = FormatOptions.valueOf(profile.getProperty("format", FormatOptions.ZIP.toString())))) {
                options.add(Options.FORMAT_TZIP);
            }
            if (profile.md5_roms) {
                options.add(Options.MD5_ROMS);
            }
            if (profile.md5_disks) {
                options.add(Options.MD5_DISKS);
            }
            if (profile.sha1_roms) {
                options.add(Options.SHA1_ROMS);
            }
            if (profile.sha1_disks) {
                options.add(Options.SHA1_DISKS);
            }
        }
        return options;
    }

    private boolean isSuspiciousCRC(String crc) {
        return this.suspicious_crc != null && this.suspicious_crc.contains(crc);
    }

    DirScan(Profile profile, File dir, ProgressHandler handler, boolean is_dest) throws BreakException {
        this(dir, handler, profile.suspicious_crc, DirScan.getOptions(profile, is_dest));
    }

    DirScan(File dir, ProgressHandler handler, EnumSet<Options> options) throws BreakException {
        this(dir, handler, null, options);
    }

    private DirScan(File dir, ProgressHandler handler, HashSet<String> suspicious_crc, EnumSet<Options> options) throws BreakException {
        this.init7zJBinding();
        this.dir = dir;
        this.handler = handler;
        this.suspicious_crc = suspicious_crc;
        this.options = options;
        this.need_sha1_or_md5 = options.contains((Object)Options.NEED_SHA1_OR_MD5) || options.contains((Object)Options.NEED_SHA1) || options.contains((Object)Options.NEED_MD5);
        this.md5_disks = options.contains((Object)Options.MD5_DISKS) || options.contains((Object)Options.NEED_MD5);
        this.md5_roms = options.contains((Object)Options.MD5_ROMS) || options.contains((Object)Options.NEED_MD5);
        this.sha1_disks = options.contains((Object)Options.SHA1_DISKS) || options.contains((Object)Options.NEED_SHA1);
        this.sha1_roms = options.contains((Object)Options.SHA1_ROMS) || options.contains((Object)Options.NEED_SHA1);
        boolean is_dest = options.contains((Object)Options.IS_DEST);
        boolean recurse = options.contains((Object)Options.RECURSE);
        boolean use_parallelism = options.contains((Object)Options.USE_PARALLELISM);
        boolean format_tzip = options.contains((Object)Options.FORMAT_TZIP);
        boolean include_empty_dirs = options.contains((Object)Options.EMPTY_DIRS);
        boolean archives_and_chd_as_roms = options.contains((Object)Options.ARCHIVES_AND_CHD_AS_ROMS);
        Path path = Paths.get(dir.getAbsolutePath(), new String[0]);
        this.containers_byname = !Settings.getProperty("debug_nocache", false) ? this.load(dir) : Collections.synchronizedMap(new HashMap());
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        handler.clearInfos();
        handler.setInfos(use_parallelism ? Runtime.getRuntime().availableProcessors() : 1, false);
        try (Stream<Path> stream = Files.walk(path, is_dest ? 1 : 100, FileVisitOption.FOLLOW_LINKS);){
            AtomicInteger i = new AtomicInteger();
            handler.setProgress(String.format(Messages.getString("DirScan.ListingFiles"), dir), 0);
            ((StreamEx)((StreamEx)StreamEx.of(StreamSupport.stream(stream.spliterator(), use_parallelism)).unordered()).takeWhile(p -> !handler.isCancel())).forEach(p -> {
                Container c = null;
                if (path.equals(p)) {
                    return;
                }
                File file = p.toFile();
                try {
                    BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                    if (is_dest) {
                        c = this.containers_byname.get(file.getName());
                        if (null == c || (c.modified != attr.lastModifiedTime().toMillis() || c instanceof Archive && c.size != attr.size()) && !c.up2date) {
                            if (attr.isRegularFile()) {
                                c = new Archive(file, attr);
                                this.containers.add(c);
                            } else {
                                c = new Directory(file, attr);
                                this.containers.add(c);
                            }
                            if (c != null) {
                                c.up2date = true;
                                this.containers_byname.put(file.getName(), c);
                            }
                        } else if (!c.up2date) {
                            c.up2date = true;
                            this.containers.add(c);
                        }
                    } else if (attr.isRegularFile()) {
                        if (Container.getType(file) == Container.Type.UNK || archives_and_chd_as_roms) {
                            if (path.equals(file.getParentFile().toPath())) {
                                return;
                            }
                            File parent_dir = file.getParentFile();
                            BasicFileAttributes parent_attr = Files.readAttributes(p.getParent(), BasicFileAttributes.class, new LinkOption[0]);
                            Path relative = path.relativize(p.getParent());
                            c = this.containers_byname.get(relative.toString());
                            if (null == c || c.modified != parent_attr.lastModifiedTime().toMillis() && !c.up2date) {
                                c = new Directory(parent_dir, attr);
                                this.containers.add(c);
                                if (c != null) {
                                    c.up2date = true;
                                    this.containers_byname.put(relative.toString(), c);
                                }
                            } else if (!c.up2date) {
                                c.up2date = true;
                                this.containers.add(c);
                            }
                        } else {
                            Path relative = path.relativize((Path)p);
                            c = this.containers_byname.get(relative.toString());
                            if (null == c || (c.modified != attr.lastModifiedTime().toMillis() || c.size != attr.size()) && !c.up2date) {
                                c = new Archive(file, attr);
                                this.containers.add(c);
                                if (c != null) {
                                    c.up2date = true;
                                    this.containers_byname.put(relative.toString(), c);
                                }
                            } else if (!c.up2date) {
                                c.up2date = true;
                                this.containers.add(c);
                            }
                        }
                    } else if (include_empty_dirs) {
                        try (DirectoryStream<Path> dirstream = Files.newDirectoryStream(p);){
                            if (!dirstream.iterator().hasNext()) {
                                Path relative = path.relativize((Path)p);
                                c = this.containers_byname.get(relative.toString());
                                if (null == c || c.modified != attr.lastModifiedTime().toMillis() && !c.up2date) {
                                    c = new Directory(file, attr);
                                    this.containers.add(c);
                                    if (c != null) {
                                        c.up2date = true;
                                        this.containers_byname.put(relative.toString(), c);
                                    }
                                } else if (!c.up2date) {
                                    c.up2date = true;
                                    this.containers.add(c);
                                }
                            }
                        }
                    }
                    handler.setProgress(String.format(Messages.getString("DirScan.ListingFiles2"), dir, i.incrementAndGet()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            if (this.containers_byname.entrySet().removeIf(entry -> !((Container)entry.getValue()).up2date)) {
                // empty if block
            }
        }
        catch (IOException e) {
            Log.err("IOException when listing", e);
        }
        catch (Throwable e) {
            Log.err("Other Exception when listing", e);
        }
        TorrentZip torrentzip = is_dest && format_tzip ? new TorrentZip(new DummyLogCallback(), new SimpleTorrentZipOptions(false, true)) : null;
        AtomicInteger i = new AtomicInteger(0);
        handler.clearInfos();
        handler.setInfos(use_parallelism ? Runtime.getRuntime().availableProcessors() : 1, true);
        handler.setProgress(String.format(Messages.getString("DirScan.ScanningFiles"), dir), i.get(), this.containers.size());
        handler.setProgress2("", 0, this.containers.size());
        ((StreamEx)StreamEx.of(use_parallelism ? (Stream)this.containers.parallelStream().unordered() : this.containers.stream()).takeWhile(c -> !handler.isCancel())).forEach(arg_0 -> this.lambda$new$4(is_dest, format_tzip, torrentzip, recurse, archives_and_chd_as_roms, handler, i, arg_0));
        if (!handler.isCancel()) {
            this.save(dir);
        }
    }

    private void update_entry(Entry entry) throws IOException {
        this.update_entry(entry, null);
    }

    private void update_entry(Entry entry, Path entry_path) throws IOException {
        Path path;
        if (entry.parent.getType() == Container.Type.ZIP) {
            if (entry.size == 0L && entry.crc == null) {
                path = entry_path;
                if (entry_path == null) {
                    path = this.getPath(entry);
                }
                Map<String, Object> entry_zip_attrs = Files.readAttributes(path, "zip:*", new LinkOption[0]);
                entry.size = (Long)entry_zip_attrs.get("size");
                entry.crc = String.format("%08x", entry_zip_attrs.get("crc"));
                if (entry_path == null) {
                    path.getFileSystem().close();
                }
            }
            this.entries_bycrc.put(entry.crc + "." + entry.size, entry);
        }
        if (entry.type == Entry.Type.CHD && entry.sha1 == null && entry.md5 == null) {
            path = entry_path;
            if (entry_path == null) {
                path = this.getPath(entry);
            }
            CHDInfoReader chd_info = new CHDInfoReader(path.toFile());
            if (this.sha1_disks && null != (entry.sha1 = chd_info.getSHA1())) {
                this.entries_bysha1.put(entry.sha1, entry);
            }
            if (this.md5_disks && null != (entry.md5 = chd_info.getMD5())) {
                this.entries_bymd5.put(entry.md5, entry);
            }
            if (entry_path == null) {
                path.getFileSystem().close();
            }
        } else if (entry.type != Entry.Type.CHD && (this.need_sha1_or_md5 || entry.crc == null || this.isSuspiciousCRC(entry.crc))) {
            ArrayList<String> algorithms = new ArrayList<String>();
            if (entry.crc == null) {
                algorithms.add("CRC");
            }
            if (entry.md5 == null && (this.md5_roms || this.need_sha1_or_md5)) {
                algorithms.add("MD5");
            }
            if (entry.sha1 == null && (this.sha1_roms || this.need_sha1_or_md5)) {
                algorithms.add("SHA-1");
            }
            if (algorithms.size() > 0) {
                try {
                    MDigest[] digests;
                    Path path2 = entry_path;
                    if (entry_path == null) {
                        path2 = this.getPath(entry);
                    }
                    block12: for (MDigest md : digests = this.computeHash(path2, algorithms)) {
                        switch (md.getAlgorithm()) {
                            case "CRC": {
                                entry.crc = md.toString();
                                if (null == entry.crc) continue block12;
                                this.entries_bycrc.put(entry.crc + "." + entry.size, entry);
                                continue block12;
                            }
                            case "MD5": {
                                entry.md5 = md.toString();
                                if (null == entry.md5) continue block12;
                                this.entries_bymd5.put(entry.md5, entry);
                                continue block12;
                            }
                            case "SHA-1": {
                                entry.sha1 = md.toString();
                                if (null == entry.sha1) continue block12;
                                this.entries_bysha1.put(entry.sha1, entry);
                            }
                        }
                    }
                    if (entry_path == null) {
                        path2.getFileSystem().close();
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (entry.crc != null) {
                this.entries_bycrc.put(entry.crc + "." + entry.size, entry);
            }
            if (entry.sha1 != null) {
                this.entries_bysha1.put(entry.sha1, entry);
            }
            if (entry.md5 != null) {
                this.entries_bymd5.put(entry.md5, entry);
            }
        }
    }

    private MDigest[] computeHash(Path entry_path, List<String> algorithm) throws NoSuchAlgorithmException {
        return this.computeHash(entry_path, algorithm.toArray(new String[0]));
    }

    private MDigest[] computeHash(Path entry_path, String[] algorithm) throws NoSuchAlgorithmException {
        MDigest[] md = new MDigest[algorithm.length];
        for (int i = 0; i < algorithm.length; ++i) {
            md[i] = MDigest.getAlgorithm(algorithm[i]);
        }
        try {
            MDigest.computeHash(Files.newInputStream(entry_path, new OpenOption[0]), md);
        }
        catch (Exception e) {
            System.err.println(entry_path);
            e.printStackTrace();
        }
        return md;
    }

    private Path getPath(Entry entry) throws IOException {
        FileSystem srcfs = FileSystems.newFileSystem(entry.parent.file.toPath(), null);
        return srcfs.getPath(entry.file, new String[0]);
    }

    Entry find_byhash(Rom r) {
        Entry entry = null;
        if (r.sha1 != null) {
            entry = this.entries_bysha1.get(r.sha1);
            if (null != entry) {
                return entry;
            }
            if (this.isSuspiciousCRC(r.crc)) {
                return null;
            }
        }
        if (r.md5 != null) {
            entry = this.entries_bymd5.get(r.md5);
            if (null != entry) {
                return entry;
            }
            if (this.isSuspiciousCRC(r.crc)) {
                return null;
            }
        }
        return this.entries_bycrc.get(r.crc + "." + r.size);
    }

    Entry find_byhash(Disk d) {
        Entry entry = null;
        if (d.sha1 != null && null != (entry = this.entries_bysha1.get(d.sha1))) {
            return entry;
        }
        return this.entries_bymd5.get(d.md5);
    }

    private static String getCacheExt(EnumSet<Options> options) {
        if (options.contains((Object)Options.IS_DEST)) {
            if (options.contains((Object)Options.ARCHIVES_AND_CHD_AS_ROMS)) {
                if (options.contains((Object)Options.RECURSE)) {
                    return ".radcache";
                }
                return ".adcache";
            }
            if (options.contains((Object)Options.RECURSE)) {
                return ".rdcache";
            }
            return ".dcache";
        }
        if (options.contains((Object)Options.ARCHIVES_AND_CHD_AS_ROMS)) {
            if (options.contains((Object)Options.RECURSE)) {
                return ".rascache";
            }
            return ".ascache";
        }
        if (options.contains((Object)Options.RECURSE)) {
            return ".rscache";
        }
        return ".scache";
    }

    public static File getCacheFile(File file, EnumSet<Options> options) {
        File workdir = Settings.getWorkPath().toFile();
        File cachedir = new File(workdir, "cache");
        cachedir.mkdirs();
        CRC32 crc = new CRC32();
        crc.update(file.getAbsolutePath().getBytes());
        return new File(cachedir, String.format("%08x", crc.getValue()) + DirScan.getCacheExt(options));
    }

    private void save(File file) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(DirScan.getCacheFile(file, this.options))));){
            oos.writeObject(this.containers_byname);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Container> load(File file) {
        File cachefile = DirScan.getCacheFile(file, this.options);
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cachefile)));){
            this.handler.setProgress(String.format(Messages.getString("DirScan.LoadingScanCache"), file), 0);
            Map map = (Map)ois.readObject();
            return map;
        }
        catch (Throwable throwable6) {
            return new HashMap<String, Container>();
        }
    }

    Iterable<Container> getContainersIterable() {
        return this.containers;
    }

    Container getContainerByName(String name) {
        return this.containers_byname.get(name);
    }

    File getDir() {
        return this.dir;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$4(boolean is_dest, boolean format_tzip, TorrentZip torrentzip, boolean recurse, final boolean archives_and_chd_as_roms, final ProgressHandler handler, AtomicInteger i, final Container c) {
        try {
            switch (3.$SwitchMap$jrm$profile$data$Container$Type[c.getType().ordinal()]) {
                case 1: {
                    if (c.loaded >= 1 && (!this.need_sha1_or_md5 || c.loaded >= 2)) ** GOTO lbl36
                    env = new HashMap<String, Boolean>();
                    env.put("useTempFile", true);
                    env.put("readOnly", true);
                    try {
                        fs = new ZipFileSystemProvider().newFileSystem(URI.create("zip:" + c.file.toURI()), env);
                        var11_20 = null;
                        try {
                            root = fs.getPath("/", new String[0]);
                            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path entry_path, BasicFileAttributes attrs) throws IOException {
                                    DirScan.this.update_entry(c.add(new Entry(entry_path.toString())), entry_path);
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                            c.loaded = this.need_sha1_or_md5 != false ? 2 : 1;
                            ** GOTO lbl39
                        }
                        catch (Throwable var12_25) {
                            var11_20 = var12_25;
                            throw var12_25;
                        }
                        finally {
                            if (fs != null) {
                                if (var11_20 != null) {
                                    try {
                                        fs.close();
                                    }
                                    catch (Throwable var12_24) {
                                        var11_20.addSuppressed(var12_24);
                                    }
                                } else {
                                    fs.close();
                                }
                            }
                        }
                    }
                    catch (ZipError e) {
                        System.err.println(c.file + " : " + e.getMessage());
                    }
                    ** GOTO lbl39
lbl36:
                    // 2 sources

                    for (Entry entry : c.getEntries()) {
                        this.update_entry(entry);
                    }
lbl39:
                    // 3 sources

                    if (!is_dest || !format_tzip || c.lastTZipCheck >= c.modified) break;
                    c.lastTZipStatus = torrentzip.Process(c.file);
                    c.lastTZipCheck = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    entries = new SevenZUpdateEntries(c);
                    var10_19 = null;
                    SevenZUpdateEntries.access$1000(entries);
                    if (entries == null) break;
                    if (var10_19 == null) ** GOTO lbl56
                    try {
                        entries.close();
                    }
                    catch (Throwable var11_21) {
                        var10_19.addSuppressed(var11_21);
                    }
                    break;
lbl56:
                    // 1 sources

                    entries.close();
                    break;
                    catch (Throwable var11_22) {
                        try {
                            var10_19 = var11_22;
                            throw var11_22;
                        }
                        catch (Throwable var15_28) {
                            if (entries != null) {
                                if (var10_19 != null) {
                                    try {
                                        entries.close();
                                    }
                                    catch (Throwable var16_29) {
                                        var10_19.addSuppressed(var16_29);
                                    }
                                } else {
                                    entries.close();
                                }
                            }
                            throw var15_28;
                        }
                    }
                }
                case 3: {
                    try {
                        Files.walkFileTree(c.file.toPath(), EnumSet.noneOf(FileVisitOption.class), is_dest != false && recurse != false ? 0x7FFFFFFF : 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path entry_path, BasicFileAttributes attrs) throws IOException {
                                if (attrs.isRegularFile()) {
                                    Entry entry = new Entry(entry_path.toString(), attrs);
                                    if (archives_and_chd_as_roms) {
                                        entry.type = Entry.Type.UNK;
                                    }
                                    handler.setProgress(c.file.getName(), -1, null, File.separator + c.file.toPath().relativize(entry_path).toString());
                                    DirScan.this.update_entry(c.add(entry), entry_path);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (AccessDeniedException entries) {
                        // empty catch block
                    }
                    c.loaded = this.need_sha1_or_md5 != false ? 2 : 1;
                    break;
                }
            }
            handler.setProgress(String.format(Messages.getString("DirScan.Scanned"), new Object[]{c.file.getName()}));
            handler.setProgress2(String.format("%d/%d (%d%%)", new Object[]{i.get(), this.containers.size(), (int)((double)i.get() * 100.0 / (double)this.containers.size())}), i.incrementAndGet());
        }
        catch (IOException e) {
            Log.err("IOException when scanning", e);
        }
        catch (BreakException e) {
            handler.cancel();
        }
        catch (Throwable e) {
            Log.err("Other Exception when listing", e);
        }
    }

    private class SevenZUpdateEntries
    implements Closeable {
        private RandomAccessFile randomAccessFile = null;
        private final Container container;
        private final ArrayList<String> algorithms;
        private final MDigest[] digest;
        private IInArchive nArchive = null;
        private SevenZFile jArchive = null;
        private SevenZipArchive jArchive2 = null;

        private SevenZUpdateEntries(Container container) throws NoSuchAlgorithmException {
            this.container = container;
            this.algorithms = new ArrayList();
            if (DirScan.this.sha1_roms) {
                this.algorithms.add("SHA-1");
            }
            if (DirScan.this.md5_roms) {
                this.algorithms.add("MD5");
            }
            this.digest = new MDigest[this.algorithms.size()];
            for (int i = 0; i < this.algorithms.size(); ++i) {
                this.digest[i] = MDigest.getAlgorithm(this.algorithms.get(i));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jArchive2 != null) {
                this.jArchive2.close();
            }
            if (this.jArchive != null) {
                this.jArchive.close();
            }
            if (this.nArchive != null) {
                this.nArchive.close();
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }

        private IInArchive getNArchive() throws IOException {
            if (this.randomAccessFile == null) {
                this.randomAccessFile = new RandomAccessFile(this.container.file, "r");
            }
            if (this.nArchive == null) {
                this.nArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(this.randomAccessFile));
            }
            return this.nArchive;
        }

        private SevenZFile getJArchive() throws IOException {
            if (this.jArchive == null) {
                this.jArchive = new SevenZFile(this.container.file);
            }
            return this.jArchive;
        }

        private ISimpleInArchive getNInterface() throws IOException {
            return this.getNArchive().getSimpleInterface();
        }

        private SevenZipArchive getJInterface() throws IOException {
            if (this.jArchive2 == null) {
                this.jArchive2 = new SevenZipArchive(this.container.file);
            }
            return this.jArchive2;
        }

        private void updateEntries() throws IOException, NoSuchAlgorithmException {
            if (SevenZip.isInitializedSuccessfully()) {
                HashMap<Integer, Entry> entries = new HashMap<Integer, Entry>();
                if (this.container.loaded < 1 || DirScan.this.need_sha1_or_md5 && this.container.loaded < 2) {
                    for (ISimpleInArchiveItem item : this.getNInterface().getArchiveItems()) {
                        if (item.isFolder()) continue;
                        this.updateEntry(this.container.add(new Entry(item.getPath())), entries, item);
                    }
                    this.container.loaded = DirScan.this.need_sha1_or_md5 ? 2 : 1;
                } else {
                    for (Entry entry : this.container.getEntries()) {
                        this.updateEntry(entry, entries, null);
                    }
                }
                this.computeHashes(entries);
            } else {
                HashSet<Entry> entries = new HashSet<Entry>();
                if (this.container.loaded < 1 || DirScan.this.need_sha1_or_md5 && this.container.loaded < 2) {
                    for (SevenZArchiveEntry archive_entry : this.getJArchive().getEntries()) {
                        if (archive_entry.isDirectory()) continue;
                        this.updateEntry(this.container.add(new Entry(archive_entry.getName())), entries, archive_entry);
                    }
                    this.container.loaded = DirScan.this.need_sha1_or_md5 ? 2 : 1;
                } else {
                    for (Entry entry : this.container.getEntries()) {
                        this.updateEntry(entry, entries, (SevenZArchiveEntry)null);
                    }
                }
                this.computeHashes(entries);
            }
        }

        private void updateEntry(Entry entry, Map<Integer, Entry> entries, ISimpleInArchiveItem item) throws IOException {
            if (entry.size == 0L && entry.crc == null && item != null) {
                entry.size = item.getSize();
                entry.crc = String.format("%08x", item.getCRC());
            }
            DirScan.this.entries_bycrc.put(entry.crc + "." + entry.size, entry);
            if (entry.sha1 == null && entry.md5 == null && (DirScan.this.need_sha1_or_md5 || entry.crc == null || DirScan.this.isSuspiciousCRC(entry.crc))) {
                if (item == null) {
                    for (ISimpleInArchiveItem itm : this.getNInterface().getArchiveItems()) {
                        if (!entry.file.equals(itm.getPath())) continue;
                        item = itm;
                        break;
                    }
                }
                if (item != null) {
                    entries.put(item.getItemIndex(), entry);
                }
            } else {
                if (entry.sha1 != null) {
                    DirScan.this.entries_bysha1.put(entry.sha1, entry);
                }
                if (entry.md5 != null) {
                    DirScan.this.entries_bymd5.put(entry.md5, entry);
                }
            }
        }

        private void updateEntry(Entry entry, HashSet<Entry> entries, SevenZArchiveEntry archive_entry) throws IOException {
            if (entry.size == 0L && entry.crc == null && archive_entry != null) {
                entry.size = archive_entry.getSize();
                entry.crc = String.format("%08x", archive_entry.getCrcValue());
            }
            DirScan.this.entries_bycrc.put(entry.crc + "." + entry.size, entry);
            if (entry.sha1 == null && entry.md5 == null && (DirScan.this.need_sha1_or_md5 || entry.crc == null || DirScan.this.isSuspiciousCRC(entry.crc))) {
                entries.add(entry);
            } else {
                if (entry.sha1 != null) {
                    DirScan.this.entries_bysha1.put(entry.sha1, entry);
                }
                if (entry.md5 != null) {
                    DirScan.this.entries_bymd5.put(entry.md5, entry);
                }
            }
        }

        private void computeHashes(final Map<Integer, Entry> entries) throws NoSuchAlgorithmException, IOException {
            if (entries.size() > 0) {
                this.getNArchive().extract(IntStreamEx.of(entries.keySet()).toArray(), false, new IArchiveExtractCallback(){
                    Entry entry;

                    public void setTotal(long total) throws SevenZipException {
                    }

                    public void setCompleted(long complete) throws SevenZipException {
                    }

                    public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
                        if (extractOperationResult == ExtractOperationResult.OK) {
                            for (MDigest d : SevenZUpdateEntries.this.digest) {
                                if (d.getAlgorithm().equals("SHA-1")) {
                                    this.entry.sha1 = d.toString();
                                    DirScan.this.entries_bysha1.put(this.entry.sha1, this.entry);
                                }
                                if (d.getAlgorithm().equals("MD5")) {
                                    this.entry.md5 = d.toString();
                                    DirScan.this.entries_bymd5.put(this.entry.md5, this.entry);
                                }
                                d.reset();
                            }
                        }
                    }

                    public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
                    }

                    public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
                        this.entry = (Entry)entries.get(index);
                        if (extractAskMode != ExtractAskMode.EXTRACT) {
                            return null;
                        }
                        return data -> {
                            for (MDigest d : SevenZUpdateEntries.this.digest) {
                                d.update(data);
                            }
                            return data.length;
                        };
                    }
                });
            }
        }

        private void computeHashes(HashSet<Entry> entries) throws IOException {
            for (Entry entry : entries) {
                for (MDigest d : MDigest.computeHash(this.getJInterface().extract_stdout(entry.getName()), this.digest)) {
                    if (d.getAlgorithm().equals("SHA-1")) {
                        entry.sha1 = d.toString();
                        DirScan.this.entries_bysha1.put(entry.sha1, entry);
                    }
                    if (d.getAlgorithm().equals("MD5")) {
                        entry.md5 = d.toString();
                        DirScan.this.entries_bymd5.put(entry.md5, entry);
                    }
                    d.reset();
                }
            }
        }

        static /* synthetic */ void access$1000(SevenZUpdateEntries x0) throws IOException, NoSuchAlgorithmException {
            x0.updateEntries();
        }
    }

    public static enum Options {
        IS_DEST,
        RECURSE,
        NEED_SHA1_OR_MD5,
        NEED_SHA1,
        NEED_MD5,
        USE_PARALLELISM,
        FORMAT_TZIP,
        MD5_ROMS,
        MD5_DISKS,
        SHA1_ROMS,
        SHA1_DISKS,
        EMPTY_DIRS,
        ARCHIVES_AND_CHD_AS_ROMS,
        JUNK_SUBFOLDERS,
        MATCH_PROFILE;

    }
}

