/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.output;

import java.util.function.BiConsumer;
import org.rundeck.client.tool.CommandOutput;

public class ChannelOutput
implements CommandOutput {
    CommandOutput fallback;
    boolean infoEnabled = true;
    CommandOutput info;
    boolean outputEnabled = true;
    CommandOutput output;
    boolean warningEnabled = true;
    CommandOutput warning;
    boolean errorEnabled = true;
    CommandOutput error;

    public Builder toBuilder() {
        return ChannelOutput.builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ChannelOutput orig) {
        return new Builder(orig);
    }

    private ChannelOutput() {
    }

    private ChannelOutput(ChannelOutput output) {
        this.fallback = output.fallback;
        this.info = output.info;
        this.output = output.output;
        this.warning = output.warning;
        this.error = output.error;
        this.infoEnabled = output.infoEnabled;
        this.outputEnabled = output.outputEnabled;
        this.warningEnabled = output.warningEnabled;
        this.errorEnabled = output.errorEnabled;
    }

    private void select(CommandOutput candidate, CommandOutput fallback, Object output, BiConsumer<CommandOutput, Object> out) {
        if (null != candidate) {
            out.accept(candidate, output);
        } else if (null != fallback) {
            out.accept(fallback, output);
        }
    }

    @Override
    public void info(Object msg) {
        if (this.infoEnabled) {
            this.select(this.info, this.fallback, msg, CommandOutput::info);
        }
    }

    @Override
    public void output(Object msg) {
        if (this.outputEnabled) {
            this.select(this.output, this.fallback, msg, CommandOutput::output);
        }
    }

    @Override
    public void error(Object msg) {
        if (this.errorEnabled) {
            this.select(this.error, this.fallback, msg, CommandOutput::error);
        }
    }

    @Override
    public void warning(Object msg) {
        if (this.warningEnabled) {
            this.select(this.warning, this.fallback, msg, CommandOutput::warning);
        }
    }

    public static class Builder {
        final ChannelOutput build;

        public Builder() {
            this.build = new ChannelOutput();
        }

        public Builder(ChannelOutput output) {
            this.build = new ChannelOutput(output);
        }

        public Builder fallback(CommandOutput fallback) {
            this.build.fallback = fallback;
            return this;
        }

        public Builder info(CommandOutput info) {
            this.build.info = info;
            return this;
        }

        public Builder infoEnabled(boolean enabled) {
            this.build.infoEnabled = enabled;
            return this;
        }

        public Builder output(CommandOutput output) {
            this.build.output = output;
            return this;
        }

        public Builder outputEnabled(boolean enabled) {
            this.build.outputEnabled = enabled;
            return this;
        }

        public Builder warning(CommandOutput warning) {
            this.build.warning = warning;
            return this;
        }

        public Builder warningEnabled(boolean enabled) {
            this.build.warningEnabled = enabled;
            return this;
        }

        public Builder error(CommandOutput error) {
            this.build.error = error;
            return this;
        }

        public Builder errorEnabled(boolean enabled) {
            this.build.errorEnabled = enabled;
            return this;
        }

        public ChannelOutput build() {
            return new ChannelOutput(this.build);
        }
    }
}

