/*
 *  Author: tican
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

void cpu(const int BUF_SIZE)
{
	struct utsname name;
	FILE *file;
	int processors;
	char buf[BUF_SIZE];
	char *cpu1, *cpu2, *cpu3, *cpu4, *cpu5, *fname;

	fname = "/proc/cpuinfo";
	file = fopen(fname, "r");
	if ( !file ) {
		fprintf(stderr, "Could not open %s. Bailing out.\n", fname);
		exit(EXIT_FAILURE);
	}
	
	puts("");
	printf("  CPU\n\n");

	if (uname(&name) != -1) {
		printf("  Platform:\t %s\n", name.machine);
	}

	processors = 0;

	while ( fgets(buf, BUF_SIZE, file) ) {
		cpu1=strstr(buf,"vendor_id"); 
		cpu2=strstr(buf,"model name");
		cpu3=strstr(buf,"cpu MHz");
		cpu4=strstr(buf,"bogomips");
		cpu5=strstr(buf,"cache size");

		if ( strstr(buf,"processor") ) {
			printf("\n  ID:\t\t %i\n", processors);
			processors++;
		}
		if ( cpu1 ) {
			printf("  Type:\t\t%s", strchr(cpu1,':')+1 );
		}
		if ( cpu2 ) {
			printf("  Model:\t%s", strchr(cpu2,':')+1 );
		}
		if ( cpu3 ) {
			printf("  Frequency:\t%s", strchr(cpu3,':')+1 );
		}
		if ( cpu4 ) {
			printf("  Bogomips:\t%s", strchr(cpu4,':')+1 );
		}
		if ( cpu5 ) {
			printf("  Cache:\t%s", strchr(cpu5,':')+1 );
		}
	}

	puts("");
	fclose(file);
}
