(import (owl digest))

(define shorten
   (string->regex "s/(....).....*(....)/\\1...\\2/"))

(define (test name digest input wanted)
   (let ((res (digest input)))
      (if (equal? res wanted)
         (print "OK " name "(" (shorten input) ") = " res)
         (print "   " name "(" (shorten input) ") = " res " instead of " wanted "!"))))

(define (test2 name digest i1 i2 wanted)
   (let ((res (digest i1 i2)))
      (if (equal? res wanted)
         (print "OK " name "(" (shorten i1) "," (shorten i2) ") = " res)
         (print "   " name "(" (shorten i1) "," (shorten i2) ") = " res " instead of " wanted "!"))))

(test "SHA1" sha1 "" "da39a3ee5e6b4b0d3255bfef95601890afd80709")
(test "SHA1" sha1 "a" "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8")
(test "SHA1" sha1 "aa" "e0c9035898dd52fc65c41454cec9c4d2611bfb37")
(test "SHA1" sha1 "aaa" "7e240de74fb1ed08fa08d38063f6a6a91462a815")
(test "SHA1" sha1 "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" "8eca554631df9ead14510e1a70ae48c70f9b9384")
(test "SHA1" sha1 "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" "0756a3fa3cc329c9e1eed4857a3d9088606ce590")

(test "SHA1" sha1 (list #\a) "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8")
(test "SHA1" sha1 (vector #\a) "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8")

(test "SHA1" sha1 "ä" "961fa22f61a56e19f3f5f8867901ac8cf5e6d11f")

(test2 "HMAC-SHA1" hmac-sha1 "" "" "fbdb1d1b18aa6c08324b7d64b71fb76370690e1d")
(test2 "HMAC-SHA1" hmac-sha1 "key" "The quick brown fox jumps over the lazy dog" "de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9")
(test2 "HMAC-SHA1" hmac-sha1 "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" "Slartibartfast" "1925d72c14f0f273b652d19ac8477f093b95a13a")

(test "SHA256" sha256 "" "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855")
(test "SHA256" sha256 "abc" "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad")
(test "SHA256" sha256 "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq" "248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1")

(test2 "HMAC-SHA256" hmac-sha256 "" "" "b613679a0814d9ec772f95d778c35fc5ff1697c493715653c6c712144292c5ad")
(test2 "HMAC-SHA256" hmac-sha256 "key" "The quick brown fox jumps over the lazy dog" "f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8")
