/* pep.h  1992 January 6 [gh]
+-----------------------------------------------------------------------------
| Abstract:
|    Common types and definitions for pep.
|
| See main module for history and comments.
+---------------------------------------------------------------------------*/

/* These 5 symbols may be (un)set by you according preferences/environment  */

/* FINDFIRST  define if compiler knows  _findfirst, _findnext & _findclose  */
/* STRICMP    should be defined if "stricmp" reported missing by the linker */
/* SYSV2      should be defined if you are compiling this on SYS V.2 UNIX   */
/* __TURBOC__ are already set to 1 by Borland, (may be undefined by you).   */
/* VMSV1      should be defined if you are using VAX C ver. 1.x VMS         */
#define FINDFIRST

/* Canonize macroes predefined by the compiler.                             */

#ifdef MSDOS
#define __MSDOS__  1
#endif

#ifdef msdos
#define __MSDOS__  1
#endif

#ifdef unix
#define __UNIX__   1
#endif

#ifdef vms
#define __VMS__    1
#endif


/*---( defines )------------------------------------------------------------*/

#ifdef __VMS__
#include <ssdef.h>
#endif

#define FALSE       0			/* Boolean FALSE                    */
#define TRUE        !FALSE		/* Boolean TRUE			    */


#ifdef __MSDOS__
#define SETDTA    0x1A /* Set Disk Transfer Address */
#define GETFRST   0x4E /* Find first ASCIZ          */
#define GETNEXT   0x4F /* Find next  ASCIZ          */
#define DIRCHAR   '\\' /* Directory path separator  */
#endif

#ifdef __UNIX__
#define DIRCHAR   '/'  /* Directory path separator  */
#endif

#ifdef __VMS__
#define unlink(x) delete(x)
#define DIRCHAR   '>'  /* Directory path separator  */
#endif

#ifdef __VMS__
#define NORML_EXIT SS$_NORMAL
#define ERROR_EXIT SS$_ABORT
#else
#define NORML_EXIT 0
#define ERROR_EXIT 1
#endif


/*---( types )--------------------------------------------------------------*/

typedef unsigned char BOOL;


/*---( variables )----------------------------------------------------------*/

#ifdef MAIN
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN FILE *Fdi;
EXTERN FILE *Fdo;
EXTERN int  IFrst, ILast, ILimit;           /* Fold direction flags         */

#ifndef MAIN
extern long LCount;                         /* Global line count            */
extern int  LineXx;                         /* Horisontal position on line. */
extern int  ITabSz;			    /* Input  tabulator size.       */
extern int  OTabSz;			    /* Output tabulator size.       */
extern int  LinSiz;			    /* Max. line size.		    */
extern int  StrSiz;			    /* String size for strings.     */
extern int  EndOLn;			    /* -1 CRLF, -2 Paragraph only   */

extern int  bflagb;		            /* Binary wash.                 */
extern int  cflagc;                         /* Compress                     */
extern int  dflagd;                         /* DEC character set.           */
extern int  gflagg;                         /* General fold table           */
extern int  iflagi;                         /* IBM character set.           */
extern int  kflagk;                         /* Kman character set.          */
extern int  lflagl;                         /* Have blank line after par.   */
extern int  mflagm;                         /* MAC character set.           */
extern int  sflags;                         /* String extraction.           */
extern int  tflagt;                         /* Tab expansion                */
extern int  vflagv;			    /* Terminate only paragraphs.   */
extern int  wflag0;			    /* From WS doc. mode to 7-bit.  */
extern int  wflag1;			    /* From 7-bit to WS doc. mode.  */
extern int  xflagx;
extern int  zflagz;
#endif


/*---( prototypes )---------------------------------------------------------*/

void		doansi(int guardl);

void		mess(int err);
void		showprogress(void);

void		inittable(void);
void		listtable(char *tabledir);
void		readtable(char *tabledir, char *cname, BOOL echo);
void		doplain(void);

/* EOH */
