/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.mediawiki.Template;
import org.eclipse.mylyn.wikitext.mediawiki.TemplateResolver;

public class WikiTemplateResolver
extends TemplateResolver {
    private String wikiBaseUrl;

    public String getWikiBaseUrl() {
        return this.wikiBaseUrl;
    }

    public void setWikiBaseUrl(String wikiBaseUrl) {
        this.wikiBaseUrl = wikiBaseUrl;
    }

    @Override
    public Template resolveTemplate(String templateName) {
        if (this.wikiBaseUrl != null) {
            int indexOf = ((String)templateName).indexOf(58);
            if (indexOf == 0) {
                templateName = ((String)templateName).substring(1);
            } else if (indexOf == -1) {
                templateName = "Template:" + (String)templateName;
            }
            URL url = this.computeRawUrl((String)templateName);
            if (url != null) {
                try {
                    String content = this.readContent(url);
                    Template template = new Template();
                    Object basicName = ((String)templateName).toLowerCase().startsWith("template:") ? ((String)templateName).substring(((String)templateName).lastIndexOf(58) + 1) : templateName;
                    template.setName((String)basicName);
                    template.setTemplateMarkup(content);
                    return template;
                }
                catch (IOException e) {
                    String message = MessageFormat.format("Cannot read from {0}: {1}", url, e.getMessage());
                    Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, message, e);
                }
            }
        }
        return null;
    }

    protected String readContent(URL url) throws IOException {
        return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
    }

    private URL computeRawUrl(String path) {
        try {
            Object qualifiedUrl = this.wikiBaseUrl;
            if (!((String)qualifiedUrl).endsWith("/")) {
                qualifiedUrl = (String)qualifiedUrl + "/";
            }
            qualifiedUrl = (String)qualifiedUrl + "index.php?title=" + URLEncoder.encode(path, "UTF-8") + "&action=raw";
            return new URL((String)qualifiedUrl);
        }
        catch (IOException e) {
            Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, MessageFormat.format("Cannot compute raw URL for {0}: {1}", path, e.getMessage()), e);
            return null;
        }
    }
}

