/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

public final class OnigScannerMatch {
    public final int index;
    private final OnigCaptureIndex[] captureIndices;

    OnigScannerMatch(OnigResult result, OnigString source) {
        this.index = result.getIndex();
        this.captureIndices = this.captureIndicesOfMatch(result, source);
    }

    private OnigCaptureIndex[] captureIndicesOfMatch(OnigResult result, OnigString source) {
        int resultCount = result.count();
        OnigCaptureIndex[] captures = new OnigCaptureIndex[resultCount];
        int i = 0;
        while (i < resultCount) {
            int loc = result.locationAt(i);
            int captureStart = source.getCharIndexOfByte(loc);
            int captureEnd = source.getCharIndexOfByte(loc + result.lengthAt(i));
            captures[i] = captureStart == 0 && captureEnd == 0 ? OnigCaptureIndex.EMPTY : new OnigCaptureIndex(captureStart, captureEnd);
            ++i;
        }
        return captures;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof OnigScannerMatch) {
            void other;
            OnigScannerMatch onigScannerMatch = (OnigScannerMatch)object;
            OnigScannerMatch cfr_ignored_0 = (OnigScannerMatch)object;
            return this.index == other.index && Arrays.equals(this.captureIndices, other.captureIndices);
        }
        return false;
    }

    public OnigCaptureIndex[] getCaptureIndices() {
        return this.captureIndices;
    }

    public int hashCode() {
        return 31 * (31 + this.index) + Arrays.hashCode(this.captureIndices);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{\n");
        result.append("  \"index\": ");
        result.append(this.index);
        result.append(",\n");
        result.append("  \"captureIndices\": [\n");
        int i = 0;
        OnigCaptureIndex[] onigCaptureIndexArray = this.captureIndices;
        int n = this.captureIndices.length;
        int n2 = 0;
        while (n2 < n) {
            OnigCaptureIndex captureIndex = onigCaptureIndexArray[n2];
            if (i > 0) {
                result.append(",\n");
            }
            result.append("    ");
            result.append(captureIndex);
            ++i;
            ++n2;
        }
        result.append("\n");
        result.append("  ]\n");
        result.append("}");
        return result.toString();
    }
}

