/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogSwitcherItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CatalogSwitcher
extends Composite
implements ISelectionProvider {
    private static final int ITEM_MARGIN = 5;
    private static final int MIN_SCROLL_HEIGHT = 42;
    private final MarketplaceCatalogConfiguration configuration;
    private final ImageRegistry imageRegistry = new ImageRegistry();
    private final List<ISelectionChangedListener> listeners = new LinkedList<ISelectionChangedListener>();
    private final List<CatalogSwitcherItem> items = new LinkedList<CatalogSwitcherItem>();
    private CatalogDescriptor selection;
    private Composite marketplaceArea;

    public CatalogSwitcher(Composite parent, int style, MarketplaceCatalogConfiguration configuration) {
        super(parent, style);
        this.configuration = configuration;
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo((Composite)this);
        this.setBackgroundMode(2);
        Color listBackground = this.getDisplay().getSystemColor(25);
        this.setBackground(listBackground);
        StyleHelper styleHelper = new StyleHelper().on((Widget)this);
        styleHelper.setClass("CatalogSwitcher");
        this.createContents(this);
    }

    private void createContents(final Composite parent) {
        this.createHeader(parent);
        final ScrolledComposite scrollArea = new ScrolledComposite(parent, 512);
        scrollArea.setBackgroundMode(1);
        scrollArea.setLayout((Layout)new FillLayout());
        this.marketplaceArea = new Composite((Composite)scrollArea, 0);
        this.marketplaceArea.setBackgroundMode(1);
        scrollArea.setContent((Control)this.marketplaceArea);
        RowLayout layout = new RowLayout(256);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.marketplaceArea.setLayout((Layout)layout);
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(c -> {
            Object data = c.data;
            if (data instanceof CatalogDescriptor) {
                CatalogDescriptor catalogDescriptor;
                this.selection = catalogDescriptor = (CatalogDescriptor)data;
                this.refreshSelection();
                this.fireSelectionChanged();
            }
        });
        this.items.clear();
        List<CatalogDescriptor> catalogDescriptors = this.configuration.getCatalogDescriptors();
        for (CatalogDescriptor catalogDescriptor : catalogDescriptors) {
            CatalogSwitcherItem item = this.createMarketplace(this.marketplaceArea, catalogDescriptor);
            item.addSelectionListener(selectionListener);
            this.items.add(item);
        }
        scrollArea.setExpandVertical(true);
        scrollArea.setExpandHorizontal(true);
        scrollArea.setMinHeight(42);
        scrollArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = parent.getClientArea();
                int scrollBarWidth = scrollArea.getVerticalBar().getSize().x;
                scrollArea.setMinSize(CatalogSwitcher.this.marketplaceArea.computeSize(r.width - scrollBarWidth, -1));
            }
        });
    }

    private void createHeader(Composite parent) {
        CatalogCategory fakeCategory = new CatalogCategory();
        fakeCategory.setName(Messages.CatalogSwitcher_Header);
        CategoryItem header = new CategoryItem(parent, 0, new DiscoveryResources(parent.getDisplay()), fakeCategory);
        MarketplaceViewer.setSeparatorVisible(header, false);
        MarketplaceViewer.fixLayout(header);
        new StyleHelper().on((Widget)header).setClass("CatalogSwitcherHeader");
    }

    private CatalogSwitcherItem createMarketplace(Composite composite, CatalogDescriptor catalogDescriptor) {
        CatalogSwitcherItem marketplaceItem = new CatalogSwitcherItem(composite, this.imageRegistry, catalogDescriptor);
        StyleHelper styleHelper = new StyleHelper().on((Widget)marketplaceItem);
        styleHelper.setId("catalog-" + composite.getChildren().length);
        return marketplaceItem;
    }

    private void fireSelectionChanged() {
        for (ISelectionChangedListener listener : this.listeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)this.selection));
            listener.selectionChanged(event);
        }
    }

    public void dispose() {
        this.imageRegistry.dispose();
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.selection);
    }

    public void setSelection(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            CatalogDescriptor newDescriptor;
            IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
            CatalogDescriptor oldDescriptor = this.selection;
            this.selection = newDescriptor = (CatalogDescriptor)structuredSelection.getFirstElement();
            this.refreshSelection();
            if (newDescriptor != oldDescriptor) {
                this.fireSelectionChanged();
            }
        }
    }

    private void refreshSelection() {
        for (CatalogSwitcherItem item : this.items) {
            item.setSelected(this.selection != null && this.selection == item.getCatalogDescriptor());
        }
        new StyleHelper().on((Widget)this).applyStyles();
    }

    public int getPreferredHeight() {
        return 42 + 2 * this.getBorderWidth() + 6;
    }

    public List<CatalogSwitcherItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public CatalogSwitcherItem getSelectedItem() {
        if (this.selection == null) {
            return null;
        }
        for (CatalogSwitcherItem item : this.items) {
            if (this.selection != item.getCatalogDescriptor()) continue;
            return item;
        }
        return null;
    }
}

