/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.CachingMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.DefaultCatalogService;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceStorageService;
import org.eclipse.epp.internal.mpc.core.service.UserFavoritesService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientService;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.IMarketplaceStorageService;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(name="org.eclipse.epp.mpc.core.servicelocator", service={IMarketplaceServiceLocator.class})
public class ServiceLocator
implements IMarketplaceServiceLocator {
    private static final String DEBUG_CLIENT_REMOVE_OPTION = "xxx";
    private static final String STORAGE_SERVICE_BINDING_ID = "bind.storageService";
    private static final String DEBUG_CLIENT_OPTIONS_PATH = "org.eclipse.epp.mpc.core/client/";
    private static boolean DEBUG_FAKE_CLIENT = false;
    private static final String DEBUG_OPTION = "/debug";
    private static final String DEBUG_FAKE_CLIENT_OPTION = "/client/fakeVersion";
    private static ServiceLocator instance;
    private ICatalogService catalogService;
    private ServiceTracker<IMarketplaceService, IMarketplaceService> marketplaceServiceTracker;
    private ServiceTracker<ICatalogService, ICatalogService> catalogServiceTracker;
    private ServiceTracker<IMarketplaceStorageService, IMarketplaceStorageService> storageServiceTracker;
    private ServiceTracker<IUserFavoritesService, IUserFavoritesService> favoritesServiceTracker;
    private URL defaultCatalogUrl;
    private URL defaultMarketplaceUrl;
    private final List<ServiceRegistration<?>> dynamicServiceRegistrations = new ArrayList();
    private HttpClientService httpClient;

    public ServiceLocator() {
        this.defaultMarketplaceUrl = DefaultMarketplaceService.DEFAULT_SERVICE_URL;
        this.defaultCatalogUrl = DefaultCatalogService.DEFAULT_CATALOG_SERVICE_URL;
    }

    public HttpClientService getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClientService httpClient) {
        HttpClientService oldClient = this.httpClient;
        this.httpClient = httpClient;
        if (oldClient != httpClient) {
            this.updateHttpClient(httpClient);
        }
    }

    @Reference(unbind="unbindHttpClient", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    public void bindHttpClient(HttpClientService httpClient) {
        this.setHttpClient(httpClient);
    }

    public void unbindHttpClient(HttpClientService httpClient) {
        if (this.httpClient == httpClient) {
            this.setHttpClient(null);
        }
    }

    private void updateHttpClient(final HttpClientService httpClient) {
        ServiceLocator.applyServiceReferenceOperation(this.favoritesServiceTracker, new ServiceReferenceOperation<IUserFavoritesService>(){

            @Override
            public void apply(ServiceReference<IUserFavoritesService> reference) {
                IUserFavoritesService service;
                ServiceRegistration<IUserFavoritesService> registration = ServiceLocator.this.getDynamicServiceInstance(reference);
                if (registration != null && (service = ServiceUtil.getService(registration)) instanceof UserFavoritesService) {
                    if (httpClient == null) {
                        ((UserFavoritesService)service).unbindHttpClient(httpClient);
                    } else {
                        ((UserFavoritesService)service).bindHttpClient(httpClient);
                    }
                }
            }
        });
        ServiceLocator.applyServiceReferenceOperation(this.marketplaceServiceTracker, new ServiceReferenceOperation<IMarketplaceService>(){

            @Override
            public void apply(ServiceReference<IMarketplaceService> reference) {
                IMarketplaceService service;
                ServiceRegistration<IMarketplaceService> registration = ServiceLocator.this.getDynamicServiceInstance(reference);
                if (registration != null && (service = ServiceUtil.getService(registration)) instanceof DefaultMarketplaceService) {
                    ((DefaultMarketplaceService)service).setHttpClient(httpClient);
                }
            }
        });
    }

    @Deprecated
    public IMarketplaceService getMarketplaceService() {
        return this.getDefaultMarketplaceService();
    }

    @Override
    public IMarketplaceService getDefaultMarketplaceService() {
        return this.getMarketplaceService(this.defaultMarketplaceUrl.toExternalForm());
    }

    @Override
    public synchronized IMarketplaceService getMarketplaceService(String baseUrl) {
        IMarketplaceService service = this.getService(this.marketplaceServiceTracker, baseUrl);
        if (service != null) {
            return service;
        }
        service = this.createMarketplaceService(baseUrl);
        this.registerService(baseUrl, IMarketplaceService.class, service);
        return service;
    }

    private <T> void registerService(String baseUrl, Class<T> serviceClass, T service) {
        this.registerService(baseUrl, serviceClass, service, null);
    }

    private <T> ServiceRegistration<T> registerService(String baseUrl, Class<T> serviceClass, T service, Dictionary<String, Object> properties) {
        if (baseUrl != null) {
            if (properties == null) {
                properties = new Hashtable<String, Object>(1);
            }
            properties.put("url", baseUrl);
        }
        ServiceRegistration registration = FrameworkUtil.getBundle(IMarketplaceServiceLocator.class).getBundleContext().registerService(serviceClass, service, properties);
        this.dynamicServiceRegistrations.add(registration);
        return registration;
    }

    private <T> T getService(ServiceTracker<T, T> serviceTracker, String baseUrl) {
        ServiceReference[] serviceReferences;
        if (serviceTracker != null && (serviceReferences = serviceTracker.getServiceReferences()) != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                Object service;
                ServiceReference serviceReference = serviceReferenceArray[n2];
                Object serviceBaseUrl = ServiceUtil.getOverridablePropertyValue(serviceReference, "url");
                if (baseUrl.equals(serviceBaseUrl) && (service = serviceTracker.getService(serviceReference)) != null) {
                    return (T)service;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IMarketplaceService createMarketplaceService(String baseUrl) {
        URL base;
        try {
            base = URLUtil.toURL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        DefaultMarketplaceService defaultService = new DefaultMarketplaceService(base);
        Map<String, String> requestMetaParameters = ServiceLocator.computeDefaultRequestMetaParameters();
        defaultService.setRequestMetaParameters(requestMetaParameters);
        IUserFavoritesService favoritesService = this.getFavoritesService(baseUrl);
        defaultService.setUserFavoritesService(favoritesService);
        defaultService.setHttpClient(this.httpClient);
        CachingMarketplaceService service = new CachingMarketplaceService(defaultService);
        return service;
    }

    @Override
    public IMarketplaceStorageService getStorageService(String marketplaceUrl) {
        return this.getService(this.storageServiceTracker, marketplaceUrl);
    }

    @Override
    public IMarketplaceStorageService getDefaultStorageService() {
        return this.getStorageService(this.defaultMarketplaceUrl.toExternalForm());
    }

    @Override
    public IUserFavoritesService getFavoritesService(String marketplaceUrl) {
        return this.getService(this.favoritesServiceTracker, marketplaceUrl);
    }

    @Override
    public IUserFavoritesService getDefaultFavoritesService() {
        return this.getFavoritesService(this.defaultMarketplaceUrl.toExternalForm());
    }

    public IUserFavoritesService registerFavoritesService(String marketplaceBaseUrl, String apiServerUrl, String apiKey) {
        IMarketplaceStorageService storageService = this.getStorageService(marketplaceBaseUrl);
        if (storageService == null && (storageService = this.registerStorageService(marketplaceBaseUrl, apiServerUrl, apiKey)) == null) {
            return null;
        }
        UserFavoritesService favoritesService = new UserFavoritesService();
        favoritesService.bindStorageService(storageService);
        favoritesService.bindHttpClient(this.httpClient);
        this.registerService(marketplaceBaseUrl, IUserFavoritesService.class, favoritesService);
        return favoritesService;
    }

    public IMarketplaceStorageService registerStorageService(String marketplaceBaseUrl, String apiServerUrl, String apiKey) {
        ServiceRegistration<MarketplaceStorageService> registration = null;
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        config.put("serviceUrl", apiServerUrl);
        if (apiKey != null) {
            config.put("applicationToken", apiKey);
        }
        try {
            MarketplaceStorageService marketplaceStorageService = new MarketplaceStorageService();
            registration = this.registerService(marketplaceBaseUrl, IMarketplaceStorageService.class, marketplaceStorageService, config);
            BundleContext bundleContext = ServiceUtil.getBundleContext(registration);
            if (bundleContext != null) {
                marketplaceStorageService.activate(bundleContext, config);
            }
            return marketplaceStorageService;
        }
        catch (Exception | NoClassDefFoundError ex) {
            MarketplaceClientCore.error("Userstorage API failed to initialize", ex);
            this.unregisterService(registration);
            return null;
        }
    }

    private void unregisterService(ServiceRegistration<?> registration) {
        if (registration != null) {
            this.dynamicServiceRegistrations.remove(registration);
            registration.unregister();
        }
    }

    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        URL marketplaceUrl;
        URL baseUrl = ServiceUtil.getUrl(properties, "url", null);
        URL catalogUrl = ServiceUtil.getUrl(properties, "catalogUrl", baseUrl);
        if (catalogUrl != null) {
            this.defaultCatalogUrl = catalogUrl;
        }
        if ((marketplaceUrl = ServiceUtil.getUrl(properties, "marketplaceUrl", baseUrl)) != null) {
            this.defaultMarketplaceUrl = marketplaceUrl;
        }
        this.marketplaceServiceTracker = new ServiceTracker(context, IMarketplaceService.class, null);
        this.marketplaceServiceTracker.open(true);
        this.catalogServiceTracker = new ServiceTracker(context, ICatalogService.class, null);
        this.catalogServiceTracker.open(true);
        this.storageServiceTracker = new ServiceTracker(context, IMarketplaceStorageService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<IMarketplaceStorageService, IMarketplaceStorageService>(){

            public IMarketplaceStorageService addingService(ServiceReference<IMarketplaceStorageService> reference) {
                IMarketplaceStorageService service = (IMarketplaceStorageService)ServiceLocator.this.storageServiceTracker.addingService(reference);
                Object marketplaceUrl = ServiceUtil.getOverridablePropertyValue(reference, "url");
                if (marketplaceUrl != null && service != null) {
                    ServiceLocator.this.bindToUserFavoritesServices(marketplaceUrl.toString(), reference);
                }
                return service;
            }

            public void modifiedService(ServiceReference<IMarketplaceStorageService> reference, IMarketplaceStorageService service) {
                Object marketplaceUrl = ServiceUtil.getOverridablePropertyValue(reference, "url");
                if (marketplaceUrl != null) {
                    ServiceLocator.this.rebindToUserFavoritesServices(marketplaceUrl.toString(), reference, service);
                } else {
                    ServiceLocator.this.unbindFromUserFavoritesServices(reference, service);
                }
            }

            public void removedService(ServiceReference<IMarketplaceStorageService> reference, IMarketplaceStorageService service) {
                ServiceLocator.this.unbindFromUserFavoritesServices(reference, service);
            }
        });
        this.storageServiceTracker.open(true);
        this.favoritesServiceTracker = new ServiceTracker(context, IUserFavoritesService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<IUserFavoritesService, IUserFavoritesService>(){

            public IUserFavoritesService addingService(ServiceReference<IUserFavoritesService> reference) {
                return ServiceUtil.getService(reference);
            }

            public void modifiedService(ServiceReference<IUserFavoritesService> reference, IUserFavoritesService service) {
                if (!(service instanceof UserFavoritesService)) {
                    return;
                }
                ServiceReference storageServiceBinding = (ServiceReference)reference.getProperty(ServiceLocator.STORAGE_SERVICE_BINDING_ID);
                if (storageServiceBinding != null && service.getStorageService() == null) {
                    ((UserFavoritesService)service).bindStorageService((IMarketplaceStorageService)ServiceUtil.getService(storageServiceBinding));
                } else if (service.getStorageService() != null && ServiceLocator.this.getDynamicServiceInstance(reference) != null) {
                    ((UserFavoritesService)service).setStorageService(null);
                }
            }

            public void removedService(ServiceReference<IUserFavoritesService> reference, IUserFavoritesService service) {
            }
        });
        this.favoritesServiceTracker.open(true);
    }

    private static <T> void applyServiceReferenceOperation(ServiceTracker<T, ?> serviceTracker, ServiceReferenceOperation<T> op) {
        ServiceReference[] serviceReferences;
        if (serviceTracker != null && (serviceReferences = serviceTracker.getServiceReferences()) != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                op.apply(serviceReference);
                ++n2;
            }
        }
    }

    private void bindToUserFavoritesServices(final String marketplaceUrl, ServiceReference<IMarketplaceStorageService> serviceReference) {
        ServiceLocator.applyServiceReferenceOperation(this.favoritesServiceTracker, new DynamicBindingOperation<IUserFavoritesService, IMarketplaceStorageService>(this, STORAGE_SERVICE_BINDING_ID, serviceReference){

            @Override
            public void apply(ServiceReference<IUserFavoritesService> reference) {
                Object baseUrl = ServiceUtil.getOverridablePropertyValue(reference, "url");
                if (marketplaceUrl.equals(baseUrl)) {
                    super.apply(reference);
                }
            }

            @Override
            protected IMarketplaceStorageService getCurrentBinding(IUserFavoritesService service) {
                return service.getStorageService();
            }
        });
    }

    private void rebindToUserFavoritesServices(final String marketplaceUrl, final ServiceReference<IMarketplaceStorageService> serviceReference, final IMarketplaceStorageService serviceInstance) {
        ServiceLocator.applyServiceReferenceOperation(this.favoritesServiceTracker, new DynamicBindingOperation<IUserFavoritesService, IMarketplaceStorageService>(this, STORAGE_SERVICE_BINDING_ID, serviceReference){

            @Override
            public void apply(ServiceReference<IUserFavoritesService> reference) {
                Object baseUrl = ServiceUtil.getOverridablePropertyValue(reference, "url");
                if (marketplaceUrl.equals(baseUrl)) {
                    super.apply(reference);
                } else {
                    this.unbindFromUserFavoritesService(reference, (ServiceReference<IMarketplaceStorageService>)serviceReference, serviceInstance);
                }
            }

            @Override
            protected IMarketplaceStorageService getCurrentBinding(IUserFavoritesService service) {
                return service.getStorageService();
            }
        });
    }

    private void unbindFromUserFavoritesServices(final ServiceReference<IMarketplaceStorageService> serviceReference, final IMarketplaceStorageService serviceInstance) {
        ServiceLocator.applyServiceReferenceOperation(this.favoritesServiceTracker, new DynamicBindingOperation<IUserFavoritesService, IMarketplaceStorageService>(this, STORAGE_SERVICE_BINDING_ID, serviceReference){

            @Override
            public void apply(ServiceReference<IUserFavoritesService> reference) {
                this.unbindFromUserFavoritesService(reference, (ServiceReference<IMarketplaceStorageService>)serviceReference, serviceInstance);
            }

            @Override
            protected IMarketplaceStorageService getCurrentBinding(IUserFavoritesService service) {
                return service.getStorageService();
            }
        });
    }

    private void unbindFromUserFavoritesService(ServiceReference<IUserFavoritesService> reference, ServiceReference<IMarketplaceStorageService> serviceReference, IMarketplaceStorageService serviceInstance) {
        IUserFavoritesService service;
        ServiceRegistration<IUserFavoritesService> registration = this.getDynamicServiceInstance(reference);
        if (registration == null) {
            return;
        }
        Object binding = reference.getProperty(STORAGE_SERVICE_BINDING_ID);
        if (binding != null && serviceReference.equals(binding) && registration != null) {
            Dictionary<String, Object> properties = ServiceUtil.getProperties(reference);
            properties.remove(STORAGE_SERVICE_BINDING_ID);
            registration.setProperties(properties);
        }
        if ((service = ServiceUtil.getService(registration)).getStorageService() == serviceInstance) {
            ((UserFavoritesService)service).unbindStorageService(serviceInstance);
        }
    }

    private <T, R extends T> ServiceRegistration<T> getDynamicServiceInstance(ServiceReference<T> reference) {
        for (ServiceRegistration<?> serviceRegistration : this.dynamicServiceRegistrations) {
            if (!reference.equals((Object)serviceRegistration.getReference())) continue;
            ServiceRegistration<?> referencedRegistration = serviceRegistration;
            return referencedRegistration;
        }
        return null;
    }

    public synchronized void deactivate() {
        if (this.favoritesServiceTracker != null) {
            this.favoritesServiceTracker.close();
            this.favoritesServiceTracker = null;
        }
        if (this.storageServiceTracker != null) {
            this.storageServiceTracker.close();
            this.storageServiceTracker = null;
        }
        if (this.marketplaceServiceTracker != null) {
            this.marketplaceServiceTracker.close();
            this.marketplaceServiceTracker = null;
        }
        if (this.catalogServiceTracker != null) {
            this.catalogServiceTracker.close();
            this.catalogServiceTracker = null;
        }
        for (ServiceRegistration<?> serviceRegistration : this.dynamicServiceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Override
    public synchronized ICatalogService getCatalogService() {
        ICatalogService registeredService;
        if (this.catalogServiceTracker != null && (registeredService = (ICatalogService)this.catalogServiceTracker.getService()) != null) {
            return registeredService;
        }
        if (this.catalogService != null) {
            return this.catalogService;
        }
        DefaultCatalogService catalogService = new DefaultCatalogService(this.defaultCatalogUrl);
        this.registerService(null, ICatalogService.class, catalogService);
        return catalogService;
    }

    @Deprecated
    public static synchronized void setInstance(ServiceLocator instance) {
        ServiceLocator.instance = instance;
    }

    @Deprecated
    public static synchronized ServiceLocator getInstance() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceLocator.getCompatibilityLocator();
        if (locator != null && locator instanceof ServiceLocator) {
            return (ServiceLocator)locator;
        }
        instance = new ServiceLocator();
        return instance;
    }

    public static synchronized IMarketplaceServiceLocator getCompatibilityLocator() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceHelper.getMarketplaceServiceLocator();
        if (locator == null) {
            instance = new ServiceLocator();
            locator = instance;
        }
        return locator;
    }

    public static Map<String, String> computeDefaultRequestMetaParameters() {
        LinkedHashMap<String, String> requestMetaParameters = new LinkedHashMap<String, String>();
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "client", "org.eclipse.epp.mpc.core");
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "os", Platform.getOS());
        Bundle platformBundle = Platform.getBundle((String)"org.eclipse.platform");
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "platform.version", platformBundle == null ? null : ServiceLocator.shortenVersionString(platformBundle.getVersion().toString()));
        return requestMetaParameters;
    }

    public static Map<String, String> computeProductInfo() {
        Bundle productBundle;
        LinkedHashMap<String, String> productInfo = new LinkedHashMap<String, String>();
        BundleContext bundleContext = FrameworkUtil.getBundle(MarketplaceClientCore.class).getBundleContext();
        IProduct product = Platform.getProduct();
        String productId = bundleContext.getProperty("eclipse.product");
        if (productId == null && product != null) {
            productId = product.getId();
        }
        ServiceLocator.addDefaultRequestMetaParameter(productInfo, "product", productId);
        String productVersion = null;
        if (productId != null && (productVersion = bundleContext.getProperty("eclipse.buildId")) == null && product != null && (productBundle = product.getDefiningBundle()) != null) {
            productVersion = productBundle.getVersion().toString();
        }
        ServiceLocator.addDefaultRequestMetaParameter(productInfo, "product.version", productVersion);
        return productInfo;
    }

    private static void addDefaultRequestMetaParameter(Map<String, String> requestMetaParameters, String key, String value) {
        if (DEBUG_FAKE_CLIENT) {
            String debugOption = Platform.getDebugOption((String)(DEBUG_CLIENT_OPTIONS_PATH + key));
            if (DEBUG_CLIENT_REMOVE_OPTION.equals(debugOption)) {
                requestMetaParameters.remove(key);
                return;
            }
            if (debugOption != null && !"".equals(debugOption)) {
                value = debugOption;
            }
        }
        if (value != null) {
            requestMetaParameters.put(key, value);
        }
    }

    private static String shortenVersionString(String version) {
        int index = version.indexOf(46);
        if (index > -1 && (index = version.indexOf(46, index + 1)) > -1) {
            return version.substring(0, index);
        }
        return version;
    }

    @Component(name="org.eclipse.epp.mpc.core.debug.options", property={"listener.symbolic.name=org.eclipse.epp.mpc.core"})
    public static class DebugOptionsInitializer
    implements DebugOptionsListener {
        public void optionsChanged(DebugOptions options) {
            boolean debug = options.getBooleanOption("org.eclipse.epp.mpc.core/debug", false);
            boolean fakeClient = false;
            if (debug) {
                fakeClient = options.getBooleanOption("org.eclipse.epp.mpc.core/client/fakeVersion", false);
            }
            DEBUG_FAKE_CLIENT = fakeClient;
        }
    }

    private abstract class DynamicBindingOperation<T, B>
    implements ServiceReferenceOperation<T> {
        private final String dynamicBindId;
        private final ServiceReference<B> binding;

        public DynamicBindingOperation(String dynamicBindId, ServiceReference<B> binding) {
            this.dynamicBindId = dynamicBindId;
            this.binding = binding;
        }

        @Override
        public void apply(ServiceReference<T> reference) {
            ServiceRegistration<T> registration = ServiceLocator.this.getDynamicServiceInstance(reference);
            if (registration != null) {
                Dictionary<String, Object> properties = ServiceUtil.getProperties(reference);
                if (properties.get(this.dynamicBindId) != null) {
                    return;
                }
                T service = ServiceUtil.getService(registration);
                B currentBinding = service == null ? null : (B)this.getCurrentBinding(service);
                this.apply(service, currentBinding, registration, properties);
            }
        }

        protected void apply(T service, B currentBinding, ServiceRegistration<T> registration, Dictionary<String, Object> properties) {
            if (service != null && currentBinding == null) {
                properties.put(this.dynamicBindId, this.binding);
                registration.setProperties(properties);
            }
        }

        protected abstract B getCurrentBinding(T var1);
    }

    private static interface ServiceReferenceOperation<T> {
        public void apply(ServiceReference<T> var1);
    }
}

