/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.TimeoutException;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.kernel.equinox.extensions.hooks.MetaInfResourceClassLoaderDelegateHook;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.framework.ImportExpander;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.kernel.osgi.framework.ServiceUtils;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.services.work.WorkArea;
import org.eclipse.virgo.kernel.userregion.internal.ConsoleConfigurationConvertor;
import org.eclipse.virgo.kernel.userregion.internal.DumpExtractor;
import org.eclipse.virgo.kernel.userregion.internal.EmptyModuleContextAccessor;
import org.eclipse.virgo.kernel.userregion.internal.InitialArtifactDeployer;
import org.eclipse.virgo.kernel.userregion.internal.KernelStartedAwaiter;
import org.eclipse.virgo.kernel.userregion.internal.ServiceScopingRegistryHook;
import org.eclipse.virgo.kernel.userregion.internal.ServiceScopingStrategy;
import org.eclipse.virgo.kernel.userregion.internal.UserRegionConfigurationDeployer;
import org.eclipse.virgo.kernel.userregion.internal.UserRegionLogEvents;
import org.eclipse.virgo.kernel.userregion.internal.dump.StandardDumpExtractor;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxHookRegistrar;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxOsgiFramework;
import org.eclipse.virgo.kernel.userregion.internal.equinox.StandardPackageAdminUtil;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.ImportExpansionHandler;
import org.eclipse.virgo.kernel.userregion.internal.management.StateDumpMXBeanExporter;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiFrameworkFactory;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardResolutionFailureDetective;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.EventLoggerFactory;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.ConfigurationExporter;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.deployer.api.config.ConfigurationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    private static final long SYSTEM_BUNDLE_ID = 0L;
    private static final String PROPERTY_USER_REGION_ARTIFACTS = "initialArtifacts";
    private static final String PROPERTY_USER_REGION_COMMANDLINE_ARTIFACTS = "commandLineArtifacts";
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
    private static final String KERNEL_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel";
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
    private volatile EquinoxHookRegistrar hookRegistrar;
    private StateDumpMXBeanExporter stateDumpMBeanExorter;
    private ConsoleConfigurationConvertor consoleConfigurationConvertor = null;

    public void start(BundleContext context) throws Exception {
        this.publishConfigurations(context);
        ResolutionFailureDetective rfd = this.createResolutionFailureDetective(context);
        Repository repository = (Repository)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, Repository.class);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, PackageAdmin.class);
        EventLogger eventLogger = ((EventLoggerFactory)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, EventLoggerFactory.class)).createEventLogger(context.getBundle());
        RegionDigraph regionDigraph = (RegionDigraph)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, RegionDigraph.class);
        WorkArea workArea = (WorkArea)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, WorkArea.class);
        ImportExpansionHandler importExpansionHandler = this.createImportExpansionHandler(context, packageAdmin, repository, eventLogger);
        this.registrationTracker.track(context.registerService(ImportExpander.class.getName(), (Object)importExpansionHandler, null));
        TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler = this.createBundleTransformationHandler(importExpansionHandler);
        OsgiFramework osgiFramework = this.createOsgiFramework(context, packageAdmin, bundleTransformerHandler);
        this.registrationTracker.track(context.registerService(OsgiFramework.class.getName(), (Object)osgiFramework, null));
        StandardDumpExtractor dumpExtractor = new StandardDumpExtractor(workArea);
        QuasiFrameworkFactory quasiFrameworkFactory = this.createQuasiFrameworkFactory(context, rfd, repository, bundleTransformerHandler, regionDigraph, dumpExtractor);
        this.registrationTracker.track(context.registerService(QuasiFrameworkFactory.class.getName(), (Object)quasiFrameworkFactory, null));
        EquinoxHookRegistrar hookRegistrar = this.createHookRegistrar(context, packageAdmin, bundleTransformerHandler);
        hookRegistrar.init();
        this.hookRegistrar = hookRegistrar;
        PackageAdminUtil packageAdminUtil = this.createPackageAdminUtil(context);
        this.registrationTracker.track(context.registerService(PackageAdminUtil.class.getName(), (Object)packageAdminUtil, null));
        this.scheduleRegistrationOfServiceScopingRegistryHooks(context, eventLogger);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", Integer.MIN_VALUE);
        this.registrationTracker.track(context.registerService(ModuleContextAccessor.class.getName(), (Object)new EmptyModuleContextAccessor(), properties));
        this.scheduleInitialArtifactDeployerCreation(context, eventLogger);
        context.registerService(ConfigurationDeployer.class, (Object)new UserRegionConfigurationDeployer(context), null);
        this.initializeConsoleConfigurationConvertor(context);
        this.stateDumpMBeanExorter = new StateDumpMXBeanExporter(quasiFrameworkFactory);
    }

    private void publishConfigurations(BundleContext context) throws Exception {
        ConfigurationExporter configurationExporter = (ConfigurationExporter)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, ConfigurationExporter.class);
        ConfigurationAdmin admin = (ConfigurationAdmin)ServiceUtils.getPotentiallyDelayedService((BundleContext)context, ConfigurationAdmin.class);
        try {
            this.publishConfigurationFromKernelRegion(configurationExporter.getUserRegionConfigurationProperties(), admin.getConfiguration(USER_REGION_CONFIGURATION_PID));
            this.publishConfigurationFromKernelRegion(configurationExporter.getKernelRegionConfigurationProperties(), admin.getConfiguration(KERNEL_REGION_CONFIGURATION_PID));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to publish required configurations. Startup sequence can't continue", e);
        }
    }

    private void publishConfigurationFromKernelRegion(Dictionary<String, Object> configurationProperties, Configuration config) throws IOException {
        config.update(configurationProperties);
    }

    private ResolutionFailureDetective createResolutionFailureDetective(BundleContext context) {
        PlatformAdmin platformAdmin = (PlatformAdmin)OsgiFrameworkUtils.getService((BundleContext)context, PlatformAdmin.class).getService();
        return new StandardResolutionFailureDetective(platformAdmin);
    }

    private OsgiFramework createOsgiFramework(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler) {
        return new EquinoxOsgiFramework(context, packageAdmin, bundleTransformerHandler);
    }

    private QuasiFrameworkFactory createQuasiFrameworkFactory(BundleContext bundleContext, ResolutionFailureDetective detective, Repository repository, TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler, RegionDigraph regionDigraph, DumpExtractor dumpExtractor) {
        return new StandardQuasiFrameworkFactory(bundleContext, detective, repository, bundleTransformerHandler, regionDigraph, dumpExtractor);
    }

    private TransformedManifestProvidingBundleFileWrapper createBundleTransformationHandler(ImportExpansionHandler importExpander) {
        return new TransformedManifestProvidingBundleFileWrapper(importExpander);
    }

    private ImportExpansionHandler createImportExpansionHandler(BundleContext context, PackageAdmin packageAdmin, Repository repository, EventLogger eventLogger) {
        ExportedPackage[] exportedPackages;
        HashSet<String> packagesExportedBySystemBundle = new HashSet<String>(30);
        ExportedPackage[] exportedPackageArray = exportedPackages = packageAdmin.getExportedPackages(context.getBundle(0L));
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage exportedPackage = exportedPackageArray[n2];
            packagesExportedBySystemBundle.add(exportedPackage.getName());
            ++n2;
        }
        return new ImportExpansionHandler(repository, context, packagesExportedBySystemBundle, eventLogger);
    }

    private EquinoxHookRegistrar createHookRegistrar(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleFileWrapper) {
        MetaInfResourceClassLoaderDelegateHook hook = new MetaInfResourceClassLoaderDelegateHook(context, packageAdmin);
        return new EquinoxHookRegistrar(bundleFileWrapper, (ClassLoaderDelegateHook)hook);
    }

    private PackageAdminUtil createPackageAdminUtil(BundleContext context) {
        return new StandardPackageAdminUtil(context);
    }

    private void scheduleRegistrationOfServiceScopingRegistryHooks(BundleContext context, EventLogger eventLogger) {
        ServiceScopingHookRegisteringRunnable runnable = new ServiceScopingHookRegisteringRunnable(context, this.registrationTracker, eventLogger);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private void scheduleInitialArtifactDeployerCreation(BundleContext context, EventLogger eventLogger) {
        KernelStartedAwaiter startedAwaiter = new KernelStartedAwaiter();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/eclipse/virgo/kernel/*");
        this.registrationTracker.track(context.registerService(EventHandler.class.getName(), (Object)startedAwaiter, properties));
        InitialArtifactDeployerCreatingRunnable runnable = new InitialArtifactDeployerCreatingRunnable(context, eventLogger, this.registrationTracker, startedAwaiter);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private void initializeConsoleConfigurationConvertor(BundleContext context) {
        this.consoleConfigurationConvertor = new ConsoleConfigurationConvertor(context);
        this.consoleConfigurationConvertor.start();
    }

    public void stop(BundleContext context) throws Exception {
        EquinoxHookRegistrar hookRegistrar;
        StateDumpMXBeanExporter localStateDumpMBeanExporter;
        this.registrationTracker.unregisterAll();
        if (this.consoleConfigurationConvertor != null) {
            this.consoleConfigurationConvertor.stop();
        }
        if ((localStateDumpMBeanExporter = this.stateDumpMBeanExorter) != null) {
            localStateDumpMBeanExporter.close();
            this.stateDumpMBeanExorter = null;
        }
        if ((hookRegistrar = this.hookRegistrar) != null) {
            hookRegistrar.destroy();
            this.hookRegistrar = null;
        }
    }

    private static final class InitialArtifactDeployerCreatingRunnable
    implements Runnable {
        private final BundleContext context;
        private final EventLogger eventLogger;
        private final KernelStartedAwaiter startAwaiter;
        private final ServiceRegistrationTracker registrationTracker;

        public InitialArtifactDeployerCreatingRunnable(BundleContext context, EventLogger eventLogger, ServiceRegistrationTracker registrationTracker, KernelStartedAwaiter startAwaiter) {
            this.context = context;
            this.eventLogger = eventLogger;
            this.startAwaiter = startAwaiter;
            this.registrationTracker = registrationTracker;
        }

        @Override
        public void run() {
            EventAdmin eventAdmin = (EventAdmin)OsgiFrameworkUtils.getService((BundleContext)this.context, EventAdmin.class).getService();
            Shutdown shutdown = (Shutdown)OsgiFrameworkUtils.getService((BundleContext)this.context, Shutdown.class).getService();
            try {
                DeployUriNormaliser uriNormaliser = (DeployUriNormaliser)ServiceUtils.getPotentiallyDelayedService((BundleContext)this.context, DeployUriNormaliser.class);
                ApplicationDeployer deployer = (ApplicationDeployer)ServiceUtils.getPotentiallyDelayedService((BundleContext)this.context, ApplicationDeployer.class);
                Dictionary<String, Object> artifactConfiguration = this.getRegionArtifactConfiguration();
                InitialArtifactDeployer initialArtifactDeployer = new InitialArtifactDeployer(this.startAwaiter, deployer, artifactConfiguration.get(Activator.PROPERTY_USER_REGION_ARTIFACTS), artifactConfiguration.get(Activator.PROPERTY_USER_REGION_COMMANDLINE_ARTIFACTS), uriNormaliser, eventAdmin, this.eventLogger, shutdown);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("event.topics", "org/eclipse/virgo/kernel/*");
                this.registrationTracker.track(this.context.registerService(EventHandler.class.getName(), (Object)initialArtifactDeployer, properties));
                initialArtifactDeployer.deployArtifacts();
            }
            catch (TimeoutException te) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.KERNEL_SERVICE_NOT_AVAILABLE, (Throwable)te, new Object[]{ServiceUtils.getWaitLimitSeconds(), "org.eclipse.virgo.kernel.startup.wait.limit"});
                shutdown.immediateShutdown();
            }
            catch (InterruptedException ie) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.USERREGION_START_INTERRUPTED, (Throwable)ie, new Object[0]);
                shutdown.immediateShutdown();
            }
        }

        private Dictionary<String, Object> getRegionArtifactConfiguration() {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)OsgiFrameworkUtils.getService((BundleContext)this.context, ConfigurationAdmin.class).getService();
            try {
                Configuration config = configAdmin.getConfiguration(Activator.USER_REGION_CONFIGURATION_PID, null);
                Dictionary properties = config.getProperties();
                return properties;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to read region artifact configuration", ioe);
            }
        }
    }

    private static final class ServiceScopingHookRegisteringRunnable
    implements Runnable {
        private final EventLogger eventLogger;
        private final BundleContext context;
        private final ServiceRegistrationTracker registrationTracker;

        public ServiceScopingHookRegisteringRunnable(BundleContext context, ServiceRegistrationTracker registrationTracker, EventLogger eventLogger) {
            this.context = context;
            this.registrationTracker = registrationTracker;
            this.eventLogger = eventLogger;
        }

        @Override
        public void run() {
            ScopeFactory scopeFactory = (ScopeFactory)OsgiFrameworkUtils.getService((BundleContext)this.context, ScopeFactory.class).getService();
            Shutdown shutdown = (Shutdown)OsgiFrameworkUtils.getService((BundleContext)this.context, Shutdown.class).getService();
            try {
                ScopeServiceRepository scopeServiceRepository = (ScopeServiceRepository)ServiceUtils.getPotentiallyDelayedService((BundleContext)this.context, ScopeServiceRepository.class);
                ServiceScopingStrategy serviceScopingStrategy = new ServiceScopingStrategy(scopeFactory, scopeServiceRepository);
                ServiceScopingRegistryHook serviceScopingRegistryHook = new ServiceScopingRegistryHook(serviceScopingStrategy);
                this.registrationTracker.track(this.context.registerService(new String[]{"org.osgi.framework.hooks.service.FindHook", "org.osgi.framework.hooks.service.EventHook"}, (Object)serviceScopingRegistryHook, null));
            }
            catch (TimeoutException te) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.KERNEL_SERVICE_NOT_AVAILABLE, (Throwable)te, new Object[]{ServiceUtils.getWaitLimitSeconds(), "org.eclipse.virgo.kernel.startup.wait.limit"});
                shutdown.immediateShutdown();
            }
            catch (InterruptedException ie) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.USERREGION_START_INTERRUPTED, (Throwable)ie, new Object[0]);
                shutdown.immediateShutdown();
            }
        }
    }
}

