/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.theme.QxAnimation;
import org.eclipse.rap.rwt.internal.theme.QxBoolean;
import org.eclipse.rap.rwt.internal.theme.QxBorder;
import org.eclipse.rap.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxCursor;
import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxFloat;
import org.eclipse.rap.rwt.internal.theme.QxFont;
import org.eclipse.rap.rwt.internal.theme.QxIdentifier;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxShadow;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.service.ApplicationContext;

public final class ThemePropertyAdapterRegistry {
    private static final Object LOCK = new Object();
    private static final String ATTR_NAME = String.valueOf(ThemePropertyAdapterRegistry.class.getName()) + "#instance";
    private final Map<Class<? extends QxType>, ThemePropertyAdapter> map = new HashMap<Class<? extends QxType>, ThemePropertyAdapter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThemePropertyAdapterRegistry getInstance(ApplicationContext applicationContext) {
        ThemePropertyAdapterRegistry result;
        Object object = LOCK;
        synchronized (object) {
            result = (ThemePropertyAdapterRegistry)applicationContext.getAttribute(ATTR_NAME);
            if (result == null) {
                result = new ThemePropertyAdapterRegistry();
                applicationContext.setAttribute(ATTR_NAME, result);
            }
        }
        return result;
    }

    private ThemePropertyAdapterRegistry() {
        this.map.put(QxAnimation.class, new AnimationPropertyAdapter());
        this.map.put(QxBoolean.class, new DirectPropertyAdapter());
        this.map.put(QxBorder.class, new BorderPropertyAdapter());
        this.map.put(QxBoxDimensions.class, new BoxDimensionsPropertyAdapter());
        this.map.put(QxColor.class, new ColorPropertyAdapter());
        this.map.put(QxCursor.class, new CursorPropertyAdapter());
        this.map.put(QxDimension.class, new DimensionPropertyAdapter());
        this.map.put(QxFloat.class, new DirectPropertyAdapter());
        this.map.put(QxFont.class, new FontPropertyAdapter());
        this.map.put(QxIdentifier.class, new DirectPropertyAdapter());
        this.map.put(QxImage.class, new ImagePropertyAdapter());
        this.map.put(QxShadow.class, new ShadowPropertyAdapter());
    }

    public ThemePropertyAdapter getPropertyAdapter(Class key) {
        return this.map.get(key);
    }

    public static class AnimationPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "animations";
        }

        public JsonValue getValue(QxType value) {
            QxAnimation animation = (QxAnimation)value;
            JsonObject result = new JsonObject();
            int j = 0;
            while (j < animation.animations.length) {
                QxAnimation.Animation currentAnimation = animation.animations[j];
                JsonArray currentAnimationArray = new JsonArray();
                currentAnimationArray.add(currentAnimation.duration);
                String timingFunction = QxAnimation.toCamelCaseString(currentAnimation.timingFunction);
                currentAnimationArray.add(timingFunction);
                result.add(currentAnimation.name, currentAnimationArray);
                ++j;
            }
            return result;
        }
    }

    public static class BorderPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "borders";
        }

        public JsonValue getValue(QxType value) {
            QxBorder border = (QxBorder)value;
            JsonObject result = new JsonObject();
            result.add("width", border.width);
            result.add("style", border.style);
            result.add("color", border.color);
            return result;
        }
    }

    public static class BoxDimensionsPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "boxdims";
        }

        public JsonValue getValue(QxType value) {
            QxBoxDimensions boxdim = (QxBoxDimensions)value;
            JsonArray result = new JsonArray();
            result.add(boxdim.top);
            result.add(boxdim.right);
            result.add(boxdim.bottom);
            result.add(boxdim.left);
            return result;
        }
    }

    public static class ColorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "colors";
        }

        public JsonValue getValue(QxType value) {
            JsonValue result;
            QxColor color = (QxColor)value;
            if (color.isTransparent()) {
                result = JsonValue.valueOf("undefined");
            } else {
                JsonArray colorArray = new JsonArray();
                colorArray.add(color.red);
                colorArray.add(color.green);
                colorArray.add(color.blue);
                colorArray.add(color.alpha);
                result = colorArray;
            }
            return result;
        }
    }

    public static class CursorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return this.createKey(value);
        }

        public String getSlot(QxType value) {
            return "cursors";
        }

        public JsonValue getValue(QxType value) {
            QxCursor cursor = (QxCursor)value;
            JsonValue result = cursor.isCustomCursor() ? JsonValue.NULL : JsonValue.valueOf(cursor.value);
            return result;
        }

        private String createKey(QxType value) {
            int index;
            String result = Integer.toHexString(value.hashCode());
            QxCursor cursor = (QxCursor)value;
            if (cursor.isCustomCursor() && (index = cursor.value.lastIndexOf(46)) >= 0) {
                result = String.valueOf(result) + cursor.value.substring(index);
            }
            return result;
        }
    }

    public static class DimensionPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "dimensions";
        }

        public JsonValue getValue(QxType value) {
            return JsonValue.valueOf(((QxDimension)value).value);
        }
    }

    public static class DirectPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return value.toDefaultString();
        }

        public String getSlot(QxType value) {
            return null;
        }

        public JsonValue getValue(QxType value) {
            return null;
        }
    }

    public static class FontPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "fonts";
        }

        public JsonValue getValue(QxType value) {
            QxFont font = (QxFont)value;
            JsonObject result = new JsonObject();
            result.add("family", JsonUtil.createJsonArray(font.family));
            result.add("size", font.size);
            result.add("bold", font.bold);
            result.add("italic", font.italic);
            return result;
        }
    }

    public static class ImagePropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return this.createKey(value);
        }

        public String getSlot(QxType value) {
            QxImage image = (QxImage)value;
            String result = image.isGradient() ? "gradients" : "images";
            return result;
        }

        public JsonValue getValue(QxType value) {
            QxImage image = (QxImage)value;
            JsonValue result = null;
            if (image.isGradient()) {
                JsonObject gradientObject = null;
                gradientObject = new JsonObject();
                JsonArray percents = JsonUtil.createJsonArray(image.gradientPercents);
                gradientObject.add("percents", percents);
                JsonArray colors = JsonUtil.createJsonArray(image.gradientColors);
                gradientObject.add("colors", colors);
                gradientObject.add("vertical", image.vertical);
                result = gradientObject;
            } else if (!image.none) {
                JsonArray imageArray = new JsonArray();
                imageArray.add(image.width);
                imageArray.add(image.height);
                result = imageArray;
            }
            return result;
        }

        private String createKey(QxType value) {
            int index;
            String result = Integer.toHexString(value.hashCode());
            QxImage image = (QxImage)value;
            if (image.path != null && (index = image.path.lastIndexOf(46)) >= 0) {
                result = String.valueOf(result) + image.path.substring(index);
            }
            return result;
        }
    }

    public static class ShadowPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "shadows";
        }

        public JsonValue getValue(QxType value) {
            JsonValue result;
            QxShadow shadow = (QxShadow)value;
            if (shadow.equals(QxShadow.NONE)) {
                result = JsonValue.NULL;
            } else {
                JsonArray array = new JsonArray();
                array.add(shadow.inset);
                array.add(shadow.offsetX);
                array.add(shadow.offsetY);
                array.add(shadow.blur);
                array.add(shadow.spread);
                array.add(shadow.color);
                array.add(shadow.opacity);
                result = array;
            }
            return result;
        }
    }

    public static interface ThemePropertyAdapter {
        public String getSlot(QxType var1);

        public String getKey(QxType var1);

        public JsonValue getValue(QxType var1);
    }
}

