/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.text.MessageFormat;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.lifecycle.WidgetLifeCycleAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public final class WidgetUtil {
    public static final String CUSTOM_WIDGET_ID = "org.eclipse.rap.rwt.customWidgetId";

    private WidgetUtil() {
    }

    public static WidgetAdapter getAdapter(Widget widget) {
        WidgetAdapter adapter = widget.getAdapter(org.eclipse.rap.rwt.lifecycle.WidgetAdapter.class);
        if (adapter == null) {
            throw new IllegalStateException("Could not retrieve an instance of WidgetAdapter.");
        }
        return adapter;
    }

    public static String getId(Widget widget) {
        return WidgetUtil.getAdapter(widget).getId();
    }

    public static String getVariant(Widget widget) {
        String result = null;
        WidgetAdapterImpl widgetAdapter = (WidgetAdapterImpl)WidgetUtil.getAdapter(widget);
        Object data = widget.getData("org.eclipse.rap.rwt.customVariant");
        if (data instanceof String && !(result = (String)data).equals(widgetAdapter.getCachedVariant())) {
            if (WidgetUtil.validateVariantString(result)) {
                widgetAdapter.setCachedVariant(result);
            } else {
                String pattern = "Illegal character in widget variant ''{0}''";
                Object[] arguments = new Object[]{result};
                String message = MessageFormat.format(pattern, arguments);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static AbstractWidgetLCA getLCA(Widget widget) {
        AbstractWidgetLCA lca = (AbstractWidgetLCA)widget.getAdapter(WidgetLifeCycleAdapter.class);
        if (lca == null) {
            throw new IllegalStateException("Could not retrieve an instance of WidgetLifeCycleAdapter.");
        }
        return lca;
    }

    public static Widget find(Composite root, final String id) {
        final Widget[] result = new Widget[1];
        if (id != null) {
            WidgetTreeVisitor.accept(root, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    if (WidgetUtil.getId(widget).equals(id)) {
                        result[0] = widget;
                    }
                    return result[0] == null;
                }
            });
        }
        return result[0];
    }

    public static void registerDataKeys(String ... keys) {
        ParamCheck.notNull(keys, "keys");
        WidgetDataUtil.registerDataKeys(keys);
    }

    private static boolean validateVariantString(String variant) {
        int length;
        boolean result = false;
        String name = variant;
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        if ((length = name.length()) > 0) {
            result = WidgetUtil.isValidStart(name.charAt(0));
            int i = 1;
            while (i < length && result) {
                result &= WidgetUtil.isValidPart(name.charAt(i));
                ++i;
            }
        }
        return result;
    }

    private static boolean isValidStart(char ch) {
        return ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '\u0080' && ch <= '\u00ff';
    }

    private static boolean isValidPart(char ch) {
        return WidgetUtil.isValidStart(ch) || ch >= '0' && ch <= '9' || ch == '-';
    }
}

