/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.creation;

import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducer<T>
implements Producer<T> {
    protected OwbBean<T> bean;

    protected AbstractProducer(OwbBean<T> bean) {
        this.bean = bean;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.bean.getInjectionPoints();
    }

    public T produce(CreationalContext<T> creationalContext) {
        if (!(creationalContext instanceof CreationalContextImpl)) {
            creationalContext = this.bean.getWebBeansContext().getCreationalContextFactory().wrappedCreationalContext(creationalContext, this.bean);
        }
        T instance = this.bean.createNewInstance(creationalContext);
        return instance;
    }

    public void dispose(T instance) {
        CreationalContext<T> cc = this.getCreationalContext();
        this.bean.destroyCreatedInstance(instance, cc);
    }

    protected CreationalContext<T> getCreationalContext() {
        CreationalContext<T> cc = null;
        BeanManagerImpl bm = this.bean.getWebBeansContext().getBeanManagerImpl();
        try {
            Context ctx = bm.getContext(this.bean.getScope());
            if (ctx instanceof AbstractContext) {
                cc = ((AbstractContext)ctx).getCreationalContext(this.bean);
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        if (cc == null) {
            cc = bm.createCreationalContext((Contextual)this.bean);
        }
        return cc;
    }

    protected <X> X getBean(Class<X> clazz) {
        return clazz.cast(this.bean);
    }
}

