/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.InterfaceMaker;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.RefreshableScriptTargetSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ScriptFactoryPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanClassLoaderAware,
BeanFactoryAware,
ResourceLoaderAware,
DisposableBean,
Ordered {
    public static final String INLINE_SCRIPT_PREFIX = "inline:";
    public static final String REFRESH_CHECK_DELAY_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"refreshCheckDelay");
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"proxyTargetClass");
    public static final String LANGUAGE_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"language");
    private static final String SCRIPT_FACTORY_NAME_PREFIX = "scriptFactory.";
    private static final String SCRIPTED_OBJECT_NAME_PREFIX = "scriptedObject.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private long defaultRefreshCheckDelay = -1L;
    private boolean defaultProxyTargetClass = false;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ConfigurableBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    final DefaultListableBeanFactory scriptBeanFactory = new DefaultListableBeanFactory();
    private final Map<String, ScriptSource> scriptSourceCache = new HashMap<String, ScriptSource>();

    public void setDefaultRefreshCheckDelay(long defaultRefreshCheckDelay) {
        this.defaultRefreshCheckDelay = defaultRefreshCheckDelay;
    }

    public void setDefaultProxyTargetClass(boolean defaultProxyTargetClass) {
        this.defaultProxyTargetClass = defaultProxyTargetClass;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("ScriptFactoryPostProcessor doesn't work with a BeanFactory which does not implement ConfigurableBeanFactory: " + beanFactory.getClass());
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        this.scriptBeanFactory.setParentBeanFactory((BeanFactory)this.beanFactory);
        this.scriptBeanFactory.copyConfigurationFrom(this.beanFactory);
        Iterator it = this.scriptBeanFactory.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AopInfrastructureBean)) continue;
            it.remove();
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Class predictBeanType(Class beanClass, String beanName) {
        block8: {
            if (!ScriptFactory.class.isAssignableFrom(beanClass)) {
                return null;
            }
            BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
            try {
                Object bean;
                String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
                String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
                this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
                ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
                ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
                Object[] interfaces = scriptFactory.getScriptInterfaces();
                Class scriptedType = scriptFactory.getScriptedObjectType(scriptSource);
                if (scriptedType != null) {
                    return scriptedType;
                }
                if (!ObjectUtils.isEmpty((Object[])interfaces)) {
                    return interfaces.length == 1 ? interfaces[0] : this.createCompositeInterface((Class[])interfaces);
                }
                if (bd.isSingleton() && (bean = this.scriptBeanFactory.getBean(scriptedObjectBeanName)) != null) {
                    return bean.getClass();
                }
            }
            catch (Exception ex) {
                if (ex instanceof BeanCreationException && ((BeanCreationException)ex).getMostSpecificCause() instanceof BeanCurrentlyInCreationException) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Could not determine scripted object type for bean '" + beanName + "': " + ex.getMessage()));
                    }
                }
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug((Object)("Could not determine scripted object type for bean '" + beanName + "'"), (Throwable)ex);
            }
        }
        return null;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) {
        if (!ScriptFactory.class.isAssignableFrom(beanClass)) {
            return null;
        }
        BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
        String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
        this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
        ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
        ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
        boolean isFactoryBean = false;
        try {
            Class scriptedObjectType = scriptFactory.getScriptedObjectType(scriptSource);
            if (scriptedObjectType != null) {
                isFactoryBean = FactoryBean.class.isAssignableFrom(scriptedObjectType);
            }
        }
        catch (Exception ex) {
            throw new BeanCreationException(beanName, "Could not determine scripted object type for " + scriptFactory, (Throwable)ex);
        }
        long refreshCheckDelay = this.resolveRefreshCheckDelay(bd);
        if (refreshCheckDelay >= 0L) {
            Class[] interfaces = scriptFactory.getScriptInterfaces();
            RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource((BeanFactory)this.scriptBeanFactory, scriptedObjectBeanName, scriptFactory, scriptSource, isFactoryBean);
            boolean proxyTargetClass = this.resolveProxyTargetClass(bd);
            String language = (String)bd.getAttribute(LANGUAGE_ATTRIBUTE);
            if (proxyTargetClass && (language == null || !language.equals("groovy"))) {
                throw new BeanDefinitionValidationException("Cannot use proxyTargetClass=true with script beans where language is not groovy (found " + language + ")");
            }
            ts.setRefreshCheckDelay(refreshCheckDelay);
            return this.createRefreshableProxy((TargetSource)ts, interfaces, proxyTargetClass);
        }
        if (isFactoryBean) {
            scriptedObjectBeanName = "&" + scriptedObjectBeanName;
        }
        return this.scriptBeanFactory.getBean(scriptedObjectBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareScriptBeans(BeanDefinition bd, String scriptFactoryBeanName, String scriptedObjectBeanName) {
        DefaultListableBeanFactory defaultListableBeanFactory = this.scriptBeanFactory;
        synchronized (defaultListableBeanFactory) {
            if (!this.scriptBeanFactory.containsBeanDefinition(scriptedObjectBeanName)) {
                Object[] interfaces;
                this.scriptBeanFactory.registerBeanDefinition(scriptFactoryBeanName, this.createScriptFactoryBeanDefinition(bd));
                ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
                ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
                Object[] scriptedInterfaces = interfaces = scriptFactory.getScriptInterfaces();
                if (scriptFactory.requiresConfigInterface() && !bd.getPropertyValues().isEmpty()) {
                    Class configInterface = this.createConfigInterface(bd, (Class[])interfaces);
                    scriptedInterfaces = (Class[])ObjectUtils.addObjectToArray((Object[])interfaces, (Object)configInterface);
                }
                BeanDefinition objectBd = this.createScriptedObjectBeanDefinition(bd, scriptFactoryBeanName, scriptSource, (Class[])scriptedInterfaces);
                long refreshCheckDelay = this.resolveRefreshCheckDelay(bd);
                if (refreshCheckDelay >= 0L) {
                    objectBd.setScope("prototype");
                }
                this.scriptBeanFactory.registerBeanDefinition(scriptedObjectBeanName, objectBd);
            }
        }
    }

    protected long resolveRefreshCheckDelay(BeanDefinition beanDefinition) {
        long refreshCheckDelay = this.defaultRefreshCheckDelay;
        Object attributeValue = beanDefinition.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (attributeValue instanceof Number) {
            refreshCheckDelay = ((Number)attributeValue).longValue();
        } else if (attributeValue instanceof String) {
            refreshCheckDelay = Long.parseLong((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid refresh check delay attribute [" + REFRESH_CHECK_DELAY_ATTRIBUTE + "] with value [" + attributeValue + "]: needs to be of type Number or String");
        }
        return refreshCheckDelay;
    }

    protected boolean resolveProxyTargetClass(BeanDefinition beanDefinition) {
        boolean proxyTargetClass = this.defaultProxyTargetClass;
        Object attributeValue = beanDefinition.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE);
        if (attributeValue instanceof Boolean) {
            proxyTargetClass = (Boolean)attributeValue;
        } else if (attributeValue instanceof String) {
            proxyTargetClass = new Boolean((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid refresh check delay attribute [" + REFRESH_CHECK_DELAY_ATTRIBUTE + "] with value [" + attributeValue + "]: needs to be of type Number or String");
        }
        return proxyTargetClass;
    }

    protected BeanDefinition createScriptFactoryBeanDefinition(BeanDefinition bd) {
        GenericBeanDefinition scriptBd = new GenericBeanDefinition();
        scriptBd.setBeanClassName(bd.getBeanClassName());
        scriptBd.getConstructorArgumentValues().addArgumentValues(bd.getConstructorArgumentValues());
        return scriptBd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptSource getScriptSource(String beanName, String scriptSourceLocator) {
        Map<String, ScriptSource> map = this.scriptSourceCache;
        synchronized (map) {
            ScriptSource scriptSource = this.scriptSourceCache.get(beanName);
            if (scriptSource == null) {
                scriptSource = this.convertToScriptSource(beanName, scriptSourceLocator, this.resourceLoader);
                this.scriptSourceCache.put(beanName, scriptSource);
            }
            return scriptSource;
        }
    }

    protected ScriptSource convertToScriptSource(String beanName, String scriptSourceLocator, ResourceLoader resourceLoader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX.length()), beanName);
        }
        return new ResourceScriptSource(resourceLoader.getResource(scriptSourceLocator));
    }

    protected Class createConfigInterface(BeanDefinition bd, Class[] interfaces) {
        PropertyValue[] pvs;
        InterfaceMaker maker = new InterfaceMaker();
        PropertyValue[] propertyValueArray = pvs = bd.getPropertyValues().getPropertyValues();
        int n = pvs.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValue pv = propertyValueArray[n2];
            String propertyName = pv.getName();
            Class propertyType = BeanUtils.findPropertyType((String)propertyName, (Class[])interfaces);
            String setterName = "set" + StringUtils.capitalize((String)propertyName);
            Signature signature = new Signature(setterName, Type.VOID_TYPE, new Type[]{Type.getType((Class)propertyType)});
            maker.add(signature, new Type[0]);
            ++n2;
        }
        if (bd instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abd = (AbstractBeanDefinition)bd;
            if (abd.getInitMethodName() != null) {
                Signature signature = new Signature(abd.getInitMethodName(), Type.VOID_TYPE, new Type[0]);
                maker.add(signature, new Type[0]);
            }
            if (abd.getDestroyMethodName() != null) {
                Signature signature = new Signature(abd.getDestroyMethodName(), Type.VOID_TYPE, new Type[0]);
                maker.add(signature, new Type[0]);
            }
        }
        return maker.create();
    }

    protected Class createCompositeInterface(Class[] interfaces) {
        return ClassUtils.createCompositeInterface((Class[])interfaces, (ClassLoader)this.beanClassLoader);
    }

    protected BeanDefinition createScriptedObjectBeanDefinition(BeanDefinition bd, String scriptFactoryBeanName, ScriptSource scriptSource, Class[] interfaces) {
        GenericBeanDefinition objectBd = new GenericBeanDefinition(bd);
        objectBd.setFactoryBeanName(scriptFactoryBeanName);
        objectBd.setFactoryMethodName("getScriptedObject");
        objectBd.getConstructorArgumentValues().clear();
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)scriptSource);
        objectBd.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)interfaces);
        return objectBd;
    }

    protected Object createRefreshableProxy(TargetSource ts, Class[] interfaces, boolean proxyTargetClass) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(ts);
        ClassLoader classLoader = this.beanClassLoader;
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfacesForClass((Class)ts.getTargetClass(), (ClassLoader)this.beanClassLoader);
        }
        proxyFactory.setInterfaces(interfaces);
        if (proxyTargetClass) {
            classLoader = null;
            proxyFactory.setProxyTargetClass(proxyTargetClass);
        }
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor((Object)ts);
        introduction.suppressInterface(TargetSource.class);
        proxyFactory.addAdvice((Advice)introduction);
        return proxyFactory.getProxy(classLoader);
    }

    public void destroy() {
        this.scriptBeanFactory.destroySingletons();
    }
}

