/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.IOUtils;

final class UserConfigurationPropertiesSource
implements PropertiesSource {
    private static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private static final FilenameFilter PROPERTIES_FILENAME_FILTER = new FilenameFilter(){
        {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            try {
                return name.endsWith(UserConfigurationPropertiesSource.PROPERTIES_FILE_SUFFIX);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    };
    private final File[] kernelConfigDirectories;

    public UserConfigurationPropertiesSource(File[] kernelConfigDirectories) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.kernelConfigDirectories = kernelConfigDirectories;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            TreeMap<String, Properties> result = new TreeMap<String, Properties>();
            File[] fileArray = this.kernelConfigDirectories;
            int n = this.kernelConfigDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File[] configFiles;
                File dir = fileArray[n2];
                File[] fileArray2 = configFiles = UserConfigurationPropertiesSource.getPropertiesFiles(dir);
                int n3 = configFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    Properties properties = this.readPropertiesFromFile(file);
                    String pid = this.computePid(file, properties, result.keySet());
                    result.put(pid, properties);
                    ++n4;
                }
                ++n2;
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static File[] getPropertiesFiles(File directory) {
        try {
            if (directory.isDirectory()) {
                return FileSystemUtils.listFiles((File)directory, (FilenameFilter)PROPERTIES_FILENAME_FILTER);
            }
            return new File[0];
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties readPropertiesFromFile(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            Properties props = new Properties();
            BufferedInputStream is = null;
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    props.load(is);
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(is);
                    return null;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)is);
            return props;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String createPid(File file) {
        try {
            return UserConfigurationPropertiesSource.trimExtension(file.getName());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String trimExtension(String name) {
        try {
            int lpDot = name.lastIndexOf(46);
            return lpDot == -1 ? name : name.substring(0, lpDot);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String computePid(File file, Properties properties, Set<String> existingPids) {
        try {
            String pid = properties.getProperty("service.factoryPid");
            if (StringUtils.hasText((String)pid)) {
                return String.valueOf(pid) + "-" + UserConfigurationPropertiesSource.createPid(file);
            }
            pid = properties.getProperty("service.pid");
            if (StringUtils.hasText((String)pid)) {
                return pid;
            }
            return UserConfigurationPropertiesSource.createPid(file);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

