/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.recovery;

import java.net.URI;
import java.util.Map;
import org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer;
import org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

final class RecoveryAgent
implements EventHandler {
    private static final String TOPIC_SYSTEM_ARTIFACTS_DEPLOYED = "org/eclipse/virgo/kernel/userregion/systemartifacts/DEPLOYED";
    private static final String TOPIC_RECOVERY_COMPLETED = "org/eclipse/virgo/kernel/deployer/recovery/COMPLETED";
    private final ApplicationRecoverer recoverer;
    private final EventLogger eventLogger;
    private final EventAdmin eventAdmin;
    private final Map<URI, DeploymentOptions> recoveryState;

    public RecoveryAgent(ApplicationRecoverer recoverer, DeployerRecoveryLog recoveryLog, EventLogger eventLogger, EventAdmin eventAdmin) {
        this.recoverer = recoverer;
        this.recoveryState = recoveryLog.getRecoveryState();
        this.eventLogger = eventLogger;
        this.eventAdmin = eventAdmin;
    }

    void performRecovery() {
        if (this.isRecoveryEnabled()) {
            Thread recoveryThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry redeployEntry : RecoveryAgent.this.recoveryState.entrySet()) {
                            URI uri = (URI)redeployEntry.getKey();
                            DeploymentOptions deploymentOptions = (DeploymentOptions)redeployEntry.getValue();
                            try {
                                RecoveryAgent.this.recoverer.recoverDeployment(uri, deploymentOptions);
                            }
                            catch (DeploymentException e) {
                                RecoveryAgent.this.eventLogger.log((LogEvent)DeployerLogEvents.RECOVERY_FAILED, (Throwable)e, new Object[]{uri});
                            }
                            catch (FatalDeploymentException e) {
                                RecoveryAgent.this.eventLogger.log((LogEvent)DeployerLogEvents.RECOVERY_FAILED, (Throwable)e, new Object[]{uri});
                            }
                        }
                    }
                    finally {
                        RecoveryAgent.this.recoveryComplete();
                    }
                }
            }, "deployer-recovery");
            recoveryThread.start();
        } else {
            this.recoveryComplete();
        }
    }

    private void recoveryComplete() {
        this.recoveryState.clear();
        this.eventAdmin.postEvent(new Event(TOPIC_RECOVERY_COMPLETED, null));
    }

    private boolean isRecoveryEnabled() {
        return Boolean.valueOf(FrameworkUtil.getBundle(this.getClass()).getBundleContext().getProperty("org.eclipse.virgo.kernel.deployer.disableRecovery")) == false;
    }

    public void handleEvent(Event event) {
        if (TOPIC_SYSTEM_ARTIFACTS_DEPLOYED.equals(event.getTopic())) {
            this.performRecovery();
        }
    }
}

