/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.management;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.management.DumpInspector;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDumpInspector
implements DumpInspector {
    private static final String OSGI_STATE_STRING = "OSGi-state";
    private static final long LARGE_FILE_SIZE_LIMIT = 1024000L;
    private final Logger logger = LoggerFactory.getLogger(FileSystemDumpInspector.class);
    private final DumpGenerator generator;
    private final ConfigurationProvider configurationProvider;

    public FileSystemDumpInspector(DumpGenerator generator, ConfigurationProvider configurationProvider) {
        this.generator = generator;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public String getConfiguredDumpDirectory() {
        return (String)this.configurationProvider.getConfiguration().get("dump.root.directory");
    }

    @Override
    public String[] getDumps() throws IOException {
        File dumpDir = this.getDumpDirectory();
        ArrayList<String> dumps = new ArrayList<String>();
        if (dumpDir != null && dumpDir.exists() && dumpDir.isDirectory()) {
            String[] list;
            String[] stringArray = list = FileSystemUtils.list((File)dumpDir, (Logger)this.logger);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String dumpFolderName = stringArray[n2];
                File dumpFolder = new File(dumpDir, dumpFolderName);
                if (dumpFolder.exists() && dumpFolder.isDirectory()) {
                    dumps.add(dumpFolderName);
                }
                ++n2;
            }
            return dumps.toArray(new String[dumps.size()]);
        }
        return new String[0];
    }

    @Override
    public String[][] getDumpEntries(String dumpId) throws IOException {
        if (dumpId == null) {
            return new String[0][];
        }
        File dumpDir = new File(this.getDumpDirectory(), dumpId);
        if (dumpDir != null && dumpDir.exists() && dumpDir.isDirectory()) {
            ArrayList<String> dumpItems = new ArrayList<String>(Arrays.asList(FileSystemUtils.list((File)dumpDir, (Logger)this.logger)));
            if (dumpItems.contains("osgi.zip") && dumpItems.contains("region.digraph")) {
                dumpItems.add(OSGI_STATE_STRING);
            }
            dumpItems.remove("osgi.zip");
            dumpItems.remove("region.digraph");
            String[][] result = new String[dumpItems.size()][];
            int i = 0;
            while (i < dumpItems.size()) {
                result[i] = OSGI_STATE_STRING.equals(dumpItems.get(i)) ? new String[]{(String)dumpItems.get(i), "StateDumpInspector/getSummary/" + this.getConfiguredDumpDirectory().replace("/", "!/") + "!/" + dumpId} : new String[]{(String)dumpItems.get(i), "DumpInspector/getDumpEntry/" + dumpId + "/" + (String)dumpItems.get(i)};
                ++i;
            }
            return result;
        }
        return new String[0][];
    }

    @Override
    public String[] getDumpEntry(String dumpId, String entryName) {
        File dumpEntry;
        if (dumpId == null || entryName == null) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>();
        File dumpDir = this.getDumpDirectory();
        if (dumpDir != null && dumpDir.exists() && dumpDir.isDirectory() && (dumpEntry = new File(dumpDir, String.valueOf(dumpId) + File.separatorChar + entryName)) != null) {
            RandomAccessFile reader = null;
            try {
                reader = new RandomAccessFile(dumpEntry, "r");
                while (reader.getFilePointer() < reader.length()) {
                    if (reader.getFilePointer() > 1024000L) {
                        lines.add("File exceeds 1MB, truncated.");
                        break;
                    }
                    String rawLine = reader.readLine();
                    if (rawLine == null) continue;
                    lines.add(this.escapeAngleBrackets(rawLine));
                }
                reader.close();
            }
            catch (IOException e) {
                this.logger.error("Error while reading dump file " + dumpEntry.getPath(), (Throwable)e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    @Override
    public void createDump() {
        this.generator.generateDump("Generated via JMX", new Throwable[0]);
    }

    @Override
    public void deleteDump(String dumpId) {
        File root;
        File dumpDir = this.getDumpDirectory();
        if (dumpDir != null && dumpDir.exists() && dumpDir.isDirectory() && (root = new File(dumpDir, dumpId)).exists() && root.isDirectory()) {
            FileSystemUtils.deleteRecursively((File)root);
        }
    }

    private File getDumpDirectory() {
        String dumpDirectory = (String)this.configurationProvider.getConfiguration().get("dump.root.directory");
        File dumpDir = new File(dumpDirectory);
        if (dumpDir.exists() && dumpDir.isDirectory()) {
            return dumpDir;
        }
        return null;
    }

    private String escapeAngleBrackets(String unfriendlyMarkup) {
        String processed = unfriendlyMarkup.replace("<", "&#60;");
        processed = processed.replace(">", "&#62;");
        return processed;
    }
}

