/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDetector
extends AbstractServerDetector {
    public static final String JBOSS_AS_MANAGEMENT_ROOT_SERVER = "jboss.as:management-root=server";
    public static final int LOGGING_DETECT_TIMEOUT = 300000;
    public static final int LOGGING_DETECT_INTERVAL = 200;

    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        ServerHandle handle = this.checkFromJSR77(pMBeanServerExecutor);
        if (handle == null) {
            handle = this.checkFor5viaJMX(pMBeanServerExecutor);
            if (handle == null) {
                handle = this.checkForManagementRootServerViaJMX(pMBeanServerExecutor);
            }
            if (handle == null) {
                handle = this.checkForWildflySwarm();
            }
            if (handle == null) {
                handle = this.fallbackForVersion7Check(pMBeanServerExecutor);
            }
        }
        return handle;
    }

    private ServerHandle checkForWildflySwarm() {
        if (this.isJBossModulesBasedContainer(this.getClass().getClassLoader()) && System.getProperties().containsKey("swarm.app.artifact")) {
            String version = System.getProperty("swarm.version");
            return new JBossServerHandle(version != null ? version : "unknown", "Wildfly Swarm", null);
        }
        return null;
    }

    @Override
    public void jvmAgentStartup(Instrumentation instrumentation) {
        this.jvmAgentStartup(instrumentation, this.getClass().getClassLoader());
    }

    void jvmAgentStartup(Instrumentation instrumentation, ClassLoader classLoader) {
        if (this.isJBossModulesBasedContainer(classLoader)) {
            this.awaitServerInitializationForJBossModulesBasedContainer(instrumentation);
        }
    }

    protected boolean isJBossModulesBasedContainer(ClassLoader classLoader) {
        return this.hasWildflyProperties() && classLoader.getResource("org/jboss/modules/Main.class") != null;
    }

    private boolean hasWildflyProperties() {
        if (System.getProperty("jboss.modules.system.pkgs") != null) {
            return true;
        }
        String bootModuleLoader = System.getProperty("boot.module.loader");
        if (bootModuleLoader != null) {
            return bootModuleLoader.contains("wildfly");
        }
        return false;
    }

    private void awaitServerInitializationForJBossModulesBasedContainer(Instrumentation instrumentation) {
        int count = 0;
        while (count * 200 < 300000) {
            String loggingManagerClassName = System.getProperty("java.util.logging.manager");
            if (loggingManagerClassName != null && this.isClassLoaded(loggingManagerClassName, instrumentation)) {
                return;
            }
            try {
                Thread.sleep(200L);
                ++count;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException(String.format("Detected JBoss Module loader, but property java.util.logging.manager is not set after %d seconds", 300));
    }

    private ServerHandle checkFromJSR77(MBeanServerExecutor pMBeanServerExecutor) {
        String version;
        if (ClassUtil.checkForClass("org.jboss.mx.util.MBeanServerLocator") && (version = this.getVersionFromJsr77(pMBeanServerExecutor)) != null) {
            int idx = version.indexOf(32);
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            return new JBossServerHandle(version, null);
        }
        return null;
    }

    private ServerHandle checkFor5viaJMX(MBeanServerExecutor pMBeanServerExecutor) {
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.system:type=Server")) {
            String versionFull = this.getAttributeValue(pMBeanServerExecutor, "jboss.system:type=Server", "Version");
            String version = null;
            if (versionFull != null) {
                version = versionFull.replaceAll("\\(.*", "").trim();
            }
            return new JBossServerHandle(version, null);
        }
        return null;
    }

    private ServerHandle checkForManagementRootServerViaJMX(MBeanServerExecutor pMBeanServerExecutor) {
        if (this.searchMBeans(pMBeanServerExecutor, "jboss.as:*").size() != 0) {
            String version = this.getAttributeValue(pMBeanServerExecutor, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "productVersion");
            if (version == null) {
                version = this.getAttributeValue(pMBeanServerExecutor, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "releaseVersion");
            }
            if (version != null) {
                String product = this.getAttributeValue(pMBeanServerExecutor, JBOSS_AS_MANAGEMENT_ROOT_SERVER, "productName");
                return new JBossServerHandle(version, product != null ? product : "jboss", null);
            }
        }
        return null;
    }

    private ServerHandle fallbackForVersion7Check(MBeanServerExecutor pMBeanServerExecutor) {
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.modules:*")) {
            return new JBossServerHandle("7", null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> servers) {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            servers.add((MBeanServer)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossServerHandle
    extends ServerHandle {
        JBossServerHandle(String version, String name, Map<String, String> extraInfo) {
            super("RedHat", name, version, extraInfo);
        }

        JBossServerHandle(String version, Map<String, String> extraInfo) {
            this(version, "jboss", extraInfo);
        }
    }
}

