/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import javax.servlet.ServletException;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.internal.SnapException;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.container.FilterChainFactory;
import org.eclipse.virgo.snaps.core.internal.webapp.container.FilterManager;
import org.eclipse.virgo.snaps.core.internal.webapp.container.ServletManager;
import org.eclipse.virgo.snaps.core.internal.webapp.container.StandardVirtualContainerRequestDispatcher;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainer;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainerRequestDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardVirtualContainer
implements VirtualContainer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;
    private final ServletManager servletManager;
    private final FilterManager filterManager;
    private final SnapServletContext snapServletContext;
    private final FilterChainFactory filterChainFactory;
    private final RequestRouter requestRouter;

    public StandardVirtualContainer(WebXml webXml, SnapServletContext servletContext, ClassLoader snapClassLoader, RequestRouter requestRouter) throws SnapException {
        this.classLoader = snapClassLoader;
        this.servletManager = new ServletManager(webXml, servletContext, snapClassLoader);
        this.filterManager = new FilterManager(webXml, servletContext, snapClassLoader);
        this.filterChainFactory = new FilterChainFactory(this.filterManager);
        this.snapServletContext = servletContext;
        this.requestRouter = requestRouter;
    }

    @Override
    public VirtualContainerRequestDispatcher createDispatcher() {
        return new StandardVirtualContainerRequestDispatcher(this.servletManager, this.classLoader, this, this.filterChainFactory, this.requestRouter);
    }

    @Override
    public void destroy() {
        this.servletManager.destroy();
        this.filterManager.destroy();
        this.logger.info("Virtual container destroyed");
    }

    @Override
    public void init() throws ServletException {
        this.servletManager.init();
        this.filterManager.init();
        this.logger.info("Virtual container initialized");
    }

    @Override
    public SnapServletContext getSnapServletContext() {
        return this.snapServletContext;
    }

    @Override
    public void addHost(SnapServletContext servletContext) {
        this.servletManager.addSnapServletContext(servletContext);
        this.filterManager.addSnapServletContext(servletContext);
    }
}

