/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.util.common.GraphNode;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardInstallArtifactGraphInclosure
implements InstallArtifactGraphInclosure {
    private final Logger logger;
    private final EventLogger eventLogger;
    private final BundleContext bundleContext;
    private final ArtifactStorageFactory artifactStorageFactory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public StandardInstallArtifactGraphInclosure(@NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull BundleContext bundleContext, @NonNull EventLogger eventLogger) {
        EventLogger eventLogger2 = eventLogger;
        BundleContext bundleContext2 = bundleContext;
        ArtifactStorageFactory artifactStorageFactory2 = artifactStorageFactory;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactStorageFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)eventLogger2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.artifactStorageFactory = artifactStorageFactory;
            this.eventLogger = eventLogger;
            this.bundleContext = bundleContext;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public GraphNode<InstallArtifact> constructGraphNode(ArtifactIdentity identity, File artifact, Map<String, String> properties, String repositoryName) throws DeploymentException {
        try {
            try {
                GraphNode<InstallArtifact> graphNode;
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                if (!artifact.exists()) {
                    throw new DeploymentException(artifact + " does not exist");
                }
                ArtifactIdentity scopedIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(identity);
                ArtifactStorage artifactStorage = this.artifactStorageFactory.create(artifact, scopedIdentity);
                try {
                    graphNode = this.constructInstallArtifactGraph(scopedIdentity, properties, artifactStorage, repositoryName);
                }
                catch (DeploymentException e) {
                    artifactStorage.delete();
                    throw e;
                }
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return graphNode;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> constructInstallArtifactGraph(ArtifactIdentity identity, Map<String, String> deploymentProperties, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        try {
            try {
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                GraphNode<InstallArtifact> graph = null;
                List iatfHolders = OsgiFrameworkUtils.getServices((BundleContext)this.bundleContext, InstallArtifactGraphFactory.class);
                for (OsgiServiceHolder iatfHolder : iatfHolders) {
                    InstallArtifactGraphFactory iatf = (InstallArtifactGraphFactory)iatfHolder.getService();
                    try {
                        if (iatf == null || (graph = iatf.constructInstallArtifactGraph(identity, artifactStorage, deploymentProperties, repositoryName)) == null) continue;
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(iatfHolder.getServiceReference());
                    }
                }
                if (graph == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.MISSING_ARTIFACT_FACTORY, new Object[]{identity.getType(), identity.getName(), identity.getVersion()});
                    throw new DeploymentException("Cannot create InstallArtifact for '" + identity + "'");
                }
                GraphNode<InstallArtifact> graphNode = graph;
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return graphNode;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public GraphNode<InstallArtifact> recoverInstallGraph(ArtifactIdentity artifactIdentity, File artifact) {
        try {
            try {
                GraphNode<InstallArtifact> graphNode;
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                ArtifactStorage artifactStorage = null;
                try {
                    GraphNode<InstallArtifact> installArtifactGraph;
                    artifactStorage = this.artifactStorageFactory.create(artifact, artifactIdentity);
                    graphNode = installArtifactGraph = this.constructInstallArtifactGraph(artifactIdentity, null, artifactStorage, null);
                }
                catch (RuntimeException e) {
                    if (artifactStorage != null) {
                        artifactStorage.delete();
                    }
                    this.logger.error(String.format("An error occurred during recovery of artefact '%s'", artifact), (Throwable)e);
                    throw e;
                }
                catch (DeploymentException e) {
                    if (artifactStorage != null) {
                        artifactStorage.delete();
                    }
                    this.logger.warn(String.format("An error occurred during recovery of artefact '%s'", artifact), (Throwable)e);
                    graphNode = null;
                }
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return graphNode;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactGraphInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("StandardInstallArtifactGraphInclosure.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactGraphInclosure"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "constructGraphNode", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactGraphInclosure", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:java.io.File:java.util.Map:java.lang.String:", "identity:artifact:properties:repositoryName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 65);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "constructInstallArtifactGraph", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactGraphInclosure", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:java.util.Map:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:java.lang.String:", "identity:deploymentProperties:artifactStorage:repositoryName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 80);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "recoverInstallGraph", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactGraphInclosure", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:java.io.File:", "artifactIdentity:artifact:", "", "org.eclipse.virgo.util.common.GraphNode"), 111);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactGraphInclosure");
    }
}

