/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class AbstractNewParProjectWizard
extends BasicNewResourceWizard {
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;

    protected IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, ResourceMessages.NewProject_windowTitle);
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)AbstractNewParProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus((int)2, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()), (Throwable)cause)) : new StatusAdapter(StatusUtil.newStatus((int)cause.getStatus().getSeverity(), (String)ResourceMessages.NewProject_errorMessage, (Throwable)cause));
                status.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.ui.ide", 0, NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()), t));
                status.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 5);
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    protected WizardNewProjectCreationPage getMainPage() {
        return this.mainPage;
    }

    protected IProject getNewProject() {
        return this.newProject;
    }

    protected void setMainPage(WizardNewProjectCreationPage page) {
        this.mainPage = page;
    }
}

