/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ActivationBreakpoint;
import org.eclipse.viatra.transformation.debug.model.transformationstate.RuleActivation;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.util.ViatraDebuggerUtil;

public class ToggleActivationBreakpointHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            RuleActivation act;
            TransformationThread thread;
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof RuleActivation && (thread = ViatraDebuggerUtil.getThread((TransformationState)(act = (RuleActivation)((IStructuredSelection)selection).getFirstElement()).getTransformationState())) != null) {
                ActivationBreakpoint transformationBreakpoint = new ActivationBreakpoint(((RuleActivation)((IStructuredSelection)selection).getFirstElement()).getTrace());
                transformationBreakpoint.setMarker(thread.getTransformationType().getResource().createMarker(transformationBreakpoint.getMarkerIdentifier()));
                transformationBreakpoint.setEnabled(true);
                ActivationBreakpoint breakpointToRemove = null;
                IBreakpoint[] iBreakpointArray = thread.getBreakpoints();
                int n = iBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint iBreakpoint = iBreakpointArray[n2];
                    if (iBreakpoint.equals(transformationBreakpoint)) {
                        breakpointToRemove = transformationBreakpoint;
                    }
                    ++n2;
                }
                if (breakpointToRemove != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpointToRemove, true);
                } else {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)transformationBreakpoint);
                }
            }
        }
        catch (CoreException e) {
            throw new ExecutionException("Error while toggling breakpoint", (Throwable)e);
        }
        return null;
    }
}

