/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public abstract class AbstractColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends SingleInputNode
implements Clearable,
IAggregatorNode {
    protected final IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator;
    protected final TupleMask groupMask;
    protected final TupleMask columnMask;
    protected final int sourceWidth;
    protected final IQueryRuntimeContext runtimeContext;
    protected final AggregateResult NEUTRAL;
    protected AggregatorOuterIndexer aggregatorOuterIndexer;
    protected AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers;

    public AbstractColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer);
        this.operator = operator;
        this.groupMask = groupMask;
        this.columnMask = columnMask;
        this.sourceWidth = groupMask.indices.length;
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
        this.NEUTRAL = operator.getAggregate(operator.createNeutral());
        reteContainer.registerClearable(this);
    }

    public AbstractColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, int aggregatedColumn) {
        this(reteContainer, operator, groupMask, TupleMask.selectSingle((int)aggregatedColumn, (int)groupMask.sourceWidth));
    }

    @Override
    public CommunicationTracker getCommunicationTracker() {
        return this.reteContainer.getCommunicationTracker();
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendChild(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
            this.getCommunicationTracker().registerDependency(this, this.aggregatorOuterIndexer);
        }
        return this.aggregatorOuterIndexer;
    }

    @Override
    public Indexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.sourceWidth + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
            this.getCommunicationTracker().registerDependency(this, this.aggregatorOuterIdentityIndexers[resultPositionInSignature]);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    public void propagateAggregateResultUpdate(Tuple group, AggregateResult oldValue, AggregateResult newValue, Timestamp timestamp) {
        if (!Objects.equals(oldValue, newValue)) {
            this.propagate(Direction.DELETE, group, oldValue, timestamp);
            this.propagate(Direction.INSERT, group, newValue, timestamp);
        }
    }

    public void propagate(Direction direction, Tuple group, AggregateResult value, Timestamp timestamp) {
        Tuple tuple = this.tupleFromAggregateResult(group, value);
        if (this.aggregatorOuterIndexer != null) {
            this.aggregatorOuterIndexer.propagate(direction, tuple, group, timestamp);
        }
        if (this.aggregatorOuterIdentityIndexers != null) {
            AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
            int n = this.aggregatorOuterIdentityIndexers.length;
            int n2 = 0;
            while (n2 < n) {
                AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                if (aggregatorOuterIdentityIndexer != null) {
                    aggregatorOuterIdentityIndexer.propagate(direction, tuple, group, timestamp);
                }
                ++n2;
            }
        }
    }

    public abstract Tuple getAggregateTuple(Tuple var1);

    public abstract Map<Tuple, Timeline<Timestamp>> getAggregateTupleTimeline(Tuple var1);

    public abstract AggregateResult getAggregateResult(Tuple var1);

    public abstract Map<AggregateResult, Timeline<Timestamp>> getAggregateResultTimeline(Tuple var1);

    protected Tuple tupleFromAggregateResult(Tuple groupTuple, AggregateResult aggregateResult) {
        if (aggregateResult == null) {
            return null;
        }
        return Tuples.staticArityLeftInheritanceTupleOf((Tuple)groupTuple, (Object)this.runtimeContext.wrapElement(aggregateResult));
    }

    protected class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        protected final int resultPositionInSignature;
        protected final TupleMask pruneResult;
        protected final TupleMask reorderMask;
        protected NetworkStructureChangeSensitiveLogic logic;
        private final NetworkStructureChangeSensitiveLogic TIMELESS;
        private final NetworkStructureChangeSensitiveLogic TIMELY;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(AbstractColumnAggregatorNode.this.reteContainer, TupleMask.displace((int)AbstractColumnAggregatorNode.this.sourceWidth, (int)resultPositionInSignature, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1)));
            this.TIMELESS = new NetworkStructureChangeSensitiveLogic(){

                @Override
                public Collection<Tuple> get(Tuple signatureWithResult) {
                    Tuple prunedSignature = AggregatorOuterIdentityIndexer.this.pruneResult.transform((ITuple)signatureWithResult);
                    Object result = AbstractColumnAggregatorNode.this.getAggregateResult(prunedSignature);
                    if (result != null && Objects.equals(signatureWithResult.get(AggregatorOuterIdentityIndexer.this.resultPositionInSignature), result)) {
                        return Collections.singleton(signatureWithResult);
                    }
                    return null;
                }

                @Override
                public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature) {
                    throw new UnsupportedOperationException();
                }
            };
            this.TIMELY = new NetworkStructureChangeSensitiveLogic(){

                @Override
                public Collection<Tuple> get(Tuple signatureWithResult) {
                    return AggregatorOuterIdentityIndexer.this.TIMELESS.get(signatureWithResult);
                }

                @Override
                public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signatureWithResult) {
                    Tuple prunedSignature = AggregatorOuterIdentityIndexer.this.pruneResult.transform((ITuple)signatureWithResult);
                    Map result = AbstractColumnAggregatorNode.this.getAggregateResultTimeline(prunedSignature);
                    for (Map.Entry entry : result.entrySet()) {
                        if (!Objects.equals(signatureWithResult.get(AggregatorOuterIdentityIndexer.this.resultPositionInSignature), entry.getKey())) continue;
                        return Collections.singletonMap(signatureWithResult, entry.getValue());
                    }
                    return null;
                }
            };
            this.resultPositionInSignature = resultPositionInSignature;
            this.pruneResult = TupleMask.omit((int)resultPositionInSignature, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1));
            this.reorderMask = resultPositionInSignature == AbstractColumnAggregatorNode.this.sourceWidth ? null : this.mask;
            this.logic = this.createLogic();
        }

        @Override
        public void networkStructureChanged() {
            super.networkStructureChanged();
            this.logic = this.createLogic();
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            return this.logic.get(signatureWithResult);
        }

        @Override
        public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature) {
            return this.logic.getTimeline(signature);
        }

        public void propagate(Direction direction, Tuple tuple, Tuple group, Timestamp timestamp) {
            if (tuple != null) {
                this.propagate(direction, this.reorder(tuple), group, true, timestamp);
            }
        }

        private Tuple reorder(Tuple signatureWithResult) {
            Tuple transformed = this.reorderMask == null ? signatureWithResult : this.reorderMask.transform((ITuple)signatureWithResult);
            return transformed;
        }

        @Override
        public Node getActiveNode() {
            return this.parent;
        }

        protected NetworkStructureChangeSensitiveLogic createLogic() {
            if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
                return this.TIMELY;
            }
            return this.TIMELESS;
        }
    }

    protected class AggregatorOuterIndexer
    extends StandardIndexer {
        protected NetworkStructureChangeSensitiveLogic logic;
        private final NetworkStructureChangeSensitiveLogic TIMELESS;
        private final NetworkStructureChangeSensitiveLogic TIMELY;

        public AggregatorOuterIndexer() {
            super(AbstractColumnAggregatorNode.this.reteContainer, TupleMask.omit((int)AbstractColumnAggregatorNode.this.sourceWidth, (int)(AbstractColumnAggregatorNode.this.sourceWidth + 1)));
            this.TIMELESS = new NetworkStructureChangeSensitiveLogic(){

                @Override
                public Collection<Tuple> get(Tuple signature) {
                    Tuple aggregateTuple = AbstractColumnAggregatorNode.this.getAggregateTuple(signature);
                    if (aggregateTuple == null) {
                        return null;
                    }
                    return Collections.singleton(aggregateTuple);
                }

                @Override
                public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature) {
                    throw new UnsupportedOperationException();
                }
            };
            this.TIMELY = new NetworkStructureChangeSensitiveLogic(){

                @Override
                public Collection<Tuple> get(Tuple signatureWithResult) {
                    return AggregatorOuterIndexer.this.TIMELESS.get(signatureWithResult);
                }

                @Override
                public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature) {
                    Map<Tuple, Timeline<Timestamp>> aggregateTuples = AbstractColumnAggregatorNode.this.getAggregateTupleTimeline(signature);
                    if (aggregateTuples.isEmpty()) {
                        return null;
                    }
                    return aggregateTuples;
                }
            };
            this.parent = AbstractColumnAggregatorNode.this;
            this.logic = this.createLogic();
        }

        @Override
        public void networkStructureChanged() {
            super.networkStructureChanged();
            this.logic = this.createLogic();
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            return this.logic.get(signature);
        }

        @Override
        public Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature) {
            return this.logic.getTimeline(signature);
        }

        public void propagate(Direction direction, Tuple tuple, Tuple group, Timestamp timestamp) {
            if (tuple != null) {
                this.propagate(direction, tuple, group, true, timestamp);
            }
        }

        @Override
        public Node getActiveNode() {
            return AbstractColumnAggregatorNode.this;
        }

        protected NetworkStructureChangeSensitiveLogic createLogic() {
            if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
                return this.TIMELY;
            }
            return this.TIMELESS;
        }
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract Collection<Tuple> get(Tuple var1);

        public abstract Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple var1);
    }
}

