/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public final class TimelyDefaultMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyMaskedMemory<Timestamp, Tuple> {
    public TimelyDefaultMaskedTupleMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner, isLazy);
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.memoryMap.keySet();
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Tuple key = this.mask.transform(tuple);
        return this.removeInternal(key, tuple, timestamp);
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Tuple key = this.mask.transform(tuple);
        return this.addInternal(key, tuple, timestamp);
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        return this.getInternal(signature.toImmutable());
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple signature) {
        return this.getWithTimestampInternal(signature.toImmutable());
    }

    @Override
    public boolean isPresentAtInfinity(ITuple signature) {
        return this.isPresentAtInfinityInteral(signature.toImmutable());
    }

    public Set<Tuple> getResumableSignatures() {
        if (this.foldingStates == null || this.foldingStates.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)this.foldingStates.firstEntry().getValue();
    }

    @Override
    public Map<Tuple, Map<Tuple, Diff<Timestamp>>> resumeAt(Timestamp timestamp) {
        Map<Tuple, Map<Tuple, Diff<Timestamp>>> result = CollectionsFactory.createMap();
        Comparable resumableTimestamp = this.getResumableTimestamp();
        if (resumableTimestamp == null || resumableTimestamp.compareTo(timestamp) != 0) {
            throw new IllegalStateException("Expected to continue folding at " + resumableTimestamp + "!");
        }
        Set signatures = (Set)this.foldingStates.remove(timestamp);
        for (Tuple signature : signatures) {
            TimelyMemory memory = (TimelyMemory)this.memoryMap.get(signature);
            Map<Tuple, Diff<Comparable>> diffMap = memory.resumeAt(resumableTimestamp);
            result.put(signature, diffMap);
            this.registerFoldingState(memory.getResumableTimestamp(), signature);
        }
        return result;
    }
}

