/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

abstract class AbstractTimelyTrivialMaskedMemory<Timestamp extends Comparable<Timestamp>>
extends MaskedTupleMemory<Timestamp> {
    protected final TimelyMemory<Timestamp> memory;

    protected AbstractTimelyTrivialMaskedMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner);
        this.memory = new TimelyMemory(isLazy);
    }

    @Override
    public void initializeWith(MaskedTupleMemory<Timestamp> other, Timestamp defaultValue) {
        Iterable<Tuple> signatures = other.getSignatures();
        for (Tuple signature : signatures) {
            if (other.isTimely()) {
                Map<Tuple, Timeline<Timestamp>> tupleMap = other.getWithTimeline(signature);
                for (Map.Entry entry : tupleMap.entrySet()) {
                    for (Signed signed : ((Timeline)entry.getValue()).asChangeSequence()) {
                        if (signed.getDirection() == Direction.DELETE) {
                            this.removeWithTimestamp((Tuple)entry.getKey(), signed.getPayload());
                            continue;
                        }
                        this.addWithTimestamp((Tuple)entry.getKey(), signed.getPayload());
                    }
                }
                continue;
            }
            Collection<Tuple> tuples = other.get(signature);
            for (Tuple tuple : tuples) {
                this.removeWithTimestamp(tuple, defaultValue);
            }
        }
    }

    @Override
    public void clear() {
        this.memory.clear();
    }

    @Override
    public int getTotalSize() {
        return this.memory.size();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.memory.keySet().iterator();
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.removeWithTimestamp(tuple, null, timestamp);
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.addWithTimestamp(tuple, null, timestamp);
    }

    @Override
    public boolean isTimely() {
        return true;
    }

    @Override
    public Timestamp getResumableTimestamp() {
        return this.memory.getResumableTimestamp();
    }
}

