/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class GenericTypeExtend
implements IIteratingSearchOperation {
    private final IInputKey type;
    private final int[] positions;
    private final List<Integer> positionList;
    private final Set<Integer> unboundVariableIndices;
    private final TupleMask indexerMask;
    private final TupleMask callMask;

    public GenericTypeExtend(IInputKey type, int[] positions, TupleMask callMask, TupleMask indexerMask, Set<Integer> unboundVariableIndices) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %d parameters, but %d positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        ArrayList<Integer> modifiablePositionList = new ArrayList<Integer>();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            modifiablePositionList.add(position);
            ++n2;
        }
        this.positionList = Collections.unmodifiableList(modifiablePositionList);
        this.positions = positions;
        this.type = type;
        this.unboundVariableIndices = unboundVariableIndices;
        this.indexerMask = indexerMask;
        this.callMask = callMask;
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.positionList;
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.type.getPrettyPrintableName() + "(" + this.positionList.stream().map(input -> String.format("%s%s", this.unboundVariableIndices.contains(input) ? "-" : "+", variableMapping.apply((Integer)input))).collect(Collectors.joining(", ")) + ")";
    }

    private class Executor
    extends ExtendOperationExecutor<Tuple> {
        private final VolatileMaskedTuple maskedTuple;

        public Executor() {
            this.maskedTuple = new VolatileMaskedTuple(GenericTypeExtend.this.callMask);
        }

        @Override
        protected Iterator<? extends Tuple> getIterator(MatchingFrame frame, ISearchContext context) {
            this.maskedTuple.updateTuple((ITuple)frame);
            return context.getRuntimeContext().enumerateTuples(GenericTypeExtend.this.type, GenericTypeExtend.this.indexerMask, (ITuple)this.maskedTuple).iterator();
        }

        @Override
        protected boolean fillInValue(Tuple newTuple, MatchingFrame frame, ISearchContext context) {
            for (Integer position : GenericTypeExtend.this.unboundVariableIndices) {
                frame.setValue(position, null);
            }
            int i = 0;
            while (i < GenericTypeExtend.this.positions.length) {
                Object newValue = newTuple.get(i);
                Object oldValue = frame.getValue(GenericTypeExtend.this.positions[i]);
                if (oldValue != null && !Objects.equals(oldValue, newValue)) {
                    return false;
                }
                frame.setValue(GenericTypeExtend.this.positions[i], newValue);
                ++i;
            }
            return true;
        }

        @Override
        protected void cleanup(MatchingFrame frame, ISearchContext context) {
            for (Integer position : GenericTypeExtend.this.unboundVariableIndices) {
                frame.setValue(position, null);
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return GenericTypeExtend.this;
        }
    }
}

