/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;

public class SelectionHelper {
    private final Set<ISelectionChangedListener> selectionChangedListeners = Sets.newHashSet();
    private final ISelectionChangedListener trickyListener = event -> {
        for (ISelectionChangedListener l : this.selectionChangedListeners) {
            l.selectionChanged(new SelectionChangedEvent(event.getSelectionProvider(), this.unwrapElements_ViewersElementsToEObjects(event.getSelection())));
        }
    };

    public Iterable<ISelectionChangedListener> getSelectionChangedListeners() {
        return this.selectionChangedListeners;
    }

    public boolean addSelectionChangedListener(ISelectionChangedListener listener) {
        return this.selectionChangedListeners.add(listener);
    }

    public boolean removeSelectionChangedListener(ISelectionChangedListener listener) {
        return this.selectionChangedListeners.remove(listener);
    }

    public ISelectionChangedListener getTrickyListener() {
        return this.trickyListener;
    }

    private Object getSourceObject(Item i) {
        if (i.getParamEObject() != null) {
            return i.getParamEObject();
        }
        if (i.getParamObject() != null) {
            return i.getParamObject();
        }
        throw new IllegalStateException("Invalid Item selected - no source model element available.");
    }

    public ISelection unwrapElements_ViewersElementsToEObjects(ISelection sel) {
        ArrayList proxy = Lists.newArrayList();
        if (sel instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (e instanceof Item) {
                    proxy.add(this.getSourceObject((Item)e));
                } else if (e instanceof Edge) {
                    proxy.add(this.getSourceObject(((Edge)e).getSource()));
                    proxy.add(this.getSourceObject(((Edge)e).getTarget()));
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)proxy);
    }

    public ISelection unwrapElements_EObjectsToViewersElements(ISelection sel, ViewerState state) {
        ArrayList proxy = Lists.newArrayList();
        if (state != null && sel instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (e instanceof EObject) {
                    proxy.addAll(state.getItemsFor(e));
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)proxy);
    }
}

