/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.emf;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.base.api.DataTypeListener;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFQueryMetaContext;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassUnscopedTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.AbstractQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class EMFQueryRuntimeContext
extends AbstractQueryRuntimeContext {
    protected final NavigationHelper baseIndex;
    protected final Map<EClass, EnumSet<IndexingService>> indexedClasses = Maps.newHashMap();
    protected final Map<EDataType, EnumSet<IndexingService>> indexedDataTypes = Maps.newHashMap();
    protected final Map<EStructuralFeature, EnumSet<IndexingService>> indexedFeatures = Maps.newHashMap();
    protected final EMFQueryMetaContext metaContext;
    protected Logger logger;
    private EMFScope emfScope;
    private static Function<Object, Tuple> wrapUnary = new Function<Object, Tuple>(){

        public Tuple apply(Object obj) {
            return Tuples.staticArityFlatTupleOf((Object)obj);
        }
    };

    public EMFQueryRuntimeContext(NavigationHelper baseIndex, Logger logger, EMFScope emfScope) {
        this.baseIndex = baseIndex;
        this.logger = logger;
        this.metaContext = new EMFQueryMetaContext(emfScope);
        this.emfScope = emfScope;
    }

    public EMFScope getEmfScope() {
        return this.emfScope;
    }

    private static <K> boolean addIndexingService(Map<K, EnumSet<IndexingService>> map, K key, IndexingService service) {
        EnumSet<IndexingService> current = map.get(key);
        if (current == null) {
            current = EnumSet.of(service);
            map.put(key, current);
            return true;
        }
        return current.add(service);
    }

    public void dispose() {
        this.indexedFeatures.clear();
        this.indexedClasses.clear();
        this.indexedDataTypes.clear();
    }

    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        return (V)this.baseIndex.coalesceTraversals(callable);
    }

    public boolean isCoalescing() {
        return this.baseIndex.isCoalescing();
    }

    public IQueryMetaContext getMetaContext() {
        return this.metaContext;
    }

    public void ensureIndexed(IInputKey key, IndexingService service) {
        this.ensureEnumerableKey(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.ensureIndexed(eClass, service);
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.ensureIndexed(dataType, service);
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.ensureIndexed(feature, service);
        } else {
            this.illegalInputKey(key);
        }
    }

    public void ensureIndexed(IInputKey key) {
        this.ensureIndexed(key, IndexingService.INSTANCES);
    }

    protected EnumSet<IndexingService> getCurrentIndexingServiceFor(IInputKey key) {
        this.ensureValidKey(key);
        if (!key.isEnumerable()) {
            return EnumSet.noneOf(IndexingService.class);
        }
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedClasses.get(eClass);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedDataTypes.get(dataType);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            EnumSet<IndexingService> is = this.indexedFeatures.get(feature);
            return is == null ? EnumSet.noneOf(IndexingService.class) : is;
        }
        this.illegalInputKey(key);
        return EnumSet.noneOf(IndexingService.class);
    }

    public boolean isIndexed(IInputKey key, IndexingService service) {
        return this.getCurrentIndexingServiceFor(key).contains(service);
    }

    public boolean isIndexed(IInputKey key) {
        return this.isIndexed(key, IndexingService.INSTANCES);
    }

    public boolean containsTuple(IInputKey key, Tuple seed) {
        this.ensureValidKey(key);
        if (key instanceof JavaTransitiveInstancesKey) {
            Class<?> instanceClass = this.forceGetWrapperInstanceClass((JavaTransitiveInstancesKey)key);
            if (instanceClass != null) {
                return instanceClass.isInstance(this.getFromSeed(seed, 0));
            }
            return false;
        }
        if (key instanceof EClassUnscopedTransitiveInstancesKey) {
            EClass emfKey = (EClass)((EClassUnscopedTransitiveInstancesKey)key).getEmfKey();
            Object candidateInstance = this.getFromSeed(seed, 0);
            if (candidateInstance instanceof EObject) {
                return this.baseIndex.isInstanceOfUnscoped((EObject)candidateInstance, emfKey);
            }
            return false;
        }
        this.ensureIndexed(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            return this.baseIndex.getAllInstances(eClass).contains(this.getFromSeed(seed, 0));
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            return this.baseIndex.getDataTypeInstances(dataType).contains(this.getFromSeed(seed, 0));
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            return this.baseIndex.findByFeatureValue(this.getFromSeed(seed, 1), feature).contains(this.getFromSeed(seed, 0));
        }
        this.illegalInputKey(key);
        return false;
    }

    private Class<?> forceGetWrapperInstanceClass(JavaTransitiveInstancesKey key) {
        Class instanceClass;
        try {
            instanceClass = key.forceGetWrapperInstanceClass();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("Could not load instance class for type constraint " + (String)key.getWrappedKey()), (Throwable)e);
            instanceClass = null;
        }
        return instanceClass;
    }

    public Iterable<Tuple> enumerateTuples(IInputKey key, Tuple seed) {
        this.ensureIndexed(key);
        final HashSet<Tuple> result = new HashSet<Tuple>();
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return Iterables.transform((Iterable)this.baseIndex.getAllInstances(eClass), wrapUnary);
            }
            if (this.containsTuple(key, seed)) {
                result.add(Tuples.staticArityFlatTupleOf((Object)seedInstance));
            }
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return Iterables.transform((Iterable)this.baseIndex.getDataTypeInstances(dataType), wrapUnary);
            }
            if (this.containsTuple(key, seed)) {
                result.add(Tuples.staticArityFlatTupleOf((Object)seedInstance));
            }
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            final Object seedSource = this.getFromSeed(seed, 0);
            final Object seedTarget = this.getFromSeed(seed, 1);
            if (seedSource == null && seedTarget != null) {
                Set results = this.baseIndex.findByFeatureValue(seedTarget, feature);
                return Iterables.transform((Iterable)results, (Function)new Function<Object, Tuple>(){

                    public Tuple apply(Object obj) {
                        return Tuples.staticArityFlatTupleOf((Object)obj, (Object)seedTarget);
                    }
                });
            }
            if (seedSource != null && seedTarget != null) {
                if (this.containsTuple(key, seed)) {
                    result.add(Tuples.staticArityFlatTupleOf((Object)seedSource, (Object)seedTarget));
                }
            } else if (seedSource == null && seedTarget == null) {
                this.baseIndex.processAllFeatureInstances(feature, new IEStructuralFeatureProcessor(){

                    public void process(EStructuralFeature feature, EObject source, Object target) {
                        result.add(Tuples.staticArityFlatTupleOf((Object)source, (Object)target));
                    }
                });
            } else if (seedSource != null && seedTarget == null) {
                Set results = this.baseIndex.getFeatureTargets((EObject)seedSource, feature);
                return Iterables.transform((Iterable)results, (Function)new Function<Object, Tuple>(){

                    public Tuple apply(Object obj) {
                        return Tuples.staticArityFlatTupleOf((Object)seedSource, (Object)obj);
                    }
                });
            }
        } else {
            this.illegalInputKey(key);
        }
        return result;
    }

    public Iterable<? extends Object> enumerateValues(IInputKey key, Tuple seed) {
        this.ensureIndexed(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return this.baseIndex.getAllInstances(eClass);
            }
            this.illegalEnumerateValues(seed);
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return this.baseIndex.getDataTypeInstances(dataType);
            }
            this.illegalEnumerateValues(seed);
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            Object seedSource = this.getFromSeed(seed, 0);
            Object seedTarget = this.getFromSeed(seed, 1);
            if (seedSource == null && seedTarget != null) {
                return this.baseIndex.findByFeatureValue(seedTarget, feature);
            }
            if (seedSource != null && seedTarget == null) {
                return this.baseIndex.getFeatureTargets((EObject)seedSource, feature);
            }
            this.illegalEnumerateValues(seed);
        } else {
            this.illegalInputKey(key);
        }
        return null;
    }

    public int countTuples(IInputKey key, Tuple seed) {
        this.ensureIndexed(key, IndexingService.STATISTICS);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return this.baseIndex.countAllInstances(eClass);
            }
            return this.containsTuple(key, seed) ? 1 : 0;
        }
        if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            Object seedInstance = this.getFromSeed(seed, 0);
            if (seedInstance == null) {
                return this.baseIndex.countDataTypeInstances(dataType);
            }
            return this.containsTuple(key, seed) ? 1 : 0;
        }
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            Object seedSource = this.getFromSeed(seed, 0);
            Object seedTarget = this.getFromSeed(seed, 1);
            if (seedSource == null && seedTarget != null) {
                return this.baseIndex.findByFeatureValue(seedTarget, feature).size();
            }
            if (seedSource != null && seedTarget != null) {
                return this.containsTuple(key, seed) ? 1 : 0;
            }
            if (seedSource == null && seedTarget == null) {
                return this.baseIndex.countFeatures(feature);
            }
            if (seedSource != null && seedTarget == null) {
                return this.baseIndex.countFeatureTargets((EObject)seedSource, feature);
            }
        } else {
            this.illegalInputKey(key);
        }
        return 0;
    }

    public void ensureEnumerableKey(IInputKey key) {
        this.ensureValidKey(key);
        if (!this.metaContext.isEnumerable(key)) {
            throw new IllegalArgumentException("Key is not enumerable: " + key);
        }
    }

    public void ensureValidKey(IInputKey key) {
        this.metaContext.ensureValidKey(key);
    }

    public void illegalInputKey(IInputKey key) {
        this.metaContext.illegalInputKey(key);
    }

    public void illegalEnumerateValues(Tuple seed) {
        throw new IllegalArgumentException("Must have exactly one unseeded element in enumerateValues() invocation, received instead: " + seed);
    }

    @Deprecated
    public void ensureIndexed(EClass eClass) {
        this.ensureIndexed(eClass, IndexingService.INSTANCES);
    }

    public void ensureIndexed(EClass eClass, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedClasses, eClass, service)) {
            Set<EClass> newClasses = Collections.singleton(eClass);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(eClass).providesLevel(level)) {
                this.baseIndex.registerEClasses(newClasses, level);
            }
        }
    }

    @Deprecated
    public void ensureIndexed(EDataType eDataType) {
        this.ensureIndexed(eDataType, IndexingService.INSTANCES);
    }

    public void ensureIndexed(EDataType eDataType, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedDataTypes, eDataType, service)) {
            Set<EDataType> newDataTypes = Collections.singleton(eDataType);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(eDataType).providesLevel(level)) {
                this.baseIndex.registerEDataTypes(newDataTypes, level);
            }
        }
    }

    @Deprecated
    public void ensureIndexed(EStructuralFeature feature) {
        this.ensureIndexed(feature, IndexingService.INSTANCES);
    }

    public void ensureIndexed(EStructuralFeature feature, IndexingService service) {
        if (EMFQueryRuntimeContext.addIndexingService(this.indexedFeatures, feature, service)) {
            Set<EStructuralFeature> newFeatures = Collections.singleton(feature);
            IndexingLevel level = IndexingLevel.toLevel((IndexingService)service);
            if (!this.baseIndex.getIndexingLevel(feature).providesLevel(level)) {
                this.baseIndex.registerEStructuralFeatures(newFeatures, level);
            }
        }
    }

    public void addUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        if (key instanceof JavaTransitiveInstancesKey) {
            return;
        }
        this.ensureIndexed(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.baseIndex.addInstanceListener(Collections.singleton(eClass), (InstanceListener)new EClassTransitiveInstancesAdapter(listener, seed.get(0)));
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.baseIndex.addDataTypeListener(Collections.singleton(dataType), (DataTypeListener)new EDataTypeInSlotsAdapter(listener, seed.get(0)));
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.baseIndex.addFeatureListener(Collections.singleton(feature), (FeatureListener)new EStructuralFeatureInstancesKeyAdapter(listener, seed.get(0), seed.get(1)));
        } else {
            this.illegalInputKey(key);
        }
    }

    public void removeUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        if (key instanceof JavaTransitiveInstancesKey) {
            return;
        }
        this.ensureIndexed(key);
        if (key instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)key).getEmfKey();
            this.baseIndex.removeInstanceListener(Collections.singleton(eClass), (InstanceListener)new EClassTransitiveInstancesAdapter(listener, seed.get(0)));
        } else if (key instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)key).getEmfKey();
            this.baseIndex.removeDataTypeListener(Collections.singleton(dataType), (DataTypeListener)new EDataTypeInSlotsAdapter(listener, seed.get(0)));
        } else if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            this.baseIndex.removeFeatureListener(Collections.singleton(feature), (FeatureListener)new EStructuralFeatureInstancesKeyAdapter(listener, seed.get(0), seed.get(1)));
        } else {
            this.illegalInputKey(key);
        }
    }

    private Object getFromSeed(Tuple seed, int index) {
        return seed == null ? null : seed.get(index);
    }

    public Object unwrapElement(Object internalElement) {
        return internalElement;
    }

    public Tuple unwrapTuple(Tuple internalElements) {
        return internalElements;
    }

    public Object wrapElement(Object externalElement) {
        return externalElement;
    }

    public Tuple wrapTuple(Tuple externalElements) {
        return externalElements;
    }

    public void ensureWildcardIndexing(IndexingService service) {
        this.baseIndex.setWildcardLevel(IndexingLevel.toLevel((IndexingService)service));
    }

    public void executeAfterTraversal(Runnable runnable) throws InvocationTargetException {
        this.baseIndex.executeAfterTraversal(runnable);
    }

    private static class EClassTransitiveInstancesAdapter
    extends ListenerAdapter
    implements InstanceListener {
        private Object seedInstance;

        public EClassTransitiveInstancesAdapter(IQueryRuntimeContextListener listener, Object seedInstance) {
            super(listener, seedInstance);
            this.seedInstance = seedInstance;
        }

        public void instanceInserted(EClass clazz, EObject instance) {
            if (this.seedInstance != null && !this.seedInstance.equals(instance)) {
                return;
            }
            this.listener.update((IInputKey)new EClassTransitiveInstancesKey(clazz), Tuples.staticArityFlatTupleOf((Object)instance), true);
        }

        public void instanceDeleted(EClass clazz, EObject instance) {
            if (this.seedInstance != null && !this.seedInstance.equals(instance)) {
                return;
            }
            this.listener.update((IInputKey)new EClassTransitiveInstancesKey(clazz), Tuples.staticArityFlatTupleOf((Object)instance), false);
        }
    }

    private static class EDataTypeInSlotsAdapter
    extends ListenerAdapter
    implements DataTypeListener {
        private Object seedValue;

        public EDataTypeInSlotsAdapter(IQueryRuntimeContextListener listener, Object seedValue) {
            super(listener, seedValue);
            this.seedValue = seedValue;
        }

        public void dataTypeInstanceInserted(EDataType type, Object instance, boolean firstOccurrence) {
            if (firstOccurrence) {
                if (this.seedValue != null && !this.seedValue.equals(instance)) {
                    return;
                }
                this.listener.update((IInputKey)new EDataTypeInSlotsKey(type), Tuples.staticArityFlatTupleOf((Object)instance), true);
            }
        }

        public void dataTypeInstanceDeleted(EDataType type, Object instance, boolean lastOccurrence) {
            if (lastOccurrence) {
                if (this.seedValue != null && !this.seedValue.equals(instance)) {
                    return;
                }
                this.listener.update((IInputKey)new EDataTypeInSlotsKey(type), Tuples.staticArityFlatTupleOf((Object)instance), false);
            }
        }
    }

    private static class EStructuralFeatureInstancesKeyAdapter
    extends ListenerAdapter
    implements FeatureListener {
        private Object seedHost;
        private Object seedValue;

        public EStructuralFeatureInstancesKeyAdapter(IQueryRuntimeContextListener listener, Object seedHost, Object seedValue) {
            super(listener, seedHost, seedValue);
            this.seedHost = seedHost;
            this.seedValue = seedValue;
        }

        public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
            if (this.seedHost != null && !this.seedHost.equals(host)) {
                return;
            }
            if (this.seedValue != null && !this.seedValue.equals(value)) {
                return;
            }
            this.listener.update((IInputKey)new EStructuralFeatureInstancesKey(feature), Tuples.staticArityFlatTupleOf((Object)host, (Object)value), true);
        }

        public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
            if (this.seedHost != null && !this.seedHost.equals(host)) {
                return;
            }
            if (this.seedValue != null && !this.seedValue.equals(value)) {
                return;
            }
            this.listener.update((IInputKey)new EStructuralFeatureInstancesKey(feature), Tuples.staticArityFlatTupleOf((Object)host, (Object)value), false);
        }
    }

    private static abstract class ListenerAdapter {
        IQueryRuntimeContextListener listener;
        Tuple seed;

        public ListenerAdapter(IQueryRuntimeContextListener listener, Object ... seed) {
            this.listener = listener;
            this.seed = Tuples.flatTupleOf((Object[])seed);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            result = 31 * result + (this.seed == null ? 0 : this.seed.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            ListenerAdapter other = (ListenerAdapter)obj;
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            return !(this.seed == null ? other.seed != null : !this.seed.equals((Object)other.seed));
        }

        public String toString() {
            return "Wrapped<Seed:" + this.seed + ">#" + this.listener;
        }
    }
}

