/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.zest.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.HorizontalShiftAlgorithm;
import org.eclipse.gef.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpaceTreeLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.extensions.jface.ViatraViewersJFaceViewSupport;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViewersZestPlugin;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;

public class ViatraViewersZestViewSupport
extends ViatraViewersJFaceViewSupport {
    private final ModifiableZestContentViewer graphViewer;
    protected Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            ViatraViewersZestViewSupport.this.getGraphViewer().refresh();
        }
    };
    protected Action clearGraph = new Action("Clear Graph"){

        public void run() {
            ViatraViewersZestViewSupport.this.getGraphViewer().setInput(null);
        }
    };

    public ModifiableZestContentViewer getGraphViewer() {
        return this.graphViewer;
    }

    public ViatraViewersZestViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope, ModifiableZestContentViewer _graphViewer) {
        super(_owner, _config, _scope, (ContentViewer)_graphViewer);
        this.graphViewer = _graphViewer;
    }

    protected void init() {
        super.init();
        this.getGraphViewer().setLayoutAlgorithm((ILayoutAlgorithm)new RadialLayoutAlgorithm());
    }

    protected void bindModel() {
        ViatraQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.state = ViatraViewerDataModel.newViewerState((ViatraQueryEngine)engine, (Collection)this.configuration.getPatterns(), (ViewerDataFilter)this.configuration.getFilter(), (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            ViatraGraphViewers.bind(this.graphViewer, this.state);
        }
    }

    public void createToolbar() {
        this.refreshGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/refresh.gif"));
        this.clearGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/clear.gif"));
        IToolBarManager toolBarManager = this.getOwner().getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.add((IAction)this.refreshGraph);
        toolBarManager.add((IAction)this.clearGraph);
        IMenuManager menuManager = this.getOwner().getViewSite().getActionBars().getMenuManager();
        menuManager.removeAll();
        menuManager.add((IContributionItem)this.createLayoutMenu());
    }

    public MenuManager createLayoutMenu() {
        MenuManager mgr = new MenuManager("Layout");
        mgr.add((IAction)this.createLayoutAction("Tree", (ILayoutAlgorithm)new TreeLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Spring", (ILayoutAlgorithm)new SpringLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Radial", (ILayoutAlgorithm)new RadialLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("SpaceTree", (ILayoutAlgorithm)new SpaceTreeLayoutAlgorithm()));
        SugiyamaLayoutAlgorithm sugiyamaAlgorithm = new SugiyamaLayoutAlgorithm();
        HorizontalShiftAlgorithm shiftAlgorithm = new HorizontalShiftAlgorithm();
        mgr.add((IAction)this.createLayoutAction("Sugiyama (unstable)", (ILayoutAlgorithm)new CompositeLayoutAlgorithm(new ILayoutAlgorithm[]{sugiyamaAlgorithm, shiftAlgorithm})));
        return mgr;
    }

    protected Action createLayoutAction(String name, final ILayoutAlgorithm lay) {
        return new Action(name){

            public void run() {
                ViatraViewersZestViewSupport.this.getGraphViewer().setLayoutAlgorithm(lay);
                ViatraViewersZestViewSupport.this.getGraphViewer().refresh();
            }
        };
    }
}

