/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.planner.ILocalSearchPlanner;
import org.eclipse.viatra.query.runtime.localsearch.planner.LocalSearchRuntimeBasedStrategy;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.EMFOperationCompiler;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriterCacher;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PQueryFlattener;

public class LocalSearchPlanner
implements ILocalSearchPlanner {
    private final PDisjunctionRewriter preprocessor;
    private final LocalSearchRuntimeBasedStrategy plannerStrategy;
    private final IQueryRuntimeContext runtimeContext;
    private final LocalSearchHints configuration;
    private final IOperationCompiler operationCompiler;
    private final IQueryBackendContext context;

    @Deprecated
    public LocalSearchPlanner(LocalSearchBackend backend, Logger logger, LocalSearchHints configuration) {
        this(backend.getBackendContext(), new EMFOperationCompiler(backend.getRuntimeContext(), configuration.isUseBase()), logger, configuration);
    }

    public LocalSearchPlanner(IQueryBackendContext backendContext, IOperationCompiler compiler, Logger logger, LocalSearchHints configuration) {
        this.runtimeContext = backendContext.getRuntimeContext();
        this.configuration = configuration;
        this.operationCompiler = compiler;
        PQueryFlattener flattener = new PQueryFlattener(configuration.getFlattenCallPredicate());
        PBodyNormalizer normalizer = new PBodyNormalizer(this.runtimeContext.getMetaContext()){

            protected boolean shouldCalculateImpliedTypes(PQuery query) {
                return false;
            }
        };
        this.preprocessor = new PDisjunctionRewriterCacher(new PDisjunctionRewriter[]{flattener, normalizer});
        this.plannerStrategy = new LocalSearchRuntimeBasedStrategy();
        this.context = backendContext;
    }

    @Override
    public Collection<SearchPlanForBody> plan(PQuery querySpec, Set<PParameter> boundParameters) throws QueryProcessingException {
        this.preprocessor.setTraceCollector(this.configuration.getTraceCollector());
        Set normalizedBodies = this.preprocessor.rewrite(querySpec.getDisjunctBodies()).getBodies();
        ArrayList plansForBodies = Lists.newArrayListWithExpectedSize((int)normalizedBodies.size());
        for (PBody normalizedBody : normalizedBodies) {
            Set<PVariable> boundVariables = this.calculatePatternAdornmentForPlanner(boundParameters, normalizedBody);
            SubPlan plan = this.plannerStrategy.plan(normalizedBody, boundVariables, this.context, this.configuration);
            List<ISearchOperation> compiledOperations = this.operationCompiler.compile(plan, boundParameters);
            SearchPlanForBody compiledPlan = new SearchPlanForBody(normalizedBody, this.operationCompiler.getVariableMappings(), plan, compiledOperations, this.operationCompiler.getDependencies());
            plansForBodies.add(compiledPlan);
        }
        return plansForBodies;
    }

    private Set<PVariable> calculatePatternAdornmentForPlanner(Set<PParameter> boundParameters, PBody normalizedBody) {
        HashMap parameterMapping = Maps.newHashMap();
        for (ExportedParameter constraint : normalizedBody.getSymbolicParameters()) {
            parameterMapping.put(constraint.getPatternParameter(), constraint.getParameterVariable());
        }
        HashSet boundVariables = Sets.newHashSet();
        for (PParameter parameter : boundParameters) {
            PVariable mappedParameter = (PVariable)parameterMapping.get(parameter);
            if (mappedParameter == null) {
                mappedParameter = normalizedBody.getVariableByNameChecked((Object)parameter.getName());
            }
            boundVariables.add(mappedParameter);
        }
        return boundVariables;
    }
}

