/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class ExtendToEStructuralFeatureSource
extends ExtendOperation<EObject>
implements IIteratingSearchOperation {
    private int targetPosition;
    private EStructuralFeature feature;
    private final IInputKey type;

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        super(sourcePosition);
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.type = new EStructuralFeatureInstancesKey(feature);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Iterable values = context.getRuntimeContext().enumerateValues(this.type, Tuples.flatTupleOf((Object[])new Object[]{null, frame.getValue(this.targetPosition)}));
        this.it = Iterables.filter((Iterable)values, EObject.class).iterator();
    }

    public String toString() {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + this.position + ", +" + this.targetPosition + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object)this.targetPosition, (Object[])new Integer[0]);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

