/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.IAdornmentProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHintOptions;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanProvider;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class AbstractLocalSearchResultProvider
implements IQueryResultProvider {
    protected final LocalSearchBackend backend;
    protected final IQueryBackendContext backendContext;
    protected final IQueryRuntimeContext runtimeContext;
    protected final PQuery query;
    protected final QueryEvaluationHint userHints;
    protected final IPlanProvider planProvider;
    protected final ISearchContext searchContext;

    public AbstractLocalSearchResultProvider(LocalSearchBackend backend, IQueryBackendContext context, PQuery query, IPlanProvider planProvider, QueryEvaluationHint userHints) {
        this.backend = backend;
        this.backendContext = context;
        this.query = query;
        this.planProvider = planProvider;
        this.userHints = userHints;
        this.runtimeContext = context.getRuntimeContext();
        this.searchContext = new ISearchContext.SearchContext(this.backendContext, userHints, backend.getCache());
    }

    protected abstract IOperationCompiler getOperationCompiler(IQueryBackendContext var1, LocalSearchHints var2);

    private IQueryRuntimeContext getRuntimeContext() {
        return this.backend.getRuntimeContext();
    }

    private LocalSearchMatcher createMatcher(IPlanDescriptor plan, final ISearchContext searchContext) {
        ArrayList compiledPlans = Lists.newArrayList(plan.getPlan());
        Collection executors = Collections2.transform((Collection)compiledPlans, (Function)new Function<SearchPlanForBody, SearchPlanExecutor>(){

            public SearchPlanExecutor apply(SearchPlanForBody input) {
                SearchPlan plan = new SearchPlan();
                plan.addOperations(input.getCompiledOperations());
                return new SearchPlanExecutor(plan, searchContext, input.getVariableKeys());
            }
        });
        Collection parameterSizes = Collections2.transform((Collection)compiledPlans, (Function)new Function<SearchPlanForBody, Integer>(){

            public Integer apply(SearchPlanForBody input) {
                PBody body = input.getBody();
                return body.getUniqueVariables().size();
            }
        });
        return new LocalSearchMatcher(plan, executors, (int)((Integer)Collections.max(parameterSizes)));
    }

    private IPlanDescriptor createPlan(MatcherReference key, IPlanProvider planProvider) throws QueryProcessingException {
        LocalSearchHints configuration = this.overrideDefaultHints(key.getQuery());
        IOperationCompiler compiler = this.getOperationCompiler(this.backendContext, configuration);
        IPlanDescriptor plan = planProvider.getPlan(this.backendContext, compiler, configuration, key);
        return plan;
    }

    private LocalSearchHints overrideDefaultHints(PQuery pQuery) {
        return LocalSearchHints.getDefaultOverriddenBy(this.computeOverridingHints(pQuery));
    }

    private QueryEvaluationHint computeOverridingHints(PQuery pQuery) {
        return this.backendContext.getHintProvider().getQueryEvaluationHint(pQuery).overrideBy(this.userHints);
    }

    private Iterator<MatcherReference> computeExpectedAdornments() {
        return Iterators.transform(this.overrideDefaultHints(this.query).getAdornmentProvider().getAdornments(this.query).iterator(), (Function)new Function<Set<PParameter>, MatcherReference>(){

            public MatcherReference apply(Set<PParameter> input) {
                return new MatcherReference(AbstractLocalSearchResultProvider.this.query, input, AbstractLocalSearchResultProvider.this.userHints);
            }
        });
    }

    public void prepare() throws QueryProcessingException {
        try {
            this.runtimeContext.coalesceTraversals((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractLocalSearchResultProvider.this.indexInitializationBeforePlanning();
                    AbstractLocalSearchResultProvider.this.prepareDirectDependencies();
                    AbstractLocalSearchResultProvider.this.runtimeContext.executeAfterTraversal(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractLocalSearchResultProvider.this.preparePlansForExpectedAdornments();
                            }
                            catch (QueryProcessingException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new QueryProcessingException("Error while building required indexes: %s", new String[]{e.getTargetException().getMessage()}, "Error while building required indexes.", (Object)this.query, (Throwable)e);
        }
    }

    protected void preparePlansForExpectedAdornments() throws QueryProcessingException {
        Iterator<MatcherReference> iterator = this.computeExpectedAdornments();
        while (iterator.hasNext()) {
            LocalSearchHints configuration = this.overrideDefaultHints(this.query);
            IOperationCompiler compiler = this.getOperationCompiler(this.backendContext, configuration);
            IPlanDescriptor plan = this.planProvider.getPlan(this.backendContext, compiler, configuration, iterator.next());
            try {
                this.indexKeys(plan.getIteratedKeys());
            }
            catch (InvocationTargetException e) {
                throw new QueryProcessingException(e.getMessage(), null, e.getMessage(), (Object)this.query, (Throwable)e);
            }
            for (SearchPlanForBody body : plan.getPlan()) {
                for (MatcherReference dependency : body.getDependencies()) {
                    try {
                        this.searchContext.getMatcher(dependency);
                    }
                    catch (LocalSearchException e) {
                        throw new QueryProcessingException("Could not prepare dependency {1}", new String[]{dependency.toString()}, e.getMessage(), (Object)this.query, (Throwable)((Object)e));
                    }
                }
            }
        }
    }

    protected void prepareDirectDependencies() throws QueryProcessingException {
        IAdornmentProvider adornmentProvider = new IAdornmentProvider(){

            @Override
            public Iterable<Set<PParameter>> getAdornments(PQuery query) {
                return Collections.emptySet();
            }
        };
        QueryEvaluationHint hints = new QueryEvaluationHint(Collections.singletonMap(LocalSearchHintOptions.ADORNMENT_PROVIDER, adornmentProvider), null);
        for (PQuery dep : this.getDirectPositiveDependencies()) {
            this.backendContext.getResultProviderAccess().getResultProvider(dep, hints);
        }
    }

    protected void indexInitializationBeforePlanning() throws QueryProcessingException {
    }

    protected void indexReferredTypesOfQuery(PQuery query, IndexingService requiredIndexingServices) {
        for (PBody body : query.getDisjunctBodies().getBodies()) {
            for (PConstraint constraint : body.getConstraints()) {
                if (!(constraint instanceof TypeConstraint)) continue;
                this.runtimeContext.ensureIndexed((IInputKey)((TypeConstraint)constraint).getSupplierKey(), requiredIndexingServices);
            }
        }
    }

    private Set<PQuery> getDirectPositiveDependencies() {
        IFlattenCallPredicate flattenPredicate = this.overrideDefaultHints(this.query).getFlattenCallPredicate();
        LinkedList<PQuery> queue = new LinkedList<PQuery>();
        HashSet<PQuery> visited = new HashSet<PQuery>();
        HashSet<PQuery> result = new HashSet<PQuery>();
        queue.add(this.query);
        while (!queue.isEmpty()) {
            PQuery next = (PQuery)queue.poll();
            visited.add(next);
            for (PBody body : next.getDisjunctBodies().getBodies()) {
                for (PositivePatternCall ppc : body.getConstraintsOfType(PositivePatternCall.class)) {
                    PQuery dep = (PQuery)ppc.getSupplierKey();
                    if (flattenPredicate.shouldFlatten(ppc)) {
                        if (visited.contains(dep)) continue;
                        queue.add(dep);
                        continue;
                    }
                    result.add(dep);
                }
            }
        }
        return result;
    }

    private LocalSearchMatcher initializeMatcher(Object[] parameters) {
        try {
            return this.newLocalSearchMatcher(parameters);
        }
        catch (ViatraQueryException | QueryProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public LocalSearchMatcher newLocalSearchMatcher(Object[] parameters) throws ViatraQueryException, QueryProcessingException {
        HashSet adornment = Sets.newHashSet();
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                adornment.add((PParameter)this.query.getParameters().get(i));
            }
            ++i;
        }
        MatcherReference reference = new MatcherReference(this.query, adornment, this.userHints);
        IPlanDescriptor plan = this.createPlan(reference, this.planProvider);
        if (this.overrideDefaultHints(reference.getQuery()).isUseBase()) {
            try {
                this.indexKeys(plan.getIteratedKeys());
            }
            catch (InvocationTargetException e) {
                throw new ViatraQueryException("Could not index keys", "Could not index keys", (Throwable)e);
            }
        }
        LocalSearchMatcher matcher = this.createMatcher(plan, this.searchContext);
        matcher.addAdapters(this.backend.getAdapters());
        return matcher;
    }

    private void indexKeys(final Iterable<IInputKey> keys) throws InvocationTargetException {
        final IQueryRuntimeContext qrc = this.getRuntimeContext();
        qrc.coalesceTraversals((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (IInputKey key : keys) {
                    qrc.ensureIndexed(key, IndexingService.INSTANCES);
                }
                return null;
            }
        });
    }

    public Tuple getOneArbitraryMatch(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        MatchingFrame frame = matcher.editableMatchingFrame();
        frame.setParameterValues(parameters);
        return matcher.getOneArbitraryMatch(frame);
    }

    public int countMatches(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        MatchingFrame frame = matcher.editableMatchingFrame();
        frame.setParameterValues(parameters);
        return matcher.countMatches(frame);
    }

    public Collection<? extends Tuple> getAllMatches(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        MatchingFrame frame = matcher.editableMatchingFrame();
        frame.setParameterValues(parameters);
        return matcher.getAllMatches(frame);
    }

    public IQueryBackend getQueryBackend() {
        return this.backend;
    }

    public void addUpdateListener(IUpdateable listener, Object listenerTag, boolean fireNow) {
    }

    public void removeUpdateListener(Object listenerTag) {
    }

    public IMatcherCapability getCapabilites() {
        LocalSearchHints configuration = this.overrideDefaultHints(this.query);
        return configuration;
    }
}

